.386
.model flat,prolog
locals


public f_open
public f_close
public f_read
public f_write
public f_getpos
public f_seek

public f_findfirst
public f_findnext



;
.data
;
bufsize = 2048

tfile struc
 handle   dd ?
 error	  dd ?
 filepos  dd ?
 flags	  db ?
 bufpos   dd ?
 bufend   dd ?
 buf	  db bufsize dup(?)
ends

tsearch struc
 fill	  db 21 dup(?)
 attr	  db ?
 time	  dw ?
 date	  dw ?
 size	  dd ?
 name	  db 13 dup(?)
ends

ofCreate   = 256
ffBufread  = 1
ffModified = 2

faArchive = 20h

;
.code
;

f_open proc near
	;esi -> tfile, edx -> file-string, eax = filemode

	mov	ecx,size tfile		;struktur lschen
@@clr:	dec	ecx
	mov	byte ptr [esi+ecx],0
	jnz	@@clr
					;ecx = 0 fr file-attribut
	test	eax,ofCreate
	mov	ah,3dh
	jz	@@0
	dec	ah
@@0:	int	21h

	mov	edx,0
	jnc	@@ok
	xchg	eax,edx
@@ok:
	mov	handle[esi],eax
	mov	error[esi],edx

	ret
f_open endp

f_close proc near
	;-> esi = offset auf struktur
	mov	ebx,handle[esi]

	or	ebx,ebx 		;file offen?
	jz	@@weg

	test	flags[esi],ffModified
	jz	@@1
	test	flags[esi],ffBufread
	jz	@@0
		;seek back
	mov	edx,filepos[esi]
	shld	ecx,edx,16
	mov	ax,4200h
	int	21h
@@0:		;save
	mov	ecx,bufend[esi]
	lea	edx,buf[esi]
	mov	ah,40h
	int	21h
	;jc	 @@err
@@1:
		;close
	mov	ah,3eh
	int	21h

	mov	handle[esi],0

@@weg:	ret
f_close endp

f_read proc near
	;-> esi -> tfile, edi -> ausgabebuffer, edx = byte zu lesen
	;<- eax = byte gelesen
	local	count,outbufsize :dword ;stackframe automatisch !

	cld

	mov	outbufsize,edx		;edx = byte zu lesen
	mov	count,edx

	or	edx,edx 		;0 byte zu lesen
	jz	@@weg
	cmp	error[esi],0		;vorher fehler aufgetreten ?
	jne	@@clr

	mov	eax,bufend[esi]
	sub	eax,bufpos[esi]
	jg	@@1
@@l:		;interner buffer leer
	mov	ebx,handle[esi]

	test	flags[esi],ffModified
	jz	@@0
	test	flags[esi],ffBufread
	jz	@@s;readerror
		;seek back
	mov	edx,filepos[esi]
	shld	ecx,edx,16
	mov	ax,4200h
	int	21h
@@s:		;save
	mov	ecx,bufend[esi]
	lea	edx,buf[esi]
	mov	ah,40h
	int	21h
	jc	@@err

@@0:
	mov	eax,bufend[esi]
	add	filepos[esi],eax
	sub	bufpos[esi],eax

	mov	ecx,bufsize
	lea	edx,buf[esi]
	mov	ah,3Fh
	int	21h
	jc	@@err
	mov	bufend[esi],eax
	or	eax,eax 		;file am ende ?
	jz	@@readerror
@@1:		;daten aus internem buffer lesen (eax = byte im buffer)

	cmp	eax,count
	jb	@@2
	mov	eax,count
@@2:
	mov	ecx,eax
		;aus buffer kopieren
	push	esi
	add	esi,bufpos[esi]
	add	esi,offset buf
	rep	movsb
	pop	esi
@@4:
	add	bufpos[esi],eax 	;eax = anzahl kopierter byte
	sub	count,eax
	jnz	@@l
	jz	@@weg
@@readerror:
	mov	eax,100
@@err:	mov	error[esi],eax

@@clr:	xor	al,al
	mov	ecx,count
	rep	stosb

@@weg:	mov	eax,outbufsize
	sub	eax,count

	ret
f_read endp


f_write proc near
	;-> edi -> tfile, esi -> quellbuffer, edx = byte zu schreiben
	;<- eax = byte geschrieben
	local	count,srcbufsize :dword

	cld

	mov	srcbufsize,edx		;edx = byte zu lesen
	mov	count,edx

	or	edx,edx 		;0 byte zu schreiben
	jz	@@weg
	cmp	error[edi],0		;fehler ?
	jne	@@weg

	mov	eax,bufsize
	sub	eax,bufpos[edi]
	ja	@@1
@@l:		;interner buffer voll
	mov	ebx,handle[edi]
	mov	edx,filepos[edi]	 ;fileposition des buffer-anfangs

	test	flags[edi],ffBufread
	jz	@@0
		;seek back
	shld	ecx,edx,16
	mov	ax,4200h
	int	21h
@@0:
	mov	bufend[edi],0
	mov	bufpos[edi],0
	mov	flags[edi],0

	mov	ecx,bufsize
	lea	edx,buf[edi]
	mov	ah,40h
	int	21h
	jc	@@err
	add	filepos[edi],eax
	cmp	eax,bufsize		;disk write error ?
	jne	@@writeerror

@@1:		;daten in internen buffer schreiben (eax = byte im buffer frei)
	or	flags[edi],ffModified
	cmp	eax,count
	jb	@@2
	mov	eax,count
@@2:
	mov	ecx,eax
		;in buffer kopieren
	push	edi
	add	edi,bufpos[edi]
	add	edi,offset buf
	rep	movsb
	pop	edi
@@4:
	add	bufpos[edi],eax 	;eax = anzahl kopierter byte
	sub	count,eax
	jnz	@@l

	mov	eax,bufpos[edi]
	cmp	eax,bufend[edi] 	;hat sich der buffer vergrert?
	jbe	@@weg
	mov	bufend[edi],eax
	jmp	@@weg

@@writeerror:
	mov	eax,101
@@err:	mov	error[edi],eax


@@weg:	mov	eax,srcbufsize
	sub	eax,count

	ret
f_write endp

f_getpos proc near
	;-> esi -> tfile
	mov	eax,filepos[esi]
	add	eax,bufpos[esi]
	ret
f_getpos endp

f_seek proc near
	;-> esi -> tfile, edx = position

	mov	eax,edx

	sub	eax,filepos[esi]	;pos. relativ zu buffer-filepos
	cmp	eax,bufsize
	jae	@@0
		;seek-pos innerhalb des buffers
	mov	bufpos[esi],eax
	jmp	@@weg

@@0:		;seek-pos auerhalb des buffers
	mov	ebx,handle[esi]
	xchg	edx,filepos[esi]	;edx = old filepos

	test	flags[esi],ffModified
	jz	@@1
	test	flags[esi],ffBufread
	jz	@@s
		;seek back
	shld	ecx,edx,16
	mov	ax,4200h
	int	21h
@@s:		;save
	mov	ecx,bufend[esi]
	lea	edx,buf[esi]
	mov	ah,40h
	int	21h
	jc	@@err

@@1:
	mov	bufpos[esi],0
	mov	bufend[esi],0
	mov	flags[esi],0
	mov	edx,filepos[esi]	;edx = new filepos
	shld	ecx,edx,16
	mov	ax,4200h
	int	21h
	jnc	@@weg
;	 jmp	 @@weg
@@err:
	mov	error[esi],eax

@@weg:	ret
f_seek endp

f_findfirst proc near
	;-> eax -> ASCIIZ path name
	;-> ecx = attribute
	;-> edx -> tsearch

	push	eax

	mov	ah,1Ah			;set DTA
	int	21h

	mov	ah,4Eh			;find first
	pop	edx
	int	21h
	movzx	eax,ax

	ret
f_findfirst endp

f_findnext proc near

	mov	ah,4Fh			;find next
	int	21h
	movzx	eax,ax

	ret
f_findnext endp

;f_err proc near
;	 mov	 ah,9
;	 mov	 edx,offset f_err
;	 int	 21h
;	 mov	 eax,2
;	 call	 exit_
;endp


end


