/***********************************************
 *              Mem utilities                  *
 * Skal 96                                     *
 ***********************************************/

#ifndef _MEM_H_
#define _MEM_H_

#include "main.h"

/********************************************************/

#ifdef DOS

#define BASE_FP(s)    ( (UINT)(s)<<4 )
#define SEG_OFF_FP(s,o)    ( ((UINT)(s)<<4) + (o) )
#define MAKE_FP(s)    ( __djgpp_conventional_base + ( ((UINT)(s))<<4 ) )
#define MK_FP(s,o)    ( __djgpp_conventional_base + ( ((UINT)(s))<<4 ) + (UINT)(o) )

#endif

/********************************************************/

extern void *My_Malloc( int );
extern void *My_Realloc( void *Ptr, int );
extern void My_Free( void * );
extern void *My_Fatal_Malloc( int );

#ifdef DEBUG_MEM

extern void Print_Mem_State( );

#else

#define Print_Mem_State( )

#endif

/********************************************************/

#define M_Free(x)   { if ((x)!=NULL) My_Free((x)); (x)=NULL; }
#define New_Object(N,type) ( (type *)My_Malloc( (N)*sizeof(type) ) )
#define New_Fatal_Object(N,type) ( (type *)My_Fatal_Malloc( (N)*sizeof(type) ) )
#define Mem_Clear(P)     bzero( (void *)(P), sizeof( *(P) ) )

/********************************************************/

#endif /* _MEM_H_ */

