/***********************************************
 *      VBE2.0 graphics Driver                 *
 * Skal 96                                     *
 ***********************************************/

#ifndef _DRV_VBE_H_
#define _DRV_VBE_H_

#include "main.h"
#include <stdarg.h>

#ifdef DOS

#ifndef DONT_USE_VBE

/********************************************************/

#include <dpmi.h>
#include <sys/nearptr.h>
#include <sys/farptr.h>
#include <go32.h>    /* <= for _dos_ds */
#include <sys/exceptn.h>   /* <= for _djgpp_ds_alias */

extern int kbhit( );
extern int getkey( );  /* ALT's have 0x100 set */

#define DOS_CTRL_KEY    0x04
#define DOS_SHIFT_KEY   0x83
#define DOS_ALT_KEY     0x08
#define DOS_TAB_KEY     23
#define DOS_LEFT_KEY    100
#define DOS_RIGHT_KEY   102
#define DOS_UP_KEY      98
#define DOS_DOWN_KEY    104

#include "out_regs.h"

/********************************************************/
/********************************************************/

typedef struct {

  USHORT  ModeAttributes;
  PIXEL   WinAAttributes;
  PIXEL   WinBAttributes;
  USHORT  Granularity;
  USHORT  WinSize;
  USHORT  WinASegment;
  USHORT  WinBSegment;
  UINT    WinFuncPtr;
  USHORT  bytePerLine;
  USHORT  XRes;
  USHORT  YRes;
  PIXEL   XCharSize;
  PIXEL   YCharSize;
  PIXEL   NPlanes;
  PIXEL   BitsPerPixel;
  PIXEL   NBanks;
  PIXEL   MemoryModel;
  PIXEL   BankSize;
  PIXEL   NPages;
  PIXEL   Reserved;
  PIXEL   RedMaskSize, RedFieldPos;
  PIXEL   GreenMaskSize, GreenFieldPos;
  PIXEL   BlueMaskSize, BlueFieldPos;
  PIXEL   RsvdMaskSize, DirectColorInfo;
  void    *PhysBasePtr;
  UINT    OffScreenMemOffset;
  USHORT  OffScreenMemSize;
  PIXEL   reserved[ 206 ];

} VBE_MODE;

typedef struct {

  char     VbeSignature[4];
  USHORT   VbeVersion;  		/* 4 */
  void    *OemStringPtr;   	/* 6 */
  PIXEL    Capabilities[4];	/* 10 */
  USHORT  *VideoModePtr;	   /* 14 */
  USHORT   TotalMemory;	   	/* 18 */
  USHORT   OemSoftwareRev;	   /* 20 */
  void    *OemVendorNamePtr;	/* 22 */
  void    *OemProductNamePtr;	/* 26 */
  void    *OemProductRevPtr;	/* 30 */
  PIXEL    Reserved[ 222 ];
  PIXEL    OemData[256];

} VBE_INFO;

/********************************************************/

#include "v_cards.h"

/********************************************************/

typedef struct MEM_ZONE_VBE MEM_ZONE_VBE;

struct MEM_ZONE_VBE {

   MEM_ZONE_DRIVER_FIELDS

      /* VBE specific */

   MEM_IMG      The_Display;
   VBE_INFO    *VInfo;
   INT          RAMDAC_Cur_Width, RAMDAC_Width; 
   PIXEL       *Base_Ptr;
   USHORT       Mode_Number;
   INT          Bank_Size, Total_Mem;
   INT          VESA_Win_No, Cur_Bank;    /* 176/180 */
   void        (*Set_Bank)( MEM_ZONE_VBE *, INT );
   void        *LFB_To_Be_Mapped;
   void        *PM_WinFuncPtr;         /* 188 */
   void        *RM_WinFuncPtr;         /* 192 */
   __dpmi_regs  SVGA_Regs;             /* 196 */

   CARD_METHODS *Video_Card;

};

/********************************************************/

   /* needed by v_vards.c.  => external */

extern PIXEL *Get_VBE_Info( PIXEL **VInfo, INT Vbe20 );
extern VBE_MODE *Get_Mode_Info( USHORT Mode, VBE_MODE *_VBE_Info_ );
extern void Vesa_Info_To_Mem_Img( MEM_IMG *M, VBE_MODE *Info );
extern MEM_IMG *VBE_Detect_Available_Modes( MEM_ZONE_VBE *VBE, USHORT *Ptr );
extern void VBE_Print_Mode_Info( STRING S, MEM_IMG *M );
extern USHORT VBE_Set_VESA_Mode( USHORT Mode, MEM_ZONE_VBE *VBE );
extern INT Do_Init_VESA_Mode( MEM_ZONE_VBE *VBE );

#endif      /* DONT_USE_VBE */

   /* Some DOS funcs in dos_mem.c */

extern void _Enable( PIXEL *, INT );
extern void _Disable( );
extern void Safe_Bzero( PIXEL *Ptr, INT Size );
extern int _The_DS_;
extern unsigned _The_Segment_;
extern UINT Enabled;
extern void DOSemu_MEM_Copy_Rect( MEM_ZONE *M,
   PIXEL *Dst, PIXEL *Src, INT Width, INT Height, INT Pad_Dst );

extern USHORT Dos_Segment;
extern void Free_Dos_Buffer( );
extern USHORT Allocate_Dos_Buffer( UINT Size );
extern PIXEL *Map_Physical_Address( UINT Size, PIXEL *Address );
extern void Unmap_Physical_Address( PIXEL *Address );
extern STRING _Retreive_String( PIXEL *Ptr, INT n, STRING S );
extern STRING _Retreive_String2( UINT Seg, UINT Off, INT n, STRING S );

   /* Some DOS funcs in drv_vga.c */

extern EXTERN UINT VBE_Search_Best_X_Mode( MEM_IMG *M, MEM_IMG *X_Mode );
extern void VBE_Init_VGA_Mode( UINT Mode, MEM_ZONE_VBE * );

/********************************************************/
/********************************************************/

#else

#define _G_VBE_DRIVER_  NULL
#define _G_S3_DRIVER_     NULL
#define _G_ET4000_DRIVER_ NULL
#define _G_ET6000_DRIVER_ NULL
#define _G_MATROX_DRIVER_ NULL

#endif      /* DOS */

/********************************************************/

#endif   /* _DRV_VBE_H_ */

