/*
 *    RGB test
 *
 *   This produces 6 types of color patterns, with
 *   different RGB format (0x332, 0x555, 0x565, etc...)
 *
 *   Run with `vid3 "300:500:0x332"` when under a
 *   X11 8bpp DISPLAY, otherwise, it'll be strange
 *   Under DOS, try `vid3 "300:500:0x565"` for instance...
 *
 ****************************************************/

#include "sl.h"

#include <math.h>
int Count = 0;

#define RAD_SCALE   (2.0*M_PI/256.0)
PIXEL Timer1=0, Timer2=0;

PIXEL *Radial;

#define SUB_W  128
#define SUB_H  128
MEM_IMAGE The_Screen;

/*********************************************************************/
/*********************************************************************/

void Do_Plasma( MEM_IMAGE M )
{
   double x;
   UINT Src1, Src2, Src3;
   PIXEL *Radial1, *Radial2, *Radial3, *Dst;
   INT i, j;
   UINT Out_Mask[4], Out_Shift[4];
   UINT *Tab;
      
   Timer1 += 1; Timer2 -= 3;

   x = ( .5 + .3*cos( Timer1*RAD_SCALE ) );
   Src1 = (UINT)( x*SUB_W );
   x = ( .9 + .6*sin( Timer2*RAD_SCALE ) )*SUB_H;
   Src1 += (UINT)( x/2 )*SUB_W*2;

   x = .6 + .2*sin( .4125 + Timer1*RAD_SCALE );
   Src2 = (UINT)( x*SUB_W );
   x = ( .9 + .65*cos( .123 + Timer1*RAD_SCALE ) )*SUB_H;
   Src2 += (UINT)( x/2 )*SUB_W*2;

   x = ( .8 + .3*cos( .511 + Timer1*RAD_SCALE ) );
   Src3 = (UINT)( x*SUB_W );
   x = ( .3 + .25*sin( -.12545 + Timer2*RAD_SCALE ) )*SUB_H;
   Src3 += (UINT)( x/2 )*SUB_W*2;

   Format_Mask_And_Shift( Zone_Format( M ), Out_Mask, Out_Shift );

   Radial1 = Radial + Src1;
   Radial2 = Radial + Src2;
   Radial3 = Radial + Src3;

   switch( Format_Depth( Zone_Format(M) ) )
   {
      case 1:
         for( j=Zone_Height(M)-1; j>=0; --j )
         {
            PIXEL *Dst;
            Dst = (PIXEL *)Zone_Scanline(M,j);
            if ( Dst != NULL ) 
               for( i=Zone_Width(M)-1; i>=0; --i )
               {
                  UINT Col;
                  Col  = ( Radial1[i] & Out_Mask[RED_F] )<<Out_Shift[RED_F];
                  Col |= ( Radial2[i] & Out_Mask[GREEN_F] )<<Out_Shift[GREEN_F];
                  Col |= ( Radial3[i] & Out_Mask[BLUE_F] )<<Out_Shift[BLUE_F];
                  *Dst++ = (PIXEL)( Col>>COL_BITS_FIX );
               }
            Radial1 += SUB_W*2;
            Radial2 += SUB_W*2;
            Radial3 += SUB_W*2;
         }
      break;
      case 2:
         for( j=Zone_Height(M)-1; j>=0; --j )
         {
            USHORT *Dst;
            Dst = (USHORT *)Zone_Scanline(M,j);
            if ( Dst != NULL ) 
               for( i=Zone_Width(M)-1; i>=0; --i )
               {
                  UINT Col;
                  Col  = ( Radial1[i] & Out_Mask[RED_F] )<<Out_Shift[RED_F];
                  Col |= ( Radial2[i] & Out_Mask[GREEN_F] )<<Out_Shift[GREEN_F];
                  Col |= ( Radial3[i] & Out_Mask[BLUE_F] )<<Out_Shift[BLUE_F];
                  *Dst++ = (USHORT)( Col>>COL_BITS_FIX );
               }
            Radial1 += SUB_W*2;
            Radial2 += SUB_W*2;
            Radial3 += SUB_W*2;
         }
      break;
      case 3:
         for( j=Zone_Height(M)-1; j>=0; --j )
         {
            PIXEL *Dst;
            Dst = (PIXEL *)Zone_Scanline(M,j);
            if ( Dst != NULL ) 
               for( i=Zone_Width(M)-1; i>=0; --i )
               {
                  UINT Col;
                  Col  = ( Radial1[i] & Out_Mask[RED_F] )<<Out_Shift[RED_F];
                  Col |= ( Radial2[i] & Out_Mask[GREEN_F] )<<Out_Shift[GREEN_F];
                  Col |= ( Radial3[i] & Out_Mask[BLUE_F] )<<Out_Shift[BLUE_F];
                  Col >>= COL_BITS_FIX;
                  
                  *Dst++ = Col&0xFF;
                  *Dst++ = (Col>>8)&0xFF;
                  *Dst++ = (Col>>16)&0xFF;
               }
            Radial1 += SUB_W*2;
            Radial2 += SUB_W*2;
            Radial3 += SUB_W*2;
         }
      break;
      case 4:
         for( j=Zone_Height(M)-1; j>=0; --j )
         {
            UINT *Dst;
            Dst = (UINT *)Zone_Scanline(M,j);
            if ( Dst != NULL ) 
               for( i=Zone_Width(M)-1; i>=0; --i )
               {
                  UINT Col;
                  Col  = ( Radial1[i] & Out_Mask[RED_F] )<<Out_Shift[RED_F];
                  Col |= ( Radial2[i] & Out_Mask[GREEN_F] )<<Out_Shift[GREEN_F];
                  Col |= ( Radial3[i] & Out_Mask[BLUE_F] )<<Out_Shift[BLUE_F];
                  *Dst++ = (UINT)( Col>>COL_BITS_FIX );
               }
            Radial1 += SUB_W*2;
            Radial2 += SUB_W*2;
            Radial3 += SUB_W*2;
         }
      break;
   }
   Zone_Flush( M );
}

/*********************************************************************/

void Main_Loop( MEM_IMAGE The_Screen )
{
   MEM_IMAGE MM1, MM2, MM3, MM4, MM5, MM6;
   INT H, W;

   MM1 = MM2 = MM3 = MM4 = MM5 = MM6 = NULL;

   W = Zone_Width( The_Screen );
   H = Zone_Height( The_Screen );

   MM1 = Extract_Converted_Zone( NULL, The_Screen, 
      SUB_W, SUB_H, 5, 5, FMT_332, NULL );

   MM2 = Extract_Converted_Zone( NULL, The_Screen, 
      SUB_W, SUB_H, SUB_W+15, 5, FMT_555, NULL );

   MM3 = Extract_Converted_Zone( NULL, The_Screen, 
      SUB_W, SUB_H, 5, SUB_H+15, FMT_565, NULL );

   MM4 = Extract_Converted_Zone( NULL, The_Screen, 
      SUB_W, SUB_H, SUB_W+15, SUB_H+15, FMT_444, NULL );

   MM5 = Extract_Converted_Zone( NULL, The_Screen, 
      SUB_W, SUB_H, 5, 2*SUB_H+25, FMT_24b, NULL );

   MM6 = Extract_Converted_Zone( NULL, The_Screen, 
      SUB_W, SUB_H, SUB_W+15, 2*SUB_H+25, FMT_32b, NULL );

   Zone_Flush( The_Screen );
   do
   {
      if ( MM1!=NULL ) Do_Plasma( MM1 );
      if ( MM2!=NULL ) Do_Plasma( MM2 );
      if ( MM3!=NULL ) Do_Plasma( MM3 );
      if ( MM4!=NULL ) Do_Plasma( MM4 );
      if ( MM5!=NULL ) Do_Plasma( MM5 );
      if ( MM6!=NULL ) Do_Plasma( MM6 );

      Count++;
      if ( Driver_Get_Event(The_Screen) & DRV_KEY_PRESS ) break;
   }
   while( Count != 350 );

   Zone_Destroy( MM6 );
   Zone_Destroy( MM5 );
   Zone_Destroy( MM4 );
   Zone_Destroy( MM3 );
   Zone_Destroy( MM2 );
   Zone_Destroy( MM1 );
}

/*********************************************************************/

void main( int argc, char **argv )
{
   int i, j;
   PIXEL *Ptr;
   STRING Mode_String;

   Mode_String = "300:500:?";

   if ( argc>1 ) Mode_String = argv[1];

   Register_Video_Support( 4, _G_DGA_DRIVER_,
      _G_X11_DRIVER_, _G_SVGL_DRIVER_, _G_VBE_DRIVER_ );

   The_Screen = Driver_Call( NULL,
      /* DRV_DISPLAY, ":0", */
      DRV_NAME, "RGB patterns",
      /* DRV_DONT_USE, _SHM_, */
      /* DRV_DETECT, */
      DRV_PRINT_INFO,
      DRV_CONVERT,
      DRV_MODE, Mode_String,      
      DRV_END_ARG );
   if ( The_Screen == NULL ) 
   {
      Driver_Print_Error( );
      exit( 1 );
   }

   Radial = New_Object( SUB_W*2 * SUB_H*2, PIXEL );

   Ptr = ( PIXEL *)Radial;
   for( j=0; j<SUB_H*2; ++j )
      for( i=0; i<SUB_W*2; ++i )
      {
         double Norm, x, y, T;
         int What;
         x = (double)(i-SUB_W)/(SUB_W);
         y = (double)(j-SUB_H)/(SUB_H);
         Norm = ( x*x + y*y );
         Norm = sqrt( Norm )*2.0*M_PI*2.0;
         if ( y!=0.0 ) T = atan2( y, x );
         else 
         {
            if ( x>0.0 ) T = M_PI;
            else T = -M_PI;
         }
         Norm += .325 + .5*sin( T*5.0 );
         Norm = ( 1.0 + sin( Norm ) )*127.9;
         *Ptr++ = ( PIXEL )( Norm );
      }

   Count = 0;

   Main_Loop( The_Screen );

   M_Free( Radial );
   Driver_Close( The_Screen );
   exit( 0 );
}

/*********************************************************************/
/*********************************************************************/


