/*
 *       strange.c
 *
 * Strange attractors are not so hard to find :)
 *
 *   this little proggy is adapted from my 
 *   contribution to 'xlockmore' (version>4.1)
 *
 *                                 Skal97
 *  Pascal.Massimino@ens.fr
 *  http://www.eleves.ens.fr:8080/home/massimin
 ***************************************************/
 
/*****************************************************/

#include "sl.h"

/*****************************************************/

#include <math.h>
#include <time.h>
#include <stdlib.h>

typedef float          DBL;
typedef int            PRM;

MEM_IMAGE The_Screen;
COLOR_ENTRY CMap[256];

#ifndef RAND_MAX
#define RAND_MAX  ( (1<<32)-1 )
#endif

/*********************************************************************/

extern void Release_Strange( );

void Clean( int dummy )
{
   Driver_Close( The_Screen );
   Release_Strange( );
   exit( 0 );
}

/*********************************************************************/

#define UNIT (1<<12)
#define UNIT2 (1<<14)
/* #define UNIT2 (3140*UNIT/1000) */

#define SKIP_FIRST      100
#define MAX_POINTS      6500
#define DBL_To_PRM(x)  (PRM)( (DBL)(UNIT)*(x) )

#define DO_FOLD(a) (a)<0 ? -Fold[ (-(a))&(UNIT2-1) ] : Fold[ (a)&(UNIT2-1) ]


/******************************************************************/

#define MAX_PRM 3*5

typedef struct {
   DBL Prm1[ MAX_PRM ], Prm2[ MAX_PRM ];
   void (*Iterate)( PRM, PRM, PRM *, PRM * );
   int Cur_Pt, Max_Pt;
   int Col, Count, Speed;
} ATTRACTOR;

typedef struct XPoint { short x, y; } XPoint;

static ATTRACTOR Root;
static PRM xmin, xmax, ymin, ymax;
static PRM Prm[ MAX_PRM ];
static PRM Fold[ UNIT2+1 ];
static XPoint *Buffer1, *Buffer2;
static INT *Lines = NULL;

/******************************************************************/
/******************************************************************/

static DBL Amp_Prm[ MAX_PRM ] =
{
   1.0, 3.5, 3.5, 2.5, 4.7,
   1.0, 3.5, 3.6, 2.5, 4.7,
   1.0, 1.5, 2.2, 2.1, 3.5
};
static DBL Mid_Prm[ MAX_PRM ] = 
{
   0.0, 1.5,  0.0, .5, 1.5,
   0.0, 1.5,  0.0, .5, 1.5,
   0.0, 1.5, -1.0, -.5, 2.5,
};

static DBL Gauss_Rand( DBL c, DBL A, DBL S )
{
   DBL y;

   y = (double)random( )/RAND_MAX;
   y = A * ( 1.0 - exp( -y*y*S )  ) / ( 1.0 - exp( -S ) );
   if ( random()&0x01 ) return( c + y );
   else return( c - y );
}

static void Random_Prm( DBL *Prm )
{
   int i;

   for( i=0; i<MAX_PRM; ++i )
      Prm[ i ] = Gauss_Rand( Mid_Prm[ i ], Amp_Prm[ i ], 4.0 );
}

/***************************************************************/

   /* 2 examples of non-linear map */

static void Iterate_X2( PRM x, PRM y, PRM *xo, PRM *yo )
{
   PRM xx, yy, xy, x2y, y2x, Tmp;

   xx = (x*x)/UNIT;  
   x2y = (xx*y)/UNIT;
   yy = (y*y)/UNIT;  
   y2x = (yy*x)/UNIT;
   xy = (x*y)/UNIT;

   Tmp = Prm[1]*xx + Prm[2]*xy + Prm[3]*yy + Prm[4]*x2y;
   Tmp = Prm[0] - y + (Tmp/UNIT);
   *xo = DO_FOLD( Tmp );
   Tmp = Prm[6]*xx + Prm[7]*xy + Prm[8]*yy + Prm[9]*y2x;
   Tmp = Prm[5] + x + (Tmp/UNIT);
   *yo = DO_FOLD( Tmp );
}

static void Iterate_X3( PRM x, PRM y, PRM *xo, PRM *yo )
{
   PRM xx, yy, xy, x2y, y2x, Tmp_x, Tmp_y, Tmp_z;

   xx = (x*x)/UNIT;  
   x2y = (xx*y)/UNIT;
   yy = (y*y)/UNIT;  
   y2x = (yy*x)/UNIT;
   xy = (x*y)/UNIT;

   Tmp_x = Prm[1]*xx + Prm[2]*xy + Prm[3]*yy + Prm[4]*x2y;
   Tmp_x = Prm[0] - y + (Tmp_x/UNIT);
   Tmp_x = DO_FOLD( Tmp_x );

   Tmp_y = Prm[6]*xx + Prm[7]*xy + Prm[8]*yy + Prm[9]*y2x;
   Tmp_y = Prm[5] + x + (Tmp_y/UNIT);
   Tmp_y = DO_FOLD( Tmp_y );

   Tmp_z = Prm[11]*xx + Prm[12]*xy + Prm[13]*yy + Prm[14]*y2x;
   Tmp_z = Prm[10] + x + (Tmp_z/UNIT);
   Tmp_z = UNIT+Tmp_z*Tmp_z/UNIT;

   *xo = (Tmp_x*UNIT)/Tmp_z;
   *yo = (Tmp_y*UNIT)/Tmp_z;
}

static void ( *Funcs[ 2 ] )( PRM, PRM, PRM *, PRM *) = {
   Iterate_X2, Iterate_X3
};

/***************************************************************/

static void inline Draw_Points( PIXEL *Bits, XPoint *Buf, INT Nb, PIXEL Color )
{
   int i;
   for( i=Nb-1; i>=0; --i )
      Bits[ Buf[i].x + Lines[ Buf[i].y ] ] = Color;
}

static void Draw_Strange( MEM_IMAGE Screen )
{
   int i, j, n, Cur_Pt;
   PRM x, y, xo, yo;
   DBL u;
   XPoint *Buf;
   DBL Lx, Ly;
   void (*Iterate)( PRM, PRM, PRM *, PRM * );

   Cur_Pt = Root.Cur_Pt;
   Iterate = Root.Iterate;

   u = ( DBL )( Root.Count )/1000.0;
   for( j=MAX_PRM-1; j>=0; --j )
      Prm[ j ] = DBL_To_PRM( (1.0-u)*Root.Prm1[ j ] + u*Root.Prm2[ j ] );

   x = y = DBL_To_PRM( .1 );
   for( n=SKIP_FIRST; n; --n )
   {
      (*Iterate)( x, y, &xo, &yo );
      x = xo - 4 + ( random()&0x07 );
      y = yo - 4 + ( random()&0x07 );
   }

   xmax = 0; xmin = UNIT*4;
   ymax = 0; ymin = UNIT*4;
   Root.Cur_Pt = 0;
   Buf = Buffer2;
   Lx = (DBL)Zone_Width( Screen )/UNIT/2.2;
   Ly = (DBL)Zone_Height( Screen )/UNIT/2.2;
   for( n=Root.Max_Pt; n; --n )
   {
      (*Iterate)( x, y, &xo, &yo );
      Buf->x = ( short )( Lx*( x + DBL_To_PRM( 1.1 ) ) );
      Buf->y = ( short )( Ly*( DBL_To_PRM( 1.1 ) - y ) );
      /* fprintf( stderr, "X,Y: %d %d    ", Buf->x, Buf->y ); */
      Buf++; Root.Cur_Pt++;
      if ( xo>xmax ) xmax = xo;
      else if ( xo<xmin ) xmin = xo;
      if ( yo>ymax ) ymax = yo;
      else if ( yo<ymin ) ymin = yo;
      x = xo - 4 + ( random()&0x07 );
      y = yo - 4 + ( random()&0x07 );
   }

   Draw_Points( Zone_Scanline( Screen, 0 ), Buffer1, Cur_Pt, 0 );
   Draw_Points( Zone_Scanline( Screen, 0 ), Buffer2, Root.Cur_Pt, Root.Col );

   Buf = Buffer1; Buffer1 = Buffer2; Buffer2 = Buf;

   if ( ( xmax-xmin<DBL_To_PRM(.2) ) && ( ymax-ymin<DBL_To_PRM(.2) ) )
      Root.Count += 4*Root.Speed;
   else Root.Count += Root.Speed;

   if ( Root.Count >= 1000 )
   {
      for( i=MAX_PRM-1; i>=0; --i ) Root.Prm1[ i ] = Root.Prm2[ i ];
      Random_Prm( Root.Prm2 );
      Root.Count = 0;
   }

   Root.Col += random()&0x03;
   if ( Root.Col>255 ) Root.Col = 16;
}


/***************************************************************/

void Release_Strange( )
{
   if ( Buffer1 != NULL ) free( Buffer1 );
   if ( Buffer2 != NULL ) free( Buffer2 );
   Buffer1 = NULL;
   Buffer2 = NULL;
   if ( Lines != NULL ) M_Free( Lines );
}

/***************************************************************/

static INT Init_Strange( MEM_IMAGE Screen )
{
   ATTRACTOR *Attractor;
   int i;

   srandom( time(NULL) );

   for( i=0; i<=UNIT2; ++i )
   {
      DBL x;      
      /* x = ( DBL )(i)/UNIT2; */
      /* x = sin( M_PI/2.0*x ); */
      /* x = sqrt( x ); */
      /* x = x*x; */
      /* x = x*(1.0-x)*4.0; */
      x = ( DBL )(i)/UNIT;
      x = sin( x );
      Fold[ i ] = DBL_To_PRM( x );
   }

   bzero( &Root, sizeof( Root ) );

   Buffer1 = ( XPoint *)calloc( MAX_POINTS, sizeof( XPoint ) );
   if ( Buffer1 == NULL ) goto Abort;
   Buffer2 = ( XPoint *)calloc( MAX_POINTS, sizeof( XPoint ) );
   if ( Buffer2 == NULL ) goto Abort;

   Root.Max_Pt = MAX_POINTS;

   Root.Cur_Pt = 0;
   Root.Count = 0;
   Root.Col = random() & 0xFF;
   Root.Speed = 4;

   Root.Iterate = Funcs[ random() % 2 ];
   Random_Prm( Root.Prm1 );
   Random_Prm( Root.Prm2 );

   if ( Lines != NULL ) M_Free( Lines );
   Lines = ( INT *)New_Object( Zone_Height( Screen ), INT );
   if ( Lines == NULL ) goto Abort;
   for( i=0; i<Zone_Height( Screen ); ++i )
      Lines[i] = Zone_BpS( Screen )*i;

   return( FALSE );

Abort:
   Release_Strange( );
   Root.Cur_Pt = 0;
   return( TRUE );
}


/***************************************************************/

void main( int argc, char **argv )
{
   INT i;
   PIXEL r, g, b, lr, lg, lb;
   STRING Mode_String;

   Mode_String = "640:480:0x000";

   if ( argc>1 ) Mode_String = argv[1];

   Register_Video_Support( 4, _G_DGA_DRIVER_,
      _G_X11_DRIVER_, _G_SVGL_DRIVER_, _G_VBE_DRIVER_ );
   The_Screen = Driver_Call( NULL,
      DRV_DISPLAY, ":0",
      DRV_NAME, "Strange attractors",
      /* DRV_DETECT, */
      DRV_CONVERT,
      DRV_MODE, Mode_String,
      DRV_END_ARG );
   if ( The_Screen == NULL )
   {
      Driver_Print_Error( );
      exit(1);
   }

   if ( Init_Strange( The_Screen ) ) Exit_Upon_Error( "Error in init." );

   lr = lg = lb = 255;
   Drv_Build_Ramp( CMap, 1, 15, 0,0,0, lr, lg, lb );
   for( i=16; i<255-32; i+=32 )
   {
      r = random() & 0xFF;
      g = random() & 0xFF;
      b = random() & 0xFF;
      Drv_Build_Ramp( CMap, -1, 32, lr, lg, lb, r, g, b );
      lr = r; lg = g; lb = b;
   }
   Drv_Build_Ramp( CMap, -1, 32, lr, lg, lb, 255, 255, 255 );
   Driver_Change_CMap( The_Screen, 256, CMap );

   i = 0;
   do {
      Draw_Strange( The_Screen );
      Zone_Flush( The_Screen );
      i++;
      if ( Driver_Get_Event(The_Screen) & DRV_KEY_PRESS ) break;
   }
   while( i != 70000 );

   Clean( 0 );
}

/***************************************************************/

