;**
;** bimo.asm:
;** Assembler code for real-mode and protected-mode
;** INT 0xC interrupt handlers to support the INT 0xC
;** interrupt in both modes
;**
.386
;**
;** The real-mode interrupt handler is in a 16-bit code
;** segment so that the assembler will generate the right
;** code.  We will copy this code down to a 16-bit segment
;** in low memory rather than executing it in place.
;**

;**
;** The protected-mode interrupt handler is in a 32-bit code
;** segment.  Even so, we have to be sure to force an IRETD
;** at the end of the handler, because MASM doesn't generate
;** one.  This handler will be called on a 32-bit stack by
;** DOS/4GW.
;**
;** _DATA is the flat model data segment, which we load into
;** ES so we can write to absolute address 0xB8000.  (In the
;** flat model, DS is based at 0.)
;**

MC_SIZE EQU 32

_DATA   SEGMENT DWORD PUBLIC USE32 'DATA'

    PUBLIC  _ms_mask,_msv_cur_x,_msv_cur_y

_ms_mask db (MC_SIZE*MC_SIZE) dup (?)
ms_save  db (MC_SIZE*MC_SIZE) dup (0)
ms_x     dw ?
ms_y     dw ?
mouse_volt  db 0
msv_state dw 0 ; init
last_bnk  dw 0FFh ; initelni
_msv_cur_x    dw ?
_msv_cur_y    dw ?
save_bnk dw ?
vesa_gran dw 64 ; kbyte-os ablakok --- ez nem biztos!!!

_DATA   ENDS

;---------------------------------------------------------------------

DGROUP GROUP _DATA

_TEXT   SEGMENT DWORD PUBLIC USE32 'CODE'
    ASSUME  cs:_TEXT

    PUBLIC  msv_handler_,msv_hide_,msv_show_,msv_init_

    ASSUME  ds:_DATA, es:_DATA
setaddr: ; X:ebx, Y:edx -- input | Ret: esi -- fulladdr.

    push    edx
    and     edx,0ffffh
    and     ebx,03ffh ; max 1024

    push    edx ebx

    shr     dx,6
    cmp     dx,last_bnk
    je      nemkelluj
    mov     last_bnk,dx
    mov     ax,04f05h
    mov     bx,0
    int     10h
nemkelluj:
    pop     ebx edx

    push    edx
    shl     edx,10
    and     edx,0ffffh
    add     edx,0a0000h
    add     edx,ebx

    mov     esi,edx
    pop     edx
    pop     edx
    ret
;----------------------------------
putmousec:
    push   ebp

    mov    bx,_msv_cur_x
    mov    dx,_msv_cur_y
    mov    bp,MC_SIZE
    mov    edi,offset _ms_mask
    cld
ujsor3:
    call   setaddr
    mov    ecx,MC_SIZE
ujoszl4:
    mov    al,es:[edi]
    cmp    al,0ffh
    je     nemrakunkmost
    mov    ds:[esi],al
nemrakunkmost: ; maszkolas
    inc    esi
    inc    edi
    loop   ujoszl4

    inc    dx   ; y++

    dec    bp
    jnz    ujsor3
    pop    ebp
    ret
;----------------------------------
restmousec:
    cmp    mouse_volt,0
    je     pmvx2

    push   ebp

    mov    bx,ms_x
    mov    dx,ms_y
    mov    bp,MC_SIZE
    mov    edi,offset ms_save
    cld
ujsor2:
    call   setaddr
    mov    ecx,MC_SIZE
ujoszl1:
    mov    al,es:[edi]
    mov    ds:[esi],al
    inc    esi
    inc    edi
    loop   ujoszl1

    inc    dx   ; y++

    dec    bp
    jnz    ujsor2
    pop    ebp
    mov    mouse_volt,0

pmvx2:
    ret
;-----------------------------
savemousec:
    push   ebp

    mov    bx,_msv_cur_x
    mov    dx,_msv_cur_y
    mov    bp,MC_SIZE
    mov    edi,offset ms_save
    cld
ujsor1:
    call   setaddr
    mov    ecx,MC_SIZE
    rep    movsb    ; ds:si -> es:di
    inc    dx   ; y++

    dec    bp
    jnz    ujsor1
    pop    ebp

    mov    mouse_volt,1
    ret
;-----------------------------
msv_handler_:
    push    es ds
    pusha
    mov     bx,DGROUP
    mov     es,bx
    mov     ds,bx
    ASSUME  ds:_DATA, es:_DATA

    cmp     msv_state,1
    jne     nemaktiv

    mov     _msv_cur_x,cx
    mov     _msv_cur_y,dx

; ide kell meg save_bank is,
    call    restmousec
    call    savemousec
    call    putmousec
; ide meg restore!
    mov     ax,_msv_cur_x
    mov     ms_x,ax
    mov     ax,_msv_cur_y
    mov     ms_y,ax

nemaktiv:

    popa
    pop     ds es
;    iretd
    retf
;-----------------------------
msv_hide_:
    call    restmousec
    mov     msv_state,0
    ret

msv_show_:
    mov     msv_state,1
   ; kene meg vmi paint is.../readmousepos
    ret

msv_init_: ; elvileg itt is DS stimmel...
    mov mouse_volt,0
    mov msv_state,-1
    mov last_bnk,0FFh
    ret

_TEXT   ENDS
    END
