
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <sys\stat.h>
#include <mem.h>
#include <alloc.h>
#include <ctype.h>
#include <graphics.h>
#include "..\vgafx.h"

#include "zzdata.h"

//extern czdf zf;
extern "C" void far far_EGAVGA_driver( void );

#include <graphics.h>
#include <stdio.h>

/*	PCXFILE.c -  Routines to generate PCX files
*/


//#include <stdio.h>
//#include "lib.h"
//#include "pcx.h"


/*	PCX_GETC

	Read the next "token" in the picture file. If the high order
	two bits are not 11, then it's a single byte. If they are,
	it's a repeat count, and the next byte is the value to repeat.
*/

#define uint unsigned int
#define uchar unsigned char
#define ERROR   (-1)		/* function failure return val		*/
#define OK      ( 0)		/* function success return val		*/

char far *EGA_BASE = (char far *)MK_FP(0xA000,0);
int select_plane( int plane );

typedef struct {
   unsigned char red, green, blue;
} TRIPLET;

typedef struct {
   char maker,
 	version,
	code,
	bpp;
   int	x1, y1, x2, y2,
   	hres, vres;
   TRIPLET triple[16]; /* palette */
   char vmode,
   	nplanes;
   int	bpl;
   char __unused[128-68];
} PCXHDR;


long fbpos=0;
long fbsize=0;
char far *fbuf=NULL;

int xgetc()
{
 fbpos++;
 if (fbpos>fbsize)
  return EOF;

 return fbuf[fbpos];
}

int pcx_getc( unsigned *c,unsigned *n, int fpvan, unsigned maxn )
{
	static int csave=-1, nsave=-1;
	unsigned int i;

	if ( !fpvan )
	   return nsave = csave = -1;

	if ( nsave == -1 )
	{  *n = 1;

	   if ( (i=xgetc()) == EOF )
	      return ERROR;

	   if ( (i & 0xc0) == 0xc0 )
	   {  *n = i & 0x3f;
	      if ( (i=xgetc()) == EOF )
	         return ERROR;
	   };

	   *c = i;
	} else
	{  *n = nsave;
	   *c = csave;
	   nsave = csave = -1;
	};

	if ( *n > maxn )
	{  nsave = *n - maxn;
	   csave = *c;
	   *n = maxn;
	};
	return OK;
}


typedef struct {
   PCXHDR hdr;
   uchar **rows[4];
} PCXPIC;


int pcx_read_pic( char far *fb, long size )
{
 fbuf=fb;
 fbpos=0;
 fbsize=size;
	/* A picture consists of a number of lines, each line having
	   a number of planes. Each plane is a bit map.
	*/
	uchar /* *calloc(), *allocz(),*/ *p;
	int i, j, c, n, row, plane, bytes, nrows, nplan;
	PCXHDR *ph;

        PCXPIC pic;
	ph = & pic.hdr;

	//fseek( fp, 0l, 0 );
	//if ( fread( (char *)ph, sizeof(*ph), 1, fp ) != sizeof(*ph) )
	// ; //  return ERROR;
        _fmemcpy((char far *)ph, fbuf, sizeof(*ph) );
        fbpos+=sizeof(*ph);

	pcx_getc( (uint *)0, (uint *)0, 0, 0 );

	bytes = ph->bpl;
	nrows = ph->y2 - ph->y1 +1;
	nplan = ph->nplanes;

        /*
	for ( plane = 0; plane < nplan; plane++ )
	   if ( ! pic->rows[plane] )
	      if ( ! (pic->rows[plane] =
				(uchar **)calloc(1,sizeof(char *) * nrows)) )
	         return 1;
        */

        char *q = (char *)malloc(bytes+1);
	for ( row = 0; row < nrows; row++ )
	   for ( plane = 0; plane < nplan; plane++ )
	    {
	   /*  if ( !(p = pic->rows[plane][row]) )
	         if ( !(p = pic->rows[plane][row] = calloc(1,bytes +1)) )
	            return 1;
             */
              p=q;
	      for ( n=i=0; i<bytes; i += n )
	       {
	        if ( pcx_getc( (uint *)&c, (uint *)&n, 1, bytes - i ) )
	         return ERROR;
	        for ( j=0; j < n; j++ )
	         *p++ = c;
	       };
             if (nplan>1)
              select_plane(plane);
             else
              select_plane(-0x0F);
             _fmemcpy((EGA_BASE+80*row),q,80);
	    };
        free(q);
	return OK;
}





#define REG_ADDRESS 0x3c4
#define REG_MAPMASK 0x3c5
#define REG_IDX     0x3ce
#define REG_VAL     0x3cf
#define OUTIDX(i,v) {outportb(REG_IDX,i);outportb(REG_VAL,v);}

int select_plane( int plane )
{
 outportb( REG_ADDRESS, 2 );
 outportb( REG_MAPMASK, plane >= 0 ? 1 << (plane & 0x03) : -plane );
}


int LoadPCX( char *fname )
{
 cleardevice();

 long bs;
 char far *kbuf;

 bs=zf.getsize(fname);
 kbuf=(char far *)farmalloc(bs);
 zf.far_readfile(fname,kbuf);

 pcx_read_pic(kbuf,bs);

 farfree(kbuf);
}

