#include <process.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <alloc.h>
#include <dos.h>
#include <conio.h>
#include <mem.h>
#include <ctype.h>
#include <graphics.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys\types.h>

#include "zzfiles.h"
#include "zzdata.h"
#include "..\HSC\hsc.h"
#include "..\mouse.h"
#include "zzvga.h"
#include "..\SB\SBDriver.h"
#include "..\SND\sndsys.h"
#include "..\DVT\bccdvt.cpp"

/*
   Errlist & enhancements:
    [ ] Write to file - ask filename!
    [ ] Write to file !!! error !!!
    [ ] Paletta rossz

    [ ] ZigZagLX file feldolgozasa -> ha hiba van a file-ban, akkor kifagyhat
    [X] Billentyuzet
    [ ] Kereses
    [ ] File kiiras
    [X] File nyomtatas
    [ ] 80 oszlopnal tobb van => kifagyhat a cikknel, elromolhat
*/

///////////////////////////////////////////////
#define UNDER_DEVELOPMENT  0 // 1 // 0
///////////////////////////////////////////////

#define SZOVEGALWAYSEXT 0

#define PRINTERNUM      0
#define SZUNET          15

#define EZZELXor        0xFF

#define IU_PRESSED    1
#define IU_DEPRESSED  0

#define NSOROKLEFELE  27

#define S_DOWN   0
#define S_UP     1
#define S_ZZLOGO 2
#define S_QUIT   3
#define S_BACK   4
#define S_HELP   5
#define S_DOWNd  6
#define S_QUITd  7
#define S_HELPd  8
#define S_BACKd  9
#define S_WAIT   10
#define S_UPd        11
#define S_ZENEOFF    12
#define S_ZENEON     13
#define S_ZENEOFFd   14
#define S_ZENEONd    15
#define S_END    16
#define S_HOME   17
#define S_HOMEd  18
#define S_ENDd   19
#define S_GOTO   20
#define S_GOTOd  21
#define S_ZENECH     22
#define S_ZENECHd    23
#define S_NUMBERX    24
#define S_PRINT      25
#define S_PRINTd     26
#define S_DISKRE     27
#define S_DISKREd    28
#define S_TXTDISK    29
#define S_TXTDISKd   30
#define S_DISKREg    31
#define S_TXTDISKg   32
#define S_OK         33
#define S_OKd        34
#define S_CANCEL     35
#define S_CANCELd    36
#define S_SOUNDOFF   37
#define S_SOUNDOFFd  39
#define S_SOUNDON    38
#define S_SOUNDONd   40

#define V_SELECT 1
#define V_CLICK  2
#define V_INTRO  3

#define DISPPAGEX  4+8*48-30    // "Page X/Y" -nak a kezdo x-e
#define DISPPAGEY  20-3

#define DW_X     320
#define DW_Y     240

#define SX_HELP    550
#define SX_ZENE    515
#define SX_ZENECH  485
#define SX_SOUND   450

#define K_ESCAPE 27
#define K_ENTER  13
#define K_DOWN   80
#define K_UP     72
#define K_LEFT   75
#define K_RIGHT  77
#define K_PGDN   81
#define K_PGUP   73
#define K_HOME   71
#define K_END    79
#define K_F1     59

#define C_MENU          DARKGRAY
#define C_MBORDER       WHITE

#define WT_NONCENTER    0
#define WT_CENTER       1

#define COORDX(x)  ((x) * 8)
#define COORDY(y)  (43 + (y) * 16)
/*------------------------------*/
extern "C" void far far_EGAVGA_driver( void );
extern "C" void far far_Herc_driver( void );

extern "C" void WriteStr(int ccoff,int x,int y,int stroff, int strlen, int color=15,int iscoded=0);
extern "C" void WriteStr386(int ccoff,int x,int y,int stroff, int strlen, int color=15,int iscoded=0);
extern "C" int far vanedebug( void );
extern "C" int far setcol( unsigned fbcol );
int Sb_Get_Params(void);



int hck=0;
void memchk(void)
{
 int cnt=0;
 if (heapcheck()==-1)
  {
   struct heapinfo hi;

   hi.ptr = NULL;
   gotoxy(1,1);
   printf( "   Size   Status  (Heap)\n" );
   printf( "   ----   ------\n" );
   while( heapwalk( &hi ) == _HEAPOK )
    {
     cnt++;
     printf( "%7u    %s\n", hi.size, hi.in_use ? "used" : "free" );
     if (cnt>5)
      return;

     if (cnt>20)
      {
       cnt=0;
       printf("Pause...");
       getch();
      }
    }
   getch();
  }
 if (farheapcheck()==-1)
  {
   struct farheapinfo hi;

   hi.ptr = NULL;
   printf( "   Size   Status  (Far heap)\n" );
   printf( "   ----   ------\n" );
   while( farheapwalk( &hi ) == _HEAPOK )
    {
     cnt++;
     if (cnt>5)
      return;

     printf( "%7lu    %s\n", hi.size, hi.in_use ? "used" : "free" );
     if (cnt>20)
      {
       cnt=0;
       printf("Pause...");
       getch();
      }
    }
   getch();
  }
}


/*------------------------*/
scim cim[200];
int maxcim=0;

char far* sprites[50];
/*---*/
char wszov[100];
char *currfont = NULL;
char charadd[4102];
char charadd2[4102];

int music_num=1;
char far *mus[10];

char vanAdLib;

czdf zf;

unsigned SbIOaddr = 0x220; // default SB port
unsigned SbIRQ    = 7;     // default SB IRQ
unsigned SbDMAchan = 1;
unsigned SbType = 3; // default type : SB 2.0

unsigned int SB_status = 0; // SB status flag

char far *voc[10];

int sound_s=1;
int tpage=0;
/*-------------------------------------*/

struct s_ico
 {
  int id;
  int id2;
  int x;
  int y;
  int width;
  int height;
 };

class sman
 {
  s_ico *ico;
  int ico_num;
  int wl;

 public:
  void addicon(int x,int y,int id,int id2=-1);
  void replaceicon(int rid,int x,int y,int id,int id2=-1);
  void drawall( void );
  int geticon(int x,int y); // (...,-1, ha nincs)
  void updateicon( int id , int state, int snd=0 );
  int getpressed( void ); // -1, ha nincs
  sman( int maxicons=25 );
  ~sman( void );
 };

/*-------------------------------------*/

void loadsprites( void );
int spriteunchain( char far *schain, long sc_size, char far** stomb );
void putsprite( int x,int y, int id );
int spritex( int id );
int spritey( int id );
void writetext(int x,int y,char far *text, int iscenter=WT_NONCENTER,int iscoded=0 );
void loadtitles( void );
void drawbars( void );
void cikkbetolt( scim cm );
int outpage( char far *page );
int convtext( char huge *hova, long *oldind, long fs );
void dispwait( void );
void undispwait( void );
void dispstatpage( int cur, int max, int all );
char *getstring(int x,int y, char *buff, int maxkar, int csaknum=0);
void printstring(char far* address);
long calcowncrc ( char *fnev,void (*statdisp)(long,long));
void loadpic( scim cime );
void loadPCXpic( scim cime );
void loadANSI( scim cime );
void specLoadDriver(void);
char far * specLoadVOC(char *name);  // after play, user MUST FARfree buf
int askconfirm(char *sor1,char *sor2);
void xoroltomb(char huge* mit);
void checkstatus(long where,long max);
void drawxbar( int px, int onoff=1 );

void VGAoutro(void);
/*------------------------------*/

void main ( int argc, char **argv )
{
 unsigned sAX;

 int f;
 int mpage=0;
 long len;
 unsigned xx;
 int c,d;
 long crc;

 int vd=0;

 asm push DS
 _DS=_psp;
 vanedebug();
 asm pop DS
 vd=_AX;

 /*
 if (vd==1 && (!UNDER_DEVELOPMENT) )
  {
   printf(
   "            ###############################\n"
   "            ###    H!    ###\n"
   "            ###############################\n"
   "                                           \n"
   "              Ez a NOSASOFT diszkjsga, a \n"
   "                      Z I G Z A G          \n"
   "                                           \n"
   "            s nem DEBUG pldaprogram,  ha \n"
   "            mindenkppen debuggolni akarsz,\n"
   "            akkor sajnos valami  mst  kell\n"
   "            keresned, mert a ZIGZAG nem fog\n"
   "            DEBUG-gal a htn futni. Ha r-\n"
   "            dekel, hogy mirt, akkor olvasd\n"
   "            el a megfelel cikket (ZigZ.#1)!\n"
   "            De ne DEBUG all indtsad, mert\n"
   "            akkor  megint  csak  ezt a szar\n"
   "            szveget olvasgathatod.        \n"
   "            s hidd el, nem a DEBUG a szar,\n"
   "            s nem is a ZIGZAG....         \n"
   "              (rlj, hogy nem ptettnk(?)\n"
   "            a programba bntet eljrst,\n"
   "            mert akkor most megnzhetnd\n"
   "            magad.)\n" );
   exit(1);
  }
 */

#if (UNDER_DEVELOPMENT==1)
 printf("\r\n\n\n\n\nWarning: This has been compiled for internal use only !!!\r\n\n\n\n\n\n\n\n\n");
#endif

 textcolor(WHITE);
 cprintf("Loading NOSASOFT ZigZag...");

 char DemoVTver [32];



 if (! VT_Init() )
 {
   cprintf("\r\nPlease run ZIGZAG.BAT to get full music support...\r\n" );
   cprintf("Continue without music anyway? [y/N] ");
   c=toupper(getch());
   if (c!='Y')
    return;
 }


 VT_IDstring( DemoVTver );
 /*
 printf( "DemoVT found. Version string is \"%s\".\n"
         "Number of channels: %i.\n"
         "VT_Info points to: %Fp.\n\n",
        DemoVTver, VT_ChannelCount(), VT_Info );
 */
 VT_SetVolume(255);
 VT_AutoOn();
 VT_SyncStart();
 /*
 SSLoadDriver();
 SS_configinit();
 SS_setvolume(255);
 if (SS_loadmod("thalamus.mod"))
  {
   printf("Err loading mod...\n");
   return;
  }

 SS_playmusic();
 getch();
 */

 if (zf.open(/*argv[0]*/ "ZIGZAG.000"))
  {
   printf("Error with/opening data file...\n");
   return;
  }

 //SS_playmusic();

 /*
 while (1)
  {
   pollMIDI();
   putch('.');
   if (kbhit())
    {
     c=getch();
     if (c==27)
      break;
     putch(c);
    }
  }
 stopMIDI();
 endMIDI();
 */

 mouse_installed();



 registerfarbgidriver(far_EGAVGA_driver);

 //&& specLoadDriver();

 if (driver)
  {
   Sb_Get_Params();

   SetIOAddr( SbIOaddr );
   SetIRQ( SbIRQ );

   InitialiseDriver();
  }

 if (SB_installed)
  SetStatusWord(&SB_status);

 if (SB_installed)
  voc[3] = specLoadVOC("ZigZag3.VOC");

 if (SB_installed)
  farOutputVoice(voc[V_INTRO]);

 VGAintro();

 len = zf.getsize("ZZMusic1.HSC");
 mus[0]=(char far*)farmalloc(len);
 zf.far_readfile("ZZMusic1.HSC",mus[0]);
 music_num=1; // itt (mg) csak 1 lehet

 //&& vanAdLib=1;
 //&& if (!HSC_reset())
  vanAdLib=0;

 //-- if (argv[1][0]!='N')
 //--  HSC_startmusic(mus[music_num-1]);

 char far *tg;
 tg = (char far *)farmalloc(imagesize(5,5,40,25));
 getimage(5,5,40,25,tg);
 sheader hd;
#if (UNDER_DEVELOPMENT == 0)
 /*
 zf.close(); // ez kell a SHARE miatt !!!
 crc=calcowncrc("ZigZag.NSS",checkstatus);
 zf.open();
 */
#endif

 zf.get_header(&hd);
#if (UNDER_DEVELOPMENT == 0)
 /*
 if (crc!=hd.filecrc)
  {
   closegraph();
   printf("Error:\n\rZigZag.NSS is not valid.\n\r");
   UninstallDriver();
   exit(2);
  }
 */
#endif
 //--
 //-- if (SB_installed)
 //--  {
 //--   voc[1] = specLoadVOC("ZigZag1.VOC");
 //--   voc[2] = specLoadVOC("ZigZag2.VOC");
 //--  }

 len = zf.getsize("ZZMusic2.HSC");
 mus[1]=(char far*)farmalloc(len);
 zf.far_readfile("ZZMusic2.HSC",mus[1]);
 len = zf.getsize("ZZMusic3.HSC");
 mus[2]=(char far*)farmalloc(len);
 zf.far_readfile("ZZMusic3.HSC",mus[2]);

 loadtitles();

 checkstatus(100l,100l);
 putimage(5,5,tg,0);
 if (tg) farfree(tg);

 while ((!kbhit()) && (!left_button_pressed()))
  ;

 while (kbhit())
  getch();

 //closegraph();
 VGAoutro();

 int gdriver = DETECT, gmode, errorcode;
 initgraph(&gdriver, &gmode, "");

 struct palettetype pal,pal2,pal3={16,{0,1,49,59,43,47,611,53,21,5,12,13,49,52,62,63}};
 getpalette(&pal);

 for (c=0;c<16;c++)
  pal2.colors[c]=pal.colors[WHITE];

 setallpalette(&pal2);

 int f1;
 unsigned bytes;
 if (zf.getsize("ZZFont.dat")>4100)
  {
   printf("Fatal error : Font file > 4100 bytes");
   exit(1);
  }
 if (zf.getsize("ZZFont.dat")==-1)
  {
   printf("Fatal error : Font file not found");
   exit(1);
  }
 zf.far_readfile("ZZFont.dat",(char far *)&charadd);
 currfont = (char *)&charadd;

 zf.far_readfile("ZZFont2.dat",(char far *)&charadd2);

 setfillstyle(SOLID_FILL,C_MENU);
 bar(0,0,639,40);
 setcolor(C_MBORDER);
 rectangle(0,0,639,40);


 setcolor(BLACK);
 settextjustify(CENTER_TEXT,CENTER_TEXT);
 outtextxy(322,22,"Loading NOSASOFT ZigZag...");
 setcolor(WHITE);
 outtextxy(320,20,"Loading NOSASOFT ZigZag...");


 mouse_window( 0,0,639,479 );
 mouse_sensivity( 8,16 );
 //set_mouse_position(320,120);
 //enable_software_cursor();
 //m_hide();

 //settextjustify(LEFT_TEXT,TOP_TEXT);

 loadsprites();


 setcolor(DARKGRAY);
 outtextxy(322,22,"Loading NOSASOFT ZigZag...");
 outtextxy(320,20,"Loading NOSASOFT ZigZag...");


 putsprite(10-2,20-spritey(S_ZZLOGO)/2,S_ZZLOGO);
 putsprite(65-5,20-spritey(S_NUMBERX)/2,S_NUMBERX);

 sman ms(20);

 ms.addicon(200,5,S_DOWN,S_DOWNd);
 ms.addicon(170,5,S_UP,S_UPd);
 ms.addicon(100,5,S_QUIT,S_QUITd);
 ms.addicon(SX_SOUND,5,S_SOUNDOFF,S_SOUNDOFFd);
 //ms.addicon(SX_ZENECH,5,S_ZENECH,S_ZENECHd);
 //ms.addicon(SX_ZENE,5,S_ZENEOFF,S_ZENEOFFd);
 ms.addicon(SX_HELP,5,S_HELP,S_HELPd);

 ms.drawall();

 for (c=0; c<=((maxcim>27)?26:maxcim) ; c++)
  writetext(COORDX(40),COORDY(c),cim[c].title,WT_CENTER);

 mpage=maxcim/27+1;
 dispstatpage(1,mpage,1);

 set_mouse_position(320,120);
 enable_software_cursor();

 scim helpcim = {"Help text","help.txt",T_NORMAL,""};

 tpage=0;
 int kar,kar2;
 int kilep=0;
 int posx=0;

 int i,pr;
 int mx,my;
 int redraw=0;
 long tim=0;

 drawxbar(posx,1);
 //drawxbar(posx,0);

 //setallpalette(&pal);
 setallpalette(&pal);


 memchk();

 //startMIDI();
 do
  {
   //delay(SZUNET); //***
   tim++;
   drawbars();
   pr = ms.getpressed();

   memchk();

   if (kbhit())
    {
     kar=toupper(getch());
     if (kar==0)
      kar2=getch();

     switch (kar)
      {
       case K_ESCAPE:kilep = 1;
                    break;
       case  K_ENTER:if ((cim[tpage*27+posx].filenev[0]) && cim[tpage*27+posx].filenev[0]!='\0')
                      {
                       if (SB_installed && sound_s)
                        farOutputVoice(voc[V_SELECT]);
                       cikkbetolt(cim[tpage*27+posx]);
                       redraw=1|2;
                      }
                    break;
       case      'C':pr=S_ZENECH;
                    break;
       case      'M':if (music_num>=512)
                      pr=S_ZENEON;
                     else
                      pr=S_ZENEOFF;
                    break;
       case      'S':if (sound_s)
                      pr=S_SOUNDOFF;
                     else
                      pr=S_SOUNDON;
                    break;
       case        0:switch (kar2)
                      {
                       case K_DOWN:if (posx==((maxcim-tpage*27)>27?26:(maxcim-tpage*27)))
                                    {
                                     if ((tpage+1)*27<maxcim)
                                      {
                                       posx=0;
                                       tpage++;
                                       redraw=1|4;
                                      }
                                     break;
                                    }
                                   if (posx>=((maxcim-tpage*27)>27?26:(maxcim-tpage*27)))
                                    break;
                                   drawxbar(posx,0);
                                   posx++;
                                   drawxbar(posx,1);
                                  break;
                       case K_PGDN:pr=S_DOWN;
                                  break;
                       case   K_UP:if ((posx==0)&&(tpage>0))
                                    {
                                     posx=26;
                                     tpage--;
                                     redraw=1|4;
                                     break;
                                    }
                                   if (posx<=0)
                                    break;
                                   drawxbar(posx,0);
                                   posx--;
                                   drawxbar(posx,1);
                                  break;
                       case K_PGUP:pr=S_UP;
                                  break;
                       case   K_F1:pr=S_HELP;
                                  break;
                      }
                    break;
      }
    }


   if (pr>=0)
    {
     switch (pr)
      {
       case    S_QUIT:kilep=1;
                     break;
       case    S_DOWN:if ((tpage+1)*27<maxcim)
                       {
                        tpage++;
                        redraw=1|4;
                       }
                     break;
       case      S_UP:if (tpage>0)
                       {
                        tpage--;
                        redraw=1|4;
                       }
                     break;
       /*
       case S_ZENEOFF:ms.replaceicon(S_ZENEOFF,SX_ZENE,5,S_ZENEON,S_ZENEONd);
                      ms.updateicon(S_ZENEON,IU_DEPRESSED);
                      HSC_stopmusic();
                      music_num|=512;
                     break;
       case  S_ZENEON:ms.replaceicon(S_ZENEON,SX_ZENE,5,S_ZENEOFF,S_ZENEOFFd);
                      ms.updateicon(S_ZENEOFF,IU_DEPRESSED);
                      music_num|=512;
                      music_num^=512;
                      HSC_startmusic(mus[music_num-1]);
                     break;
       case  S_ZENECH:if (music_num>=512)
                       break;
                      music_num++;
                      if (music_num>3)
                       music_num=1;
                      HSC_stopmusic();
                      HSC_startmusic(mus[music_num-1]);
                     break;
       */
       case S_SOUNDOFF:ms.replaceicon(S_SOUNDOFF,SX_SOUND,5,S_SOUNDON,S_SOUNDONd);
                       ms.updateicon(S_SOUNDON,IU_DEPRESSED);
                       sound_s=0;
                       VT_SetVolume(0);
                       //VT_AutoOff();
                     break;
       case S_SOUNDON:ms.replaceicon(S_SOUNDON,SX_SOUND,5,S_SOUNDOFF,S_SOUNDOFFd);
                      ms.updateicon(S_SOUNDOFF,IU_DEPRESSED);
                      sound_s=1;
                      //VT_AutoOn();
                      VT_SetVolume(255);
                     break;
       case    S_HELP:cikkbetolt(helpcim);
                      redraw=1|2;
                     break;
      }
    }
   if (pr==-2)
    {
     read_mouse_position(&mx,&my);
     if (my>43)
      {
       my-=43;
       my/=16;
       if ((cim[tpage*27+my].filenev[0]) && cim[tpage*27+my].filenev[0]!='\0')
        {
         if (SB_installed && sound_s)
          farOutputVoice(voc[V_SELECT]);
         cikkbetolt(cim[tpage*27+my]);
         redraw=1|2;
        }
      }
    }

   if (redraw)
    {
     if (redraw&4)
      {
       setfillstyle(SOLID_FILL,0);
       m_hide();
       bar(0,41,639,479);
       m_show();
       dispstatpage(tpage+1,mpage,1);
      }
     if (redraw&2)
      {
       m_hide();
       setfillstyle(SOLID_FILL,C_MENU);
       bar(0,0,639,40);
       setcolor(C_MBORDER);
       rectangle(0,0,639,40);
       m_show();

       putsprite(10,20-spritey(S_ZZLOGO)/2,S_ZZLOGO);
       putsprite(65-5,20-spritey(S_NUMBERX)/2,S_NUMBERX);

       dispstatpage(tpage+1,mpage,1);

       ms.drawall();
      }

     for (c=0; c<=((maxcim-tpage*27)>27?26:(maxcim-tpage*27)) ; c++)
      writetext(COORDX(40),COORDY(c),cim[c+tpage*27].title,WT_CENTER);
     redraw=0;
     drawxbar(posx,1);
    }

   if (tim>=30)
    {
     tim=0;
     /*
     drawxbar(posx,0);
     drawxbar(posx,1);
     */
    }
  }
 while (kilep==0);

 HSC_stopmusic();

 VT_AutoOff();  // stop updating music

 closegraph();

 if (mus) farfree(mus);
 int cc;
 for (cc=0; cc<50 ; cc++)
  if (sprites[cc]) farfree(sprites[cc]);

 for (cc=0; cc<10 ; cc++)
  if (voc[cc]) farfree(voc[cc]);

 //SS_stopmusic();
 //SS_endmusic();

 UninstallDriver();
}

void checkstatus(long where,long max)
{
 static char szov[20];

 setcolor(10);
 outtextxy(5,5,szov);
 setcolor(181);
 ltoa((where*100)/max,szov,10);
 strcat(szov,"%");
 outtextxy(5,5,szov);
}

void drawxbar( int px, int onoff )
{
 static cp=0;
 static userpat=0xFFFF;
 long up;
 int ss;
 int sy;
 //setcolor(onoff?LIGHTGRAY:BLACK);
 /*
 setcolor(LIGHTGRAY);
 if (onoff==1)
  {
   cp=(++cp) % 4;
   up=(0x003Fl) << (cp*4);
   //userpat=(0x000F) << (cp*4);
   userpat=up | (up>>16);
   setlinestyle(USERBIT_LINE,userpat,1);
  }
 else
  setlinestyle(USERBIT_LINE,userpat,1);

 setwritemode(XOR_PUT);
 ss=strlen(cim[px+tpage*27].title);
 rectangle(COORDX(40-1)-ss*8/2,COORDY(px)-1,COORDX(40+1)+ss*8/2,COORDY(px+1));
 setwritemode(COPY_PUT);
 setlinestyle(SOLID_LINE,0,1);
 */
 //sy=COORDY(px)-1;
 //sy=COORDY(px+1);

 ss=strlen(cim[px+tpage*27].title);
 setwritemode(XOR_PUT);
 setcolor(MAGENTA);
 m_hide();
 for (sy=(COORDY(px)-1) ; sy<=(COORDY(px+1)) ; sy++)
  line(COORDX(40-1)-ss*8/2,sy,COORDX(40+1)+ss*8/2,sy);
 m_show();
 setwritemode(COPY_PUT);
}

/*------------------------------------------------------------*/

void loadsprites( void )
{
 int f;
 long fs;
 char* buf;

 fs = zf.getsize("ZZSpr.NS");
 buf=(char *)malloc(fs);
 zf.far_readfile("ZZSpr.NS",buf);

 spriteunchain(buf,fs,sprites);

 if (buf) free(buf);
}

int spriteunchain( char far *schain, long sc_size, char far** stomb )
{
 int c;
 int sx,sy;

 char far *dfp=schain;
 unsigned is;

 c=-1;
 while ( sc_size>dfp-schain+1 )
  {
   c++;
   _fmemcpy(&sx,dfp,2); dfp+=2;
   _fmemcpy(&sy,dfp,2); dfp+=2;
   is = imagesize(0,0,sx,sy);
   stomb[c]=(char far *)farmalloc(is+1);
   _fmemcpy(stomb[c],&sx,2);
   _fmemcpy(&(stomb[c][2]),&sy,2);
   _fmemcpy( &(stomb[c][4]),dfp,is-4 ); dfp += is-4;
  }
 c++;

 return(c);
}

int spritex( int id )
{
 int sx;
 _fmemcpy(&sx,&sprites[id][0],2);
 return(sx);
}

int spritey( int id )
{
 int sy;
 _fmemcpy(&sy,&sprites[id][2],2);
 return(sy);
}

void putsprite( int x,int y, int id )
{
 m_hide();
 putimage(x,y,sprites[id],COPY_PUT);
 m_show();
}

/*-------------------------------------------------------------------*/

void writetext(int x,int y,char far *text, int iscenter, int iscoded)
{
 if (iscenter==WT_CENTER)
  x=320-_fstrlen(text)*4;

 _fstrncpy(wszov,text,99); wszov[99]='\0';

 m_hide();
 if (wszov[0]!='\0')
  WriteStr(FP_OFF(currfont),x/8,y,FP_OFF(&wszov),strlen(wszov),YELLOW,iscoded);
  //WriteStr386(FP_OFF(currfont),x/8,y,FP_OFF(&wszov),0,YELLOW,iscoded);
 m_show();
}

/*-------------------------------------------------------------------*/

void loadtitles( void )
{
 int f;
 long fs;
 char far *buf;
 char far *p, far *q;
 char sor[203]; // semelyik sor nem lehet hosszabb 200 kar-nl!
 char *dst;
 int c,cn=0;
 int deltacn=0;

 fs = zf.getsize("ZigZagLX.TXT");
 buf = (char *)farmalloc(fs+1);
 zf.far_readfile("ZigZagLX.TXT",buf);
 buf[fs]='\0';

 p = buf;
 while ( fs>p-buf )
  {
   for (c=0; *p!='\0' && *p!='\r' && *p!='\n' && c<200; sor[c]=*p,p++,c++)  ;
   sor[c]='\0'; p++;
   while ( *p=='\n' || *p=='\r' ) p++;

   for (q=&sor[0]; *q!='\0' && *q==' '; q++ )  ;
   if ( *q=='\0' || *q==';' )
    continue;

   cn+=deltacn; deltacn=0;

   q=_fstrtok(sor,"|");
   if (q==NULL)
    continue;
   while (*q==' ') q++; q++; // "
   dst=(char *)malloc(_fstrchr(q,'\"')-q+1);
   _fstrncpy(dst,q,_fstrchr(q,'\"')-q); dst[_fstrchr(q,'\"')-q]='\0';
   cim[cn].title = dst;

   q=_fstrtok(NULL,"|");
   if (q==NULL)
    continue;
   while (*q==' ') q++; q++; // "
   dst=(char *)malloc(_fstrchr(q,'\"')-q+1);
   _fstrncpy(dst,q,_fstrchr(q,'\"')-q); dst[_fstrchr(q,'\"')-q]='\0';
   cim[cn].filenev = dst;

   deltacn=1;

   q=_fstrtok(NULL,"|");
   if (q==NULL)
    continue;
   while (*q==' ') q++;
   dst=(char *)malloc(_fstrchr(q,'\"')-q+1);
   _fstrncpy(dst,q,_fstrchr(q,'\"')-q); dst[_fstrchr(q,'\"')-q]='\0';
   /*c=0;*/
   c=T_NORMAL; //SZOVEGEXT;
   if (_fstricmp(q,"NORMAL")==0) c=T_NORMAL; /*c=T_SZOVEGEXT;*/ else
    if (_fstricmp(q,"EXTRACTABLE")==0) c=T_EXTRACTABLE; /*c=T_BOTHEXT;*/ else
     if (_fstricmp(q,"VGA256PIC")==0) c=T_VGA256PIC; else
      if (_fstricmp(q,"BOTHEXT")==0) c=T_BOTHEXT; else
       if (_fstricmp(q,"SZOVEGEXT")==0) c=T_SZOVEGEXT; else
        if (_fstricmp(q,"PCXPIC")==0) c=T_PCXPIC; else
         if (_fstricmp(q,"ANSIBIN")==0) c=T_ANSI; else
          if (_fstricmp(q,"SUBTITLE")==0) c=T_SUBTITLE;

   cim[cn].tipus = c;
   free(dst);

   q=_fstrtok(NULL,"|");
   if (q==NULL)
    continue;
   while (*q==' ') q++; q++; // "
   dst=(char *)malloc(_fstrchr(q,'\"')-q+1);
   _fstrncpy(dst,q,_fstrchr(q,'\"')-q); dst[_fstrchr(q,'\"')-q]='\0';
   cim[cn].exfilenev = dst;
  }
 maxcim = cn+deltacn-1;

 farfree(buf);
}

#define HSC_BARX    590
#define HSC_BARY    5

void drawbars( void )
{
 if (!vanAdLib) return;
 char he[9];
 register int c,d;

 _fmemcpy(&he[0],(char *)&HSC_EQUALIZER[0],9);

 setcolor(YELLOW);
 //m_hide();
 disable();
 for (c=0 ; c<9 ; c++)
  {
   d = 32-(0x0F - he[c])*2;
   if (d>32) d=0;
   if (d!=0)
    line(c*5+HSC_BARX,HSC_BARY+32,c*5+HSC_BARX,HSC_BARY+32-d);
  }
 setcolor(BLACK);
 for (c=0 ; c<9 ; c++)
  {
   d = 32-(0x0F - he[c])*2;
   if (d>32) d=0;
   line(c*5+HSC_BARX,HSC_BARY+32-d,c*5+HSC_BARX,HSC_BARY);
  }
 //m_show();
 enable();
}

/*-----------------------------------------------------*/

sman::sman( int maxicons )
{
 ico_num=-1;
 ico = (struct s_ico *)calloc(maxicons,sizeof(s_ico));
 wl=-1;
}

void sman::addicon(int x,int y,int id,int id2)
{
 struct s_ico *s;
 ico_num++;
 s = &ico[ico_num];
 s->x = x;
 s->y = y;
 s->width = spritex(id);
 s->height = spritey(id);
 s->id = id;

 if (id2!=-1)
  s->id2 = id2;
 else
  s->id2 = id;
}

void sman::replaceicon(int rid,int x,int y,int id,int id2)
{
 struct s_ico *s;
 int c;

 s=&ico[0];
 for (c=0; c<=ico_num ; c++)
  if (ico[c].id==rid)
   {
    s=&ico[c];
    break;
   }

 if (ico[c].id!=rid)
  return;

 s->x = x;
 s->y = y;
 s->width = spritex(id);
 s->height = spritey(id);
 s->id = id;

 if (id2!=-1)
  s->id2 = id2;
 else
  s->id2 = id;
}

int sman::geticon(int x,int y)
{
 if (ico_num==-1)
  return(-1);

 int c;

 for (c=0; c<=ico_num ; c++)
  if (ico[c].x<=x && x<=ico[c].x+ico[c].width )
   if (ico[c].y<=y && y<=ico[c].y+ico[c].height )
    return(ico[c].id);

 return(-1);
}

void sman::updateicon( int id , int state, int snd)
{
 int c;

 for (c=0; c<=ico_num ; c++)
  if (ico[c].id==id)
   break;

 if (ico[c].id!=id)
  return;

 if (state==IU_PRESSED)
  {
   putsprite(ico[c].x,ico[c].y,ico[c].id2);
   if ((snd) && (ico[c].id2!=ico[c].id))
    if (SB_installed && sound_s)
     farOutputVoice(voc[V_CLICK]);
  }
 else
  putsprite(ico[c].x,ico[c].y,ico[c].id);
}

void sman::drawall( void )
{
 if (ico_num==-1)
  return;

 int c;

 for (c=0; c<=ico_num ; c++)
  putsprite(ico[c].x,ico[c].y,ico[c].id);
}

int sman::getpressed( void )
{
 int i;
 int mx,my;
 if (left_button_pressed() )
  {
   i=wl;
   read_mouse_position(&mx,&my);
   wl = geticon(mx,my);
   if ((wl!=-1) && (i!=wl))
    updateicon(wl,IU_PRESSED,1);

   if ((i!=-1) && (wl!=i))
    updateicon(i,IU_DEPRESSED);

   return( -2 );
  }
 else
  if (wl!=-1)
   {
    read_mouse_position(&mx,&my);
    i = geticon(mx,my);
    if (wl!=-1)
     updateicon(wl,IU_DEPRESSED);
    if (i==wl)
     {
      wl=-1;
      return i;
     }

    wl=-1;
   }
 return( -1 );
}

sman::~sman( void )
{
 if (ico)
  free(ico);
}
/*--------------------------------------------------------*/

long pagenum;

void cikkbetolt( scim cm )
{
 if ( cm.tipus==T_VGA256PIC )
  {
   loadpic( cm );
   return;
  }

 if ( cm.tipus==T_PCXPIC )
  {
   loadPCXpic( cm );
   return;
  }

 if ( cm.tipus==T_ANSI )
  {
   loadANSI( cm );
   return;
  }

 m_hide();
 setfillstyle(SOLID_FILL,C_MENU);
 bar(0,0,639,40);
 setcolor(C_MBORDER);
 rectangle(0,0,639,40);
 putsprite(10,20-spritey(S_ZZLOGO)/2,S_ZZLOGO);
 putsprite(65-5,20-spritey(S_NUMBERX)/2,S_NUMBERX);

 setfillstyle(SOLID_FILL,0);
 bar(0,41,639,479);
 m_show();

 dispwait();
 currfont = (char *)&charadd2;

 sman sm(20);

 sm.addicon(130,5,S_BACK,S_BACKd);
 sm.addicon(170,5,S_UP,S_UPd);
 sm.addicon(200,5,S_DOWN,S_DOWNd);
 sm.addicon(235,5,S_HOME,S_HOMEd);
 sm.addicon(265,5,S_END,S_ENDd);
 sm.addicon(300,5,S_GOTO,S_GOTOd);
 if (cm.tipus==T_BOTHEXT || cm.tipus==T_SZOVEGEXT || SZOVEGALWAYSEXT)
  sm.addicon(SX_HELP-105,5,S_TXTDISK,S_TXTDISKd);
 else
  sm.addicon(SX_HELP-105,5,S_TXTDISKg);
 sm.addicon(SX_HELP-35,5,S_PRINT,S_PRINTd);

 if (cm.tipus==T_BOTHEXT || cm.tipus==T_EXTRACTABLE)
  sm.addicon(SX_HELP-70,5,S_DISKRE,S_DISKREd);
 else
  sm.addicon(SX_HELP-70,5,S_DISKREg);

 //sm.addicon(SX_HELP,5,S_HELP,S_HELPd);

 sm.drawall();

 int f;
 unsigned xx;
 long fs,fs2;
 char huge *text;
 char huge *th;
 long *index;
 char fnev[60];

 _fstrcpy(fnev,cm.filenev);
 fs2 = fs = zf.getsize(fnev);
 if (fs==-1)
  {
   undispwait();
   currfont = (char *)&charadd;
   return;
  }
 th = text = (char huge*)farmalloc(fs+3);
 index = (long *)malloc(200*4);
 dispwait();
 zf.far_readfile(fnev,text);

 text[fs]='\0';
 if (convtext( text , index , fs )==-1)
  {
   undispwait();
   currfont = (char *)&charadd;
   return;
  }

 xoroltomb(text);

 undispwait();

 outpage((char far *)&text[index[1]]);

 int ki=0;
 int i,pr;
 int mx,my;
 int kar,kar2;
 int currpage=1;

 dispstatpage(currpage,index[0],1);

 do
  {
   delay(SZUNET);
   drawbars();
   pr = sm.getpressed();

   if (kbhit())
    {
     kar=toupper(getch());
     if (kar==0)
      kar2=getch();

     switch (kar)
      {
       case K_ESCAPE:ki = 1;
                    break;
       case      'G':pr=S_GOTO;
                    break;
       case      'T':if (cm.tipus==T_BOTHEXT || cm.tipus==T_SZOVEGEXT || SZOVEGALWAYSEXT)
                      pr=S_TXTDISK;
                    break;
       case      'W':if (cm.tipus==T_BOTHEXT || cm.tipus==T_EXTRACTABLE)
                      pr=S_DISKRE;
                    break;
       case      'P':pr=S_PRINT;
                    break;
       case        0:switch (kar2)
                      {
                       case K_DOWN:
                       case K_PGDN:pr=S_DOWN;
                                  break;
                       case   K_UP:
                       case K_PGUP:pr=S_UP;
                                  break;
                       case K_HOME:pr=S_HOME;
                                  break;
                       case  K_END:pr=S_END;
                                  break;
                       case   K_F1:pr=S_HELP;
                                  break;
                      }
                    break;
      }
    }


   if (pr>=0)
    {
     switch (pr)
      {
       case S_BACK:ki=1;
                  break;
       case S_DOWN:if (currpage<index[0])
                    {
                     currpage++;
                     outpage((char far *)&text[index[currpage]]);
                     dispstatpage(currpage,index[0],1);
                    }
                  break;
       case   S_UP:if (currpage>1)
                    {
                     currpage--;
                     outpage((char far *)&text[index[currpage]]);
                     dispstatpage(currpage,index[0],1);
                    }
                  break;
       case S_HOME:if (currpage>1)
                    {
                     currpage=1;
                     outpage((char far *)&text[index[currpage]]);
                     dispstatpage(currpage,index[0],1);
                    }
                  break;
       case  S_END:if (currpage!=index[0])
                    {
                     currpage=index[0];
                     outpage((char far *)&text[index[currpage]]);
                     dispstatpage(currpage,index[0],1);
                    }
                  break;
       case S_GOTO:
                   char far *oldt;
                   char buff[20];
                   int sx1=30,sx2=50,sy1=11,sy2=14;
                   int c;

                   oldt=(char far *)farmalloc(imagesize(
                     COORDX(sx1)-1-3,COORDY(sy1)-4-3,COORDX(sx2)+1+3,COORDY(sy2-1)+4+3));
                   m_hide();
                   getimage(COORDX(sx1)-1-3,COORDY(sy1)-4-3,COORDX(sx2)+1+3,COORDY(sy2-1)+4+3,oldt);
                   bar(COORDX(sx1)-1-3,COORDY(sy1)-4-3,COORDX(sx2)+1+3,COORDY(sy2-1)+4+3);
                   setcolor(RED);
                   rectangle(COORDX(sx1)-1,COORDY(sy1)-4,COORDX(sx2)+1,COORDY(sy2-1)+4);
                   m_show();

                   writetext(COORDX(sx1),COORDY(sy1)," Page # to go to:");
                   getstring(sx1+1,sy1+1,buff,6);

                   m_hide();
                   putimage(COORDX(sx1)-1-3,COORDY(sy1)-4-3,oldt,0);
                   m_show();

                   c=atoi(buff);
                   if ((c>0) && (c<=index[0]))
                    {
                     currpage=c;
                     outpage((char far *)&text[index[currpage]]);
                     dispstatpage(currpage,index[0],1);
                    }

                   farfree(oldt);
                  break;
       case S_PRINT:if (!askconfirm("Cikk kinyomtatsa ","Mehet ?"))
                     break;
                   dispwait();
                   printstring((char far *)text);
                   undispwait();
                   break;
       case S_TXTDISK:
                   if (cm.tipus==T_SZOVEGEXT || cm.tipus==T_BOTHEXT || SZOVEGALWAYSEXT)
                   {
                    if (!askconfirm("Cikk lemezre rsa","Mehet ?"))
                     break;
                    dispwait();
                    zf.writetofile(cm.filenev,cm.filenev);
                    undispwait();
                   }
                   break;
       case S_DISKRE:
                   if (cm.tipus==T_EXTRACTABLE || cm.tipus==T_BOTHEXT)
                   {
                    if (!askconfirm("File lemezre rsa","Mehet ?"))
                     break;
                    dispwait();
                    zf.writetofile(cm.exfilenev,cm.exfilenev);
                    undispwait();
                   }
                   break;
      }
    }
   //if (pr==-2)
   // {
   //  read_mouse_position(&mx,&my);
   // }
  }
 while (!ki);

 dispstatpage(currpage,index[0],0);

 setfillstyle(SOLID_FILL,0);
 m_hide();
 bar(0,41,639,479);
 m_show();

 farfree(text);
 free(index);

 currfont = (char *)&charadd;
}

int convtext( char huge *hova, long *oldind, long fs )
{
 // Maximum 64 Kb,max. 200 oldal lehet
 // Oldind : 0.-oldalak szma (1-tl!) , 1...x - index
 long cnt;
 int cr,ic;
 unsigned xx;

 char huge* s;

 cr=0; ic=1;
 for ( s=hova, cnt=0 ; cnt<=fs ; s++,cnt++ )
  if ( *s=='\n' )
   {
    cr++;
    if ( cr>=NSOROKLEFELE )
     { ic++; oldind[ic]=cnt+1 ; cr=0; }
   }
 oldind[0]=ic;
 oldind[1]=0;

 return(0);
}

int outpage( char far *page )
{
 char huge *ih2;

 char buf[100];
 char huge *ss;
 char *s;
 int c,d,e,tv;

 char huge *s2=page;
 int cline=0;

 while (1)
  {
   for ( ss=s2,c=0 ; *ss!=('\n'^EZZELXor) && c<100 && *ss!='\0' ; ss++ );
   _fmemcpy(buf,s2,ss-s2);
   buf[ss-s2]='\0';
   s2=ss+1;
   cline++;

   for ( d=0,s=buf ; d<100 && *s ; s++,d++ ) //converter for tabs
    if ( *s==('\t'^EZZELXor) )
     {
      e=strlen(s);
      tv=8-d%8;
      memmove(&s[tv],&s[1],e);
      memset(s,(' '^EZZELXor),tv);
      s=&s[tv-1]; d+=tv-1;
     }

   if ( buf[strlen(buf)-1]==('\n'^EZZELXor) )
    buf[strlen(buf)-1]='\0'; // rip off the \n character
   if ( buf[strlen(buf)-1]==('\r'^EZZELXor) )
    buf[strlen(buf)-1]='\0'; // rip off the \r character

   m_hide();
   bar(0,COORDY((cline-1)),639,COORDY((cline))-1);

   //setcol(0x07);
   writetext(0,COORDY((cline-1)),buf,0,1);
   m_show();

   if (cline>=NSOROKLEFELE)
    break;
   if (*ss=='\0')
    {
     for (c=cline+1 ; c<=NSOROKLEFELE ; c++ )
      {
       m_hide();
       bar(0,COORDY((c-1)),639,COORDY(c)-1);
       m_show();
      }
     //bar(CIMEKSTARTX,CIMEKSTARTY+(cline)*NLINEHEIGHT,CIMEKENDX+8,CIMEKSTARTY+(NSOROKLEFELE)*NLINEHEIGHT-1);
     break;
    }
  }

 return( 0 );
}

/****************************************************************/


int dwstate=0;
char far *dwtegla;
int ws_xs,ws_ys;

void dispwait( void )
{
 long bufsize;

 if (dwstate == 1)
  return; // error - called twice w/o undispwait

 ws_xs=spritex(S_WAIT);
 ws_ys=spritey(S_WAIT);
 bufsize = imagesize(DW_X,DW_Y,DW_X+ws_xs+1,DW_Y+ws_ys+1);
 dwtegla = (char far *)farmalloc(bufsize);
 m_hide();
 getimage(DW_X-ws_xs/2,DW_Y-ws_ys/2,DW_X+ws_xs/2+1,DW_Y+ws_ys/2+1,dwtegla);
 //putimage(DW_X-ws_xs/2,DW_Y-ws_ys/2,specspr[SS_WAIT],0);
 putsprite(DW_X-ws_xs/2,DW_Y-ws_ys/2,S_WAIT);
 m_show();

 dwstate = 1;
}

void undispwait( void )
{
 if ( dwstate == 0 )
  return; // error - disp wasn't called

 m_hide();
 putimage(DW_X-ws_xs/2,DW_Y-ws_ys/2,dwtegla,0);
 m_show();
 farfree(dwtegla);
 dwstate = 0;
}

void dispstatpage( int cur, int max, int all )
{
 static char st[40];

 textsettingstype txti;

 gettextsettings(&txti);
 settextstyle(0,0,1);
 settextjustify(LEFT_TEXT,TOP_TEXT);
 setcolor(DARKGRAY);
 m_hide();
 outtextxy( DISPPAGEX ,DISPPAGEY,st);
 outtextxy( DISPPAGEX+2 ,DISPPAGEY+2,st);
 m_show();
 if (all!=1)
  return;
 sprintf(st,"Page %d/%d",cur,max);
 setcolor(BLACK);
 m_hide();
 outtextxy( DISPPAGEX+2 ,DISPPAGEY+2,st);
 setcolor(WHITE);
 outtextxy( DISPPAGEX ,DISPPAGEY,st);
 m_show();
 setcolor(WHITE);
 settextstyle(txti.font,txti.direction,txti.charsize);
}

#define KS_MAXKAR 20

volatile long *ticks = (long *)MK_FP(0,0x046C);

char *getstring(int x,int y, char *buff, int maxkar, int csaknum)
{
 int kar,karx=0,kilep=0;
 char ks[5],ktomb[KS_MAXKAR+2];

 //m_hide();
 //line(MAXX/2-(KS_XSIZE/2)+8+8*(karx),MAXY/2-(KS_YSIZE/2)+8+12+8+1,MAXX/2-(KS_XSIZE/2)+8+8*(karx+1),MAXY/2-(KS_YSIZE/2)+8+12+8+1);
 //m_show();
 writetext(COORDX((x+karx)),COORDY(y),"\x14"/*"_"*/);

 long t1=0,t2=0;
 int bo=0;

 do
  {
   t1=*ticks;
   if (t1>t2+7)
    {
     t2=t1;
     writetext(COORDX(x+karx),COORDY(y),(bo)?"\x14":"\x13");

     bo=!bo;
    }

   if (right_button_pressed())
    kilep=2;
   if (kbhit())
    {
     kar=getch();
     switch(kar)
      {
      case  0:getch(); // vezrlkd
             break;
      case 13:// Enter
              kilep=1;
             break;
      case 27:// ESC
              kilep=2;
             break;
      case  8:// Backspace
              if (karx<1)
               break;
              karx--;
              writetext(COORDX(x+karx),COORDY(y),/*"_ "*/"\x14 ");
             break;
      default:if (karx-1>=maxkar)
               break;
              if ((csaknum) && (kar<'0' || '9'<kar))
               break;
              ktomb[karx]=kar;
              ks[0]=kar; ks[1]='\x14';/*'_'*/ ks[2]='\0';
              writetext(COORDX(x+karx),COORDY(y),ks);
              karx++;
      }
    }
  }
 while (!kilep);
 ktomb[karx]='\0';

 if (kilep==2)
  buff[0]='\0';
 else
  strcpy(buff,ktomb);
}

void printstring(char far* address)
{
 asm MOV DX,PRINTERNUM
 asm INT 0x17

 int segm=FP_SEG(address);
 int off=FP_OFF(address);

 asm PUSH       DS
 asm PUSHF

 asm CLD
 asm MOV        DX,PRINTERNUM
 asm MOV        AX,segm
 asm MOV        DS,AX
 asm MOV        SI,off
printloop:
 asm LODSB
 asm CMP        AL,0
 asm JE         ittavegepr
 asm XOR        al,EZZELXor
 asm INT        0x17

 asm AND        AH,01
 asm CMP        AH,1
 asm JNE        notimeout
timeout:

notimeout:
 asm JMP        printloop

ittavegepr:
 asm MOV        AL,0x0d
 asm INT        0x17
 asm MOV        AL,0x0a
 asm INT        0x17

 asm POPF
 asm POP        DS

}

/*
void exekiir( char *fnev)
{
 dispwait();
 long fs=zf.getsize( fnev );
 int data = (char huge*)farmalloc(fs+3);
 if (fs==-1)
  {
   undispwait();
   return;
  }
 zf.far_readfile(fnev,data);
 while(fs

}
*/

void loadpic( scim cime )
{
 //if (!capVGA256)
  //return;
 int sx,sy;
 read_mouse_position(&sx,&sy);

 VGA_GIFload( cime.filenev );
 while (!( left_button_pressed() || kbhit() ));

 while (kbhit()) getch();
 //closegraph();
 VGA_GIF_out();

 int gdriver = DETECT, gmode, errorcode;
 initgraph(&gdriver, &gmode, "");

 set_mouse_position(sx,sy);
 enable_software_cursor();
}

int LoadPCX( char *fname );

void loadPCXpic( scim cime )
{
 //if (!capVGA256)
  //return;
 int sx,sy;
 read_mouse_position(&sx,&sy);
 m_hide();

 LoadPCX( cime.filenev );
 while (!( left_button_pressed() || kbhit() ));

 while (kbhit()) getch();

 //int gdriver = DETECT, gmode, errorcode;
 //initgraph(&gdriver, &gmode, "");

 cleardevice();
 set_mouse_position(sx,sy);
 enable_software_cursor();
}

void loadANSI( scim cime ) // tkp. ANS-> BIN-t tud loadolni
{
 int sx,sy;
 read_mouse_position(&sx,&sy);
 m_hide();

 long bs;
 char far *kbuf;
 char far *screen=(char far*)MK_FP(0xB800,0);

 bs=zf.getsize(cime.filenev);
 kbuf=(char far *)farmalloc(bs);
 zf.far_readfile(cime.filenev,kbuf);

 closegraph();
 _setcursortype(_NOCURSOR);

 _fmemcpy(screen,kbuf,4000);

 farfree(kbuf);

 while (!( left_button_pressed() || kbhit() ));

 while (kbhit()) getch();

 int gdriver = DETECT, gmode, errorcode;
 initgraph(&gdriver, &gmode, "");

 set_mouse_position(sx,sy);
 enable_software_cursor();
}


/*-------------------------------------------------*/

void specLoadDriver(void)
{
    FILE *f;
    long length;
    char *sp;
    char sn[129];
    unsigned nxx;
    char far *ide;

    strcpy(sn,"CT-VOICE.DRV");

    length = zf.getsize(sn);

    driver_mem = (char far *)farmalloc((int)length + 32);

    if (FP_OFF(driver_mem) != 0)
     {
        driver = (void (far*)())MK_FP(FP_SEG(driver_mem)+1,0);
        ide = (char far *)MK_FP(FP_SEG(driver_mem)+1,0);
        zf.far_readfile( sn , ide );
     }
    else
     {
      driver = (void (far*)())driver_mem;
      ide = driver_mem;
      //_dos_read( fileno(f) , ide ,(int)length , &nxx);
      zf.far_readfile( sn , ide );
     }

    fclose(f);
}

char far * specLoadVOC(char *name)  // after play, user MUST FARfree buf
{
    FILE *f;
    char far *buf;
    long length;
    unsigned xx;

    //f = fopen(name,"rb");
    //if(!f)
    //    return NULL;

    //length = filelength(fileno(f)) - 0x1a;
    length = zf.getsize(name) - 0x1A;

    buf = (char far *)farmalloc(/*(int)*/length);

    //fseek(f,0x1a,SEEK_SET);
    //_dos_read(fileno(f),buf,length,&xx);
    zf.far_specreadfile(name,buf,0x1A);

    //fclose(f);
    return buf;
}

int askconfirm(char *sor1,char *sor2)
{
 char far *oldt;
 char buff[20];
 int sy1=11,sy2=16;
 int sxkozep=40;
 int c;

 int mxx;
 mxx = 14;
 if (strlen(sor1)>mxx) mxx=strlen(sor1);
 if (strlen(sor2)>mxx) mxx=strlen(sor2);
 mxx=(mxx*2+1)/2;

 int sx1=sxkozep-mxx/2-1;
 int sx2=sxkozep+mxx/2+1;

 oldt=(char far *)farmalloc(imagesize(
   COORDX(sx1)-1-3,COORDY(sy1)-4-3,COORDX(sx2)+1+3,COORDY(sy2-1)+4+3));
 m_hide();
 getimage(COORDX(sx1)-1-3,COORDY(sy1)-4-3,COORDX(sx2)+1+3,COORDY(sy2-1)+4+3,oldt);
 bar(COORDX(sx1)-1-3,COORDY(sy1)-4-3,COORDX(sx2)+1+3,COORDY(sy2-1)+4+3);
 setcolor(RED);
 rectangle(COORDX(sx1)-1,COORDY(sy1)-4,COORDX(sx2)+1,COORDY(sy2-1)+4);
 rectangle(COORDX(sx1)-3,COORDY(sy1)-6,COORDX(sx2)+3,COORDY(sy2-1)+6);
 setcolor(LIGHTRED);
 rectangle(COORDX(sx1)-2,COORDY(sy1)-5,COORDX(sx2)+2,COORDY(sy2-1)+5);
 m_show();

 writetext(COORDX(sxkozep-strlen(sor1)/2),COORDY(sy1),sor1);
 writetext(COORDX(sxkozep-strlen(sor2)/2),COORDY(sy1+1),sor2);

 sman sm(4);

 sm.addicon(COORDX(sxkozep)-spritex(S_OK)-5,COORDY(sy1+2)+4,S_OK,S_OKd);
 sm.addicon(COORDX(sxkozep)+5,COORDY(sy1+2)+4,S_CANCEL,S_CANCELd);

 sm.drawall();

 int kilep=-1,x,kar;

 do
  {
   x=sm.getpressed();
   if (x>=0)
    {
     if (x==S_OK) kilep=1;
     if (x==S_CANCEL) kilep=0;
    }
   if (kbhit())
    {
     kar=getch();
     if (kar==13) kilep=1;
     if (kar==27) kilep=0;
    }
  }
 while (kilep==-1);

 m_hide();
 putimage(COORDX(sx1)-1-3,COORDY(sy1)-4-3,oldt,0);
 m_show();

 farfree(oldt);

 return (kilep);
}

//------------------------------------------------
void xoroltomb(char huge* mit)
{
 long c=0;
 while(mit[c]!=0)
 {
  mit[c]^=EZZELXor;
  c++;
 }
}
