
ezzelxor	EQU	0FFh



ARGccoff	EQU	word ptr [bp+4]	; stack frame addressing
ARGx		EQU	word ptr [bp+6]
ARGy		EQU	word ptr [bp+8]
ARGoff		EQU	word ptr [bp+10]
ARGstrlen	EQU	word ptr [bp+12]
ARGcolor	EQU	word ptr [bp+14]
ARGiscoded	EQU	word ptr [bp+16]

VARshift	EQU	         [bp-2]
VARxoff		EQU              [bp-4]
VARyoff		EQU		 [bp-6]
VARoff		EQU		 [bp-8]

BytesPerLine	=	80		; (must 40 in 320x200 16-color mode)
RMWbits		=	18h		; Read-Modify-Write bits

_TEXT		SEGMENT	byte public 'CODE'
		ASSUME	cs:_TEXT

		EXTRN	_charadd:byte

		PUBLIC	_WriteStr,_WriteStr386
_WriteStr	PROC	near

		push	bp		;; preserve caller registers
		mov	bp,sp
		sub	sp,10		; stack space for local variable
		push	si              ;;
		push	di              ;;
		push	ds              ;;
comment &
; set up Graphics Controller registers

		mov	dx,3CEh		; Graphics Controller address reg port

		mov	ax,0A05h	; AL :=  Mode register number
					; AH :=  Write Mode 2 (bits 0-1)
					;	 Read Mode 1 (bit 4)
		out	dx,ax

		mov	ah,RMWbits	; AH := Read-Modify-Write bits
		mov	al,3		; AL := Data Rotate/Function Select reg
		out	dx,ax

		mov	ax,0007		; AH := Color Don't Care bits
					; AL := Color Don't Care reg number
		out	dx,ax		; "don't care" for all bit planes
&


; calculate first pixel address

		mov	ax,ARGx
		mov	VARxoff,ax

		mov	ax,ARGy
		;shl	ax,4
		mov	VARyoff,ax
		mov	bx,80
		mul     bx
		add	ax,VARxoff
		mov	VARoff,ax

		push	es
		mov	ax,0A000h
		mov	es,ax
		mov	di,ax		; SI := video buffer offset
		mov	ax,ARGccoff
		mov	si,ax
		cld

		mov	dx,3CEh
		mov 	ax,0FEh
		out	dx,ax

		mov	ax,VARoff
		mov	di,ax
		mov	cx,16
LUP:            push    cx
		neg	cx
		add	cx,16
		MOV	dl,cl

		push	di
		mov     cx,ARGstrlen
	LUP2:   push	si
		mov     bx,ARGstrlen
		sub	bx,cx
		add	bx,ARGoff
		mov	al,DS:[bx]
		CMP	ARGiscoded,0
		JE	nemkodolt
		XOR	AL,ezzelxor
nemkodolt:
		xor	ah,ah
		shl	ax,4
		add	al,dl
		adc	ah,0
		add	si,ax

		movsb

		pop	si
		loop	lup2

		pop	di
		pop     cx

		add	di,80
		LOOP	lup

; restore default Graphics Controller registers

		pop	es


Lexit:		mov	ax,0FF08h	; default Bit Mask
		out	dx,ax

		mov	ax,0005		; default Mode register
		out	dx,ax

		mov	ax,0003		; default Data Rotate/Function Select
		out	dx,ax

		mov	ax,0F07h	; default Color Don't Care
		out	dx,ax

		pop	ds	       ;; restore caller registers and return
		pop	di             ;;
		pop	si             ;;
		mov	sp,bp
		pop	bp             ;;
		ret

_WriteStr	ENDP

;	Params: 	bx -> fuggoleges coord
;			ax -> vizszintes
;			ds:si -> szoveg
;                       ds:dx -> table
;
_WriteStr386	proc near
.386
                push	bp		;; preserve caller registers
		mov	bp,sp
                push    es
                push    si
                push    di

                mov     ax,ARGoff
                mov     si,ax
                mov     ax,ARGx
                mov     bx,ARGy
                mov     dx,ARGccoff
		cld
                mov     cx,ax
                mov	ax, 0a000h
		mov	es, ax
                ;mov     eax,0
                mov     ax,dx
                mov     cx,ax
                mov     ax,cx

		imul	bx, 80
		add	bx, ax
		movzx	edi, bx
		mov	ax, 0005h
		mov	dx, 3ceh
		out	dx, ax		;0. irasi mod
		mov	ax, 0003h
		out	dx, ax          ;feluliras, rotalas
		mov	ax, 0001h
		out	dx, ax		;SET-RESET engedelyezes

loop1:		lodsw
		CMP	ARGiscoded,0
		JE	nemkodolt2
		XOR	AL,ezzelxor
                XOR	AH,ezzelxor
nemkodolt2:
		cmp	al, 0
		je	loop3
		cmp	ah, 0
		je	loop4

		movzx	bx, ah
		xor	ah, ah
		shl	ax, 4
		shl	bx, 4
		mov	bp, ax
		ror	esi, 16
		mov	ecx, 8
loop2:		mov	si, bx
		lodsw
		add	bx, 2
		mov	dx, ax
		mov	si, bp
		lodsw
		add	bp, 2
		xchg	ah, dl
;		not	ax
;		not	dx
		stosw
		add	di, 78
		mov	ax, dx
		stosw
		add	di, 78
		loop	loop2
		ror	esi, 16
		sub	di, 80*16-2
		jmp	loop1
loop4:		mov	si, ax
		shl	si, 4
		mov	cx, 8
loop5:		lodsw
		not	ax
		stosb
		mov	al, ah
		add	di, 79
		stosb
		add	di, 79
		loop	loop5
loop3:
		mov	ax,0FF08h	; default Bit Mask
		out	dx,ax

		mov	ax,0005		; default Mode register
		out	dx,ax

		mov	ax,0003		; default Data Rotate/Function Select
		out	dx,ax

		mov	ax,0F07h	; default Color Don't Care
		out	dx,ax

                pop     di
                pop     si
                pop     es
                pop     bp
                ret
_WriteStr386    endp


_TEXT		ENDS

		END
