PAGE	55,132

;
; Name:		Bla2Col
;
; Function:	VGA 320x200x256 -> palette from black to colors
;
; Caller:	Microsoft C:
;
;			void Bla2Col(int paloffs);
;

ARGpaloffs	EQU	word ptr [bp+4]	; stack frame addressing
;ARGx		EQU	word ptr [bp+6]
;ARGy		EQU	word ptr [bp+8]
;ARGfgd		EQU	byte ptr [bp+10]
;ARGbkgd		EQU	byte ptr [bp+12]

VARshift	EQU	         [bp-2]

;BytesPerLine	=	80		; (must 40 in 320x200 16-color mode)
;RMWbits		=	18h		; Read-Modify-Write bits

_TEXT		SEGMENT	byte public 'CODE'
		ASSUME	cs:_TEXT

	      ;	EXTRN	PixelAddr10:near

                PAL     DB      768     DUP     (0)
        	PALTMP  DB      768     DUP     (0)

		PUBLIC	_Bla2Col


;---------------------------------------------
WRITE_STRING    EQU     09h
READ_STRING     EQU     0Ah

VGA256		EQU	13h
VGA16		EQU	12h
TEXTC80		EQU	03

SETMODE		EQU	0
GETMODE		EQU	OFh
PALREG		EQU	10h
   GETPALREGISTER	EQU	17h
   SETPALREGISTER	EQU	12h

DOSCALL         MACRO   CODE
                        MOV     AH,CODE
                        INT     21h
         	ENDM

PRTSTR          MACRO   STRING
                        MOV     DX,OFFSET STRING
                        DOSCALL WRITE_STRING
                ENDM

GETSTR          MACRO   BUFFER
                        MOV     DX,OFFSET BUFFER
                        DOSCALL READ_STRING
                ENDM
CALLVGA		MACRO	CODE
			MOV	AH,CODE
			INT	10h
		ENDM

SETVMODE	MACRO	MODE			;beallitasnal MODE-ba kell tenni
			MOV	AL,MODE		; az uzemmodszamot
			CALLVGA	SETMODE
		ENDM

GETVMODE	MACRO				;a hivas utan az uzemmod
			CALLVGA	GETMODE		; az AX regiszterben van
		ENDM

GETPAL		MACRO	HOVA_SEG, HOVA_OFFS, HONNAN, MENNYIT
			PUSH	ES
			MOV	BX,HONNAN
			MOV	CX,MENNYIT
			MOV	DX,SEG HOVA_SEG
			MOV	ES,DX
			MOV	DX,OFFSET HOVA_OFFS
			MOV	AL,GETPALREGISTER
			CALLVGA	PALREG
			POP	ES
		ENDM

SETPAL		MACRO	HOVA_SEG, HOVA_OFFS, HONNAN, MENNYIT
			PUSH	ES
			MOV	BX,HONNAN
			MOV	CX,MENNYIT
			MOV	DX,SEG HOVA_SEG
			MOV	ES,DX
			MOV	DX,OFFSET HOVA_OFFS
			MOV	AL,SETPALREGISTER
			CALLVGA	PALREG
			POP	ES
		ENDM
;--------------------------------


	WAIT_HIGH       EQU     0
	WAIT_LOW        EQU     20000

;	PALMENT DB       48     DUP     (0)
;	PAL     DB      768     DUP     (0)
;        PALTMP  DB      768     DUP     (0)


		MOV     BX,HANDLE
		MOV     DX,OFFSET       PAL
		MOV     CX,768
		MOV     AX,03F00h
		INT     21h
		JC      HIBA                            ;read file paletta

		CALL    SETALLPALETTE                   ; paletta beallitasa

		MOV     BX,HANDLE
		PUSH    DS
		MOV     DX,0A000h
		MOV     DS,DX
		XOR     DX,DX
		MOV     CX,64000
		MOV     AX,03F00h
		INT     21h
		POP     DS
		JC      HIBA                            ; read file kep

		MOV     BX,HANDLE
		MOV     AX,03E00h
		INT     21h
		JC      HIBA                            ; file lezaras

		CALL    FADE_TO_COLOR                  	; fade eles
		mov	ah,1
		int	21h

		MOV     AX,0003h
		INT     10h                             ; uzemmod vissza
		CALL    RESTOREPAL                      ; mentett paletta vissza
KILEPES:
		RET                                     ;Visszateres...
 START  ENDP
 PAGE

 FADE_TO_COLOR 	PROC    near
		PUSH	DS
		PUSH	ES

                MOV     CX,63
                MOV     SI,OFFSET PALTMP
                MOV     DI,OFFSET PAL
 CIKL1:
                PUSH    CX
                MOV     CX,767
 CIKL2:
                MOV     BX,CX
                MOV     AL,BYTE PTR [SI+BX]
                CMP     BYTE PTR [DI+BX],AL
                JE      TOV
                INC     AL
                MOV     BYTE PTR [SI+BX],AL
 TOV:
                LOOP    CIKL2
		CALL	SETALLPALETTE
		CALL	DELAY
                POP     CX
                LOOP    CIKL1

		POP     ES
		POP	DS
 		RET
 FADE_TO_COLOR 	ENDP

 SETALLPALETTE  PROC    near
		PUSH    AX
		PUSH    BX
		PUSH    CX
		PUSH    DX
		PUSH    SI
		PUSH    DI

		MOV     SI,OFFSET       PALTMP
		XOR     BX,BX
		MOV     DI,256
 SZINEK:
		LODSW
		MOV     CH,AH
		MOV     AH,AL
		LODSB
		MOV     CL,AL
		MOV     DX,03C8h
		MOV     AL,BL
		CLI
		OUT     DX,AL
		INC     DX
		MOV     AL,AH
		OUT     DX,AL
		MOV     AL,CH
		OUT     DX,AX
		MOV     AL,CL
		OUT     DX,AL
		STI
		INC     BX
		DEC     DI
		JNZ     SZINEK
		
		POP     DI
		POP     SI
		POP     DX
		POP     CX
		POP     BX
		POP     AX
		RET                             
 SETALLPALETTE  ENDP

 DELAY          PROC    near
		PUSH    CX
		PUSH    DX

		MOV     CX,WAIT_HIGH
		MOV     DX,WAIT_LOW
		MOV     AX,08600h
		INT     15h

		POP     DX
		POP     CX
		RET
 DELAY          ENDP
 
 SAVEPAL        PROC    near
		PUSH    AX
		PUSH    BX
		PUSH    CX
		PUSH    DX
		PUSH    ES

		XOR     BX,BX
		MOV     CX,16
		MOV     DX,SEG          PALMENT
		MOV     ES,DX
		MOV     DX,OFFSET       PALMENT
		MOV     AX,1017h
		INT     10h
		
		POP     ES
		POP     DX
		POP     CX
		POP     BX
		POP     AX
		RET
 SAVEPAL        ENDP
 
 RESTOREPAL     PROC    near
		PUSH    AX
		PUSH    BX
		PUSH    CX
		PUSH    DX
		PUSH    ES

		XOR     BX,BX
		MOV     CX,16
		MOV     DX,SEG          PALMENT
		MOV     ES,DX
		MOV     DX,OFFSET       PALMENT
		MOV     AX,1012h
		INT     10h
		
		POP     ES
		POP     DX
		POP     CX
		POP     BX
		POP     AX
		RET
 RESTOREPAL     ENDP

 CODE   ENDS
 ;      ( Tovabbi kodszegmensek )

 MEMORY SEGMENT PARA    MEMORY  'MEMORY'
 
 ;      ( A program memoria teteje )
 
MEMORY  ENDS

	END     START



_Bla2Col	PROC	near

		push	bp		; preserve caller registers
		mov	bp,sp
		sub	sp,2		; stack space for local variable
		push	si
		push	di
		push	ds

		pop	ds		; restore caller registers and return
		pop	di
		pop	si
		mov	sp,bp
		pop	bp
		ret

_Bla2Col	ENDP



_TEXT		ENDS

		END








