//{   A programot ksztette:   }
//{                             }
//{       Szathmri Miln       }
//{            from             }
//{  CSIPSZI Software Inc. (c)  }
// C++ version by John Zero/NSS

#include <stdio.h>
#include <dos.h>
#include "ems.h"

long far *myframe; // 4096 long = 16K - egy EMS lap mrete, ide fogunk lapozni
int Handle;        // a lefoglalt EMS kezelszma
int PageNum;       // a szabad lapok szma


void EMSInfo (void )
{
 printf("EMS version ........ : %d.%d\n", EMSverzio() & 0xFF, EMSverzio() >> 8 );
 printf("Total EMS memory size: %3d page(s) - %5d Kbytes\n", EMSteljes(), EMSteljes()*16);
 printf("Free EMS memory size : %3d page(s) - %5d Kbytes\n", EMSszabad(), EMSszabad()*16);
 printf("EMS page frame ..... : %4X:0000\n", EMSkeretcim() );
}

void main ( void )
{
 if (!EMSjelen())                 // az EMS driver ellenrzse
  {
   printf("EMS not present\n");
   return;
  }
 EMSInfo();
 PageNum=EMSszabad();            // lekrdezzk a szabad lapok szmt
 EMSfoglal(&Handle,PageNum);     // s lefoglaljuk az sszeset,
                                 // a Handle-vel azonostjuk
 if (EMSOk)                      // ha nem sikerlt lefoglalni akkor
  {
   printf(EMShibaszoveg(EMSOk)); // kiirjuk a hiba okt
   return;
  }

 myframe=(long far *)MK_FP(EMSkeretcim(),0);  // a myframe a keret cmre
                                              // mutasson
 printf(" Filling %d EMS pages. Please wait...\n",PageNum);

 int i,j;

 for (i=0; i<PageNum ; i++ )       // sorban az sszes
  {
   EMSkeret(Handle,i,0);           // lapot belapozzuk a keretbe
   for (j=0 ; j<4096 ; j++ )       // s
    myframe[j]=(i+j)*(1000-j);     // feltltjk rtkekkel
  }
 printf("Completed.\n\n");

 EMSInfo();
 printf("Reading the first 5 bytes from the first 5 EMS pages.\n"
        "Please wait...\n");
 for (i=0 ; i<5 ; i++ )
  {
   printf("%d. page: ",i);
   EMSkeret(Handle,i,0);       // lapozs
   for ( j=1 ; j<5 ; j++ )
    printf("%8ld",myframe[j]); // elemek kirsa
   printf("...\n");
  }
 printf("And so on...\n");
 EMSfelszabadit(Handle);       // felszabadtjuk. Ne felejtsd el!!!
}
