Unit EMS ;

Interface

Uses
  Dos ;

Const
  EMSLapMeret = $4000 ;

Type
  EMSTomb = Array[1..255] Of Record
                               Kezeloszam,
                               Lapszam     : Word ;
                             End ;

Var
  EMSOk : Byte ;

Function  EMSHibaSzoveg(EMMHibaKod: Byte) : String ;
Function  EMSJelen : Boolean ;
Function  EMSKeretCim : Word ;
Function  EMSSzabad : Word ;
Function  EMSTeljes : Word ;
Procedure EMSFoglal(Var EMMKezelo: Word; EMSLapszam: Word) ;
Procedure EMSKeret(EMMKezelo: Word; EMSLap: Word; KeretLap: Byte);
Procedure EMSFelszabadit(EMMKezelo: Word) ;
Function  EMSVerzio : Word ;
Function  EMSKezelokSzama : Word ;
Function  EMSLapszam(EMMKezelo: Word) : Word ;
Procedure EMSKezeloInfo(Var EMMKezelokSzama: Word ;
                        Var EMMKezelok) ;

Implementation

Function EMSHibaSzoveg(EMMHibaKod: Byte) : String ;
  Begin
    Case EMMHibaKod Of
      $00 : EMSHibaSzoveg := 'EMS van, hardver rendben' ;
      $80 : EMSHibaSzoveg := 'EMS szoftver hiba' ;
      $81 : EMSHibaSzoveg := 'EMS hardver hiba' ;
      $83 : EMSHibaSzoveg := 'Az EMM nem tart nyilvn ilyen ' +
                             'kezelszmot' ;
      $84 : EMSHibaSzoveg := 'Nincs ilyen EMM funkci' ;
      $85 : EMSHibaSzoveg := 'Minden EMM kezelszm foglalt' ;
      $86 : EMSHibaSzoveg := 'Mentsi/visszatltsi hiba' ;
      $87 : EMSHibaSzoveg := 'Nincs elg EMS lap' ;
      $88 : EMSHibaSzoveg := 'Nincs elg szabad EMS lap' ;
      $89 : EMSHibaSzoveg := '0 lapot nem lehet alloklni' ;
      $8A : EMSHibaSzoveg := 'A lapszm nem esik az EMM kezel ' +
                             'tartomnyba' ;
      $8B : EMSHibaSzoveg := 'A lapszm nem esik a keret ' +
                             'tartomnyba' ;
      $8C : EMSHibaSzoveg := 'Hardver mentsi terlet betelt' ;
      $8D : EMSHibaSzoveg := 'Hardver mentsi terlet foglalt' ;
      $8E : EMSHibaSzoveg := 'Nincs ilyen hardver mentsi ' +
                             'terlet' ;
      $8F : EMSHibaSzoveg := 'Nincs ilyen EMM alfunkci' ;
      Else  EMSHibaSzoveg := '' ;
    End ;
  End ;

Function  EMSJelen : Boolean ;
  Type
    KarTomb = Array[1..8] Of Char ;
  Const
    EMSEllenorzo : KarTomb = 'EMMXXXX0' ;
  Var
    R         : Registers ;
    EMSVektor : Pointer ;
  Begin
    With R Do
      Begin
        GetIntVec($67,EMSVektor) ;
        EMSVektor := Ptr(Seg(EMSVektor^),10) ;
        EMSJelen := KarTomb(EMSVektor^) = EMSEllenorzo ;
        EMSOk := AH ;
      End ;
  End ;

Function EMSKeretCim : Word ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $41 ;
        Intr($67,R) ;
        EMSKeretCim := BX ;
        EMSOk := AH ;
      End ;
  End ;

Function EMSSzabad : Word ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $42 ;
        Intr($67,R) ;
        EMSSzabad := BX ;
        EMSOk := AH ;
      End ;
  End ;

Function EMSTeljes : Word ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $42 ;
        Intr($67,R) ;
        EMSTeljes := DX ;
        EMSOk := AH ;
      End ;
  End ;

Procedure EMSFoglal(Var EMMKezelo: Word; EMSLapszam: Word) ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $43 ;
        BX := EMSLapszam ;
        Intr($67,R) ;
        EMMKezelo := DX ;
        EMSOk := AH ;
      End ;
  End ;

Procedure EMSKeret(EMMKezelo: Word; EMSLap: Word; KeretLap: Byte);
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $44 ;
        DX := EMMKezelo ;
        BX := EMSLap ;
        AL := KeretLap ;
        Intr($67,R) ;
        EMSOk := AH ;
      End ;
  End ;

Procedure EMSFelszabadit(EMMKezelo: Word) ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $45 ;
        DX := EMMKezelo ;
        Intr($67,R) ;
        EMSOk := AH ;
      End ;
  End ;

Function EMSVerzio : Word ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $46 ;
        Intr($67,R) ;
        EMSVerzio := (AL And $0F) Shl 8 + (AL And $F0) Shr 4 ;
        EMSOk := AH ;
      End ;
  End ;

Function EMSKezelokSzama : Word ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $4B ;
        Intr($67,R) ;
        EMSKezelokSzama := BX ;
        EMSOk := AH ;
      End ;
  End ;

Function EMSLapszam(EMMKezelo: Word) : Word ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $4C ;
        DX := EMMKezelo ;
        Intr($67,R) ;
        EMSLapszam := BX ;
        EMSOk := AH ;
      End ;
  End ;

Procedure EMSKezeloInfo(Var EMMKezelokSzama: Word ;
                        Var EMMKezelok) ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $4D ;
        ES := Seg(EMMKezelok) ;
        DI := Ofs(EMMKezelok) ;
        Intr($67,R) ;
        EMMKezelokSzama := BX ;
        EMSOk := AH ;
      End ;
  End ;

End.
