#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>
#include <string.h>

#include "urstdio.inc"
#include "..\zigzag.h"
#include "..\error\error.h"
#include "unrar.h"




MEMFILE *urs_fopen(filename,mode)
const char *filename;
const char *mode;
{
  MEMFILE *memfptr;
  if ((memfptr=(MEMFILE *)malloc(sizeof(MEMFILE)))==NULL)
    errexit(UNRAR_STDIO_NOMEM);
  if ((strchr(mode,'w')!=NULL) || (strchr(mode,'a')!=NULL) ||
      (strchr(mode,'+')!=NULL))
  {
    errexit(UNRAR_STDIO_NOWR);
  }
  memfptr->size=unrar_unpack(ZZ_DATFILE,ZZ_DATOFFS,&(memfptr->data),filename);
  memfptr->ptr=0;
  memfptr->mode=((strchr(mode,'t')!=NULL) ?
                    O_TEXT : (strchr(mode,'b')!=NULL) ? O_BINARY : _fmode);
  return(memfptr);
}

int urs_fclose(mfptr)
MEMFILE *mfptr;
{
  free(mfptr->data);
  return(0);
}



size_t urs_fread(buf,elsize,nelem,mfptr)
void *buf;
size_t elsize;
size_t nelem;
MEMFILE *mfptr;
{
  size_t elem;
  for (elem=0;(elem<nelem) && (mfptr->ptr+elsize<=mfptr->size) ;elem++)
  {
    memcpy((char*)buf+elem*elsize,mfptr->data+mfptr->ptr,elsize);
    mfptr->ptr+=elsize;
  }

  return(elem);
}

int urs_fseek(mfptr,offset,whence)
MEMFILE *mfptr;
long offset;
int whence;
{
  long saveptr=mfptr->ptr;
  if ((mfptr->mode==O_TEXT) && (offset!=0))
    return(1);
  else
  {
    switch (whence)
    {
      case SEEK_SET:
        mfptr->ptr=offset;
        break;
      case SEEK_CUR:
        mfptr->ptr+=offset;
        break;
      case SEEK_END:
        mfptr->ptr=mfptr->size-offset;
        break;
    }
    if ((mfptr->ptr<=mfptr->size) && (mfptr->ptr>=0))
      return(0);  //Successful
    else
    {
      mfptr->ptr=saveptr;
      return(1);  //Not successful
    }
  }
}

long urs_ftell (mfptr)
MEMFILE *mfptr;
{
  if ((mfptr->mode==O_TEXT) && (mfptr->ptr!=0))
    return(-1);
  else
    return(mfptr->ptr);
}

int urs_feof(mfptr)
MEMFILE *mfptr;
{
  return(mfptr->ptr==mfptr->size);
}

void urs_clearerr(mfptr)  //Cause, there's no error indicator, there's no
MEMFILE *mfptr;            //need for it's clearing
{
}

int urs_ferror(mfptr)
MEMFILE *mfptr;
{
  return(0);             //There are no possible errors
}

int urs_fgetc(mfptr)
MEMFILE *mfptr;
{
  if (urs_feof(mfptr))
  {
    return(EOF);
  }
  else
  {
    int retno;
    retno=*(mfptr->data+mfptr->ptr);
    mfptr->ptr++;
    if ((mfptr->mode==O_TEXT) &&
        (retno==CR) &&
        (mfptr->ptr<mfptr->size) &&
        (*(mfptr->data+mfptr->ptr)==LF))
    {
      mfptr->ptr++;
      retno=LF;
    }
    return(retno);
  }
}

int urs_fgetpos(mfptr,pos)
MEMFILE *mfptr;
fpos_t *pos;
{
  *pos=mfptr->ptr;
  return(0);  //No possible errors
}

int urs_fsetpos(mfptr,pos)
MEMFILE *mfptr;
const fpos_t *pos;
{
  return (urs_fseek(mfptr,*pos,SEEK_SET));
}

char *urs_fgets(s,n,mfptr)
char *s;
int n;
MEMFILE *mfptr;
{
  int c;
  for (c=0; c<n-1;c++)
  {
    int ch;
    ch=urs_fgetc(mfptr);
    switch (ch)
    {
      case EOF:
        s[c]=0;
        return(NULL);
      case LF:
    //maybe an error   retain=???
        s[c]=0;
//      s[c]=LF;
//      s[c+1]=0;
        return(s);
      default:
        s[c]=ch;
    }
  }
  s[c]=0;
  return(s);
}

MEMFILE *urs_freopen(filename,mode,mfptr)
const char *filename;
const char *mode;
MEMFILE *mfptr;
{
  urs_fclose(mfptr);
  return(urs_fopen(filename,mode));
}

int urs_fgetw(mfptr)
MEMFILE *mfptr;
{
  if (mfptr->mode==O_TEXT)
  {
    errexit(UNRAR_STDIO_TEXTERR);
    return(1);  //Thus no warning will be caused
  }
  else
    if (!(mfptr->ptr<mfptr->size-1))
    {
      urs_fseek(mfptr,0,SEEK_END);
      return(EOF);
    }
    else
    {
      mfptr->ptr+=2;
      return(*((int*)(mfptr->data+mfptr->ptr-2)));
    }
}

int urs_ungetc(c,mfptr)
int c;
MEMFILE *mfptr;
{
  if (urs_feof(mfptr))
    return(EOF);
  else
  {
    *(mfptr->data+mfptr->ptr)=(char)c;
    return(c);
  }
}








