#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include <process.h>
#include <mem.h>

#include "mouse\mouse_sv.h"

int MousePresent = 0;
int msv_active = 0;
int last_dcur = 0;
int last_rnum = 1;
int last_cpdef = 0;

typedef unsigned int WORD;
typedef unsigned long DWORD;

extern "C" void __interrupt msv_handler (void);
extern "C" void msvhivo1(void);

extern "C" void msv_hide(void);
extern "C" void msv_show(void);
extern "C" void msv_init(void);

#define MC_SIZE        32
#define MAXCURSNUM    200
#define MCV_FREQ        3 //5 // 18.2 times / sec

struct ca_defs {
 int curn : 8;
 int fcur : 4;
 int fmax : 4;
 };

extern "C" unsigned long        cursor_defs[];
extern "C" unsigned short curanim_defs[];
extern "C" cp_s cursor_places[];
extern "C" unsigned short msv_cur_x;
extern "C" unsigned short msv_cur_y;
extern "C" unsigned short msv_curdef;
extern "C" unsigned short msv_ihact;

int mcv_int1c_cnt=0;

void msvhivo1( void );

void (__interrupt __far *sxprev_int_1c)();
void _loadds __interrupt __far anim_maker()
{
 _disable();
 mcv_int1c_cnt++;
 if (mcv_int1c_cnt>MCV_FREQ)
  {
   mcv_int1c_cnt=0;
   int c,g;
   ca_defs *q;
   g=0;

   for (c=0;c<=last_dcur;c++)
    {
     q=(ca_defs *)&curanim_defs[c];
     if (q->fmax!=0)
      {
       if (msv_curdef==c)
        g=1;
       q->fcur++;
       q->curn++;
       if (q->fcur==q->fmax)
        {
         q->fcur=0;
         q->curn-=q->fmax;
        }
      }
    }

   if (!msv_ihact && g)
    msvhivo1();
  }
 _enable();
 _chain_intr( sxprev_int_1c );
}


void msv_inithandler(void)
{
 if (!MousePresent)
  return;

 int c,d;
 struct SREGS sregs;
 union REGS inregs, outregs;
 int (far *function_ptr)();
 int (far *fh)();

 segread(&sregs);
 inregs.w.ax = 0xC;
 inregs.w.cx = 1; // on mouse movement only 0x7f; //0x0002 + 0x0008;
 function_ptr = (int (far *)(void))msv_handler; //(int (far *)(void)) rmclickhandler;
 inregs.x.edx = FP_OFF( function_ptr );
 sregs.es     = FP_SEG( function_ptr );
 int386x( 0x33, &inregs, &outregs, &sregs );
 msv_active = 1;

 sxprev_int_1c = _dos_getvect( 0x1c );
 _dos_setvect( 0x1c, anim_maker );

 atexit(msv_deinithandler);
}

void msv_deinithandler( void )
{
 if (!MousePresent)
  return;

 if (!msv_active)
  return;

 _dos_setvect( 0x1c, sxprev_int_1c ); // restore int 1ch

 union REGS inregs, outregs;

 inregs.w.ax = 0xC;
 inregs.w.cx = 0;
 int386( 0x33, &inregs, &outregs );
 msv_active = 0;
}

int msv_setdefaultcursor( char *mc )//a hivo allokal teruletet,es az lesz hasznalva!
{
 cursor_defs[0]=(unsigned)mc;
 return 0;
}

int msv_setanimcursor( int fromn, int faz )
{
 ca_defs *q;
 q=(ca_defs *)&curanim_defs[fromn];
 _disable();
 q->fcur=0;
 q->fmax=faz;
 _enable();
 return 0;
}


int msv_definecursor( char *mc )//a hivo allokal teruletet,es az lesz hasznalva!
{
 last_dcur++;
 cursor_defs[last_dcur]=(unsigned)mc;
 curanim_defs[last_dcur]=last_dcur;
 return last_dcur;
}

int setregioncur( int x1, int y1, int x2, int y2, int curnum ) // returns refnum
{
 int c=(last_cpdef++);
 cp_s *q;
 q=&cursor_places[c+1];
 q->x1=0xffff; // end-of-list
 q=&cursor_places[c];
 q->x1=x1;
 q->x2=x2;
 q->y1=y1;
 q->y2=y2;
 q->cursnum=curnum;
 q->refnum=last_rnum;
 last_rnum++;
 return(q->refnum);
}

void clearallregionscur( void )
{
 cursor_places[0].x1=0xffff;
 last_rnum=1;
 last_cpdef=0;
}

void clearregioncur( int refnum )
{
 // ...

 last_cpdef--;
}

int curregion( void )
{
 return(msv_curdef);
}

//-------------------------------normal mouse fn-s below:

int mouse_installed( void )
{
 REGS regs;

 regs.w.ax = 0;
 int386( 0x33, &regs, &regs );
 MousePresent = (regs.w.ax != 0);
 return MousePresent;
}

void enable_software_cursor( void )
{
 if (!MousePresent)
  return;

 REGS r;

 r.w.ax = 1;
 int386(0x33,&r,&r);
 r.w.ax = 10;
 r.w.bx = 0;
 r.w.cx = 0xFFFF;
 r.w.dx = 0x7700;
 int386(0x33,&r,&r);
}

void read_mouse_position( int* x,int* y )
{
 if (!MousePresent)
  { *x=0; *y=0; return;}

 REGS r;

 r.w.ax = 3;
 int386(0x33,&r,&r);
 *x = r.w.cx;
 *y = r.w.dx;
}

int left_button_pressed( void )
{
 if (!MousePresent)
  return 0;

 REGS r;

 r.w.ax = 3;
 int386(0x33,&r,&r);
 return( r.w.bx & 1 );
}

int right_button_pressed( void )
{
 if (!MousePresent)
  return 0;

 REGS r;

 r.w.ax = 3;
 int386(0x33,&r,&r);
 return( r.w.bx & 2 );
}

void m_hide( void )
{
 if (msv_active)
  {
   msv_hide();
   return;
  }

 if (!MousePresent)
  return;
 REGS r;
 r.w.ax = 2;
 int386(0x33,&r,&r);
}

void m_show( void )
{
 if (msv_active)
  {
   msv_show();
   return;
  }

 if (!MousePresent)
  return;
 REGS r;
 r.w.ax = 1;
 int386(0x33,&r,&r);
}

void set_mouse_window( int x1, int y1, int x2, int y2)
{
 if (!MousePresent)
  return;

 REGS r;
 r.w.ax = 7;
 r.w.cx = x1;
 r.w.dx = x2;
 int386(0x33,&r,&r);

 r.w.ax = 8;
 r.w.cx = y1;
 r.w.dx = y2;
 int386(0x33,&r,&r);
}

void set_mouse_speed( int xs, int ys )
{
 if (!MousePresent)
  return;

 REGS r;
 r.w.ax = 0xf;
 r.w.cx = xs;
 r.w.dx = ys;
 int386(0x33,&r,&r);
}
