;**
;** bimo.asm:
;** Assembler code for real-mode and protected-mode
;** INT 0xC interrupt handlers to support the INT 0xC
;** interrupt in both modes
;**
.386
;**
;** The real-mode interrupt handler is in a 16-bit code
;** segment so that the assembler will generate the right
;** code.  We will copy this code down to a 16-bit segment
;** in low memory rather than executing it in place.
;**

;**
;** The protected-mode interrupt handler is in a 32-bit code
;** segment.  Even so, we have to be sure to force an IRETD
;** at the end of the handler, because MASM doesn't generate
;** one.  This handler will be called on a 32-bit stack by
;** DOS/4GW.
;**
;** _DATA is the flat model data segment, which we load into
;** ES so we can write to absolute address 0xB8000.  (In the
;** flat model, DS is based at 0.)
;**

MC_SIZE EQU 32

_DATA   SEGMENT DWORD PUBLIC USE32 'DATA'

    PUBLIC _cursor_defs,_cursor_places,_curanim_defs,_msv_cur_x,_msv_cur_y
    PUBLIC _msv_curdef,_msv_ihact

;_ms_mask db (MC_SIZE*MC_SIZE) dup (?)

cp_s struc
     x1 dw ?
     x2 dw ?
     y1 dw ?
     y2 dw ?
     cd db ?
     refnum db ?
cp_s ends

_cursor_defs   dd   200 dup (?) ; a 0. elem a default kene: highest byte a
                                ; hotspotot definialna?
_cursor_places cp_s <0ffffh,,>, 200 dup (?)
_curanim_defs  dw   200 dup (?)

ms_save  db (MC_SIZE*MC_SIZE) dup (0)
ms_x     dw ?
ms_y     dw ?
_msv_ihact dw 0
mouse_volt  db 0
msv_state dw 0 ; init
last_bnk  dw 0FFh ; initelni
_msv_cur_x    dw ?
_msv_cur_y    dw ?
_msv_curdef   dw ? ; ezt kene updatelni
save_bnk dw ?
vesa_gran dw 64 ; kbyte-os ablakok --- ez nem biztos!!!

_DATA   ENDS

;---------------------------------------------------------------------

DGROUP GROUP _DATA

_TEXT   SEGMENT DWORD PUBLIC USE32 'CODE'
    ASSUME  cs:_TEXT

    PUBLIC  msv_handler_,msv_hide_,msv_show_,msv_init_,msvhivo1_

    ASSUME  ds:_DATA, es:_DATA


;-------------kov. bankba valt.
changebank: ; dx-a kert bank
    mov     last_bnk,dx      ; granularity miatt kellene look-up-table!
    push    eax ebx
    mov     eax,04f05h
    mov     ebx,0
    int     10h
    pop     ebx eax
    ret

nextbank:
    push    edx
    mov     dx,last_bnk
    inc     dx
    call    changebank
    pop     edx
    ret

calcstart: ; X:ebx Y:edx  Ret: eax:offset _from_ a0000h !meg maszkolni kell!
    push    ecx edx
    and     ebx,0ffffh
    and     edx,0ffffh
    mov     eax,edx
    mov     ecx,640
    mul     ecx
    add     eax,ebx
    pop     edx ecx
    ret
;-------------------------
restmousec:
    cmp    mouse_volt,0
    je     pmvx2
    push   ebp

    xor    ebx,ebx
    xor    edx,edx
    mov    bx,ms_x
    mov    dx,ms_y
    call   calcstart ; -> eax: offset from a0000h
    mov    esi,offset ms_save
    mov    edi,eax
    and    edi,0ffffh
    add    edi,0A0000h
    ror    eax,16
    mov    dx,ax
    call   changebank

    cld
    mov    ebp,MC_SIZE

ujsor12:
    mov    ecx,MC_SIZE

ujoszl12:
    movsb
    cmp    di,0
    jne    megnem12
    call   nextbank
    mov    edi,0a0000h
megnem12:
    loop   ujoszl12

    add    di,(640-MC_SIZE)
    cmp    di,(640-MC_SIZE)
    jae    nemx12
    call   nextbank
nemx12:

    dec    ebp
    jnz    ujsor12

    pop    ebp
    mov    mouse_volt,0
pmvx2:
    ret
;-------------------------
savemousec:
    mov    mouse_volt,1

    push   ebp
    xor    ebx,ebx
    xor    edx,edx
    mov    bx,_msv_cur_x
    mov    dx,_msv_cur_y
    call   calcstart ; -> eax: offset from a0000h
    mov    edi,offset ms_save
    mov    esi,eax
    and    esi,0ffffh
    add    esi,0A0000h
    ror    eax,16
    mov    dx,ax
    call   changebank

    cld
    mov    ebp,MC_SIZE

ujsor23:
    mov    ecx,MC_SIZE

ujoszl23:
    movsb
    cmp    si,0
    jne    megnem23
    call   nextbank
    mov    esi,0a0000h
megnem23:
    loop   ujoszl23

    add    si,(640-MC_SIZE)
    cmp    si,(640-MC_SIZE)
    jae    nemx23
    call   nextbank
nemx23:

    dec    ebp
    jnz    ujsor23

    pop    ebp

    ret
;-------------------------
putmousec: ; esi: cursor offset-je
    push   ebp

    xor    ebx,ebx
    xor    edx,edx
    mov    bx,_msv_cur_x
    mov    dx,_msv_cur_y
    call   calcstart ; -> eax: offset from a0000h
;    mov    esi,offset _ms_mask
    mov    edi,eax
    and    edi,0ffffh
    add    edi,0A0000h
    ror    eax,16
    mov    dx,ax
    call   changebank

    cld
    mov    ebp,MC_SIZE

ujsor22:
    mov    ecx,MC_SIZE
    mov    edx,ebx ; ebx:x  -> edx

ujoszl22:
    lodsb
    inc    edx ; x pos ++

    cmp    al,0ffh
    je     skipitdude
    cmp    edx,640
    jae    skipitdude
    mov    es:[edi],al
skipitdude:
    inc    edi
    cmp    di,0
    jne    megnem22
    call   nextbank
    mov    edi,0a0000h
megnem22:
    loop   ujoszl22

    add    di,(640-MC_SIZE)
    cmp    di,(640-MC_SIZE)
    jae    nemx22
    call   nextbank
nemx22:

    dec    ebp
    jnz    ujsor22

    pop    ebp
    ret
;--------------------------------------
selectmcursor:
    push   ebp
    mov    ebp,0
    mov    _msv_curdef,bp    

    push   ebx
    xor    ebx,ebx
    mov    bx,_curanim_defs[0]
    xor    bh,bh
    mov    edi,_cursor_defs[ebx*4]
    pop    ebx

    mov    esi,0
    mov    bx,_msv_cur_x
    mov    dx,_msv_cur_y
vanmegbaby:
    mov    ax,_cursor_places[esi].x1
    cmp    ax,0ffffh
    je     vegeamokanak

    inc    ebp
    cmp    ax,bx
    ja     ujrajatszhat

    mov    ax,_cursor_places[esi].x2
    cmp    ax,bx
    jb     ujrajatszhat

    mov    ax,_cursor_places[esi].y1
    cmp    ax,dx
    ja     ujrajatszhat

    mov    ax,_cursor_places[esi].y2
    cmp    ax,dx
    jb     ujrajatszhat
    ;-- nyert!:
    xor    ebx,ebx
    mov    bl,_cursor_places[esi].cd
    mov    ax,_curanim_defs[ebx*2]
    mov    bl,al
    mov    edi,_cursor_defs[ebx*4]
    mov    bl,_cursor_places[esi].refnum
    xor    bh,bh
    mov    eax,esi
    mov    _msv_curdef,bp    
    jmp    vegeamokanak

    ;----
ujrajatszhat:
    add    esi,size cp_s
    jmp    vanmegbaby
vegeamokanak:
    mov    esi,edi
    pop    ebp
    ret
;-----------------------------
msvhivo1_:
    mov     eax,1
    mov     cx,_msv_cur_x
    mov     dx,_msv_cur_y

    push    cs
    call    msv_handler_
    ret

msv_handler_:
    cli
    push    es ds
    pusha
    mov     bx,DGROUP
    mov     es,bx
    mov     ds,bx
    ASSUME  ds:_DATA, es:_DATA

    mov     _msv_ihact,1
    cmp     msv_state,1
    jne     nemaktiv

    mov     _msv_cur_x,cx
    mov     _msv_cur_y,dx

    ;save_bank is,
    mov     ax,04f05h
    mov     bx,0100h ; query page #
    int     10h
    mov     save_bnk,dx
    mov     last_bnk,dx

    call    restmousec
    call    savemousec
    ; kene meg decide-which-mouse cursor, etc.
    ; mov     esi,offset _ms_mask
    call    selectmcursor ; esi-be tolt
    call    putmousec

    ;restore
    mov     dx,save_bnk
    cmp     dx,last_bnk
    je      nemiskellmertottvagyunkmar
    mov     ax,04f05h
    mov     bx,0 ; set page #
    int     10h
nemiskellmertottvagyunkmar:

    mov     ax,_msv_cur_x
    mov     ms_x,ax
    mov     ax,_msv_cur_y
    mov     ms_y,ax

nemaktiv:
    mov     _msv_ihact,0

    popa
    pop     ds es
    sti
;    iretd
    retf
;---------------------------------------------
msv_hide_:
    call    restmousec
    mov     msv_state,0
    ret

msv_show_:
    mov     msv_state,1
   ; kene meg vmi paint is.../readmousepos
    ret

msv_init_: ; elvileg itt is DS stimmel...
    mov mouse_volt,0
    mov msv_state,-1
    mov last_bnk,0FFh
    ret

_TEXT   ENDS
    END
