#include <conio.h>
#include <math.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <sys\stat.h>
#include <mem.h>
#include <alloc.h>
#include <stdlib.h>
#include <ctype.h>
#include <graphics.h>

#define PI	3.1415
#define PIP18	0.017452       // PI/180

int huge detectVGA256(void);
void adjustpalette( char pl[] );
void fadein( char pl[], int steps );
void fadeout( char pl[], int steps );

typedef struct
 {
  int x,y;
  int ox,oy;
  int color;
  int oldcol;
 }
  spointtype;

void main( void )
{
 //initmodes( 19 );
 int gdriver, gmode;

 /* install a user written device driver */
 gdriver = installuserdriver("VGA256", detectVGA256);

 /* must force use of detection routine */
 gdriver = DETECT;

 /* initialize graphics and local variables */
 initgraph(&gdriver, &gmode, "");

 int c,d,e,f;
 char far *scr;
 scr=(char far *)MK_FP( 0xA000 , 0 );
 int fh;
 char pal[800];

 fh=open("ZIGCOOL2.RAW" , O_RDWR|O_BINARY);
 lseek(fh,32,SEEK_SET);
 read(fh,pal,768);
 close(fh);

 adjustpalette(pal);

 fadein(pal,1);

 spointtype pt[320],pt2[320];

 /**
 for ( c=0 ; c<=310 ; c++ )
  {
   pt[c].y = 100+sin(PIP18*c*1.15)*45;
   pt[c].x = c;
   pt[c].color = c % 64;
   pt[c].oldcol = 0;
  }
 **/

 for ( c=0 ; c<=310 ; c++ )
  {
   pt2[c].y = 120+sin(PIP18*c*2.32)*45;
   pt2[c].x = c;
   pt2[c].color = c % 64 ; //((c%100)<64)? c%100 : 0; //c % 64;
   pt2[c].oldcol = 0;
   pt2[c].ox=0;
   pt2[c].oy=0;
  }

 do
  {
   for ( d=0 ; d<=5 ; d++ )
    {
     for ( c=0 ; c<=310 ; c++ )
      if ( pt2[c].oldcol != peekb( 0xA000 , (pt2[c].oy+d)*320+c ) )
       pokeb( 0xA000 , (pt2[c].oy+d)*320+c , pt2[c].oldcol );

     for ( c=0 ; c<=310 ; c++ )
      pokeb( 0xA000 , (pt2[c].y+d)*320+c , pt2[c].color );
    }

   //for ( c=0 ; c<=310 ; c++ ) { pt[c].ox=pt[c].x; pt[c].oy=pt[c].y; }
   for ( c=0 ; c<=310 ; c++ ) { pt2[c].ox=pt2[c].x; pt2[c].oy=pt2[c].y; }

   d=pt[310].y; e=pt2[310].y;
   for ( c=310 ; c>=1 ; c-- )
    {
     pt[c].y=pt[c-1].y;
     pt2[c].y=pt2[c-1].y;
    }
   pt[0].y=d; pt2[0].y=e;

   delay(2);
  }
 while ( !kbhit() );
 getch();

 getch();

 closegraph();
}

/***********************************************************/

/* detects VGA cards */
int huge detectVGA256(void)
{
   int driver, mode, sugmode = 0;

   detectgraph(&driver, &mode);
   if (driver == VGA)
      /* return suggested video mode number */
      return sugmode;
   else
      /* return an error code */
      return grError;
}

void adjustpalette( char pl[] )
{
 int i;

 for ( i=0 ; i<=255 ; i++ )
  {
   pl[3*i]/=4;
   pl[3*i+1]/=4;
   pl[3*i+2]/=4;
  }
}

void fadein( char pl[], int steps )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 int pf;

 union REGPACK reg;

 int i,d;

 /*********
 for (i=0; i<=63; i++)
  {
   pt[i].r=i; pt[i].g=i; pt[i].b=i;
   //pt[127-i].r=i; pt[127-i].g=i; pt[127-i].b=i;
  }
 *********/
 register int ms;
 ms=steps;

 for ( d=1 ; d<=ms ; d++ )
  {
   for (i=0; i<=255; i++)
    {
     pt[i].r=((pl[3*i]*d)/ ms );
     pt[i].g=((pl[3*i+1]*d)/ms );
     pt[i].b=((pl[3*i+2]*d)/ms );
    }

   for (i=0; i<=255; i++)
    {
     outportb(0x3C8,i);

     outportb(0x3C9,pt[i].r);
     outportb(0x3C9,pt[i].g);
     outportb(0x3C9,pt[i].b);
    }

   /*
   reg.r_ax = 0x10 << 8 | 0x12 ;
   reg.r_bx = 0;
   reg.r_cx = 255;
   reg.r_es = _DS;
   reg.r_dx = (unsigned)pt;
   intr(0x10, &reg);
   */

   //delay(10);
  }
 /*
 for (i=0; i<=255; i++)
  {
   pt2.r=(pl[3*i]/4);
   pt2.g=(pl[3*i+1]/4);
   pt2.b=(pl[3*i+2]/4);

   /*
   reg.r_ax = 0x10 << 8 | 0x10 ;
   reg.r_bx = i;
   reg.r_dx = pt2.r<<8;
   reg.r_cx = pt2.g<<8 | pt2.b;
   intr(0x10, &reg);
   */
   outportb(0x3C8,i);

   outportb(0x3C9,pt2.r);
   outportb(0x3C9,pt2.g);
   outportb(0x3C9,pt2.b);

   delay(10);

   //delay(10);
  }
 */
}

void fadeout( char pl[] , int steps )
{
 struct s_pt
  {
   char r,g,b;
  };
 s_pt pt[256],pt2;
 int pf;

 union REGPACK reg;

 int i,d;

 /*********
 for (i=0; i<=63; i++)
  {
   pt[i].r=i; pt[i].g=i; pt[i].b=i;
   //pt[127-i].r=i; pt[127-i].g=i; pt[127-i].b=i;
  }
 *********/
 register int ms;
 ms=steps;

 for ( d=ms ; d>=1 ; d-- )
  {
   for (i=0; i<=255; i++)
    {
     pt[i].r=((pl[3*i]*d)/ ms );
     pt[i].g=((pl[3*i+1]*d)/ms );
     pt[i].b=((pl[3*i+2]*d)/ms );
    }

   for (i=0; i<=255; i++)
    {
     outportb(0x3C8,i);

     outportb(0x3C9,pt[i].r);
     outportb(0x3C9,pt[i].g);
     outportb(0x3C9,pt[i].b);
    }

   /*
   reg.r_ax = 0x10 << 8 | 0x12 ;
   reg.r_bx = 0;
   reg.r_cx = 255;
   reg.r_es = _DS;
   reg.r_dx = (unsigned)pt;
   intr(0x10, &reg);
   */

   //delay(10);
  }
 /*
 for (i=0; i<=255; i++)
  {
   pt2.r=(pl[3*i]/4);
   pt2.g=(pl[3*i+1]/4);
   pt2.b=(pl[3*i+2]/4);

   /*
   reg.r_ax = 0x10 << 8 | 0x10 ;
   reg.r_bx = i;
   reg.r_dx = pt2.r<<8;
   reg.r_cx = pt2.g<<8 | pt2.b;
   intr(0x10, &reg);
   */
   outportb(0x3C8,i);

   outportb(0x3C9,pt2.r);
   outportb(0x3C9,pt2.g);
   outportb(0x3C9,pt2.b);

   delay(10);

   //delay(10);
  }
 */
}

/*******
**************************/
