#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>

/* function prototypes */
int huge detectVGA256(void);
void checkerrors(void);
void dpalette( void );

struct s_pt
  {
   char r,g,b;
  };
s_pt pt[256];

void dpalette(  )
{
 s_pt pt2;
 int pf;

 union REGPACK reg;

 char i;

 /*******
 reg.r_ax = 0x10 << 8 | 0x17 ;
 reg.r_bx = 0;
 reg.r_cx = 255;
 reg.r_es = _DS;
 reg.r_dx = (unsigned)pt;
 ******/
 //intr(0x10, &reg);

 pt2=pt[1];
 for (i=1; i<=63/*254*/; i++)
  {
   pt[i]=pt[i+1];
  }
 pt[63/*254*/]=pt2;

 pt2=pt[64];
 for (i=64; i<=64+63/*254*/; i++)
  {
   pt[i]=pt[i+1];
  }
 pt[64+63/*254*/]=pt2;

 pt2=pt[128];
 for (i=128; i<=128+63/*254*/; i++)
  {
   pt[i]=pt[i+1];
  }
 pt[128+63/*254*/]=pt2;

 pt2=pt[128+64];
 for (i=128+64; i<=128+64+62/*254*/; i++)
  {
   pt[i]=pt[i+1];
  }
 pt[128+64+62/*254*/]=pt2;

 reg.r_ax = 0x10 << 8 | 0x12 ;
 reg.r_bx = 0;
 reg.r_cx = 255;
 reg.r_es = _DS;
 reg.r_dx = (unsigned)pt;

 intr(0x10, &reg);
}


int main(void)
{
   int gdriver, gmode;
   int xx;
   unsigned char xf;

   /* install a user written device driver */
   gdriver = installuserdriver("VGA256", detectVGA256);

   /* must force use of detection routine */
   gdriver = DETECT;

   /* check for any installation errors */
   checkerrors();

   /* initialize graphics and local variables */
   initgraph(&gdriver, &gmode, "");

   /* check for any initialization errors */
   checkerrors();

   struct palettetype pal;
   int c,d;

   /* grab a copy of the palette */
   // getpalette(&pal);

   /* create gray scale */
   /****
    for (i=0; i<=256; i++)
      setrgbpalette(i, i, i, i);
   ****/
   putpixel( 256+1,1,63 );

   for ( d=1 ; d<=4 ; d++ )
    for (c=0 ; c<=63 ; c++ )
     {
      if (d != 4)
       setrgbpalette((d-1)*64 + c, (d==1)?c:0 ,(d==2)?c:0 , (d==3)?c:0 );
      else
       setrgbpalette((d-1)*64 + c, c , c , c );
      putpixel( (d-1)*64 + c+1,1,63 );
     }


   /* draw lines */
   for ( c=1 ; c < 255 ; c++ )
    {
    setcolor(c);
    line(c, 1, c, getmaxy());
    putpixel(c,0,(c % 2)*255);
    }

   union REGPACK reg;
   reg.r_ax = 0x10 << 8 | 0x17 ;
   reg.r_bx = 0;
   reg.r_cx = 255;
   reg.r_es = _DS;
   reg.r_dx = (unsigned)pt;
   intr(0x10, &reg);

   while (!kbhit())
    {
     dpalette();
     delay(40);
     //delay(350);
    }

   /* clean up */
   getch();
   closegraph();
   return 0;
}

/* detects VGA cards */
int huge detectVGA256(void)
{
   int driver, mode, sugmode = 0;

   detectgraph(&driver, &mode);
   if (driver == VGA)
      /* return suggested video mode number */
      return sugmode;
   else
      /* return an error code */
      return grError;
}

/* check for and report any graphics errors */
void checkerrors(void)
{
   int errorcode;

   /* read result of last graphics operation */
   errorcode = graphresult();
   if (errorcode != grOk)
   {
      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      printf("Press any key to halt:");
      getch();
      exit(1);
   }
}

