#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <conio.h>
#include <sys\stat.h>

#define BUFSIZE  40000

char buf[BUFSIZE];

void main ( int argc, char *argv[] )
{
 printf("NOSASOFT file splitter by John Zer\n");
 if (argc<4)
  {
   printf("Error :\n"
          " Usage SPLIT <infile> <outfile> <fromwhere> <count>\n");
   printf(" <count> = *  => to end of file\n");
   printf(" <count> = -xxx  => to pos. xxx\n");
   exit(1);
  }

 char inf,outf;
 long from,count;

 long curr,left,ifs;

 inf = open(argv[1],O_BINARY|O_RDONLY);
 outf = open(argv[2],O_BINARY|O_RDWR|O_CREAT,S_IREAD|S_IWRITE);

 ifs=filelength(inf);

 from = atol(argv[3]);
 if (from<0 || (from>ifs))
  {
   printf("<fromwhere> is out of range");
  }

 if (argv[4][0]=='*')
  count = ifs-from;
 else
  count = atol(argv[4]);

 if (argv[4][0]=='-')
  {
   count = atol(&argv[4][1]);
   count-=from;
  }

 if (count>(ifs-from) )
  {
   count = ifs-from;
   printf("<count> adjusted - to end of file");
  }

 left = count;
 lseek(inf,from,SEEK_SET);
 while ( left>0 )
  {
   curr = ( left>BUFSIZE ) ? BUFSIZE : left ;

   read(inf,buf,curr);
   printf(".");
   write(outf,buf,curr);
   printf(".");

   left -= curr;
  }
 printf(" Done\n");

 close(inf);
 close(outf);
}