#include <stdio.h>
#include <mem.h>
#include <stdarg.h>
#include <io.h>
#include <alloc.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <process.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <sys\stat.h>

#include "screen.h"
#include "datetype.h"
#include "bluewave.h"

//#define BW_MODE // ha bw valtozat

/*
   [X] QFNAME is set correctly
   [] Quotes
   [ ] FILE error -- hadling!
   [ ] Force only one conference...
   [.] History of subject
   [.] ^^ page pause
   [ ] Analize words used by sbdy
   [ ] Your name HIGHLITED in the list
   [ ] longest letters
   [ ] Optional 'Re:' removing in to-file
   [X] Re: removing in maximums
   [X] Most popular subjects
   [X] error with #q17
   [X] If all files are not erased before -- NDX-s -> might be error
   [ ] ARJ-error handling (? -- !!! other archivers
   [X] Don't change to tempdir (?)
  Note:
    Subj history is not case-sensitive!
*/

//#define QDEBUG

#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))


struct s_ndx
 {
  float mh;
  char conf;
 }
  sx;

int use_quotes=0;
int smono=0;
FILE *tof=NULL;  // to-file
char qwdate[40];
char qwtime[40];
char qwarea[40];
char qwbbs[90];   // revise!!!
char qwfname[12];

char optemp[255];
char arch[MAXPATH];
char archexe[MAXPATH];
char elpath[MAXPATH];

struct msg_header
 {
  char status;
  char msgnum[7]; // in ASCII
  char date[8]; // ASCII MM-DD-YY date
  char time[5]; // time in HH:MM ASCII
  char to[25];   // TO
  char from[25]; // FROM
  char subject[25]; // subject of message
  char password[12]; // message passw.
  char refernum[8]; // in ASCII
  char chunks[6]; // number of 128 byte chunks in msg, including header
  char alive; // msg is alive/killed
  char confLSB;
  char confMSB;
  char res[3];
 }
  mh;

struct ssd
 {
  int sum;
  char *name;
 }
  sd[800];

int sdcnt=0;

struct ssd subj[3500]; //[1500];
int subjcnt=0;

struct ssd rd[800];
int rdcnt=0;

struct snapon
 {
  int num;
  unsigned long jul;
 };
snapon far *napon=NULL;
int sncnt=0;
char basepath[255];

struct swpak
 {
  char ext[4];
  long size;
  ftime date;
 }
  wpak;

int days[7]; // sun->sat 0-6

char *dayname[]={"Sunday","Monday","Tuesday","Wednesday","Thursday",
                  "Friday","Saturday"};

char *monthn[]={"Jan","Feb","Mar","Apr","May","Jun",
                "Jul","Aug","Sep","Okt","Nov","Dec"};

char chour[24]={YELLOW, //00-01h
                YELLOW, //01-02h
                YELLOW, //02-03h
                LIGHTGREEN,  //03-04h
                LIGHTGREEN,  //04-05h
                GREEN,  //05-06h
                GREEN,  //06-07h
                LIGHTBLUE,   //07-08h
                LIGHTBLUE,   //08-09h
                LIGHTBLUE,   //09-10h
                LIGHTBLUE,   //10-11h
                LIGHTBLUE,   //11-12h
                LIGHTBLUE,   //12-13h
                LIGHTBLUE,   //13-14h
                LIGHTBLUE,   //14-15h
                LIGHTBLUE,   //15-16h
                LIGHTBLUE,   //16-17h
                GREEN,  //17-18h
                GREEN,  //18-19h
                LIGHTGREEN,  //19-20h
                LIGHTGREEN,  //20-21h
                LIGHTGREEN,  //21-22h
                YELLOW,      //22-23h
                YELLOW,      //23-00h
               };
int pers[24+1];

//----------------------------------------------------
void headdisp( FILE *ct );
void tempclean(void);
void dispgraf24(void);
void compgraf24(void);
int loadcfg( char *arg0 );
char *cropen( char *str);
void rogzitdata( msg_header *mh );
int sendercmp( const void *a, const void *b);
int napokcmp( const void *a, const void *b);
int process_conf( void );
float MSBINToIEEE(float f);
char *cropn( char *str);
char *cutss(char *ss,int len);
int sreplace( char *inw,  char *tok, char *st);
char *sorfeld( char *sor );
void gsetarch( void );
int execute( char *fname, char *cline);
void delfiles( char *which );
int setqwn( char *arg1 );
int gmenu(void);
void ondaydisp( void );
void hour6eval( void );
void writemax( void );
char *stripre( char *st );
void writemaxsubj( void );
void writemaxreceive( void );
int dayofweek( int ev, int honap, int nap ); // Sunday(0)--> Saturday(6)
void dispgrafday(void);
void xcprintf( char *mit, ... );
void xaprintf( int nattr, int attr2 , char *mit, ... );
int xputch( int ch );
void gethist( char *ezsubj );
void gethistname( char *ezname );

int maxsnum=0;
int sum=0;
int hmax=0; // max/hour
int quit_at_once=0;
int countit=0;
int cof1,cof2;
int cfrom=-1,cto=-1;
int voltqwkc=0;

Date ahat; // also hatar

//----------------------------------------------------
int msgfile=0; // message.dat file handle
FILE *ct=NULL; // control.dat file handle
//---------------
FILE *gof=NULL;


//----------------------------------------------------------------------
class oqwk
 {
  char qwkname[200];
  int f,g,msgfile;
  FILE *ct;
  int conf_num;
  int cnum;
  char cname[128];

 public:
  void setname( char *na ) { strcpy(qwkname,na); };
  int extract( void );
  int removetmp( void );

  int num_confs(void) { return conf_num; };
  int nextconf( void );
  int getcnum( void ) { return cnum; };
  char *getcname( void ) { return cname; };
  int nextmsg( struct msg_header *msh );
  int lastmsg() { return(eof(f)); };
 }
  ;

int oqwk::extract( void )
{
 char buf[256];

 if (mkdir("tempdir.qwk")==-1)
  {
   //cprintf("ERROR Creating directory 'TEMPDIR.QWK' -- dir. might already exist!\r\n");
   //exit(1);
   tempclean();
   if (mkdir("tempdir.qwk")==-1)
    {
     cprintf("ERROR Creating directory 'TEMPDIR.QWK' -- dir. might already exist!\r\n");
     exit(1);
    }
  }


 strcpy(buf,arch);
 sreplace(buf,"[ARCHNAME]",qwkname);
 sreplace(buf,"[TOPATH]","TEMPDIR.QWK\\");

 execute(archexe,buf);

 if ((g=open("TEMPDIR.QWK\\MESSAGES.DAT",O_RDONLY|O_BINARY))==-1)
  {
   cprintf("Error: Could not open MESSAGES.DAT !");
   tempclean();
   exit(1);
  }
 msgfile=g;

 if ((ct=fopen("TEMPDIR.QWK\\CONTROL.DAT","rt"))==NULL)
  {
   cprintf("Error: Could not open CONTROL.DAT !");
   tempclean();
   exit(1);
  }

 xcprintf("\r\n");
 headdisp(ct);     // ezt majd at kell rakni kulon

 fgets(buf,255,ct);
 conf_num=atoi(buf)+1;

 cnum=-1;
 strcpy(cname,"<ERR>");
 // file status: g:MESSAGES.DAT ct:CONTROL.DAT
}

int oqwk::nextconf()
{
 char buf[256];

 fgets(buf,255,ct);
 cnum=atoi(buf);
 fgets(cname,39,ct);
 if (cnum==0 && buf[0]!='0') // error w/conf
  return -1;

 if (cname[strlen(cname)-1]=='\n')
  cname[strlen(cname)-1]=0;

 sprintf(buf,"TEMPDIR.QWK\\%03d.NDX",cnum);

 close(f);
 f=open(buf,O_RDONLY|O_BINARY);
 if (f==-1)
  return(-1);
 // f:XXX.NDX
}

int oqwk::nextmsg( struct msg_header *msh )
{
 struct s_ndx sx;
 float ff;
 long li;
 long ffl;

 read(f,&sx,sizeof(sx));
 ff = MSBINToIEEE(sx.mh);

 sum++; // megtartani!!!
 ffl=ff;
 ffl-=1;

 li=ffl*128;
 lseek(msgfile,li,SEEK_SET);

 read(msgfile,msh,128);
}

int oqwk::removetmp( void )
{
 close(f);
 close(g);
 fclose(ct);
 tempclean();
}

//----------------------------------------------------------------

// Blue Wave:

class obwqwk
 {
  char qwkname[200];
  int inf;

  int conf_num;
  int cnum;
  char cname[128];

 public:
  void setname( char *na ) { strcpy(qwkname,na); };
  int extract( void );
  int removetmp( void );

  int num_confs(void) { return conf_num; };
  int nextconf( void );
  int getcnum( void ) { return cnum; };
  char *getcname( void ) { return cname; };
  int nextmsg( struct msg_header *msh );
  int lastmsg() { return(eof(inf)); };
 }
  ;

int obwqwk::extract( void )
{
 char buf[256];

 if (mkdir("tempdir.qwk")==-1)
  {
   //cprintf("ERROR Creating directory 'TEMPDIR.QWK' -- dir. might already exist!\r\n");
   //exit(1);
   tempclean();
   if (mkdir("tempdir.qwk")==-1)
    {
     cprintf("ERROR Creating directory 'TEMPDIR.QWK' -- dir. might already exist!\r\n");
     exit(1);
    }
  }


 strcpy(buf,arch);
 sreplace(buf,"[ARCHNAME]",qwkname);
 sreplace(buf,"[TOPATH]","TEMPDIR.QWK\\");

 execute(archexe,buf);

 char drive[MAXDRIVE];
 char dir[MAXDIR];
 char file[MAXFILE];
 char ext[MAXEXT];
 int flags;
 flags=fnsplit(qwkname,drive,dir,file,ext);
 //strcpy(buf,"TEMPDIR.QWK\\");
 //strcat(buf,drive);
 //strcat(buf,dir);
 strcpy(buf,"TEMPDIR.QWK\\");
 strcat(buf,file);
 strcat(buf,".FTI");

 if ((inf=open(buf,O_RDONLY|O_BINARY))==-1)
  {
   cprintf("Error: Could not open *.FTI !");
   tempclean();
   exit(1);
  }

 xcprintf("\r\n");
 xcprintf("<BlueWave header helye>\r\n");
 xcprintf("\r\n");
 //headdisp(ct);     // ezt majd at kell rakni kulon

 conf_num=1; // TMP only! will change!

 cnum=-1;
 strcpy(cname,"<ERR>");
}

int obwqwk::nextconf()
{
 if (cnum==1) // error w/conf
  return -1;

 strcpy(cname,"BlueWave/Bulk mode");
 cnum=1;
}

int obwqwk::nextmsg( struct msg_header *msh )
{
 FTI_REC fr;
 struct s_ndx sx;
 float ff;
 long li;
 long ffl;
 char buf[50];

 sum++; // kell!!!

 read(inf,&fr,sizeof(fr));

 memset(msh,0,sizeof(msg_header));

 //char status;
 //[7]=
 itoa(fr.msgnum,msh->msgnum,10); // in ASCII
 // !!! char date[8]; // ASCII MM-DD-YY date
 //char time[5]; // time in HH:MM ASCII

 strncpy(msh->to,fr.to,25); msh->to[25]=0;
 strncpy(msh->from,fr.from,25); msh->from[25]=0;
 strncpy(msh->subject,fr.subject,25); msh->subject[25]=0;

 int m,d,y;
 int c;
 char *p;
 p=strtok(fr.date," :");
 d=atoi(p);
 p=strtok(NULL," :");
 m=1;
 for (c=1;c<=12;c++)
  if (stricmp(monthn[c],p)==0)
   m=c;

 p=strtok(NULL," :");
 y=atoi(p);

 sprintf(msh->date,"%02d-%02d-%02d",m,d,y);

 p=strtok(NULL," ");
 strncpy(msh->time,p,5);

 /*char password[12]; // message passw.
 char refernum[8]; // in ASCII
 char chunks[6]; // number of 128 byte chunks in msg, including header
 char alive; // msg is alive/killed
 char confLSB;
 char confMSB;
 char res[3];*/
}

int obwqwk::removetmp( void )
{
 close(inf);
 tempclean();
}

//----------------------------------------------------------------------

#ifdef BW_MODE
  obwqwk *qx=new obwqwk();
#else
  oqwk *qx=new oqwk();
#endif

//----------------------------------------------------------------------

void main( int argc, char *argv[] )
{
 int c,cc,d,f,g,a;
 char *pp;
 int confnum,num,kar;
 //int fout;
 FILE *fo;
 unsigned yy;
 int bw_mode=0;

 char buf[260],b2[40],buf2[260];
 char cname[40];
 float ff;
 int n=0;

 char drive[MAXDRIVE];
 char dir[MAXDIR];
 char file[MAXFILE];
 char ext[MAXEXT];


 ahat=0L;

 for (c=0;c<24;c++)
  pers[c]=0;

 long li;

 //gof=fopen("log.txt","wt");

 textbackground(BLACK);
 textcolor(LIGHTGRAY);

 aprintf(LIGHTGRAY,WHITE,
 "Ŀ\r\n"
 #ifdef BW_MODE
 " BW-Statistical & Utils   v1.92beta\r\n"
 #else
 " QWK-Statistical & Utils  v1.92beta\r\n"
 #endif
 " (C) 1994 by ~John Zer~/~NOSASOFT~    \r\n"
 "\r\n");

 if (argc<2)
  {
   cprintf("Usage: <QWK-file> [@listfile] [!logfile] [/Q] [/C[from#-to#] | /C!]\r\n"
           "                  [/SYY-MM-DD | /SYY/MM/DD] [/BW]");
   exit(1);
  }

 struct ffblk ffblk;
 if (findfirst(argv[1],&ffblk,0)==-1)
  {
   cprintf("ERROR: File '%s' not found !\r\n",argv[1]);
   exit(1);
  }

 if (loadcfg(argv[0]))
  {
   cprintf("ERROR: Config file, QWKSTAT.CFG not found/could not be opened !\r\n");
   exit(1);
  }

 gsetarch();
 setqwn(argv[1]);

 //chdir("tempdir.qwk");

 for (c=2; c<=3; c++)
  if (argc>=(c+1))
   {
    cropen(argv[c]);
    if (argv[c][0]=='@')
     {
      movmem(&argv[c][1],&argv[c][0],strlen(argv[c]));
      strupr(argv[c]);
      tof=fopen(argv[c],"wt");
      if (!tof)
       {
        cprintf("ERROR creating file %s !\r\n",argv[c]);
        tempclean();
        exit(1);
       }
      cprintf("Opening file %s for list output...\r\n",argv[c]);
     }

    if (argv[c][0]=='!')
     {
      movmem(&argv[c][1],&argv[c][0],strlen(argv[c]));
      strupr(argv[c]);
      gof=fopen(argv[c],"wt");
      if (!gof)
       {
        cprintf("ERROR creating file %s !\r\n",argv[c]);
        tempclean();
        exit(1);
       }
      cprintf("Opening file %s for log output...\r\n",argv[c]);
     }

    if (argv[c][0]=='/')
     {
      if (toupper(argv[c][1])=='Q')
       {
        quit_at_once=1;
        cprintf("Quick-quit mode on\r\n");
       }

      if (toupper(argv[c][1])=='S')
       {
        // date start ide jon
        //cprintf("Quick-quit mode on\r\n");
        if (argv[c][2]!='\0')
         {
          DateRec dr;

          strcpy(buf,&argv[c][2]);
          pp=strtok(buf,"-/");
          dr.Year=atoi(pp);
          if (dr.Year<1000)
           dr.Year+=1900;
          pp=strtok(NULL,"-/");
          dr.Month=atoi(pp);
          pp=strtok(NULL,"-/");
          dr.Day=atoi(pp);
          ahat=dr;

          cprintf("Will count only letters written after %s\r\n",ahat.GetDateString());
         }
        //...
       }

      if (toupper(argv[c][1])=='B' && toupper(argv[c][1])=='W')
       {
        bw_mode=1;
        cprintf("BlueWave mode on\r\n");
       }

      if (toupper(argv[c][1])=='C')
       {
        countit=1;
        cprintf("Count-it mode on\r\n");
        napon=(snapon far *)farcalloc(4000,sizeof(snapon)); // 32k

        cprintf("Opening date data files...\r\n");

        fnsplit(argv[1],drive,dir,file,ext);

        strcpy(buf,basepath);
        strcat(buf,file);
        strcpy(buf2,buf);
        strcat(buf,".QS1");
        strcat(buf2,".QS2");
        cof1=open(buf,O_BINARY|O_RDWR|O_CREAT,S_IREAD|S_IWRITE);
        cof2=open(buf2,O_BINARY|O_RDWR|O_CREAT,S_IREAD|S_IWRITE);

        if (cof1==-1 || cof2==-1)
         {
          cprintf("ERROR opening date files (%s/%s) !\r\n",buf,buf2);
          tempclean();
          exit(1);
         }
        // itt kell check, hogy volt-e mar

        cprintf("Reading date datas...");
        _dos_read(cof1,napon,filelength(cof1),&yy);
        sncnt=filelength(cof1)/sizeof(napon[0]);


        f=filelength(cof2)/sizeof(swpak);
        cprintf("%d dates logged already, %d QWK-s processed so far.\r\n",sncnt,f);

        g=open(argv[1],O_RDONLY|O_BINARY);
        wpak.size=filelength(g);
        getftime(g,&wpak.date);
        close(g);

        memset(wpak.ext,0,4);
        memcpy(wpak.ext,&ext[1],4);

        // we will need wpak at the end!

        if (argv[c][2]=='!')
         {
          voltqwkc=1;
          cprintf("Date mode on, but I will NOT count any dates (again)...\r\n");
          cfrom=-2;
          cto=-2;
         }
        else
         {
          swpak far *qwx=(swpak far *)farmalloc(f*sizeof(swpak)+1);
          _dos_read(cof2,qwx,f*sizeof(swpak),&yy);
          for (d=0;d<f;d++)
           if (_fmemcmp(&wpak,&qwx[d],/*sizeof(swpak)*/4/* mert rezip/date err*/)==0)
            {
             voltqwkc=1;
             cprintf("Warning!!! This packet has probably been counted already!\r\n");
             cprintf("Do you want to count it again? [y/N]\r\n");
             //if (quit_at_once)

             kar=toupper(getch());
             if (kar=='Y')
              {
               cprintf("Ok. It was your choice...\r\n");
              }
             else
              {
               cfrom=-2; cto=-2;
               cprintf("Allright. I will NOT count any dates...\r\n");
              }
             break;
            }

          farfree(qwx);
         }

        if (argv[c][2]!='\0' && argv[c][2]!='!' && cfrom!=-2)
         {
          strcpy(buf,&argv[c][2]);
          pp=strtok(buf,"-");
          cfrom=atoi(pp);
          pp=strtok(NULL,"-");
          cto=atoi(pp);

          cprintf("Will count dates for conference #%d-%d\r\n",cfrom,cto);
         }
       }
     }
   }

 //if (bw_mode)
 // obwqwk *qx=new obwqwk();
 //else
 // oqwk *qx=new oqwk();

 int first_q=1;

 struct ffblk fxblk;
 int done;
 char xdrive[MAXDRIVE];
 char xdir[MAXDIR];
 char xfile[MAXFILE];
 char xext[MAXEXT];
 int xflags;
 xflags=fnsplit(argv[1],xdrive,xdir,xfile,xext);
 done = findfirst(argv[1],&fxblk,0);

 long d1,d2;

 while (!done)
  {
   d1=coreleft();
   d2=farcoreleft();
   //printf("Cores: %ld %ld\n",d1,d2);
   if (!first_q)
    qx->removetmp();

   strcpy(buf,xdrive);
   strcat(buf,xdir);
   strcat(buf,fxblk.ff_name);
   //printf("Buf:%s \n",buf);
   qx->setname(buf);
   //if (stricmp(fxblk.ff_name,"CTCBBS.320")==0)
    //printf("Itt!");

   qx->extract();
   textcolor(LIGHTGRAY);
   confnum=qx->num_confs();
   for (cc=0;cc<=confnum;cc++) // elvileg < kellene, hogy jo legyen...
    {
     if (qx->nextconf()!=-1)
      process_conf();
    }
   first_q=0;
   done = findnext(&fxblk);
  }

 int max4;
 hmax=0;
 //int sum=n;
 for (c=0;c<24;c++)
  {
   if (pers[c]>hmax)
    hmax=pers[c];
  }

 int hh;

 if (!quit_at_once)
  do
   {
    hh=gmenu();
    if (hmax==0 && (1<=hh && hh<=7))
     {
      cprintf("Sorry, but due to date/area filters, no letters were left\r\n"
              "to be counted. Press any key...");
      getch();
      cprintf("\r\n");
      hh=255;
     }

    switch (hh)
     {
      case 1:dispgraf24();
            break;
      case 2:compgraf24();
            break;
      case 3:hour6eval();
            break;
      case 4:writemax();
            break;
      case 5:writemaxsubj();
            break;
      case 6:writemaxreceive();
            break;
      case 7:dispgrafday();
            break;
      case 8:cprintf("\r\nSubject ->");
             gets(buf);
             gethist(buf);
            break;
      case 9:cprintf("\r\nHistory for ->");
             gets(buf);
             gethistname(buf);
            break;
      case 10:if (countit)
               ondaydisp();
              else
               {
                cprintf("Sorry, but QWK/date mode is not activated (look at option /C)\r\n");
                cprintf("Press any key...");
                getch();
                cprintf("\r\n");
               }
             break;
     }
   }
  while (hh!=-1);

 /*
 textcolor(LIGHTGRAY);
 xcprintf("Press any key to display graph...");
 textcolor(LIGHTGRAY);
 getch();
 printf("\r");
 */



 /*
 textcolor(LIGHTGRAY);
 xcprintf("Press any key to display second graph...");
 textcolor(LIGHTGRAY);
 getch();
 printf("\r");
 */

 if (countit) // test!
  {
   lseek(cof1,0,SEEK_SET);
   _dos_write(cof1,napon,sizeof(napon[0])*sncnt,&yy);

   memset(ext,0,4);
   //fnsplit(argv[1],drive,dir,file,ext);
   lseek(cof2,0,SEEK_END);
   if (!voltqwkc)
    write(cof2,&wpak,sizeof(swpak));
  }

 if (napon)
  farfree(napon);

 tempclean();
 fclose(tof);
 cprintf("\r\n");
}

/* MSBINToIEEE - Converts an MSBIN floating point number */
/*               to IEEE floating point format           */
/*                                                       */
/*  Input: f - floating point number in MSBIN format     */
/* Output: Same number in IEEE format                    */

union Converter
 {
  unsigned char uc[10];
  unsigned int  ui[5];
  unsigned long ul[2];
  float          f[2];
  double         d[1];
 };

float MSBINToIEEE(float f)
{
   union Converter t;
   int sign, exp;       /* sign and exponent */

   t.f[0] = f;

/* extract the sign & move exponent bias from 0x81 to 0x7f */

   sign = t.uc[2] / 0x80;
   exp  = (t.uc[3] - 0x81 + 0x7f) & 0xff;

/* reassemble them in IEEE 4 byte real number format */

   t.ui[1] = (t.ui[1] & 0x7f) | (exp << 7) | (sign << 15);
   return t.f[0];
} /* End of MSBINToIEEE */



char *cropn( char *str)
{
 if (!str)
  return(str);
 if (str[strlen(str)-1]=='\n')
  str[strlen(str)-1]=0;
 return (str);
}

void headdisp( FILE *ct )
{
 char buf[260];
 char *p;

 textcolor(WHITE);
 xcprintf("\r\n");
 //fprintf(fo,"\r\n");

 fgets(buf,255,ct); cropn(buf);
 xaprintf(-1,LIGHTRED,"BBS name     : ~%s ~\r\n",buf);
 strncpy(qwbbs,buf,80);
 qwbbs[80]='\0';

 fgets(buf,255,ct); cropn(buf);
 xaprintf(-1,LIGHTGREEN,"City & state : ~%s ~\r\n",buf);

 fgets(buf,255,ct); cropn(buf);
 xaprintf(-1,LIGHTGREEN,"Phone number : ~%s ~\r\n",buf);

 fgets(buf,255,ct); cropn(buf);
 xaprintf(-1,LIGHTGREEN,"Sysop        : ~%s ~\r\n",buf);

 fgets(buf,255,ct);
 fgets(buf,255,ct); cropn(buf);
 xaprintf(-1,LIGHTGREEN,"Time & date  : ~%s ~\r\n",buf);
 strcpy(qwdate,strtok(buf,", "));
 strcpy(qwtime,strtok(NULL,", "));

 fgets(buf,255,ct); cropn(buf);
 xaprintf(-1,LIGHTCYAN,"User name    : ~%s ~\r\n",buf);

 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 xcprintf("\r\n");
}

int sendercmp( const void *a, const void *b)
{
 if ( (((ssd *)a)->sum) < (((ssd *)b)->sum) )
  return 1;

 if ( (((ssd *)a)->sum) > (((ssd *)b)->sum) )
  return -1;

 return( strcmp( ((ssd *)a)->name , ((ssd *)b)->name ));
}

int napokcmp( const void *a, const void *b)
{
 if ( (((snapon *)a)->jul) < (((snapon *)b)->jul) )
  return 1;

 if ( (((snapon *)a)->jul) > (((snapon *)b)->jul) )
  return -1;

 return( 0 ); // should not occur
}


void addtoday( unsigned long jul, int num )
{
 int c;
 for (c=0; c<sncnt; c++)
  if (napon[c].jul==jul)
   {
    napon[c].num+=num;
    return;
   }
 c=sncnt++;       // init
 napon[c].num=num;
 napon[c].jul=jul;
}


int process_conf( void )
{
 int num;
 char *cname;
 int f;
 int pos;
 char buf[50];
 float ff;
 long li;
 int a,c,xx;
 DateRec dr;
 Date *da;
 unsigned long jul;
 int countit_itt=0;

 num=qx->getcnum();
 cname=qx->getcname();

 if (countit && (cfrom!=-2))
  if ((cfrom==-1)||(num>=cfrom && num<=cto))
   countit_itt=1;

 aprintf(-1,GREEN,"Processing conference #~%d~ [~%s~]...%n",num,cname,&pos);
 pos-=3;
 strcpy(qwarea,cname);
 long ffl;
 int y,m,d;

 while (!qx->lastmsg())
  {
   qx->nextmsg(&mh);

   //---
   strcpy(buf,cutss(mh.date,8));
   m=atoi(strtok(buf,"-"));
   d=atoi(strtok(NULL,"-"));
   y=atoi(strtok(NULL,"-"));

   dr.Year = y;
   dr.Month = m;
   dr.Day = d;
   if (dr.Year<1000)
    dr.Year+=1900;
   da = new Date(dr);
   jul=da->GetJulDay();

   if (ahat>(*da)) // ha az also datamuhatarnal kisebb
    continue;

   if (countit_itt)
    addtoday(jul,1);

   delete(da);
   //---

   strncpy(buf,mh.time,2);
   buf[2]='\0';
   a=atoi(buf);
   if (0<=a && a<=23)
    pers[a]++;

   if (tof)
    rogzitdata(&mh);

   //if (sum%10==0)
   // {
     gotoxy(pos,wherey());
     clreol();
     cprintf("#%d",sum);
     clreol();
   // }


   days[dayofweek(y,m,d)]++;

   strncpy(buf,mh.from,25); buf[25]='\0';
   cropen(buf);
   xx=0;
   for (c=1;c<=sdcnt;c++)
    if (strcmpi(buf,sd[c].name)==0)
     {
      sd[c].sum++;
      xx=1;
     }
   if (!xx)
    {
     c=++sdcnt;
     sd[c].name=(char *)malloc(strlen(buf)+1);
     strcpy(sd[c].name,buf);
     sd[c].sum=1;
    }

   strcpy(buf,cutss(mh.subject,25));
   stripre(buf);
   cropen(buf);
   xx=0;
   for (c=1;c<=subjcnt;c++)
    if (strcmpi(buf,subj[c].name)==0)
     {
      subj[c].sum++;
      xx=1;
     }
   if (!xx)
    {
     c=++subjcnt;
     subj[c].name=(char *)malloc(strlen(buf)+1);
     strcpy(subj[c].name,buf);
     subj[c].sum=1;
    }

   strncpy(buf,mh.to,25); buf[25]='\0';
   cropen(buf);
   xx=0;
   for (c=1;c<=rdcnt;c++)
    if (strcmpi(buf,rd[c].name)==0)
     {
      rd[c].sum++;
      xx=1;
     }
   if (!xx)
    {
     c=++rdcnt;
     rd[c].name=(char *)malloc(strlen(buf)+1);
     strcpy(rd[c].name,buf);
     rd[c].sum=1;
    }

   if (sdcnt>799)
    {
     cprintf("Error: this program currently supports only <800 people");
     exit(1);
    }

   if (rdcnt>799)
    {
     cprintf("Error: this program currently supports only <800 people");
     exit(1);
    }

   if (subjcnt>3499)
    {
     cprintf("Error: this program currently supports only <3500 subjects");
     exit(1);
    }

   if (coreleft() < 1000)
    {
     cprintf("Near mem is below 1000 bytes -> packet too big !\n");
     exit(1);
    }
  }
 gotoxy(pos,wherey());
 cprintf("Done   \r\n");
 close(f);
 return 0 ;
}

void dispgraf24(void)
{
 int c,d;
 xcprintf("Write Graph :\r\n");
 xcprintf("---------------------------------------------------------------------------\r\n");
 for(c=0;c<24;c++)
  {
   textcolor(chour[c]);
   xcprintf("%02d-%02dh ",c,(c==23)?0:(c+1));
   xaprintf(-1,LIGHTGRAY,"%3d,%3d%% ~:~",pers[c],(pers[c]*100L)/sum);

   d=((pers[c]*100L)/hmax);
   textcolor(BLUE);
   if (d>10) textcolor(LIGHTBLUE);
   if (d>25) textcolor(GREEN);
   if (d>50) textcolor(LIGHTGREEN);
   if (d>80) textcolor(YELLOW);
   for (d=0;d<((pers[c]*60)/hmax);d++)
    xcprintf("*");
   xcprintf("\r\n");
  }
 textcolor(LIGHTGRAY);
 cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}

void dispgrafday(void)
{
 int c,d;
 int hmaxdays=0;

 for (c=0;c<7;c++)
  if (hmaxdays<days[c])
   hmaxdays=days[c];

 xcprintf("Write Graph (day) :\r\n");
 //xcprintf("---------------------------------------------------------------------------\r\n");
 xcprintf("\r\n");
 for(c=0;c<7;c++)
  {
   textcolor(WHITE);
   xcprintf("%-9s ",dayname[c]);
   xaprintf(-1,LIGHTGRAY,"%3d,%3d%% ~:~",days[c],(days[c]*100L)/sum);

   //d=((days[c]*100)/hmax);
   textcolor(RED);
   for (d=0;d<((days[c]*59L)/hmaxdays);d++)
    xcprintf("*");
   xcprintf("\r\n");
  }
 textcolor(LIGHTGRAY);
 cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}


void compgraf24(void)
{
 int c,d;
 int e1,e2;
 int kar;
 xcprintf("Compressed Write Graph :\r\n");
 xcprintf("---------------------------------------------------------------------------\r\n");
 for(c=0;c<24;c+=2)
  {
   textcolor(chour[c]);
   xcprintf("%02d-%02dh : ",c,(c>=22)?0:(c+2));

   e1=((pers[c]*70)/hmax);
   e2=((pers[c+1]*70)/hmax);

   textattr(LIGHTGREEN+GREEN*16);
   for (d=0;d<min(e1,e2);d++)
    {
     putch('');
     if (gof)
      fputc('',gof);
    }

   if (e1>e2)
     { kar=''; textattr(LIGHTGREEN); }
    else
     { kar=''; textattr(GREEN); }

   if (e1!=e2)
    for (d=min(e1,e2);d<max(e1,e2);d++)
     xputch(kar);

   textbackground(BLACK);
   xcprintf("\r\n");
  }
 textcolor(LIGHTGRAY);
 cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}

void rogzitdata( msg_header *mh )
{
 if (!tof)
  return;

 char ss[256];

 strcpy(ss,optemp);
 sreplace(ss,"[QWK-FILE]",qwfname);
 sreplace(ss,"[QWK-BBS]",qwbbs);
 sreplace(ss,"[QWK-DATE]",qwdate);
 sreplace(ss,"[QWK-TIME]",qwtime);
 sreplace(ss,"[QWK-AREA]",qwarea);
 sreplace(ss,"[MSG-NUM]",cropen(cutss(mh->msgnum,7)));
 sreplace(ss,"[MSG-FROM]",cropen(cutss(mh->from,25)));
 sreplace(ss,"[MSG-TO]",cropen(cutss(mh->to,25)));
 sreplace(ss,"[MSG-SUBJECT]",cropen(cutss(mh->subject,25)));
 sreplace(ss,"[MSG-DATE]",cropen(cutss(mh->date,8)));
 sreplace(ss,"[MSG-TIME]",cropen(cutss(mh->time,5)));
 if (mh->status=='*')
  sreplace(ss,"[MSG-PRIVATE]","Y");
 else
  sreplace(ss,"[MSG-PRIVATE]","N");

 fprintf(tof,ss);
 fprintf(tof,"\n");
}

char *cropen( char *str) // max:255 chars
{
 if (!str)
  return(str);

 char st2[255];
 char *s2;

 int c;
 while (str[strlen(str)-1]=='\n')
  str[strlen(str)-1]=0;

 while (str[strlen(str)-1]==' ')
  str[strlen(str)-1]=0;

 for (c=0;c<strlen(str);c++)
  {
   if (str[c]==',')
    str[c]=' ';
   if (str[c]=='"'&&(use_quotes))
    str[c]=' ';
  }

 s2=str;
 while (*s2==' '|| *s2=='\t')
  s2++;

 strcpy(st2,s2);   //ez kell!
 strcpy(str,st2); //

 return(str);
}

char *cutss(char *ss,int len)
{
 static char rets[100];

 strncpy(rets,ss,len);
 rets[len]='\0';

 return(rets);
}

int sreplace( char *inw,  char *tok, char *st)
{
 char *p;
 char buf[255];
 p=strstr(inw,tok);
 if (!p)
  return -1;
 *p='\0';
 p+=strlen(tok);
 strcpy(buf,p);
 strcat(inw,st);
 strcat(inw,buf);
 return 0;
}

int setqwn( char *arg1 )
{
 char drive[MAXDRIVE];
 char dir[MAXDIR];
 char file[MAXFILE];
 char ext[MAXEXT];

 char cfn[MAXPATH];
 FILE *f;

 fnsplit(arg1,drive,dir,file,ext);
 strcpy(qwfname,file);
 strcat(qwfname,ext);
}


int loadcfg( char *arg0 )
{
 char drive[MAXDRIVE];
 char dir[MAXDIR];
 char file[MAXFILE];
 char ext[MAXEXT];

 char cfn[MAXPATH];
 FILE *f;

 fnsplit(arg0,drive,dir,file,ext);
 //strcpy(qwfname,file);
 //strcat(qwfname,ext);
 strcpy(cfn,drive);
 strcat(cfn,dir);

 strcpy(basepath,cfn);

 strcat(cfn,"QWKSTAT.CFG");

 if ((f=fopen(cfn,"rt"))==NULL)
  return(-1);

 int xx=0;
 int cline=0;
 char sor[256];
 char *s2;

 while (!feof(f))
  {
   sor[0]='\0';
   fgets(sor,255,f);
   cline++;

   s2=sorfeld(sor);

   if (*s2=='\0')
    continue;

   switch (xx)
    {
     case 0:// 1st: Archiver
            strcpy(arch,sor);
           break;

     case 1:// 2nd: Output list-line format
            strcpy(optemp,sor);
           break;

     case 2:// 3rd: Use quotes
            strupr(sor);
            if (strstr(sor,"YES"))
             use_quotes=1;
           break;
    }
   xx++;
  }


 fclose(f);
 return 0;
}

char *sorfeld( char *sor )
{
 char *s,*s2;

 s=&sor[strlen(sor)-1];
 if (*s=='\n') { *s=0; s--; }

 //if ((s2=strchr(sor,';'))!=NULL)  // was taken out,
 // *s2='\0';             // here, something after ';' might be useful!

 s=&sor[strlen(sor)-1];
 while (*s==' ' || *s=='\t')
  { *s=0; s--; }

 s2=sor;
 while (*s2==' '|| *s2=='\t')
  s2++;

 if (sor[0]==';')
  strcpy(s2,"");

 return(s2);
}

void gsetarch( void )
{
 char buf[MAXPATH];
 char buf2[MAXPATH];
 char *p;

 p=strtok(arch," ");
 strcpy(buf,p);
 strcpy(buf2," ");
 p=strtok(NULL,"\n");
 strcat(buf2,p);

 struct ffblk ffblk;
 if (findfirst(buf,&ffblk,0)==0)
  {
   strcpy(arch,buf);
   strcat(arch,buf2);
   return;
  }

 p=searchpath(buf);
 if (!p)
  {
   cprintf("ERROR: Archiver specified in config file not found !\r\n");
   exit(1);
  }
 strcpy(arch,p);
 strcpy(archexe,p);
 strcat(arch,buf2);
}

int execute( char *fname, char *cline) // this will 'destroy' cline!
{
 char *tt[41];
 int c;

 if (tt[0]=strtok(cline," "))
  for (c=1;c<40;c++)
   if ((tt[c]=strtok(NULL," "))==NULL)
    break;

 return(spawnv(P_WAIT,fname,tt));
}

void delfiles( char *which )
{
 struct ffblk ffblk;

 int done;
 done = findfirst(which,&ffblk,0);
 while (!done)
 {
    unlink(ffblk.ff_name);
    done = findnext(&ffblk);
 }
}

void hour6eval( void )
{
 int c,d;
 int s1=0,s2=0;
 int s1max=0;
 xcprintf("6-hour Write Graph :\r\n");
 xcprintf("---------------------------------------------------------------------------\r\n");
 for (c=1;c<=24;c++)
  {
   s1+=pers[c-1];

   if (c%6==0)
    {
     if (s1max<s1) s1max=s1;
     s1=0;
    }
  }

 s1=0;
 for (c=1;c<=24;c++)
  {
   //d=(c+6)%24;
   s1+=pers[c-1];

   if (c%6==0)
     {
      textcolor(chour[s2]);
      xcprintf("%02d-%02dh ",s2,c);
      xcprintf("%4d,%3d%% :",s1,(long(s1)*100)/sum);

      for (d=0;d<(((long)s1*60)/s1max);d++)
       xcprintf("*");
      xcprintf("\r\n");
      s1=0;
      s2=c;
     }
  }
 textcolor(LIGHTGRAY);
 xcprintf("---------------------------------------------------------------------------\r\n");
 //textcolor(BLUE);
 xaprintf(LIGHTBLUE,GREEN,"Total: ~%d~ messages\r\n",sum);

 textcolor(LIGHTGRAY);
 cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}

void writemax( void )
{
 maxsnum=0;
 int c,d;
 for (c=1;c<=sdcnt;c++)
  if (maxsnum<sd[c].sum)
   maxsnum=sd[c].sum;

 qsort(&sd[1],sdcnt,sizeof(sd[0]),sendercmp);

 textcolor(LIGHTGRAY);
 xcprintf("Top mail senders (in descending order):\r\n");
 for (c=1;c<=sdcnt;c++)
  {
   if (c%24==17)
    {
     textcolor(LIGHTGRAY);
     cprintf("Press any key to continue...");
     getch();
     cprintf("\r");
     clreol();
    }

   textcolor((c%2)?LIGHTGREEN:GREEN);
   xcprintf("%-25s %3d  %2d%% : ",sd[c].name,sd[c].sum,(sd[c].sum*100L)/sum);
   for (d=0;d<((sd[c].sum*40)/maxsnum);d++)
    xcprintf("*");
   xcprintf("\r\n");
  }
 textcolor(LIGHTGRAY);
 xcprintf("[Total: %d people]      ",sdcnt);
 cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}

void writemaxsubj( void )
{
 maxsnum=0;
 int c,d;
 for (c=1;c<=subjcnt;c++)
  if (maxsnum<subj[c].sum)
   maxsnum=subj[c].sum;

 qsort(&subj[1],subjcnt,sizeof(subj[0]),sendercmp);

 textcolor(LIGHTGRAY);
 xcprintf("Top subjects (in descending order):\r\n");
 for (c=1;c<=subjcnt;c++)
  {
   if (c%24==17)
    {
     textcolor(LIGHTGRAY);
     cprintf("Press any key to continue...");
     getch();
     cprintf("\r");
     clreol();
    }

   textcolor((c%2)?LIGHTGREEN:GREEN);
   xcprintf("%-25s %3d  %2d%% : ",subj[c].name,subj[c].sum,(subj[c].sum*100L)/sum);
   for (d=0;d<((subj[c].sum*40)/maxsnum);d++)
    xcprintf("*");
   xcprintf("\r\n");
  }
 textcolor(LIGHTGRAY);
 xcprintf("[Total: %d subjects]      ",subjcnt);
 cprintf("Press any key...");
 //cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}

void writemaxreceive( void )
{
 maxsnum=0;
 int c,d;
 for (c=1;c<=rdcnt;c++)
  if (maxsnum<rd[c].sum)
   maxsnum=rd[c].sum;

 qsort(&rd[1],rdcnt,sizeof(rd[0]),sendercmp);

 textcolor(LIGHTGRAY);
 xcprintf("Top receivers (in descending order):\r\n");
 for (c=1;c<=rdcnt;c++)
  {
   if (c%24==17)
    {
     textcolor(LIGHTGRAY);
     cprintf("Press any key to continue...");
     getch();
     cprintf("\r");
     clreol();
    }

   textcolor((c%2)?LIGHTGREEN:GREEN);
   xcprintf("%-25s %3d  %2d%% : ",rd[c].name,rd[c].sum,(rd[c].sum*100L)/sum);
   for (d=0;d<((rd[c].sum*40)/maxsnum);d++)
    xcprintf("*");
   xcprintf("\r\n");
  }
 textcolor(LIGHTGRAY);
 xcprintf("[Total: %d people]      ",rdcnt);
 cprintf("Press any key...",rdcnt);
 //cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}


int gmenu ( void )
{
 int kar;

 if (gof)
  aprintf(WHITE,LIGHTGREEN,"\r\n~Logging is on.\r\n");
 aprintf(WHITE,GREEN,
         "Ŀ\r\n"
         " ~1~ - Write graph                        \r\n"
         " ~2~ - Write compressed graph             \r\n"
         " ~3~ - Display 6-hour splitted info       \r\n"
         " ~4~ - Who wrote the most letters         \r\n"
         " ~5~ - Most popular subjects              \r\n"
         " ~6~ - Top letter receivers               \r\n"
         " ~7~ - Write graph (day)                  \r\n"
         " ~8~ - History of a subject               \r\n"
         " ~9~ - History of a somebody              \r\n"
         " ~A~ - Number written on each day*        \r\n"
         " ~ESC~ - quit                             \r\n"
         "\r\n");
 textcolor(LIGHTGRAY);

 do
  {
   kar=toupper(getch());
  }
 while (!( (('1'<=kar)&&(kar<='9')) || (('A'<=kar)&&(kar<='A')) || (kar==27) ));

 if (kar==27)
  return -1;

 if (('A'<=kar)&&(kar<='Z'))
  return(kar-'A'+10);

 return(kar-'0');
}

char *stripre( char *st )
{
 char *p;
 char ss[100];
 p=st+3;
 if (strncmpi(st,"Re:",3)!=0)
  return(st);

 strcpy(ss,p);
 strcpy(st,ss); // must 'cropen' after, to remove spaces
 return(st);
}

#define frac(x)  ((x)-int(x))

int dayofweek( int ev, int honap, int nap ) // Sunday(0)--> Saturday(6)
{
 /*
 // CHECK IT! it might be wrong !!!!!!!

 float ujev,ujhonap,ujnap,napx;
 float julnap;

 if ((honap==1) || (honap==2))
  ujev=ev-1;

 if (honap>2)
  ujev=ev;

 if ((honap=1) || (honap=2))
  ujhonap=honap+13;

 if (honap>2)
  ujhonap=honap+1;

 julnap=int(365.25*ujev)+int(30.6001*ujhonap)+nap;

 ujnap=julnap;
 ujev=int((ujnap-122.1)/365.25);
 ujhonap=int((ujnap-(365.25*ujev))/30.6001);
 napx=ujnap-int(3645.25*ujev)-int(30.6001*ujhonap);

 float xx;
 long z;
 xx=(7*frac((ujnap+5)/7));
 z=xx;
 if (xx-int(xx)>=0.5)
  z++;

 z=(z+7-3)%7;
 return(z);
 */

 struct dosdate_t d1,d;
 _dos_getdate(&d1);

 d.year=(ev>80)?1900+ev:2000+ev; d.month=honap; d.day=nap;
 _dos_setdate(&d);
 _dos_getdate(&d);

 _dos_setdate(&d1);
 return(d.dayofweek);
}

void xaprintf( int nattr, int attr2 , char *mit, ... )
{
 char krt[500]; // jobb lenne feldinamikusan...!!!
 va_list ap;

 if (!mit) return;

 va_start( ap,mit );
 vsprintf( krt, mit , ap );
 va_end( ap );



 char *p,*q;
 int cl=0;

 if (nattr==-1)
  {
   struct text_info ti;
   gettextinfo(&ti);
   nattr = ti.attribute;
  }

 // m_hide();
 textattr( nattr );
 for ( q=p=krt ; *p ; q++,p++ )
  {
   if ( *p == '~' )
    {
     if (*(p+1) == '~' )
      {
       putch(*p);
       *q=*p;
       p++;
      }
     else
      {
       cl=(cl==0) ? 1:0;
       textattr( (cl==0)? nattr : attr2 );
       q--;
      }
    }
   else
    {
     putch(*p);
     *q=*p;
    }
  }
 *q='\0';

 if (gof)
  {
   for ( q=p=krt ; *p ; q++,p++ )
    {
     if (*p=='\r')
       p++;
     *q=*p;
    }

   *q='\0';
   fputs(krt,gof);
  }

 textattr(nattr);
}

void xcprintf( char *mit, ... )
{
 char krt[500]; // jobb lenne feldinamikusan...!!!
 va_list ap;

 if (!mit) return;
 char *p,*q;

 va_start( ap,mit );
 vsprintf( krt, mit , ap );
 va_end( ap );

 cputs(krt);

 if (gof)
  {
   for ( q=p=krt ; *p ; q++,p++ )
    {
     if (*p=='\r')
       p++;
     *q=*p;
    }

   *q='\0';
   fputs(krt,gof);
  }
}

int xputch( int ch )
{
 putch(ch);
 if (gof)
  putc(ch,gof);
}

void gethist( char *ezsubj )
{
 cropen(ezsubj);
 if (ezsubj[0]==0)
  return;

 int g;
 if ((g=open("TEMPDIR.QWK\\MESSAGES.DAT",O_RDONLY|O_BINARY))==-1)
  {
   cprintf("Error: Could not open MESSAGES.DAT !");
   exit(1);
  }
 msgfile=g;

 if ((ct=fopen("TEMPDIR.QWK\\CONTROL.DAT","rt"))==NULL)
  {
   cprintf("Error: Could not open CONTROL.DAT !");
   exit(1);
  }

 xcprintf("\r\n");

 char buf[256];

 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);

 textcolor(LIGHTGRAY);

 int cc,num;

 int confnum;
 char cname[40];

 char from[25];
 char to[25];
 char time[4+1+1];
 char date[6+2+1];
 char msgnum[8];

 fgets(buf,255,ct);
 confnum=atoi(buf)+1;
 int pos,xx=0;

 xaprintf(-1,YELLOW,"History of subject '~%s~' :\r\n",ezsubj);
 xcprintf("%-25s %-25s - %-8s %-6s\r\n","From","To","Date","Time");
 xcprintf("\r\n");

 for (cc=0;cc<=confnum;cc++)
  {
   fgets(buf,255,ct);
   num=atoi(buf);
   fgets(cname,39,ct);
   if (cname[strlen(cname)-1]=='\n')  cname[strlen(cname)-1]=0;

   int f;
   int pos;
   char buf[50];
   float ff;
   long li;
   int a,c,xx;
   int sr=0;

   sprintf(buf,"TEMPDIR.QWK\\%03d.NDX",num);

   f=open(buf,O_RDONLY|O_BINARY);
   if (f==-1)
    continue;
   aprintf(-1,GREEN,"Processing conference #~%d~ [~%s~]...%n",num,cname,&pos);
   pos-=3;
   strcpy(qwarea,cname);
   long ffl;
   int y,m,d;

   while (!eof(f))
    {
     read(f,&sx,sizeof(sx));
     ff = MSBINToIEEE(sx.mh);

     sum++;
     ffl=ff;
     ffl-=1;

     li=ffl*128;
     lseek(msgfile,li,SEEK_SET);

     read(msgfile,&mh,128);
     strcpy(buf,cutss(mh.subject,25));
     cropen(buf);
     stripre(buf);
     cropen(buf);

     if (stricmp(ezsubj,buf)==0)
      {
       gotoxy(1,wherey());
       clreol();

       strcpy(msgnum,cropen(cutss(mh.msgnum,7)));
       strcpy(from,cutss(mh.from,25));
       strcpy(to,cutss(mh.to,25));
       strcpy(date,cutss(mh.date,8));
       strcpy(time,cutss(mh.time,5));
       xcprintf("%s %s - %s %s (#%s)\r\n",from,to,date,time,msgnum);
       sr++;
       if (sr==20)
        {
         sr=0;
         textcolor(LIGHTGRAY);
         cprintf("Press any key to continue...");
         getch();
         cprintf("\r");
         clreol();
        }
      }

     gotoxy(pos,wherey());
     clreol();
     cprintf("#%d",sum);
     clreol();
    }
   //gotoxy(pos,wherey());
   gotoxy(1,wherey());
   clreol();
   //cprintf("Done   \r\n");
   close(f);
  }
 close(g);
 fclose(ct);
 textcolor(LIGHTGRAY);
 cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}


void gethistname( char *ezname )
{
 cropen(ezname);
 if (ezname[0]==0)
  return;

 int g;
 if ((g=open("TEMPDIR.QWK\\MESSAGES.DAT",O_RDONLY|O_BINARY))==-1)
  {
   cprintf("Error: Could not open MESSAGES.DAT !");
   exit(1);
  }
 msgfile=g;

 if ((ct=fopen("TEMPDIR.QWK\\CONTROL.DAT","rt"))==NULL)
  {
   cprintf("Error: Could not open CONTROL.DAT !");
   exit(1);
  }

 xcprintf("\r\n");

 char buf[256],b2[256];

 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);
 fgets(buf,255,ct);

 textcolor(LIGHTGRAY);

 int cc,num;

 int confnum;
 char cname[40];

 char from[25];
 char to[25];
 char time[4+1+1];
 char date[6+2+1];
 char msgnum[8];

 fgets(buf,255,ct);
 confnum=atoi(buf)+1;
 int pos,xx=0;

 xaprintf(-1,YELLOW,"History of ~%s~ :\r\n",ezname);
 xcprintf("%-25s %-25s - %-8s %-6s\r\n","From","To","Date","Time");
 xcprintf("\r\n");

 for (cc=0;cc<=confnum;cc++)
  {
   fgets(buf,255,ct);
   num=atoi(buf);
   fgets(cname,39,ct);
   if (cname[strlen(cname)-1]=='\n')  cname[strlen(cname)-1]=0;

   int f;
   int pos;
   char buf[50];
   float ff;
   long li;
   int a,c,xx;
   int sr=0;

   sprintf(buf,"TEMPDIR.QWK\\%03d.NDX",num);

   f=open(buf,O_RDONLY|O_BINARY);
   if (f==-1)
    continue;
   aprintf(-1,GREEN,"Processing conference #~%d~ [~%s~]...%n",num,cname,&pos);
   pos-=3;
   strcpy(qwarea,cname);
   long ffl;
   int y,m,d;

   while (!eof(f))
    {
     read(f,&sx,sizeof(sx));
     ff = MSBINToIEEE(sx.mh);

     sum++;
     ffl=ff;
     ffl-=1;

     li=ffl*128;
     lseek(msgfile,li,SEEK_SET);
     read(msgfile,&mh,128);

     strcpy(buf,cutss(mh.from,25));
     cropen(buf);
     stripre(buf);
     cropen(buf);

     strcpy(b2,cutss(mh.to,25));
     cropen(b2);
     stripre(b2);
     cropen(b2);

     if ((stricmp(ezname,buf)==0)||(stricmp(ezname,b2)==0))
      {
       gotoxy(1,wherey());
       clreol();

       strcpy(msgnum,cropen(cutss(mh.msgnum,7)));
       strcpy(from,cutss(mh.from,25));
       strcpy(to,cutss(mh.to,25));
       strcpy(date,cutss(mh.date,8));
       strcpy(time,cutss(mh.time,5));
       //textcolor(GREEN);
       if (stricmp(ezname,buf)==0)
        xaprintf(GREEN,LIGHTGREEN,"~%s~ %s - %s %s (#%s)\r\n",from,to,date,time,msgnum);
       else
        xaprintf(GREEN,LIGHTGREEN,"%s ~%s~ - %s %s (#%s)\r\n",from,to,date,time,msgnum);

       textcolor(LIGHTGRAY);
       sr++;
       if (sr==20)
        {
         sr=0;
         textcolor(LIGHTGRAY);
         cprintf("Press any key to continue...");
         getch();
         cprintf("\r");
         clreol();
        }
      }

     gotoxy(pos,wherey());
     clreol();
     cprintf("#%d",sum);
     clreol();
    }
   //gotoxy(pos,wherey());
   gotoxy(1,wherey());
   clreol();
   //cprintf("Done   \r\n");
   close(f);
  }
 close(g);
 fclose(ct);
 textcolor(LIGHTGRAY);
 cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}

void ondaydisp( void )
{
 int c,d,maxd=0;

 unsigned long cs;
 DateRec dr;
 Date *da;
 snapon sn;

 textcolor(LIGHTGRAY);
 xcprintf("Number of letters written on each day:\r\n");

 for (c=0;c<sncnt;c++)
  {
   for (d=c; d<sncnt; d++)
    if (napon[c].jul>napon[d].jul)    // bubble sort... sloooow
     {
      _fmemcpy(&sn,&napon[c],sizeof(snapon));
      _fmemcpy(&napon[c],&napon[d],sizeof(snapon));
      _fmemcpy(&napon[d],&sn,sizeof(snapon));
     }
   if (maxd<napon[c].num)
    maxd=napon[c].num;
  }

 for (c=0;c<sncnt;c++)
  {
   if (c%21==20)
    {
     textcolor(LIGHTGRAY);
     cprintf("Press any key to continue...");
     getch();
     cprintf("\r");
     clreol();
    }
   da = new Date(napon[c].jul);
   da->GetDate(dr);
   if (da->GetDayOfWeek()==0)
    textcolor(LIGHTMAGENTA);
   else
    textcolor(LIGHTRED);
   xcprintf("%02d.%02d.%02d :",dr.Year,dr.Month,dr.Day);
   textcolor(CYAN);
   xcprintf(" %3d ",napon[c].num);
   textcolor(GREEN);
   for (d=0;d<(((long)napon[c].num*60)/maxd);d++)
    xcprintf("*");
   xcprintf("\r\n");
   delete(da);
  }

 //qsort(&subj[1],subjcnt,sizeof(subj[0]),sendercmp);

 textcolor(LIGHTGRAY);
 xcprintf("[Total: %d days logged]      ",sncnt);
 cprintf("Press any key...");
 getch();
 xcprintf("\r\n");
}

void tempclean(void)
{
 cprintf("Removing temporary directory...");
 chdir("tempdir.qwk");
 delfiles("..\\TEMPDIR.QWK\\*.*");
 chdir("..");
 rmdir("tempdir.qwk");
}
