#include <dos.h>
#include <errno.h>
#include <io.h>
#include <ctype.h>
#include <stdlib.h>
#include <dir.h>
#include <sys\stat.h>
#include <stdio.h>
#include <string.h>
#include <process.h>

int port=-1; // 0-based!

////////////////////////////////////////////////////////////////////
void sendchar( char cc ) // send character
{
 if (port==-1)
  return;
 union REGS regs;

 regs.h.ah = 1;
 regs.x.dx = port;
 regs.h.al = cc;
 int86(0x14, &regs, &regs);
}

void send( char *s ) // send a string
{
 char *p;
 for ( p=s ; (*p)!='\0' ; p++ )
  sendchar(*p);
}

void activate(void) // init ?
{
 union REGS regs;

 regs.h.ah = 4;
 regs.x.dx = port;
 regs.x.bx = 0;
 int86(0x14, &regs, &regs);
}
//////////////////////////////////////////////////////////////////////


int sort_function( const void *a, const void *b);

int main (int argc, char *argv[] )
{
 //struct ffblk fb;
 //ftime ft;

 int done;
 char b2[260],b3[260];
 int c,d,x;
 FILE *of, *f;
 char *p;
 long ll;
 int debugit=0;
 int usebb3=0;
 char s_cnt[]="{000}";

 char fname[200];
 char path[200];

 if (argc>3)
  port=atoi(argv[3]);

 printf("[ NOSACheck v1.0 (C) 1994 by John Zer/NOSASOFT ]\n");
 send("[ NOSACheck v1.0 (C) 1994 by John Zer/NOSASOFT ]\n");

 if (argc<2)
  {
   printf(" Usage: NCHECK <filename> <path> <0-based port>\n");
   return 0;
  }

 strcpy(fname,argv[1]);
 strupr(fname);

 if (argc>2)
  strcpy(path,argv[2]);
 else
  getcwd(path,250);
 strupr(path);
 c=strlen(path);
 if (path[c-1]!='\\' && path[c-1]!=':')
  {
   path[c]='\\';
   path[c+1]='\0';
  }

 char drive[MAXDRIVE];
 char dir[MAXDIR];
 char file[MAXFILE];
 char ext[MAXEXT];
 int flags;

 //  ll=(((long)fb.ff_ftime) | ((long)fb.ff_fdate<<16));
 //  memcpy(&ft,&ll,sizeof(long));

 printf("Processing file: %s\n",fname);

 if (unlink("FILE_ID.DIZ")==-1)
  if (errno==EACCES)
   {
    chmod("FILE_ID.DIZ",S_IREAD|S_IWRITE);
    unlink("FILE_ID.DIZ");
   };


 struct ffblk ffblk;
 //int done;
 sprintf(b2,"%s%s",path,"FILES.BB2");
 done = findfirst(b2,&ffblk,0);
 if (!done)
  {
   sprintf(b2,"copy %s%s %s%s",path,"FILES.BB2",path,"FILES.BB3");
   system(b2);

   sprintf(b2,"del %s%s",path,"FILES.BB2");
   system(b2);
   usebb3=1;
  }

 /*
 strcpy(b2,path);
 strcat(b2,"FILES.BB2");
 if (unlink(b2)==-1)
  if (errno==EACCES)
   {
    chmod(b2,S_IREAD|S_IWRITE);
    unlink(b2);
   };
 */

 strcpy(b2,path);
 strcat(b2,fname);
 flags=fnsplit(b2,drive,dir,file,ext);

 int ex=0;
 printf("Extracting DIZ from archive...");
 send("Extracting DIZ from archive...");

 if ((flags & EXTENSION) && ((strcmp(ext,".EXE")==0)||(strcmp(ext,".COM")==0)||
      (strcmp(ext,".BAT")==0)))
  {
   printf("\nExecutable files can't be scanned for DIZs !\n");
   if (usebb3)
    {
     sprintf(b2,"copy %s%s %s%s",path,"FILES.BB3",path,"FILES.BB2");
     system(b2);
    }
   return 0;
  }

 if ((flags & EXTENSION) && (strcmp(ext,".ZIP")==0))
  {
   ex=1;
   strcpy(b2,path);
   strcat(b2,fname);
   p = getenv("COMSPEC");
   if (!debugit) // debug
    spawnl(P_WAIT,p,p,"/C","PKUNZIP.EXE",b2,"FILE_ID.DIZ"," >NUL",NULL);
   else
    spawnl(P_WAIT,p,p,"/C","PKUNZIP.EXE",b2,"FILE_ID.DIZ",NULL);
  }

 if ((flags & EXTENSION) && (strcmp(ext,".ARJ")==0)) // ARJ
  {
   ex=1;
   strcpy(b2,path);
   strcat(b2,fname);
   p = getenv("COMSPEC");
   if (!debugit) // debug
    spawnl(P_WAIT,p,p,"/C","ARJ.EXE e -y ",b2,"FILE_ID.DIZ"," >NUL",NULL);
   else
    spawnl(P_WAIT,p,p,"/C","ARJ.EXE e -y ",b2,"FILE_ID.DIZ",NULL);
  }

 if ((flags & EXTENSION) && (strcmp(ext,".UC2")==0))
  {
   ex=1;
   strcpy(b2,path);
   strcat(b2,fname);
   p = getenv("COMSPEC");
   if (!debugit) // debug
    spawnl(P_WAIT,p,p,"/C","UC.EXE x ",b2,"FILE_ID.DIZ"," >NUL",NULL);
   else
    spawnl(P_WAIT,p,p,"/C","UC.EXE x ",b2,"FILE_ID.DIZ",NULL);
  }

 if (!ex)
  {
   printf("\nFile is not an archive or is of an unknown format !\n");
   if (usebb3)
    {
     sprintf(b2,"copy %s%s %s%s",path,"FILES.BB3",path,"FILES.BB2");
     system(b2);
    }
   return 0;
  }

 //sprintf(b2,"%-12s ",fb.ff_name);
 //fputs(b2,of);

 of=NULL;
 x=0;
 if ((f=fopen("FILE_ID.DIZ","rt"))!=NULL)
  {
   //printf("FILE_ID.DIZ found !\n");
   printf("found !\n");
   send("found !\n");

   FILE *f1,*f2;

   strcpy(b3,path);
   if (!usebb3)
    strcat(b3,"FILES.BBS");
   else
    strcat(b3,"FILES.BB3");

   if ((f1=fopen(b3,"rt"))!=NULL)
    {
     strcpy(b3,path);
     strcat(b3,"FILES.BB2");

     if ((f2=fopen(b3,"wt"))==NULL)
      return 0;

     int fl=0;
     while (!feof(f1))
      {
       b2[0]=0;
       fgets(b2,250,f1);
       if (b2[0]=='\0' || b2[0]=='\n')
        continue;

       if (strstr(b2,fname)!=NULL)
        fl=1;

       if (fl)
        {
         if (fl==2)
          {
           strncpy(b3,b2,5);
           b3[7]='\0';
           if (strchr(b3,'>')==NULL)
            fl=0;
          }
         else
          fl=2;
        }

       if (!fl)
        fputs(b2,f2);
      }

     fclose(f1);
     fclose(f2);
    }

   strcpy(b3,path);
   strcat(b3,"FILES.BB2");
   if ((of=fopen(b3,"a+t"))==NULL)
    return 0;

   sprintf(b2,"%-12s %s\n",fname,s_cnt);
   fputs(b2,of);

   while (!feof(f))
    {
     b2[0]=0;
     fgets(b2,250,f);
     if (b2[strlen(b2)-1]=='\n')
      b2[strlen(b2)-1]=0;
     if (b2[0]==0)
      continue;
     b2[44]='\0'; // DIZ linelen used here!

     //if (x!=0)
     // {
     fputs(" >",of);
     // }
     //x++;
     strcat(b2,"\n");
     fputs(b2,of);
    }
   fclose(f);
   fclose(of);

   if ((of=fopen("D:\\NCHECK.DAT","wt"))==NULL)
    return 0;
   fputs(path,of);
   fclose(of);
   /*
   sprintf(b2,"copy %s%s %s%s",path,"FILES.BB2",path,"FILES.BBS");
   system(b2);

   sprintf(b2,"del %s%s",path,"FILES.BB2");
   system(b2);
   */
  }
 else
  {
   //printf("FILE_ID.DIZ not found :-(\n");
   printf("not found :-(\n");
   send("not found :-(\n");
   if (usebb3)
    {
     sprintf(b2,"copy %s%s %s%s",path,"FILES.BB3",path,"FILES.BB2");
     system(b2);
    }
  }

endx:

 if (usebb3)
  {
   sprintf(b2,"del %s%s",path,"FILES.BB3");
   system(b2);
  }

 //fclose(of);
 printf("[ Done processing. ]\n");
 return 0;
}

int sort_function( const void *a, const void *b)  // must sort, so ARJ<A01,A02
{
   return( strcmp(((ffblk *)a)->ff_name,((ffblk *)b)->ff_name) );
}

