#include <io.h>
#include <dos.h>
#include <stdio.h>
#include <fcntl.h>
#include <mem.h>

#pragma option -K // unsigned chars

/****************************
	  /\  |-\   |
	 |  | |_/   |
	 +--+ |\    |
	 |  | | \ \_/
*****************************/
struct arj_main_head
 {
  unsigned headerid; // header id (main and local file) = 0xEA60 or 60000U
  unsigned headsize; // basic header size (from 'first_hdr_size' thru 'comment' below)
		     // = first_hdr_size + strlen(filename) + 1 + strlen(comment) + 1
		     // = 0 if end of archive

  char first_hdr_size; // (size up to and including 'extra data')
  char version;        // archiver version number
  char minver;         // minimum archiver version to extract
  char host_OS;        // host OS   (0 = MSDOS, 1 = PRIMOS, 2 = UNIX, 3 = AMIGA, 4 = MAC-OS)
		       // (5 = OS/2, 6 = APPLE GS, 7 = ATARI ST, 8 = NEXT)
		       // (9 = VAX VMS)
  char arj_flags;   /* arj flags
		     (0x01 = NOT USED)
		     (0x02 = RESERVED)
		     (0x04 = VOLUME_FLAG)  indicates presence of succeeding
					   volume
		     (0x08 = NOT USED)
		     (0x10 = PATHSYM_FLAG) indicates archive name translated
					   ("\" changed to "/")
		     (0x20 = BACKUP_FLAG) indicates backup type archive
		    */
  char res1;           // reserved
  char file_type;      // file type (2 = comment header)
  char res2;           // reserved
  ftime created;       // date time when original archive was created
  char res3[4];        // (future use may be archive size starting at main header)
  char res4[4];        // reserved
  char res5[4];        // reserved
  char fspos[2];       // filespec position in filename
  char unused1[2];     // (currently not used)
  char unused2[2];     // (currently not used)
 };
      /***
       ?   (currently none)

       ?   filename of archive when created (null-terminated string)
       ?   archive comment  (null-terminated string)

       4   basic header CRC

       2   1st extended header size (0 if none)
       ?   1st extended header (currently not used)
       4   1st extended header's CRC (not present when 0 extended header size)
     ***/

struct arj_local_head
 {
  unsigned headerid; // header id (main and local file) = 0xEA60 or 60000U
  unsigned headsize;
                 /*
                 basic header size (from 'first_hdr_size' thru 'comment' below)
		 = first_hdr_size + strlen(filename) + 1 + strlen(comment) + 1
		 = 0 if end of archive
                 */
  char first_hdr_size; // (size up to and including 'extra data')
  char version;       // archiver version number
  char minver;        // minimum archiver version to extract
  char host_OS; /* host OS   (0 = MSDOS, 1 = PRIMOS, 2 = UNIX, 3 = AMIGA, 4 = MAC-OS)
		  (5 = OS/2, 6 = APPLE GS, 7 = ATARI ST, 8 = NEXT)
		  (9 = VAX VMS)
		*/
  char arj_flags; /*  (0x01 = GARBLED_FLAG) indicates passworded file
		     (0x02 = RESERVED)
		     (0x04 = VOLUME_FLAG)  indicates continued file to next
					   volume (file is split)
		     (0x08 = EXTFILE_FLAG) indicates file starting position
					   field (for split files)
		     (0x10 = PATHSYM_FLAG) indicates filename translated
					   ("\" changed to "/")
		     (0x20 = BACKUP_FLAG)  indicates file marked as backup
                  */
  char method; // (0 = stored, 1 = compressed most ... 4 compressed fastest)
  char file_type; // (0 = binary, 1 = 7-bit text)
		  // (3 = directory, 4 = volume label)
  char res1;      //   reserved
  ftime modified; //   date time modified
  unsigned long comp_size; // compressed size
  unsigned long orig_size; // original size (this will be different for text mode compression)
  unsigned origCRC;   // original file's CRC
  unsigned fspos;     //  filespec position in filename
  unsigned access_mode; // file access mode
  unsigned host_data;   // (currently not used)
 };
   /**
       ?   extra data
	   4 bytes for extended file starting position when used
	   (this is present when EXTFILE_FLAG is set)

       ?   filename (null-terminated string)
       ?   comment  (null-terminated string)

       4   basic header CRC

       2   1st extended header size (0 if none)
       ?   1st extended header (currently not used)
       4   1st extended header's CRC (not present when 0 extended header size)

       ...

       ?   compressed file
    **/
/*****************************************************/

void specmain( void );

void main(int argc, char* argv[] )
{
 int af,b,px,py;
 long fpos,mpos,afp;
 struct arj_main_head arjmainhd;
 struct arj_local_head arjhd;
 char buf[255];

 if (argc<=1)
  {
   printf("Usage: ........\n");
   return;
  }

 if (argc==3)
  specmain();

 if ((af=open(argv[1],O_BINARY|O_RDONLY))==-1)
  return;

 int c,d;
 mpos=filelength(af);

 read( af,&arjmainhd,sizeof(arjmainhd) );
 if (arjmainhd.headerid != 60000l)
  {
   lseek(af,0,SEEK_SET);
   printf("DATA file : %s \n",argv[1]);

   read(af,buf,250);

   printf("| ");
   for (c=0;c<20;c++)
    {
     d=buf[c];
     printf("%02hX ",d);
    }
   printf("|\n");

   printf("| ");
   for (c=0;c<20;c++)
    printf(" %c ",buf[c]);
   printf("|\n");

   return;
  }
 lseek( af,2+arjmainhd.headsize+2+6,SEEK_SET );
 fpos=tell(af);
 printf("ARJ file : %s \n",argv[1]);
 //px=wherex(); py=wherey();
 do
  {
   //buf[12]='\0';

   memset( buf,0,254 );
   read( af,&arjhd,sizeof(arjhd) );
   if (arjhd.headerid != 60000l)
    continue;
   if ( arjhd.headsize==0 )
    break;
   if (arjhd.arj_flags & 0x08)
    lseek( af , 4 , SEEK_CUR );
   lseek( af , 2 , SEEK_CUR );
   b=arjhd.headsize-sizeof(arjhd); //-(arjhd.arj_flags & 0x08)?4:0;
   //b-=2;
   if (arjhd.arj_flags & 0x08)
    b-=4;

   read( af,buf,b );

   afp=tell(af);

   lseek( af,(fpos + 2+arjhd.headsize+2+6/*+arjhd.comp_size*/)-afp,SEEK_CUR );
   fpos=tell(af);

   read(af,buf,250);

   printf("| ");
   for (c=0;c<20;c++)
    {
     d=buf[c];
     printf("%02hX ",d);
    }
   printf("|\n");

   printf("| ");
   for (c=0;c<20;c++)
    printf(" %c ",buf[c]);
   printf("|\n");

   break; //*****!!
  }
 while ( !eof(af) );

 close( af );

 return;
}


void specmain( void )
{
 int af,b,px,py;
 long fpos,mpos,afp;
 struct arj_main_head arjmainhd;
 struct arj_local_head arjhd;
 char buf[255];




 int c,d;
 mpos=filelength(af);

 read( af,&arjmainhd,sizeof(arjmainhd) );
 if (arjmainhd.headerid != 60000l)
  {
   lseek(af,0,SEEK_SET);
   printf("DATA file : %s \n",argv[1]);

   read(af,buf,250);

   printf("| ");
   for (c=0;c<20;c++)
    {
     d=buf[c];
     printf("%02hX ",d);
    }
   printf("|\n");

   printf("| ");
   for (c=0;c<20;c++)
    printf(" %c ",buf[c]);
   printf("|\n");

   return;
  }
 lseek( af,2+arjmainhd.headsize+2+6,SEEK_SET );
 fpos=tell(af);
 printf("ARJ file : %s \n",argv[1]);
 //px=wherex(); py=wherey();
 do
  {
   //buf[12]='\0';

   memset( buf,0,254 );
   read( af,&arjhd,sizeof(arjhd) );
   if (arjhd.headerid != 60000l)
    continue;
   if ( arjhd.headsize==0 )
    break;
   if (arjhd.arj_flags & 0x08)
    lseek( af , 4 , SEEK_CUR );
   lseek( af , 2 , SEEK_CUR );
   b=arjhd.headsize-sizeof(arjhd); //-(arjhd.arj_flags & 0x08)?4:0;
   //b-=2;
   if (arjhd.arj_flags & 0x08)
    b-=4;

   read( af,buf,b );

   afp=tell(af);

   lseek( af,(fpos + 2+arjhd.headsize+2+6/*+arjhd.comp_size*/)-afp,SEEK_CUR );
   fpos=tell(af);

   read(af,buf,250);

   printf("| ");
   for (c=0;c<20;c++)
    {
     d=buf[c];
     printf("%02hX ",d);
    }
   printf("|\n");

   printf("| ");
   for (c=0;c<20;c++)
    printf(" %c ",buf[c]);
   printf("|\n");

   break; //*****!!
  }
 while ( !eof(af) );

 close( af );

 exit(1);
}
