/* usetup.c */
/* Setup program az univerzlis makrohoz. (umacro.com)  */
/*            V1.1  05/13/91  Piny 			*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>

/* Hasznos tipusok: */
typedef unsigned char	byte;
typedef unsigned int	word;

/* Univerzlis makro vltozi: */
#pragma option -a-
struct {

/* Billentyk: */
  word keystart;
  word keyend;
  word keyrun;
/* Trolt kdok szma: */
  word buffersize;

} ctable;

#pragma option -a

/* Hanghatsok frekvencija: */
#define NORMAL	1200
#define SPECIAL	2400

/* Rvid spols. */
void beep(int freq){

  sound(freq);
  delay(50);
  nosound();
}


/* Kiterjesztett billentykd */
word getkey(void){

  _AH=0; geninterrupt(0x16); return(_AX);
}


/* Vltoztatsok: */
/* 1-et ad vissza, ha menteni kell, 0-t, ha nem. */
int menu(void){

  REDRAW:
  printf("\n\n*** Univerzlis makro setup ***\n"
	     "     V1.0  05/13/91  Piny\n\n"
	     "1 - Rgzts kezdete billenty\n"
	     "2 - Rgzts vge billenty\n"
	     "3 - Futtats kezdete billenty\n\n"
	     "4 - Trolt kdok szma\n\n"
             "M - Vltoztatsok elmentse\n"
	     "K - Kilps\n\n"
	     " Vlasszon: ");

  for (;;){
    switch(getche()){
      case 'M': case 'm': beep(NORMAL); return(1);
      case 'K': case 'k': beep(NORMAL); return(0);
      case '1':{
	beep(NORMAL);
	ctable.keystart=getkey(); beep(SPECIAL);
	break;
      }
      case '2':{
	beep(NORMAL);
	ctable.keyend=getkey(); beep(SPECIAL);
	break;
      }
      case '3':{
	beep(NORMAL);
	ctable.keyrun=getkey(); beep(SPECIAL);
	break;
      }
      case '4':{
	beep(NORMAL);
	printf("\nTrolt kdok szma: ");
	scanf("%u",&(ctable.buffersize));
	goto REDRAW;
      }
    }
  }
}



void main(int argc, char *argv[]){
  FILE *umacrocom;
  char umacroname[128]="umacro.com";
  long startctable;
  char id[]="UMACRO V1.0";
  char *cp;

/* Paramterek rtelmezse. */
  if (argc>=2) strcpy(umacroname,argv[1]);

/* umacro.com fjl megnyitsa. */
  if (!(umacrocom=fopen(umacroname,"rb+wb"))){
    fprintf(stderr,"%s fjl nem ltezik.\n",umacroname);
    exit(1);
  }

/* Azonost keresse: */
  for (startctable=0; !feof(umacrocom); startctable++){
    fseek(umacrocom,startctable,SEEK_SET);
    for (cp=id; *cp; cp++){
      if (*cp!=(char)getc(umacrocom)) goto NEXT;
    }
    startctable=ftell(umacrocom);
    goto FOUND;
    NEXT:;
  }
  fprintf(stderr,"Incorrect file.\n");
  exit(1);
  FOUND:

/* A tblzat beolvassa. */
  fread(&ctable,sizeof(ctable),1,umacrocom);

/* A konfigurci mdostsa. */
  if (menu()){
    fseek(umacrocom,startctable,SEEK_SET);
    if (!(fwrite(&ctable,sizeof(ctable),1,umacrocom))){
      fprintf(stderr,"%s fjlt nem lehet mdostani.",umacroname);
      exit(1);
    }
  }

  exit(0);
}
