/*
** Copyright (C) 1992 Forte.  All rights reserved
** Written late one night 6/27/93.
*/  

#define TRUE 1
#define FALSE 0

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <conio.h>
#include <dir.h>
#include <dos.h>

/* midi files */
#include "midi.h"
#include "totsr.h"

struct header_type header;	/* format of midifile, # of tracks, and time */
int midi_libs=0;
int control_break = FALSE;
FILE *fpIn=NULL;	/* file pointer */

/* callback routine to read a character from the midi file */
mygetc() { return(getc(fpIn)); }

/* callback routine for the midi library to print error messages */
void myerror( char *s)
{
	midi_error("Error: %s\n", s);
}

/* callback routine for the midi library to record header information */
void myheader(int format,int ntrks,int division)
{
    header.format = format;
    header.ntrks = ntrks;
    header.division.quarter_note = division;
}

void mytrack(struct MIDILIB *ml, struct track *track)
{
	struct track *tp;

	if (ml->Mp_tracks) {
		for (tp=ml->Mp_tracks; tp->next_track; tp = tp->next_track) ;
		tp->next_track = track;
	} else {
		ml->Mp_tracks = track;
	}
}

/*
** This routine initalizes the midifile and midiplay libraries and
** sets up all of the callback functions
*/
void init_funcs(struct MIDILIB *ml)
{
    int i;
    int bm;

    ml->Mf_getc = mygetc;
    ml->Mf_header = myheader;
    ml->Mp_set_tempo = um_set_tempo;
    ml->Mp_reset_tick_counter = um_reset_tick_counter;
    ml->Mp_wait_for = um_wait_for;
    ml->Mp_init_timers = um_init_timers;
    ml->Mp_cleanup_timers = um_cleanup_timers;
    ml->Mp_reset_midi = reset_um;
    ml->Mp_note_on = um_note_on;
    ml->Mp_note_off = um_note_off;
    ml->Mp_pressure = um_pressure;
    ml->Mp_parameter = um_parameter;
    ml->Mp_pitch_bend = um_pitch_bend;
    ml->Mp_program = um_program;
    ml->Mp_chanpressure = um_chanpressure;
    ml->Mp_init_hardware = um_init_hardware;
    ml->Mp_cleanup = um_cleanup;
}

int user_hit_break=0;

int cbreak()
{
	user_hit_break = 1;
	return(TRUE);
}

void midi_error(char *fmt, ...)
{
	char buffer[512];
	register int i;
	va_list argptr;
	int cnt;

	va_start(argptr, fmt);
	cnt = vsprintf(buffer, fmt, argptr);
	if (cnt != EOF) {
		puts(buffer);
	}
	va_end(argptr);
}

void midi_message(char *fmt, ...)
{
	char buffer[512];
	register int i;
	va_list argptr;
	int cnt;

	va_start(argptr, fmt);
	cnt = vsprintf(buffer, fmt, argptr);
	if (cnt != EOF) {
		puts(buffer);
	}
	va_end(argptr);
}

main( int argc, char **argv)
{
    struct MIDILIB *ml;
    int i, j, ret;
    char *cp;

    ctrlbrk(cbreak);
    setcbrk(1);
    /* try and open a file */
    if (argc != 2) {
	fprintf(stderr,"usage: %s filename.mid\n", argv[0]);
	exit(0);
    }
    fpIn = fopen(argv[1], "rb");
    if (fpIn == NULL) {
	fprintf(stderr,"%s: unable to open file %s for reading.\n",argv[0], argv[1]);
	exit(1);
    }
    ml = mfinit(myerror);
    (void) init_funcs(ml); /* intialize midi libraries */
    mfread(ml);	     /* read midi file */
    fclose(fpIn);
    midi_out(ml);
    mfcleanup(ml);	        /* close the midifile library  */
    mfclose(&ml);		/* close the midi libraries */
    while( kbhit() ) getch(); 	/* if the user hit a key to stop playback,
				** remove the characters from the keyboard
				** queue.
				*/
    return(0);
}
