.286
grav		equ	7
robb		equ	2
paddress	equ	500h
pontnum		equ	4000

code		segment	byte public
		assume	cs:code, ds:code


		org	100h

start:
		push	cs
		pop	ds
		cld
		mov	ax,0A000h
		mov	es,ax
		mov	ax,13h
		int	10h

		mov	ah,0			; Read the clock
		int	1Ah
		mov	rseed,dx		; Init random seed

		mov	cx,pontnum
		mov	bx,paddress
feltolt:
		mov	al,6
		call	random
		mov	[bx],ax			;x
		mov	al,6
		call	random
		mov	[bx+2],ax		;y
		mov	al,8
		call	random
		sal	ax,robb
		mov	[bx+4],ax
		mov	al,8
		call	random
		sal	ax,robb
		mov	[bx+6],ax
		mov	al,0
		call	random
		cmp	al,0
		jne	nemnull
		inc	al
nemnull:	
		mov	word ptr [bx+8],ax	;path-len
		add	bx,0Ah			;next
		loop	feltolt

;------------------------------------ MAIN LOOP ----------------------
mainloop:
		mov	dx,3DAh			;RETRACE
w1:
		in	al,dx			; port 3DAh, CGA/EGA vid status
		test	al,8
		jnz	w1			; Jump if not zero
w2:
		in	al,dx			; port 3DAh, CGA/EGA vid status
		test	al,8
		jz	w2			; Jump if zero
		mov	bx,paddress
		mov	cx,pontnum

flyloop:
		push	cx
		cmp	word ptr [bx+8],0
		jne	tovabbmegy

		mov	cx,[bx]
		mov	dx,[bx+2]
		xor	al,al
		call	putpixel

		jmp	nemkell
tovabbmegy:
		mov	cx,[bx]			;A trlshez!
		mov	dx,[bx+2]

		mov	ax,[bx+4]		;x+=vx
		add	[bx],ax
		mov	si,[bx]
		cmp	si,-150*64
		jl	fordx
		cmp	si,150*64
		jle	nemfordx
fordx:
		mov	word ptr [bx+8],0	;Vge
		inc	disc
nemfordx:
		mov	ax,[bx+6]		;y+=vy
		add	ax,grav
		mov	[bx+6],ax
		add	[bx+2],ax
		mov	di,[bx+2]
		cmp	di,-64*90
;		jl	fordy
		cmp	di,64*90
		jle	nemfordy
fordy:
		cmp	word ptr [bx+8],0
		je	nemfordy
		mov	word ptr [bx+8],0	;Vge
		inc	disc
nemfordy:
		mov	al,0			;Black->erase old
		call	putpixel
		mov	cx,si
		mov	dx,di
		mov	al,0fh			;White->draw
		call	putpixel
nemkell:
		add	bx,0Ah			;Next
		pop	cx
		dec	cx
		js	noflyloop
		jmp	flyloop
noflyloop:
;		loop	flyloop			; Loop if cx > 0
		cmp	disc,pontnum-10
		jae	vvan

		mov	ah,1
		int	16h			; Keyboard i/o  ah=function 01h
						;  get status, if zf=0  al=char
		jnz	vege			; Jump if zero
		jmp	mainloop
vege:
		sub	ah,ah
		int	16h			; Keyboard i/o  ah=function 00h
vvan:						;  get keybd char in al, ah=scan
		mov	ax,3
		int	10h			; Video display   ah=functn 00h
						;  set display mode in al
		int	20h			; DOS program terminate

;

putpixel:
		pusha
		sar	cx,6
		add	cx,160
		sar	dx,6
		add	dx,100
		cmp	dx,200
		ja	nemkellput
		mov	di,dx
		shl	di,2
		add	di,dx
		shl	di,6
		add	di,cx
		stosb
nemkellput:
		popa
		ret		

kisrnd:
		mov	ax,rseed
		test	ah,80h
		jz	nagybit			; Jump if zero
		xor	ax,16h
		stc				; Set carry flag
		rcl	ax,1			; Rotate thru carry
		jmp	nemshl
nagybit:
		shl	ax,1			; Shift w/zeros fill
nemshl:
		mov	rseed,ax
		ret


random:					;GET RANDOM NUMBER
		push	bx
		push	cx
		mov	cl,al
		call	kisrnd
		mov	bx,ax
		rol	bx,05
		call	kisrnd
		xor	bx,ax
		rol	bx,05
		call	kisrnd
		xor	ax,bx
		sar	ax,cl
		pop	cx
		pop	bx
		ret

rseed		dw	0FFFFh
disc		dw	0


code		ends
	end	start
