
INTERRUPT       equ     21h
;INT_SEG         equ     3909h           ; SEG:OFF of instruction after the
;INT_OFF         equ     0306h           ; calling interrupt
;CHANGE_SEG      equ     12C7h           ; SEG:OFF of instruction to change
;CHANGE_OFF      equ     3BFAh

OVERLAY SEGMENT para 'code'
        ASSUME CS:OVERLAY,DS:OVERLAY
        ORG 100h

START:JMP INITCODE

;----------------------------------------------------------

OLDINT  DW      0,0
ADDR_OFF        equ     <word ptr[bp+2]>
ADDR_SEG        equ     <word ptr[bp+4]>

CR              equ     0Dh
LF              equ     0Ah
BEEP            equ     07h
EOS             equ     '$'

;DISPLACEMENT    equ     CHANGE_SEG - INT_SEG

;----------------------------------------------------------

;sect0data label byte
;include sect0.inc
;sect50data label byte
;include sect50.inc

MES        DB      BEEP,EOS

.286
; buf1    db      512 dup (0)

NEWINT proc far
        PUSHF
        CMP     AH,03Dh
        JE      ezaz1
        CMP     AH,06Ch
        jne     nemez
        CMP     DX,1
        jne     nemez
;        jmp     nemez
        jmp     ezaz2
;-----------3Dh-----------------------
ezaz1:
        PUSHA
        MOV     SI,DX
        CLD
        jmp     kompar
;-----------6Ch-----------------------
ezaz2:
        PUSHA
kompar:
uja:    LODSB
        CMP     AL,'.'
        JE      pont
        CMP     AL,0
        JNE     uja
        jmp     nemnyert
pont:
        LODSB
        CMP     AL,'d'
        je      betu1
        CMP     AL,'D'
        jne     nemnyert
betu1:
        LODSB
        CMP     AL,'o'
        je      betu2
        CMP     AL,'O'
        jne     nemnyert
betu2:
        LODSB
        CMP     AL,'c'
        je      betu3
        CMP     AL,'C'
        jne     nemnyert

betu3:  ; oke!
megvan:
        POPA
        jmp     regicall

nemnyert:
        POPA
        jmp     nemez
        ;---

regicall:
        POPF
        PUSHF
        PUSHF
        CALL dword ptr  cs:OLDINT    ; Jump to oldint
        ;--> iret=popf

        POPF
        MOV     AX,05h
        STC
        RETF 2

        ;---------------------
nemez:
;        CMP     DL,0
;        jne     hivorig
;        int 3

hivorig:
        POPF
        JMP dword ptr  cs:OLDINT    ; Jump to oldint
NEWINT ENDP

;----------------------------------------------------------

FINISH          equ     $
MESSAGE         DB      'xxx - JZ',CR,LF,EOS
CHECKSUM        DW      0

INITCODE:
        MOV     AX,CS
        MOV     DS,AX

        MOV     AH,09h
        MOV     DX,offset MESSAGE
        INT     21h

        MOV     AH,35h
        MOV     AL,INTERRUPT
        INT     21h
        MOV     OLDINT[0],BX
        MOV     OLDINT[2],ES

        MOV     AH,25h
        MOV     AL,INTERRUPT
        MOV     DX,offset NEWINT
        INT     21h

        LEA     DX,FINISH
        INT     27h
error:
        INT     20h
OVERLAY ENDS
        end START
