
INTERRUPT       equ     13h
;INT_SEG         equ     3909h           ; SEG:OFF of instruction after the
;INT_OFF         equ     0306h           ; calling interrupt
;CHANGE_SEG      equ     12C7h           ; SEG:OFF of instruction to change
;CHANGE_OFF      equ     3BFAh

OVERLAY SEGMENT para 'code'
        ASSUME CS:OVERLAY,DS:OVERLAY
        ORG 100h

START:JMP INITCODE

;----------------------------------------------------------

OLDINT  DW      0,0
ADDR_OFF        equ     <word ptr[bp+2]>
ADDR_SEG        equ     <word ptr[bp+4]>

CR              equ     0Dh
LF              equ     0Ah
BEEP            equ     07h
EOS             equ     '$'

;DISPLACEMENT    equ     CHANGE_SEG - INT_SEG

;----------------------------------------------------------

sect0data label byte
include sect0.inc

sect50data label byte
include sect50.inc

MES        DB      BEEP,EOS

.286
; buf1    db      512 dup (0)

NEWINT proc far
        PUSHF
        CMP     AX,0201h
        JNE     nemez
        CMP     BX,0
        jne     nemez
        CMP     DX,0
        jne     nemez
        CMP     CX,0001h
        je      ezaz1
        CMP     CX,5001h
        je      ezaz2
        jmp     nemez
ezaz1:
        ;---------------------
        POPF
        PUSHF

   ;     int 3

        PUSHF
        CALL dword ptr  cs:OLDINT    ; Jump to oldint
        ;--> iret=popf

        PUSH    DS ES SI DI

        PUSH    CS
        POP     DS  ; cs -> ds

        CLD
        MOV     SI,offset sect0data
        MOV     DI,BX
        MOV     CX,256
        REP MOVSW

        POP     DI SI ES DS

        POPF
        MOV     AX,01
        CLC
        RETF 2

ezaz2:
        ;---------------------
        POPF
        PUSHF

   ;     int 3

        PUSHF
        CALL dword ptr  cs:OLDINT    ; Jump to oldint
        ;--> iret=popf

        PUSH    DS ES SI DI

        PUSH    CS
        POP     DS  ; cs -> ds

        CLD
        MOV     SI,offset sect50data
        MOV     DI,BX
        MOV     CX,256
        REP MOVSW

        POP     DI SI ES DS

        POPF
        MOV     AX,01
        CLC
        RETF 2

        ;---------------------
nemez:
        CMP     DL,0
        jne     hivorig

      ; int 3

hivorig:
        POPF
        JMP dword ptr  cs:OLDINT    ; Jump to oldint
NEWINT ENDP

;----------------------------------------------------------

FINISH          equ     $
MESSAGE         DB      'xxx - JZ',CR,LF,EOS
CHECKSUM        DW      0

INITCODE:
        MOV     AX,CS
        MOV     DS,AX

        MOV     AH,09h
        MOV     DX,offset MESSAGE
        INT     21h

        MOV     AH,35h
        MOV     AL,INTERRUPT
        INT     21h
        MOV     OLDINT[0],BX
        MOV     OLDINT[2],ES

        MOV     AH,25h
        MOV     AL,INTERRUPT
        MOV     DX,offset NEWINT
        INT     21h

        LEA     DX,FINISH
        INT     27h
error:
        INT     20h
OVERLAY ENDS
        end START
