#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <sys\stat.h>
#include <dir.h>
#include <fcntl.h>
#include <alloc.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define VERSTR "v1.5b    "

/*
        [] Validate paths
        [] Re-create dir. struct
        [ ] Szoljon elotte, ha nincs eleg hely!!!
        [] Ha no free -> quit!

*/

#include "..\wnd.h"
#include "..\menu.h"
#include "..\screen.h"
#include "..\mouse.h"

char forgo[5] = "|/-\\";

#define MAXFE 10000 // kb. 190k mem kell.

int fcnt=0;
struct fentry
 {
  char name[13];
  int ut;
  long size;
 }
  huge *fe;

int utcnt=0;
struct uentry
 {
  char ut[128];
 }
  far *ue;

// globals:

int ftotal=0, ffound=0;

long totsiz=0l;
int totfound=0;
int totall=0;
int totcopy=0;
int cpnum=0;
long cpbytes=0l;
char *listfile,*frompath,*topath;

int remkdir=0; // ha megorizze masolasnal a dir. strukturat.

void writelogo( void );
void errquit( char *msg );

//------------------------------------------------------------------

char *surslash( char *dir )
{
 char *q;
 if (*(q=&dir[strlen(dir)-1])!='\\')
  q[1]='\\';
 q[2]='\0';
 return dir;
}

int direxists( char *dir ) // nem lesz jo!!!
{
 return 1; // *******************temp. fix

 char st[256],*q;
 strcpy(st,dir);
 surslash(st);
 strcat(st,"NUL");

 if (open(st,O_RDONLY)==-1)
  return 0;

 return 1;
}

int remakedir( char *dirnev ) // megprobal csinalni egy ilyen dir.-t..
                              // tobb szintes make, stb.
{
 char *q;
 char dr[256],dr2[256];
 strcpy(dr,dirnev);

 dr2[0]=0;
 if (!(q=strtok(dr,"\\")))
  return 1; // ok
 while(1)
  {
   strcat(dr2,q);
   if (!direxists(dr2))
    if (mkdir(dr2)!=0)
     errquit("Error making one of the directories!");
     //return 0; // error

   surslash(dr2);

   if (!(q=strtok(NULL,"\\")))
    return 1; // ok
  }
}

void errquit( char *msg )
{
 nyit(17,11,45,5,"Error!!!",YELLOW+16*RED,YELLOW+16*RED,RED,SPEC_FRAME,1,NULL, -1 , 3 );
 textcolor(WHITE);
 gotoxy(23-strlen(msg)/2,2);
 cprintf(msg);
 gotoxy(23-10,3);
 cputs("Press any key to quit");
 while(kbhit()) getch();
 getch();
 //csuk();
 while (isopenwindow())
  csuk();
 clrscr();
 writelogo();
 _setcursortype(_NORMALCURSOR);
 exit(1);
}

void esccheck( void )
{
 if (!kbhit())
  return;

 int xx=0;
 while (kbhit())
  if (getch()==27)
   xx=1;

 if (!xx)
  return;

 nyit(22,10,36,4,"Escape pressed!",YELLOW+16*RED,YELLOW+16*RED,RED,SPEC_FRAME,1,NULL, -1 , 3 );
 textcolor(WHITE);
 cprintf("\r\nDo you really want to quit? [y/N]");
 while(kbhit()) getch();
 if (toupper(getch())!='Y')
  {
   csuk();
   return;
  }

 while (isopenwindow())
  csuk();
 clrscr();
 writelogo();
 _setcursortype(_NORMALCURSOR);
 exit(1);
}

//------------------------------------------------------------------
int currut=-1;
int utlev=0;

int keres( char *ut )
{
 struct ffblk ff;
 int done;
 char pat[128];
 char npat[128];
 char np[128];
 int cut;

 if (fcnt>=MAXFE || utcnt>=500)
  errquit("Too much files or directories!");

 strcpy(pat,ut);
 surslash(pat);
 strcat(pat,"*.*");

 currut++;
 utlev++;

 strcpy(npat,pat);
 npat[strlen(npat)-3] = '\0';

 strcpy(np,pat);
 np[strlen(np)-4] = '\0';
 char *p=&np[strlen(np)-1];
 for (;p!=np;p--)
  if (*p=='\\')
   break;
 p++;

 gotoxy(12,2);
 cprintf("%4d",currut+1);
 gotoxy(1,3);
 clreol();
 gotoxy(15-(strlen(p)/2),3);
 cprintf("%s",p);

 _fstrcpy(ue[utcnt].ut,npat);
 cut=utcnt;
 utcnt++;

 done = findfirst(pat,&ff,0x3F);
 if (done==-1)
  errquit("Error with source path!");

 while (!done)
  {
   esccheck();
   if (ff.ff_name[0]=='.')
    {
     done=findnext(&ff);
     continue;
    }

   if (ff.ff_attrib==FA_DIREC)
    {
     strcpy(npat,pat);
     npat[strlen(npat)-3] = '\0';
     strcat(npat, ff.ff_name );
     keres(npat);
    }
   else
    {
     if (fcnt>=MAXFE)
      {
       utlev--;
       return -1;
      }

     _fstrcpy(fe[fcnt].name,ff.ff_name);
     fe[fcnt].ut=cut;
     fe[fcnt].size=ff.ff_fsize;

     fcnt++;
    }
   done = findnext(&ff);
  }

 utlev--;

 return 0;
}

//--------------------------------------------------------------------------

int filesearch( char *fnev )
{
 int c;
 for (c=0;c<fcnt;c++)
  if (_fstricmp(fnev,fe[c].name)==0)
   return c;

 return -1;
}

char *getpath( char *fnev )
{
 int a;
 static char uta[128];

 if ((a=filesearch(fnev))==-1)
  return NULL;

 _fstrcpy(uta,ue[fe[a].ut].ut);

 return uta;
}

//--------------------------------------------------------------------------
int incfilename( char *st )
{
 char sx[82],sx2[15], *q, *p;
 strncpy(sx,st,16);
 sx[16]=0;
 //if (sx[strlen(sx)-1]=='\n')
 // sx[strlen(sx)-1]='\0';
 p=strtok(sx," ");
 if (strlen(p)>=14 || strlen(p)<4)
  return 0;
 strcpy(sx2,p);
 q=strtok(sx2,". ");
 if (strlen(q)==strlen(p))
  return 0;
 if (strlen(q)>8)
  return 0;
 q=strtok(NULL,". ");
 if (strlen(q)>3)
  return 0;

 return 1;
}

/*******************/

void stabar( int x, int y, int len, float perc ) // statusbar/progress bar
{                                  // perc: 0.00 -> 1.00
 int c;
 float r1,r2;
 gotoxy(x,y);
 //perc/=100;
 for (c=1;c<=(perc*len);c++)
  putchar('');

 if (c<=len)
  {
   r1=(perc*len)-int(perc*len);
   if (r1>0.5)
    putchar('');
   else
    if (r1>0.2)
     putchar('');
    else
     putchar('');
   c++;
  }
 for (;c<=len;c++)
  putchar('');
}

void errfile( char *fil, int typ=0 )
{
 struct text_info ti;
 gettextinfo(&ti);

 window(ti.winleft,ti.wintop+7,ti.winleft+24,ti.winbottom);
 gotoxy(1,ti.winbottom-ti.wintop-7+1);
 textcolor(LIGHTCYAN);
 ColWrite(CYAN+BLUE*16,"\n%-12s %s",fil,typ==0?"Not found":typ==1?"Error!":"?");

 window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
 gotoxy(ti.curx,ti.cury);
}

//-----------------------------------------------------------------

int filemasol( char *honnan, char *hova, char *fnev )
{
 char src[256],dest[256];
 char far *fbuf;
 int sta=0;

 strcpy(src,honnan);
 surslash(src);
 strcat(src,fnev);

 strcpy(dest,hova);
 surslash(dest);
 strcat(dest,fnev);

 int f,g;
 unsigned int xx, lx;
 long len,left,lxx;

 f=open(src,O_RDONLY|O_BINARY);
 g=open(dest,O_RDWR|O_BINARY|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE);
 if (f==-1 || g==-1)
  {
   return -1;
  }

 fbuf=(char far *)farmalloc(64000+1);
 if (!fbuf)
  errquit("Not enough memory for file copy buffer!");

 left=filelength(f);

 textcolor(LIGHTCYAN);
 gotoxy(36,11);
 cprintf("%ld kb",(left+1023)/1024);
 stabar(30,12,30, 0.0 );
 cpnum++;
 cpbytes+=left;

 len=left;
 long cxx=0;
 while (left)
  {
   esccheck();

   lx=(left>64000)?64000:left;
   _dos_read(f,fbuf,lx,&xx);
   cxx+=lx;
   stabar(30,12,30, float(cxx)/(2*len) );

   esccheck();

   _dos_write(g,fbuf,lx,&xx);
   if (xx<lx)
    errquit("Error copying file (disk full?)!");
   cxx+=lx;
   stabar(30,12,30, float(cxx)/(2*len) );
   left-=lx;
  }
 farfree(fbuf);

 close(f);
 close(g);
}

/*******************/

int kivalogat( char *mibol )
{
 FILE *f;
 char *p;
 int a;
 int g;
 char sor[256];
 char uta[128],fnev[16];
 char hx[256];

 ffound=0;
 ftotal=0;
 f=fopen(mibol,"rt");
 if (!f)
  errquit("Error opening list file!");

 while (!feof(f))
  {
   esccheck();

   sor[0]='\0';
   fgets(sor,255,f);
   if (sor[strlen(sor)-1]=='\n')
    sor[strlen(sor)-1]='\0';

   if (!incfilename(sor))
    continue;

   ftotal++;

   strncpy(fnev,sor,16);
   fnev[16]=0;
   p=strtok(fnev," ");

   if ((a=filesearch(fnev))==-1)
    continue;

   _fstrcpy(uta,ue[fe[a].ut].ut);
   //cprintf("%-12s : %s ",fnev,uta);

   strcpy(hx,uta);
   strcat(hx,fnev);
   g=open(hx,O_RDONLY|O_BINARY);
   if (g!=-1)
    {
     totsiz+=filelength(g);
     close(g);
    }
   ffound++;
  }
 fclose(f);
 totfound=ffound;
 totall=ftotal;
 //cprintf("Files searched for: %d  Found: %d\r\n",ftotal,ffound);
}

int mindmasol( char *mibol, char *hovamas )
{
 FILE *f;
 char *p;
 int a;
 char sor[256];
 char uta[128],fnev[16];
 char hova[128],st[128];
 strcpy(hova,hovamas);
 surslash(hova);

 f=fopen(mibol,"rt");
 if (!f)
  return -1;

 textcolor(LIGHTRED);
 gotoxy(30,8);
 cprintf("File:");
 gotoxy(30,9);
 cprintf("Src.:");
 gotoxy(30,10);
 cprintf("Dest:");
 gotoxy(30,11);
 cprintf("Size:");

 gotoxy(30,14);
 cprintf("Files copied :");
 gotoxy(30,15);
 cprintf("Kbytes copied:");
 textcolor(LIGHTMAGENTA);
 gotoxy(30,13);
 cprintf("          - Totals -");

 int fcurr=0;

 while (!feof(f))
  {
   esccheck();
   textcolor(LIGHTCYAN);
   gotoxy(46,14);
   clreol();
   cprintf("%d / %d",cpnum,totfound);
   gotoxy(46,15);
   clreol();
   cprintf("%ld kb",(cpbytes+1023)/1024);
   stabar(30,16,30,float(cpbytes)/totsiz);

   sor[0]='\0';
   fgets(sor,255,f);
   if (sor[strlen(sor)-1]=='\n')
    sor[strlen(sor)-1]='\0';

   if (!incfilename(sor))
    continue;

   fcurr++;

   strncpy(fnev,sor,16);
   fnev[16]=0;
   p=strtok(fnev," ");

   if ((a=filesearch(fnev))==-1)
    {
     errfile(fnev,0);
     continue;
    }

   _fstrcpy(uta,ue[fe[a].ut].ut);
   textcolor(LIGHTCYAN);
   gotoxy(36,8);
   clreol();
   cputs(fnev);
   //textcolor(LIGHTGREEN);
   //gotoxy(50,8);
   //cprintf("(%d/%d)",fcurr,totall);
   textcolor(LIGHTCYAN);
   gotoxy(36,9);
   clreol();
   cputs(uta);
   gotoxy(36,11);
   clreol();

   strcpy(st,hova);
   if (remkdir)
    {
     surslash(st);
     strcat(st,&uta[strlen(frompath)+1]);
     if (!direxists(st))
      remakedir(st);
    }

   gotoxy(36,10);
   clreol();
   cputs(st);

   if (filemasol(uta,st/*hova*/,fnev)!=-1)
    totcopy++;
   else
    {
     errfile(fnev,1);
    }
  }
 fclose(f);
 //cprintf("Files searched for: %d  Found: %d\r\n",ftotal,ffound);
}


//--------------------------------------------------------------------------

void writelogo( void )
{
 printf("Ŀ\n"
        " File-Gather  "  VERSTR  "  (C) 1995 by John Zer/NOSASOFT \n"
        "\n");
}

void main( int argc, char **argv )
{
 int a;

 if (argc<4)
  {
   writelogo();

   printf(
   "   Usage: FGATHER <listfile> <from-path> <to-path> [/R]\n"
   "   Where:\n"
   "          <listfile>  is the file list to be gathered\n"
   "          <from-path> is the path that will be searched, including subdirs.\n"
   "          <to-path>   is the path where files will be copied\n"
   "          /R          if you want to re-create the directory structure\n"
   "   Example: FGATHER FILES.LST C:\\STUFFS D:\\!NEWS \n"
   );
   return;
  }

 if (argc>=5)
  if (argv[4][0]=='/' && toupper(argv[4][1])=='R')
   remkdir=1;

 listfile=(char *)malloc(strlen(argv[1])+2);
 frompath=(char *)malloc(strlen(argv[2])+2);
 topath=(char *)malloc(strlen(argv[3])+2);
 strupr(argv[1]);
 strupr(argv[2]);
 strupr(argv[3]);
 strcpy(listfile,argv[1]);
 strcpy(frompath,argv[2]);
 strcpy(topath,argv[3]);

 fe=(fentry huge *)farcalloc(MAXFE,sizeof(fentry));
 ue=(uentry far *)farcalloc(400,sizeof(uentry));  // max 400 path, 10000 files
 if (!fe || !ue)
  errquit("Not enough memory to allocate buffers.");

 if (!direxists(frompath))
  errquit("The source path does not exist!");

 if (!direxists(topath))
  errquit("The destination path does not exist!");

 _setcursortype(_NOCURSOR);
 textbackground(0);
 clrscr();
 nyit(8,5,65,17,"File-Gather " VERSTR,LIGHTCYAN+16,WHITE+16,BLUE,SPEC_FRAME,1,NULL, -1 , 3 );
 textcolor(WHITE);

 ColWrite(LIGHTCYAN+BLUE*16,"List file  : %s\r\n",listfile);
 ColWrite(LIGHTCYAN+BLUE*16,"Source     : %s\r\n",frompath);
 ColWrite(LIGHTCYAN+BLUE*16,"Destination: %s %s\r\n",topath,remkdir?"(w/directory structure)":"");

 //cprintf("\nSearching for files:\r\n");
 nyit(23,11,35,4,"Searching for files",LIGHTCYAN+16*MAGENTA,WHITE+16*MAGENTA,MAGENTA,SPEC_FRAME,1,NULL, -1 , 3 );
 textcolor(WHITE);
 keres(frompath);
 csuk();
 ColWrite(LIGHTCYAN+BLUE*16,"%d directories read, %d files\r\n",utcnt,fcnt);

 cprintf("Searching for files specified in the list...");
 kivalogat(argv[1]);
 cprintf("\r");
 clreol();
 if (totfound && totall)
  {
   ColWrite(LIGHTCYAN+BLUE*16,"Files searched for: %d  Found: %d  (%d%)\r\n",totall,totfound,(totfound*100)/totall);
   ColWrite(LIGHTCYAN+BLUE*16,"Total size: %ld kb\r\n",(totsiz+1023)/1024);
   cprintf("        \r\n");
   for (a=8;a<17;a++)
    {
     gotoxy(28,a);
     putch('');
    }

   mindmasol(listfile,topath);
  }
 else
  {
   ColWrite(LIGHTCYAN+BLUE*16,"Files searched for: %d  Found: %d  (%d%)\r\n",totall,totfound,(totfound*100)/totall);
   errquit("No file specified in the list was found!");
  }

 /*
 for (a=0;a<500;a++)
  {
   if (kbhit())
    break;
   delay(10);
  }
 while (kbhit())
  getch();
 */
 //csuk();

 //cprintf("\r\n\n");
 _setcursortype(_NORMALCURSOR);

 farfree(fe);
 farfree(ue);
}
