screen_offset	EQU	160*24

CODE_SEG segment
	ASSUME	CS:CODE_SEG,DS:CODE_SEG
	ORG	100h

BEGIN:JMP	init_vectors

	ROM_DISKETTE_INT	DD	?
	DISPLAY_BASE		DW	?
	drive			DB	?
	head			DB	?,?
	track			DB	?,?
	jelleg			DB	?
	num_floppies		DB	?
	alert_message_1		DB	'Disk format on drive : ! (Head:;Track:) Allow operation? [Y/N]         '
				DB	'Write attempt on BOOT SECTOR of drive : ! Allow operation? [Y/N]               '
	lastline		DB	160 dup (?)

resident proc far
	ASSUME	CS:CODE_SEG,DS:NOTHING

	PUSHF
	CLD

	CMP	AH,05h				; Formatting...
	JNE	tovabb1
	CMP	DL,80h				; A harddisk ?
;	JNE	tovabb1
	MOV	jelleg,01			; FORMATTING HARDDISK
	CALL	alert
	CMP	AX,0				; Allowed?
	JE	nemnyert	
tovabb1:

;-----------------------------------------------------------
mehet:
	POPF
	JMP	ROM_DISKETTE_INT		; Run original interrupt code
nemnyert:
	POPF
	STC					; Simulate error
	MOV	AH,03				; WRITE-PROTECT
	RET	2				; This is an interrupt
resident endp

alert proc near
	ASSUME	CS:CODE_SEG,DS:NOTHING
	PUSH	SI
	PUSH	DI
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DS
	PUSH	ES

	PUSH	CS
	POP	DS

	CALL	get_display_base		; Milyen adapter?
	CALL	save_last_line
	CALL	what_drive

	MOV	SI,Offset alert_message_1	; Select message
	XOR	CH,CH
	MOV	CL,jelleg			; Milyen jelleg riaszts?
inc_loop:
	ADD	SI,80
	LOOP	inc_loop
	SUB	SI,80				; 1-et mindenkpp hozzadtunk

	MOV	AX,display_base
	MOV	ES,AX
	MOV	DI,screen_offset		; Hova rjuk?

	MOV	CX,80				; 1 sort
kiir_loop:
	LODSB
	CMP	AL,''
	JNE	nem_23
	MOV	AL,drive
	JMP	no_spec
nem_23:
	CMP	AL,24
	JNE	nem_24
	MOV	AL,head
	JMP	no_spec
nem_24:
	CMP	AL,25
	JNE	nem_25
	MOV	AL,head[1]
	JMP	no_spec
nem_25:
	CMP	AL,26
	JNE	nem_26
	MOV	AL,track
	JMP	no_spec
nem_26:
	CMP	AL,27
	JNE	nem_27
	MOV	AL,track[1]
	JMP	no_spec
nem_27:
no_spec:
	STOSB
	MOV	AL,04Fh				; Attributum
	STOSB
	LOOP	kiir_loop

	CALL	ask_it				; Return: AX
						; 1-Y 0-N

	CALL	restore_last_line

	POP	ES
	POP	DS
	POP	DX
	POP	CX
	POP	BX
	POP	DI
	POP	SI
	RET
alert endp

make_hex proc near
	ASSUME CS:CODE_SEG,DS:NOTHING
	AND	AL,0fh
	CMP	AL,0Ah
	JB	nembetu
	ADD	AL,'A'-0ah-'0'
nembetu:
	ADD	AL,'0'
	RET
make_hex endp

ask_it proc near
	ASSUME CS:CODE_SEG,DS:NOTHING
	PUSHF
ujra_key:
	MOV	AH,01h				; Check if keystroke is ready
	INT	16h
	JZ	readkey
	MOV	AH,00h
	INT	16h
	JMP	ujra_key
readkey:
	MOV	AH,00h
	INT	16h
	CMP	AL,'Z'+1
	JB	upcase_ready
	SUB	AL,'a'-'A'			; Kisbet nagybetre
upcase_ready:
	MOV	AH,1
	CMP	AL,'Y'				; Y-t nyomott ?
	JNE	nemyes
	MOV	AX,0001h			; Igen, engedly megadva!
nemyes:
	CMP	AL,'N'				; N-t nyomott ?
	JNE	nemno
	MOV	AX,0000h			; Igen, nincs engedly!
nemno:
	CMP	AH,0
	JNE	readkey				; Nem 'Y' s nem 'N'
	POPF
	RET
ask_it endp

save_last_line proc near
	ASSUME CS:CODE_SEG,DS:NOTHING
	PUSH	CX
	PUSH	DS
	PUSH	ES
	PUSH	SI
	PUSH	DI

	PUSH	CS				; ES=CS
	POP	ES
	MOV	DI,Offset lastline
	MOV	CX,display_base			; A kpernyrl
	MOV	DS,CX
	MOV	SI,screen_offset
	MOV	CX,80				; Egy sort
	REP	MOVSW
	POP	DI
	POP	SI
	POP	ES
	POP	DS
	POP	CX
	RET
save_last_line endp

restore_last_line proc near
	ASSUME CS:CODE_SEG,DS:NOTHING
	PUSH	CX
	PUSH	DS
	PUSH	ES
	PUSH	SI
	PUSH	DI

	PUSH	CS				; DS=CS
	POP	DS
	MOV	SI,Offset lastline
	MOV	CX,display_base			; A kpernyre
	MOV	ES,CX
	MOV	DI,screen_offset
	MOV	CX,80				; Egy sort
	REP	MOVSW
	POP	DI
	POP	SI
	POP	ES
	POP	DS
	POP	CX
	RET
restore_last_line endp


get_display_base proc near
	ASSUME CS:CODE_SEG,DS:NOTHING

	PUSH	AX
	INT	11h				; Mostani eszkzjelz
	AND	AX,30h				; Csak a kpernyjelz
	CMP	AX,30h				; Monochrome?
	MOV	AX,0B800h			; Szinesre lltjuk
	JNE	done_get_base
	MOV	AX,0B000h			; Monochrome!
done_get_base:
	MOV	DISPLAY_BASE,AX
	POP	AX
	RET
get_display_base endp

what_drive proc near
	ASSUME CS:CODE_SEG,DS:NOTHING
	PUSH	DX
	PUSH	DX
	MOV	AL,DL				; Meghajt szma
	CMP	AL,80h				; Merevlemez?
	JB	write_letter
	SUB	AL,80h
	ADD	AL,num_floppies
write_letter:
	ADD	AL,'A'
	MOV	drive,AL
	POP	DX
	MOV	AL,DH
	SHR	AL,4
	CALL	make_hex
	MOV	head,AL
	MOV	AL,DH
	AND	AL,0fh
	CALL	make_hex
	MOV	head[1],AL
	MOV	AL,CH
	SHR	AL,4
	CALL	make_hex
	MOV	track,AL
	MOV	AL,CH
	AND	AL,0fh
	CALL	make_hex
	MOV	track[1],AL
	POP	DX
	RET
what_drive endp

end_of_resident:


author	DB	'Ŀ',0dh,0ah
	DB	'           Sterile v0.2            ',0dh,0ah
	DB	' the NOSASOFT anti-virus system is ',0dh,0ah
	DB	' installed.                        ',0dh,0ah
	DB	'                 Pre-Beta release  ',0dh,0ah
	DB	'',0dh,0ah,'$'
installed_msg:
	DB	'Already installed...',0dh,0ah,07h,'$'

;==========================================================================
init_vectors proc near
	ASSUME	CS:CODE_SEG,DS:CODE_SEG
	LEA	DX,author
	MOV	AH,09h				; Display string
	INT	21h

;	NOT	word ptr begin
						; Megnzzk, be van-e mr tltve
	XOR	BX,BX				; 0-s szegmens
	MOV	AX,CS
next_segment:
	INC	BX
	CMP	AX,BX
	MOV	ES,BX
	JE	not_installed
	MOV	SI,Offset begin
	MOV	DI,SI
	MOV	CX,16
	REP	CMPSB
	OR	CX,CX
	JNZ	NEXT_SEGMENT
	MOV	DX,Offset installed_msg		; Kirjuk a szveget
	MOV	AH,09h
	INT	21h

	MOV	AX,4c01h			; Kilps
	INT	21h

not_installed:
	CALL	get_num_floppies

	MOV	AH,35h
	MOV	AL,13h
	INT	21h
	MOV	word ptr ROM_DISKETTE_INT,BX
	MOV	word ptr ROM_DISKETTE_INT[2],ES
	MOV	AH,25h
	MOV	AL,13h
	MOV	DX,Offset resident
	INT	21h
	MOV	DX,Offset end_of_resident
	INT	27h
init_vectors endp

get_num_floppies proc near
	ASSUME CS:CODE_SEG,DS:CODE_SEG
	INT	11h				; Eszkzjelz
	MOV	CL,06h
	SHR	AX,CL				; Floppyk szma
	AND	AL,03h				; Ms nem kell
	INC	AL				; mert 0-t ad 1-re
	CMP	AL,1				; 1 floppy?
	JA	done_get_floppies
	MOV	AL,2
done_get_floppies:
	MOV	num_floppies,AL
	RET
get_num_floppies endp

CODE_SEG ends

	END begin