#include <graphics.h>
#include <conio.h>
#include <process.h>
#include <io.h>
#include <ctype.h>
#include <stdio.h>
#include <mem.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>

#include "..\gif\gifload.h"
#include "..\vgafx.h"

#define JOBBRA  1
#define LE      2
#define BALRA   3
#define FEL     4
#define SEMERRE 0

#define XSPEED 3+1
#define YSPEED 2+1

#define FALSE   0
#define TRUE    !FALSE

typedef struct {
	char r;
	char g;
	char b;
} RGB;

typedef RGB PaletteData[256];

typedef struct {
	unsigned int width;
	unsigned int height;
	unsigned char data[1];
} RasterBlock;

RasterBlock far *room;
RasterBlock far *man1;

RasterBlock far *man[20];
RasterBlock far *obj[100];
#define SP_MAN0 20

struct OBJp
 {
  int x,y;
  int width,height;// ?kell?
  int num;
  int irany;
  int xspeed,yspeed;
  int tip;
  int frame;
  int refx1,refx2,refy;
  int ininv;

  OBJp *next,*prev;
 };
#define O_FURNI 1
#define O_DOOR  2

#define OWIDTH(a)  (obj[a->num]->width)
#define OHEIGHT(a) (obj[a->num]->height)

OBJp *oback=NULL,*oact;
OBJp *obacke=NULL,*oacte;
OBJp *mana;

struct sreloc
 {
  int dx, dy;
  int num;
  //int doinv;
 }
  objrel[100];

struct sabsobj
 {
  int x,y;
  int num;
  int tip;
 }
  absobj[100];

int lehet_ir( OBJp ob, int ir);

extern "C" void OutBlock(int x,int y, RasterBlock far *blk );
extern "C" void OutBlockW(int x,int y, RasterBlock far *blk );
extern "C" void OutBlockBack(int x,int y, RasterBlock far *blk );
extern "C" void OutBack(int x,int y, RasterBlock far *blk );
extern "C" void scrtoback(void);
extern "C" void swapscreens(void);
void loadsprites( void );

char far *backscr; // 64k, scr backgr., seg:0
char far *realbck; // real
unsigned int backseg;
char far *screen = (char far *)MK_FP(0xA000,0);
int debug=0;

struct splayer
 {
  int sreq,timex,timlir,plusir;
  int canmove,canturn;
  int keres;
  OBJp *ker;
  int lastir;
  //int kertim;
 }
  ply[2];

//****************************************************************//

/* detects VGA cards */
int huge detectVGA256(void)
{
   int driver, mode, sugmode = 0;

   detectgraph(&driver, &mode);
   if (driver == VGA)
      /* return suggested video mode number */
      return sugmode;
   else
      /* return an error code */
      return grError;
}

void Error( char *st )
{
 printf("Error: %s\n",st);
 exit(1);
}

RasterBlock far *loadcell(char *fname, PaletteData *pal=NULL)
{
 char far *p;
 int f;
 long fsize;
 unsigned xs,ys;

 if ((f=open(fname,O_BINARY|O_RDONLY))==-1)
  return NULL;

 lseek(f,2,SEEK_CUR);
 read(f,&xs,2);
 read(f,&ys,2);
 //if (dominus)
 // {
 //  xs--;
 //  ys--;
 // }

 lseek(f,32,SEEK_SET);
 if (pal)
  read(f,(char *)&pal,768);
 else
  lseek(f,768,SEEK_CUR);

 p=(char far *)farmalloc((xs+1)*(ys+1)+4);
 _fmemcpy(&p[0],&xs,2);
 _fmemcpy(&p[2],&ys,2);
 unsigned xx;
 _dos_read(f,&p[4],(xs+1)*(ys+1),&xx);

 close(f);
 return((RasterBlock far *)p);
}

RasterBlock far *lopspr( char far *scrx, int x, int y, int xs, int ys )
{
 RasterBlock far *ras;

 ras=(RasterBlock far *)farmalloc(xs*ys+4);
 int c,d;
 for (c=0;c<ys;c++)
  _fmemcpy(&ras->data[c*xs],&scrx[(y+c)*320+x],xs);
 ras->width=xs;
 ras->height=ys;

 return(ras);
}

RasterBlock far *sprresz( RasterBlock far *spr, int x, int y, int xs, int ys )
{
 RasterBlock far *ras;

 ras=(RasterBlock far *)farmalloc(xs*ys+4);
 int c,d;
 int u=spr->width,v=spr->height;
 for (c=0;c<ys;c++)
  _fmemcpy(&ras->data[c*xs],&spr->data[u*(y+c)+x],xs);
 ras->width=xs;
 ras->height=ys;

 return(ras);
}

int coll_test( OBJp *objp1, OBJp *objp2)
{
   int xmin1,xmax1,xmin2,xmax2;
   int ymin1,ymax1,ymin2,ymax2;

   /* x coordinates of object 1 */
   xmin1 = objp1->x;//+objp1->sprite->xoffset;
   xmax1 = xmin1+obj[objp1->num]->width;//objp1->sprite->width;

   /* x coordinates of object 2 */
   xmin2 = objp2->x;//+objp2->sprite->xoffset;
   xmax2 = xmin2+obj[objp2->num]->width;//objp2->sprite->width;

   /* y coordinates of object 1 */
   ymin1 = objp1->y;//+objp1->sprite->yoffset;
   ymax1 = ymax1+obj[objp1->num]->height;//objp1->sprite->height;

   /* y coordinates of object 2 */
   ymin2 = objp2->y;//+objp2->sprite->yoffset;
   ymax2 = ymax2+obj[objp2->num]->height;//objp2->sprite->height;

   /* object 2 entirely to the left of object 1 */
   if (xmax2 < xmin1) return(FALSE);

   /* object 2 entirely to the right of object 1 */
   if (xmin2 > xmax1) return(FALSE);

   /* object 2 entirely to the below object 1 */
   if (ymax2 < ymin1) return(FALSE);

   /* object 2 entirely to the above object 1 */
   if (ymin2 > ymax1) return(FALSE);

   /* the objects overlap */
   return(TRUE);
}


int colltest( int x1, int y1, int x1s, int y1s, int x2, int y2, int x2s, int y2s)
{
 int xmin1,xmax1,xmin2,xmax2;
 int ymin1,ymax1,ymin2,ymax2;

 /* x coordinates of object 1 */
 xmin1 = x1;
 xmax1 = x1+x1s;

 /* x coordinates of object 2 */
 xmin2 = x2;
 xmax2 = x2+x2s;

 /* y coordinates of object 1 */
 ymax1 = y1+y1s;
 ymin1 = y1;

 /* y coordinates of object 2 */
 ymax2 = y2+y2s;
 ymin2 = y2;

 /* object 2 entirely to the left of object 1 */
 if (xmax2 < xmin1) return(FALSE);

 /* object 2 entirely to the right of object 1 */
 if (xmin2 > xmax1) return(FALSE);

 /* object 2 entirely to the below object 1 */
 if (ymax2 < ymin1) return(FALSE);

 /* object 2 entirely to the above object 1 */
 if (ymin2 > ymax1) return(FALSE);

 /* the objects overlap */
 return(TRUE);
}

/***********************************************************************/

int getbackpixel( int x, int y )
{
 return backscr[x+y*320];
}

int movex( int *xx, int ir )
{
 if (ir==1) { (*xx)+=XSPEED; return *xx; };
 if (ir==3) { (*xx)-=XSPEED; return *xx; };
 return *xx;
}

int movey( int *yy, int ir )
{
 if (ir==2) { (*yy)+=YSPEED; return *yy; };
 if (ir==4) { (*yy)-=YSPEED; return *yy; };
 return *yy;
}

#define moveit(x,y,ir) movex((x),ir); movey((y),ir);

int lehetmove( int x, int y, int ir)
{
 int x1=x,y1=y;
 moveit(&x1,&y1,ir);
 if (getbackpixel(x1,y1)==199)
  return 1;

 return 0;
}

int lehet_ir( OBJp *ob, int ir)
{
 int x1=ob->x,y1=ob->y;

 moveit(&x1,&y1,ir);
 if (getbackpixel(x1,y1)==199)
  return 1;

 return 0;
}

int checkmove( OBJp *ob, int ir)
{
 int x1=ob->x,y1=ob->y;

 moveit(&x1,&y1,ir);

 if (getbackpixel(x1,y1)==199)
  return 1;

 return 0;
}

OBJp *checkcollmove( OBJp *ob, int ir)
{
 OBJp *node;
 int x1=ob->x,y1=ob->y;

 moveit(&x1,&y1,ir);

 if (!oback)
  return NULL;

 node=oback;
 while (node)
  {
   if (colltest(node->x,node->y,obj[node->num]->width,obj[node->num]->height,
        x1+ob->refx1,y1+ob->refy,ob->refx2-ob->refx1,1))
    return node;

   node=node->next;
  }

 //if (getbackpixel(x1,y1)==199)
 // return NULL;

 return NULL;
}


int movphs[4]={4,6,2,7};
int stillphs[4]={3,1,0,5};

void manchangemov( int ir )
{
 if (ir>4 || ir<1) return;
 mana->num=movphs[ir-1]+SP_MAN0;
}

void manchangestill( int ir )
{
 if (ir>4 || ir<1) return;
 mana->num=stillphs[ir-1]+SP_MAN0;
}


OBJp *new_object( int x=0, int y=0, int num=0, int tip=0 )
{
 OBJp *node;
 node=(OBJp *)malloc(sizeof(OBJp));
 memset(node,0,sizeof(OBJp));

 node->x=x; node->y=y; node->num=num;
 node->tip=tip;

 return node;
}

int add_object( OBJp *node, int totop=1 )
{
 //OBJp node;
 //node=(OBJp *)malloc(sizeof(OBJp));
 //memcpy(node,ob,sizeof(OBJp));

 if (totop && (oback))
  {
   node->prev=obacke;
   node->next=NULL;
   obacke->next=node;
   obacke=node;
  }
 else
  {
   node->prev=NULL;
   node->next=oback;
   oback->prev=node;
   oback=node;
   if (!obacke)
    obacke=oback;
  }
}

int out_object( OBJp *ob )
{
 OBJp *node=oback;
 if (!node)
  return 0;

 while (node)
  {
   if (coll_test(node,ob) || (node==ob))
    OutBack(node->x,node->y,obj[node->num]);
   node=node->next;
  }

 OutBlockW(ob->x,ob->y,obj[ob->num]);
}

/*
void kill_object(OBJp objp)
{
   // remove the object from the linked list

   OBJp node;

   node = objp;
   if (node == bottom_node)
   {
      bottom_node = node->next;
      if (bottom_node != (OBJp) NULL)
         bottom_node->prev = (OBJp)NULL;
   }
   else if (node == top_node)
   {
      top_node = node->prev;
      top_node->next = (OBJp)NULL;
   }
   else
   {
      node->prev->next = node->next;
      node->next->prev = node->prev;
   }
   free(node);
}
*/


/***********************************************************************/

void sprreszback( int x, int y, RasterBlock far *spr, int xo, int yo, int xs, int ys )
{
 int c;
 if (xs+xo>spr->width)
  xs=spr->width-xo;
 if (ys+yo>spr->height)
  ys=spr->height-yo;

 for(c=0;c<=ys;c++)
  _fmemcpy(&backscr[(c+y)*320+x],&spr->data[spr->width*(yo+c)+xo],xs);
}

void getfback( int x, int y, int x1, int y1)
{
 int c,d;
 if (debug)
  {
   for(c=y;c<=y1;c++)
    _fmemset(&screen[c*320+x],'4',(x1-x));
   return;
  }

 for(c=y;c<=y1;c++)
  _fmemcpy(&screen[c*320+x],&backscr[c*320+x],(x1-x));
}

void diffback( int x, int y, int ir, RasterBlock far *sp )
{
 int c,d;

 int x1=x,y1=y;
 moveit(&x1,&y1,ir);

 if (y!=y1)
  {
   if (y<y1)
    getfback(x,y,x+sp->width,y1);
   else
    getfback(x,y1+sp->height,x+sp->width,y+sp->height);
  }

 if (x!=x1)
  {
   if (x<x1)
    getfback(x,y,x1,y1+sp->height);
   else
    getfback(x1+sp->width,y,x+sp->width,y+sp->height);
  }
}

void diffxback( OBJp *oldo, OBJp *newo )
{
 int c,d,x,x1,y,y1;

 x=oldo->x; y=oldo->y;
 x1=newo->x; y1=newo->y;
 //int x1=x,y1=y;
 //moveit(&x1,&y1,ir);

 if (y!=y1)
  {
   if (y<y1)
    getfback(x,y,x+OWIDTH(oldo),y1);
   else
    getfback(x,y1+OHEIGHT(oldo),x+OWIDTH(oldo),y+OHEIGHT(oldo));
  }

 if (x!=x1)
  {
   if (x<x1)
    getfback(x,y,x1,y1+OHEIGHT(oldo));
   else
    getfback(x1+OWIDTH(oldo),y,x+OWIDTH(oldo),y+OHEIGHT(oldo));
  }
}


int activate_obj( OBJp *ob=NULL )
{
 OBJp *q, *r;

 if (ob)
  q=ob;
 else
  q=checkcollmove(mana,ply[0].lastir);

 r = new OBJp;
 memcpy(r,q,sizeof(OBJp));
 sprreszback(q->x,q->y,room,q->x-15,q->y-15,obj[q->num]->width,obj[q->num]->height);

 q->x+=objrel[q->num].dx;
 q->y+=objrel[q->num].dy;
 q->num=objrel[q->num].num;
 q->ininv=(objrel[q->num].num==q->num)?1:0;

 OutBack(q->x,q->y,obj[q->num]);
 diffxback(q,mana);
 diffxback(r,mana);
 OutBlockW(mana->x,mana->y,obj[mana->num]);
 delete(r);
 if (q->tip==O_FURNI)
  ply[0].keres=1;
 else
  ply[0].keres=0;
 ply[0].ker=q;

 return 0;
}

int deactivate_obj( void )
{
 OBJp *r,*q;
 q = ply[0].ker;
 r = new OBJp;
 memcpy(r,q,sizeof(OBJp));
 sprreszback(q->x,q->y,room,q->x-15,q->y-15,obj[q->num]->width,obj[q->num]->height);
 //q->y+=6;
 if (q->ininv)
  {
   q->ininv=0;
   q->x-=objrel[q->num].dx;
   q->y-=objrel[q->num].dy;
   q->num=objrel[q->num].num;
  }
 else
  {
   q->x+=objrel[q->num].dx;
   q->y+=objrel[q->num].dy;
   q->num=objrel[q->num].num;
  }
 OutBack(q->x,q->y,obj[q->num]);
 diffxback(q,mana);
 diffxback(r,mana);
 OutBlockW(mana->x,mana->y,obj[mana->num]);
 delete(r);
 ply[0].keres=0;
 ply[0].canmove=1;

 return 0;
}

/***********************************************************************/

void main (void)
{
 char pal[768];

 int gdriver, gmode;
 int c,d;

 gdriver = installuserdriver("VGA256", detectVGA256);
 gdriver = DETECT;
 initgraph(&gdriver, &gmode, "");

 realbck=(char far *)farmalloc(64000+16);
 backseg=FP_SEG(realbck)+FP_OFF(realbck)/16+1;
 backscr=(char far *)MK_FP(backseg,0);

 loadsprites();

 loadGIF320("spy04.gif",pal);
 convertpalette(pal);
 makepalette(pal);

 OutBlock(15,15,room);
 OutBlock(15,111,room);

 scrtoback();

 int kilep=0;
 int kar,kar2;
 int ir;//lastir=LE;
 ply[0].lastir=LE;
 //char buf[256];

 //OutBlock(x,y,man1);
 int timex=0;
 int sreq=0;
 int plusir=0;
 int timlir=-1;

 // szekreny
 //OutBlock(80,36,obj[1]);
 //OutBack(80,36,obj[1]);

 OBJp *no=new_object(80,36,1,O_FURNI);
 add_object(no);
 out_object(no);

 no=new_object(163,40,2,O_FURNI);
 add_object(no);
 out_object(no);

 no=new_object(20+5,40-3,3,O_DOOR);
 add_object(no);
 out_object(no);

 no=new_object(189+5,40-3,4,O_DOOR);
 add_object(no);
 out_object(no);

 mana=new_object(40,45,SP_MAN0+1);
 mana->refx1=10; mana->refx2=23; mana->refy=26;
 out_object(mana);

 ply[0].canmove=1;
 ply[0].timex=0;
 ply[0].sreq=0;
 ply[0].plusir=0;
 ply[0].timlir=0;

 do
  {
   delay(10);
   timex++;
   timlir++;
   //ply[0].kertim++;

   kar=-1;
   if (kbhit())
    {
     kar=toupper(getch());
     if (!kar)
      kar2=getch();
    }

   switch (kar)
    {
     case  27:kilep=1; break;
     case 'S':swapscreens();
              getch();
              swapscreens();
             break;
     case 'D':debug=!debug;
             break;
     case ' ':OBJp *q;
              if ((q=checkcollmove(mana,ply[0].lastir)))
               {
                if (ply[0].keres)
                 {
                  deactivate_obj();
                  break;
                 }
                activate_obj(q);
               }
             break;
     case  0:ir=SEMERRE;
             switch (kar2)
              {
               case 72:ir=FEL; break;
               case 80:ir=LE; break;
               case 75:ir=BALRA; break;
               case 77:ir=JOBBRA; break;
	      }
             if (ir)
              {
               timlir=0;
               if (ply[0].lastir==ir)
                plusir++;
               else
                plusir=0;

               if (ply[0].keres && ir!=ply[0].lastir)
                deactivate_obj();

               if ( lehetmove(mana->x+10,mana->y+26,ir)
	         && lehetmove(mana->x+23,mana->y+26,ir)
		 && ply[0].canmove)
                {
                 diffback(mana->x,mana->y,ir,obj[mana->num]);
                 moveit(&(mana->x),&(mana->y),ir);
                 if (!((plusir/5)%2))
                  manchangemov(ir);
                 else
                  manchangestill(ir);
                 OutBlockW(mana->x,mana->y,obj[mana->num]);
                }
               else
                {
                 diffback(mana->x,mana->y,SEMERRE,obj[mana->num]);
                 manchangestill(ir);
                 OutBlockW(mana->x,mana->y,obj[mana->num]);
                }

               ply[0].lastir=ir;
               timex=0;
               sreq=1;
              }
            break;
    }

   if ( sreq && (timex>(250/10)) )
    {
     diffback(mana->x,mana->y,ply[0].lastir,obj[mana->num]);
     //OutBlockBack(x,y,man1);
     manchangestill(ply[0].lastir);
     OutBlockW(mana->x,mana->y,obj[mana->num]);
     sreq=0;
    }

   if ( (timlir!=-1) && timlir>(250/10) )
    {
     plusir=0;
     timlir=-1;
    }
  }
 while (!kilep);

 closegraph();

 farfree(room);
 for (c=0;c<20;c++)
  if (man[c])
   farfree(man[c]);
 for (c=0;c<100;c++)
  if (obj[c])
   farfree(obj[c]);

 farfree(realbck);
}

//-----------------------------------------------------------------

void loadsprites( void )
{
 int c;
 char pal[768];
 char far *sprscr=(char far *)farmalloc(64100);
 loadGIF320("spyall.gif",pal,sprscr);
 for (c=0;c<8;c++)
  obj[c+SP_MAN0]=lopspr(sprscr,1+c*35,73, 34,29);
  //man[c]=lopspr(sprscr,1+c*35,73, 34,29);

 room=lopspr(sprscr, 1,1, 203,71);
 FILE *of;
 of=fopen("spyobjx.dat","rt");
 if (!of) Error("SPYOBJX.DAT not found!");

 char buf[256];
 c=0;
 int xx1,yy1,xxs,yys;
 char *pp;
 while (!feof(of))
  {
   buf[0]='\0';
   fgets(buf,255,of);
   if (buf[strlen(buf)-1]=='\n')
    buf[strlen(buf)-1]='\0';

   if (pp=strchr(buf,';'))
    *pp='\0';

   if (buf[0]=='\0')
    continue;

   c++;

   pp=strtok(buf,",");
   xx1=atoi(pp);
   pp=strtok(NULL,",");
   yy1=atoi(pp);
   pp=strtok(NULL,",");
   xxs=atoi(pp);
   pp=strtok(NULL,",");
   yys=atoi(pp);

   obj[c]=lopspr(sprscr, xx1,yy1, xxs,yys);

   if ((pp=strtok(NULL,",")))
    {
     objrel[c].dx=atoi(pp);
     pp=strtok(NULL,",");
     objrel[c].dy=atoi(pp);
     pp=strtok(NULL,",");
     objrel[c].num=atoi(pp);
    }
   else
    {
     objrel[c].dx=0;
     objrel[c].dy=0;
     objrel[c].num=c;
    }
  }

 fclose(of);
 farfree(sprscr);
}

void loadobjpos( void )
{
 int c;
 FILE *of;
 of=fopen("spyabsob.dat","rt");
 if (!of) Error("SPYABSOB.DAT not found!");

 char buf[256];
 c=0;
 int xx1,yy1,xxs,yys;
 char *pp;
 while (!feof(of))
  {
   buf[0]='\0';
   fgets(buf,255,of);
   if (buf[strlen(buf)-1]=='\n')
    buf[strlen(buf)-1]='\0';

   if (pp=strchr(buf,';'))
    *pp='\0';

   if (buf[0]=='\0')
    continue;

   c++;

   pp=strtok(buf,",");
   absobj[c].num=atoi(pp);
   pp=strtok(NULL,",");
   absobj[c].x=atoi(pp);
   pp=strtok(NULL,",");
   absobj[c].y=atoi(pp);
   pp=strtok(NULL,",");
   if (pp)
    absobj[c].tip=atoi(pp);
  }

 fclose(of);
}
