#include <alloc.h>
#include <process.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <conio.h>

#include "selfdef.h"

void selfcheck( char *onmaga )
{
 int fh;
 int c;
 char *buf;
 int checksum;
 int readlength;
 int count;
 int chback;
 int chk2;
 printf("Checking integrity.\n");
 if ( (buf=(char *)malloc(10000))==NULL)
  {
   printf("Insufficient memory!\nProgram aborting...\n\n");
   exit(2);
  }
 if ( (fh=open(onmaga, O_BINARY | O_RDWR )) ==-1)
  {
   printf("Can't open file!\nIncrement FILES in the CONFIG.SYS!\n\n");
   exit(2);
  }
 lseek(fh,0x02,SEEK_SET);
 read(fh,&readlength,2);
 lseek(fh,0x12,SEEK_SET);
 read(fh,&chk2,2);
 if (chk2==0) readlength=0xFFFF;
 lseek(fh,0x1c,SEEK_SET);
 checksum=0;
 count=0;
 while( read(fh,buf,10000)!=0)
 {
  chback=checksum;
  for (c=0 ; c<=9999 ; c++)
   {
    /*
    asm{
     XOR AX,AX
     MOV BX,WORD PTR buf[c]
     ADD AX,BX
     ADD checksum,AX
    }
    */
    checksum+=buf[c]*c;
   }
  printf("");
  count++;
  if (count==readlength) break;
 }
 checksum=chback;
 printf("\n");
 if (checksum==0) checksum=11983;
 lseek(fh,0x12,SEEK_SET);
 read(fh,&chk2,2);
 if (chk2==0)
  {
   lseek(fh,0x12,SEEK_SET);
   write(fh,&checksum,2);
   lseek(fh,0x02,SEEK_SET);
   write(fh,&count,2);
   close(fh);
  }
 else
  {
   if (checksum!=chk2)
    {
     printf("File corrupted.");
     close(fh);
     exit(1);
    }
   if (checksum*3!=chk2*3)
    {
     printf("File corrupted.");
     close(fh);
     exit(1);
    }
  }
 free(buf);
 printf("Done.\n");
}

/*
void main( int argc,char *argv[] )
{
 selfcheck(argv[0]);
}
*/