/* little test program to see if sb_drive.c will work under MSDOS */
#include <stdio.h>
#include <stdlib.h>
#include <conio.h> /* for keyboard polling */

#include "sb_regs.h"
#include "sblast.h"

#define GOOD 1
#define FAIL 0

#define TRUE 1
#define FALSE 0

struct sb_conf dev;
struct sb_mixer_levels mix;
struct sb_mixer_params mixpar;

unsigned char string1[]={'C','r','e','a','t','i','v','e',' ','V','o','i','c',
		       'e',' ','F','i','l','e',0x1a,0x1a,0,0x0a,1,0x29,0x11};

unsigned char sndbuf[10000];

#define USAGE \
"output_file -r speed -m mic_vol -b"\
"\n"\
"output_file: Sound file name. Reqd\n"\
"speed:     Output rate (samples/sec) (valid range [4000-43478] (SBPro)\n"\
"mic_vol:    Microphone Volume (SBPro only) [0-7]\n"\
"\n"\
"\w:    Raw output (No header). Default is .VOC output\n"



int main(int argc, char** argv)
{
   int   tmp;
   unsigned int speed, utmp;
   unsigned time_constant;
   int   mic_volume;
   int   voc_file;
   long  length;
   long  count;
   FILE  * outfile;
   char  * outfile_name;
   long  header_offset;

  int           opt, error_flag; /* GNU getopt(3) variables */
  extern int 	optind;
  extern char	*optarg;

  /* Default options */
  speed=8000;
  mic_volume=7;
  voc_file=TRUE;

  error_flag = 0;
  while ((opt = getopt (argc, argv,
			"r:R:M:m:bB")) != EOF)
    switch (opt)
      {
      case 'b':                 /* raw output */
      case 'B':
	 voc_file = FALSE;
	 break;
      case 'r':                 /* output speed */
      case 'R':
	utmp = atoi(optarg);
	if ((utmp>0)&&(utmp<43479))
	 {
	  speed=utmp;
	 }
	else
	 {
	   printf("Invalid speed specified, valid limits are 0-43478.\n");
	   exit(1);
	 }
	break;
      case 'm':                 /* Microphone volume */
      case 'M':
	    tmp=atoi(optarg);
	    if ((tmp>-1)&&(tmp<8))
	      mic_volume=tmp;
	    else
	      {
		printf("Invalid microphone volume, limits 0-7\n");
		exit(1);
	      }
	    break;
      default:                  /* unrecognized option */
	error_flag = 1;
	break;
      }

  if (error_flag || !argv[optind])
    {
      fprintf(stderr, "Usage: recorder " USAGE);
      exit(1);
    }

/* get input filename */
  outfile_name = argv[optind];

   /* ok, see if sb exists */
   dev.addr = 0x220;
   dev.irq  = 7;
   tmp = sb_probe(&dev);

   if (tmp == GOOD)
       printf("Found SB at address=%d\n",dev.addr);
   else
     {
       printf("No card found\n");
       exit(1);
     }

   /* now "attach" sbpro, set up interupts, etc.. */
   tmp=sb_attach(&dev);
   printf("result of attach was %d\n",tmp);

   /* checkout mixer settings */
   mixer_get_levels( &mix );
   printf("Mixer setup: \n");
   printf("Master -> L:%d  R:%d\n",mix.master.l, mix.master.r);
   printf("Voice  -> L:%d  R:%d\n",mix.voc.l, mix.voc.r);
   printf("FM     -> L:%d  R:%d\n",mix.fm.l, mix.fm.r);
   printf("Line   -> L:%d  R:%d\n",mix.line.l, mix.line.r);
   printf("CD     -> %d\n",mix.cd);
   printf("Mic    -> %d\n",mix.mic);

   mix.mic = mic_volume;
   mixer_set_levels( &mix);

   /* record from mic, turn on filter so it doesnt sound like crap */
   mixpar.hifreq_filter = FALSE;
   mixpar.filter_input = TRUE;
   mixpar.record_source=SRC_MIC;
   mixer_set_params( &mixpar);

   if (speed) {
     printf("setting speed to %u\n",speed);
     dsp_set_speed(&speed);
     printf("Using speed=%u\n",speed);
   }
   else
     {
       speed=-1;
       dsp_set_speed(&speed);
       printf("Using speed=%u\n",speed);
     }



   /* ok, now lets send something to output */
   outfile = fopen(outfile_name,"wb");
   if (outfile==NULL) {
     printf("Cannot open output file. Aborting\n");
     exit(1);
   }


/* put a voc header on here if requested */
   if (voc_file)
   {
    /* write out header */
    fwrite(string1,1,sizeof(string1),outfile);

    /* now insert speed, length info */
    /* guess length for now */
    length = 0;

    /* mark start of sound data */
    fputc(1, outfile);

    /* length is 3 bytes, LSB first, store length + 2 (why ask why?) */
    /* store pos so we can go back later when we know length */
    header_offset= ftell(outfile);
    length += 2;
    fputc(length&0xff,outfile);
    fputc((length&0xff00)>>8,outfile);
    fputc((length&0xff0000)>>16,outfile);
    length -= 2;

    /* speed byte (SB) is given by
     *      speed < 22222 ->   SB = 256-(1000000/speed)
     *      speed > 22222 ->   SB = 65536-(256000000/speed)     */
     if (speed > 22222)
       time_constant = 65536L - (256000000L / (long)speed);
     else
       time_constant = 256 - (1000000/speed);

     fputc(time_constant & 0xff, outfile);
     fputc((time_constant & 0xff00)>>8, outfile);
   }
     /* now record  */

   printf("Hit return to start recording.\n");
   tmp=getchar();
   printf("Hit a key to end recording\n");
   length = 0;
   do{
     dsp_read(sndbuf, 5000);
     tmp=fwrite(sndbuf, 1, 5000, outfile);
     length += tmp;
    }
   while(!kbhit());
   tmp=getch();

   /* end file, then stick length in header */
   if (voc_file)
    {
      /* terminate file */
      fputc(0,outfile);

      /* seek back to where length is stored and write it */
      fseek(outfile, header_offset, SEEK_SET);

      /* length is 3 bytes, LSB first, store length + 2 (why ask why?) */
      length += 2;
      fputc(length&0xff,outfile);
      fputc((length&0xff00)>>8,outfile);
      fputc((length&0xff0000)>>16,outfile);
    }

   /* we're outa here */
   fclose(outfile);

  }
