/* go from raw to vocfile */

#include <stdio.h>
#include <stdlib.h>


unsigned char string1[]={'C','r','e','a','t','i','v','e',' ','V','o','i','c',
		       'e',' ','F','i','l','e',0x1a,0x1a,0,0x0a,1,0x29,0x11};

unsigned char buffer[64000];

main(int argc, char **argv)
{
   unsigned int speed, time_constant;
   size_t hunk_size;
   fpos_t length, count;
   FILE *infile;
   FILE *outfile;

   if ( argc < 4 ) { printf("Usage: raw2voc rawfile vocfile speed\n"); exit(1);}
   if ((infile=fopen(argv[1],"rb"))==NULL)
    {
     printf("Couldnt find input file, aborting.\n");
     exit(1);
    }
   if ((outfile=fopen(argv[2],"wb"))==NULL)
    {
     printf("Couldnt open output file, aborting.\n");
     fclose(infile);
     exit(1);
    }

    speed=(unsigned int) atol(argv[3]);
    printf("Using speed=%u\n",speed);

    /* write out header */
    fwrite(string1,1,sizeof(string1),outfile);

    /* now insert speed, length info */
    /* compute length */
    fseek(infile, 0L, SEEK_END);
    fgetpos(infile, &length);
    printf("Input length = %ld\n",length);
    fseek(infile, 0L, SEEK_SET); /* rewind file */

    fputc(1, outfile);

    /* length is 3 bytes, LSB first */
    length += 2;
    fputc(length&0xff,outfile);
    fputc((length&0xff00)>>8,outfile);
    fputc((length&0xff0000)>>16,outfile);
    length -= 2;

    /* speed byte (SB) is given by
     *      speed < 22222 ->   SB = 256-(1000000/speed)
     *      speed > 22222 ->   SB = 65536-(256000000/speed)     */
     if (speed > 22222)
       time_constant = 65536L - (256000000L / (long)speed);
     else
       time_constant = 256 - (1000000/speed);

     fputc(time_constant & 0xff, outfile);
     fputc((time_constant & 0xff00)>>8, outfile);

     /* now do the rest, copy infile to outfile */
     count = 0;
     do
     {
       hunk_size = min(length-count,64000);
       fread(buffer,1,hunk_size,infile);
       fwrite(buffer,1,hunk_size,outfile);
       count += hunk_size;
     }
     while( count < length );

   /* terminate file */
   fputc(0,outfile);

   fclose(infile);
   fclose(outfile);
}
