/* little test program to see if sb_drive.c will work under MSDOS
 * just playing the input RAW file. You can send it a VOC file and
 * its should still work, although you must supply the speed      */
#include <stdio.h>
#include "..\sbplay\sb_regs.h"
#include "..\sbplay\sblast.h"

#define GOOD 1
#define FAIL 0

#define TRUE 1
#define FALSE 0

struct sb_conf dev;
struct sb_mixer_levels mix;

unsigned char sndbuf[10000];
unsigned char vochdr[]={'C','r','e','a','t','i','v','e',' ','V','o','i','c',
		       'e',' ','F','i','l','e'};


#define USAGE \
"input_file -r speed -m master_vol -v voice_vol -s"\
"\n"\
"input_file: Sound file name. Reqd\n"\
"speed:     Output rate (samples/sec) (valid range [4000-43478] (SBPro)\n"\
"master_vol:    Master Volume (SBPro only) [0-15]\n"\
"voice_vol:     DAC Volume (SBPro only) [0-15]\n"\
"\n" \
"-s: Stereo output (SBPro only)\n"\


int main(int argc, char** argv)
{
   int   tmp;
   unsigned speed, utmp, vspeed;
   int   speed_defined;
   FILE  * infile;
   unsigned long ltmp;
   int stereo;
   int master_volume, voice_volume;
   char * infile_name;

   long pos; // ***
   int h;

  int           opt, error_flag; /* GNU getopt(3) variables */
  extern int 	optind;
  extern char	*optarg;

  /* Default options */
  speed=8000;
  speed_defined=FALSE;
  stereo= FALSE;
  master_volume=15;
  voice_volume=15;

  error_flag = 0;
  while ((opt = getopt (argc, argv,
			"r:R:M:m:V:v:sS")) != EOF)
    switch (opt)
      {
      case 'r':                 /* output speed */
      case 'R':
	utmp = atoi(optarg);
	if ((utmp>0)&&(utmp<43479))
	 {
	  speed=utmp;
	  speed_defined=TRUE;
	 }
	else
	 {
	   printf("Invalid speed specified, valid limits are 0-43478.\n");
	   exit(1);
	 }
	break;
      case 's':                 /* Stereo output */
      case 'S':
	stereo = TRUE;
	break;
      case 'm':                 /* Master volume */
      case 'M':
	    tmp=atoi(optarg);
	    if ((tmp>-1)&&(tmp<16))
	      master_volume=tmp;
	    else
	      {
		printf("Invalid master volume, limits 0-15\n");
		exit(1);
	      }
	    break;
      case 'v':                 /* DAC volume */
      case 'V':
	    tmp=atoi(optarg);
	    if ((tmp>-1)&&(tmp<16))
	      voice_volume=tmp;
	    else
	      {
		printf("Invalid DAC voice volume, limits 0-15\n");
		exit(1);
	      }
	    break;
      default:                  /* unrecognized option */
	error_flag = 1;
	break;
      }

  if (error_flag || !argv[optind])
    {
      fprintf(stderr, "Usage: player " USAGE);
      exit(1);
    }

/* get input filename */
  infile_name = argv[optind];

   /* ok, see if sb exists */
   /* set addr and irq to those for your card,
    * factor default is given below              */
   dev.addr = 0x220;
   dev.irq  = 5; //7;
   tmp = sb_probe(&dev);

   if (tmp == GOOD)
       printf("Found SB at address=%d\n",dev.addr);
   else
     {
       printf("No card found\n");
       exit(1);
     }
   printf("SB IRQ should be 5(not detected)...\n");

   /* now "attach" sbpro, set up interupts, etc.. */
   tmp=sb_attach(&dev);
   if (tmp != GOOD)
    {
      printf("Couldnt attach to card, aborting..\n");
      exit(1);
    }

   /* set stereo/mono */
   if (stereo) dsp_set_stereo(TRUE);

   /* set up mixer volumes */
   mixer_get_levels( &mix );
   mix.master.l = mix.master.r = master_volume;
   mix.voc.l = mix.voc.r = voice_volume;
   mixer_set_levels( &mix);
   mixer_get_levels( &mix );

   /* ok, now lets send something to output */
   infile = fopen(infile_name,"rb");
   if (infile == NULL )
     {
       printf("Input file not found, aborting...\n");
       exit(1);
     }

/* Lets see if it is a .VOC file */
   fread(sndbuf, 1, sizeof(vochdr), infile);
   if (strncmp(sndbuf, vochdr, sizeof(vochdr))==0)
     {
       printf("Input file identified as a .VOC file.\n");

       /* now read over some more header stuff which just identifies
	* the version number of the file - we'll assume its ok       */
	fseek(infile, 7L, SEEK_CUR);

	/* next byte should be a 1, indicating data follows */
	/* no support for silence or repeating type of blocks yet */
	if (getc(infile)!=1)
	 {
	   printf("This player doesnt understand .VOC file, aborting.\n");
	   exit(1);
	 }

	 /* next three bytes contain the length of the .VOC file */
	 /* we'll ignore this, just play till we reach EOF       */
	 fseek(infile, 3L, SEEK_CUR);

	 /* next two bytes either have the speed and compression type,
	  * if it is a low speed file, else it will contain speed only
	  * for high speed files */
	  utmp=getc(infile)|(getc(infile)<<8);

	 /* compression types only go up to a numeric type of 5 or so,
	  * and the lowest the MSB of the speed for high speed mode
	  * can be is D2, so if high byte of tmp is greater than 5, say,
	  * it should be safe to assume it is a high speed file. */
	  if (utmp > 0x0500)
	   {
	     vspeed=(unsigned int)(256000000L/(65536L-utmp));
	     printf("High speed file indentified, speed=%u.",vspeed);
	     if (!speed_defined) speed=vspeed;
	   }
	  else
	   {
	     vspeed=(unsigned int)(1000000L/(long)(256-(utmp&0xff)));
	     printf("Low speed file indentified, speed=%u.",speed);
	     if (!speed_defined) speed=vspeed;

	     /* see if file is compressed, we dont know how to handle that*/
	     if (tmp > 0xff)
	       {
		printf("Cant handle compressed files, aborting.\n");
		exit(1);
	       }
	   }
     } /* indentified as a .VOC file */

   /* now play to end of file */
   /* set speed */
   dsp_set_speed(&speed);
   printf("Setting speed to %u.\n",speed);


   pos=ftell(infile);

   do
    {
     tmp=fread(sndbuf, 1, 10000, infile);
     dsp_write(sndbuf, tmp);
     pos=ftell(infile);
     printf("Pos: %ld\n",pos);
     //getch();
    }
   while(!feof(infile));

   /*
   fseek(infile,pos,SEEK_SET);
   do
    {
     tmp=fread(sndbuf, 1, 10000, infile);
     dsp_write(sndbuf, tmp);
    }
   while(!feof(infile));

   fseek(infile,pos,SEEK_SET);
   do
    {
     tmp=fread(sndbuf, 1, 10000, infile);
     dsp_write(sndbuf, tmp);
    }
   while(!feof(infile));
   */
   dsp_flush_dac();
   fclose(infile);

  }
