#include <stdio.h>
#include <dos.h>
#include "sb_c.h"

static void far interrupt (*OldIRQ)();
volatile int DMA_complete;


/* Interrupt handler for DMA complete IRQ from Soundblaster */
static void far interrupt SBHandler()
{
    enable();
    DMA_complete = 1;

    /* Acknowledge the interrupt */
    inportb(DSP_DATA_AVAIL);
    outportb(0x20,0x20);
}

/* Sets the sample rate to be used for digitising or playback */
void Sb_Sample_Rate(unsigned rate)
{
    unsigned char tc;

    tc = (unsigned char)(256 - (1000000/rate));

    writedac(TIME_CONSTANT);  /* Command byte for sample rate */
    writedac(tc);    /* Sample rate time constant */
}

void Sb_Voice(int state)
{
    writedac((state) ? SPEAKER_ON : SPEAKER_OFF);
}

void Sb_OutVoice_DMA(char far *data, unsigned dlen, int stereo)
{
    int t;
    long addr;
    register int i;
    unsigned char im, tm;

    DMA_complete = 0;

    /* Enable interrupts on PIC */
    im = inportb(0x21);
    tm = ~(1 << SbIRQ);
    outportb(0x21,im & tm);
    enable();

    /* Setup DMA */
    dma_reset(SbDMAchan);
    dma_setup(SbDMAchan,data,dlen,1);

    /* Turn on stereo output */
    if(stereo && SbType == SBPro)
	writemixer(0x0e,0x13);

    /* Setup Soundblaster for transfer */
    writedac(DMA_8_BIT_DAC);

    /* Write length */
    writedac(dlen & 0xff);
    writedac(dlen >> 8);
}

void Sb_Init_Voice_DMA(void interrupt (*handler)(void))
{
    /* Insert our IRQ handler into interrupt chain */
    disable();
    OldIRQ = getvect(0x08 + SbIRQ);
    if(!handler)
        handler = SBHandler;

    setvect(0x08 + SbIRQ,handler);
    enable();
}

void Sb_DeInit_Voice_DMA(void)
{
    unsigned char tm;

    /* Turn off stereo output */
    if(SbType == SBPro)
	writemixer(0x0e,0x11);

    /* Restore old IRQ vector */
    disable();
    setvect(0x08 + SbIRQ,OldIRQ);
    tm = inportb(0x21);
    outportb(0x21,tm | (1 << SbIRQ));
    enable();
}

int Sb_DMA_Complete(void)
{
    return DMA_complete;
}

void Sb_Halt_DMA(void)
{
    writedac(HALT_DMA);
}

void Sb_Continue_DMA(void)
{
    writedac(CONTINUE_DMA);
}
