#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <alloc.h>
#include <process.h>
#include "sb.h"

FM_Instrument instrument = {
    0x11, 0x01, 0x8a, 0x40,
    0xf1, 0xf1, 0x11, 0xb3,
    0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00
};

/* Chromatic scale starting from C# */
int notes[12] = {0x16B,0x181,0x198,0x1B0,0x1CA,0x1E5,
                 0x202,0x220,0x241,0x263,0x287,0x2AE};

#define TRUE  1
#define FALSE 0

#define lobyte(X)   (((unsigned char *)&X)[0])
#define hibyte(X)   (((unsigned char *)&X)[1])

int verify_cmf(int fd);
int get_instruments(int fd);
int ReadVarLen(int fd);
int process_event(int fd,int delta);
int load_instrument(int channel,int instrument);

/* Globals */
int num_instruments;
int note_on[22];
char **instrument_table;


void main( int argc, char *argv[] )
{

    if(Sb_Get_Params())
    {
        puts("BLASTER environment variable not set.");
        exit(1);
    }

    Sb_FM_Reset();

    Sb_FM_Set_Voice(0,&instrument);
    Sb_FM_Set_Voice(1,&instrument);
    Sb_FM_Set_Voice(2,&instrument);
    Sb_FM_Set_Voice(3,&instrument);
    Sb_FM_Set_Voice(4,&instrument);
    Sb_FM_Set_Voice(5,&instrument);
    Sb_FM_Set_Voice(6,&instrument);
    Sb_FM_Set_Voice(7,&instrument);
    Sb_FM_Set_Voice(8,&instrument);


    int fh;
    fh = open(argv[1],O_BINARY|O_RDWR);
    get_instruments( fh );
    close(fh);

    printf("There are %d instruments in file\n",num_instruments);

    /*
    Sb_FM_Key_On(0,notes[11],2);   printf("0 - On\n");
    getch();
    Sb_FM_Key_On(1,notes[3],3);    printf("1 - On\n");
    getch();
    Sb_FM_Key_On(2,notes[6],3);    printf("2 - On\n");
    getch();
    Sb_FM_Key_On(3,notes[11],3);   printf("3 - On\n");
    getch();
    Sb_FM_Key_On(4,notes[11],4);   printf("4 - On\n");
    getch();
    Sb_FM_Key_On(5,notes[3],5);    printf("5 - On\n");
    getch();
    Sb_FM_Key_On(6,notes[6],5);    printf("6 - On\n");
    getch();
    Sb_FM_Key_On(7,notes[11],5);   printf("7 - On\n");
    getch();
    Sb_FM_Key_On(8,notes[3],6);   printf("8 - On\n");
    */

    int c;
    for (c=0 ; c<=num_instruments ; c++ )
     {
      load_instrument(0,c);
      Sb_FM_Key_On(0,notes[11],2); printf("%d\n",c);
      getch();
      Sb_FM_Key_Off(0);
     }

    //getch();
    /*
    int c;
    for ( c=0 ; c<=255 ; c+=25 )
     {
      Sb_FM_Key_On(0,notes[11],2);
      Sb_FM_Voice_Volume(0, c);
      printf("%d \n",c);
      getch();
      Sb_FM_Key_Off(0);
     }
    */

    Sb_FM_Key_Off(0);
    Sb_FM_Key_Off(1);
    Sb_FM_Key_Off(2);
    Sb_FM_Key_Off(3);
    Sb_FM_Key_Off(4);
    Sb_FM_Key_Off(5);
    Sb_FM_Key_Off(6);
    Sb_FM_Key_Off(7);
    Sb_FM_Key_Off(8);

    Sb_FM_Reset();
}

int get_instruments(int fd)
{
    int offset;
   // int num_instruments;
    int i;
    int rc;
    int fnum, block, note;
    unsigned char tmp_byte;

    /* get offset of instrument block */
    offset = 0;
    lseek(fd, 0x06, SEEK_SET);
    read(fd, &tmp_byte, 1);
    lobyte(offset) = tmp_byte;
    read(fd, &tmp_byte, 1);
    hibyte(offset) = tmp_byte;

    /* get number of instruments */
    num_instruments = 0;
    lseek(fd, 0x24, SEEK_SET);
    read(fd, &tmp_byte, 1);
    lobyte(num_instruments) = tmp_byte;
    read(fd, &tmp_byte, 1);
    hibyte(num_instruments) = tmp_byte;

    /* allocate space */
    instrument_table = (char **)malloc(sizeof(int *) * num_instruments);

    /* read each instrument */
    lseek(fd, (long)offset, SEEK_SET);
    for (i=0; i< num_instruments; i++)
    {
        /* allocate space */
        instrument_table[i] = (char *)malloc(16);

        /* set instrument characteristics */
        read(fd, instrument_table[i], 16);
    }

    return(0);
}

/*
 * load an instrument from the instrument table into the SoundBlaster
 */
int load_instrument(int channel,int instrument)
{
    int rc;

    /* error check! */
    if ((channel <0) || (channel >= 9))
        return(-1);//<<!!

    /* abort instrument if being loaded */
    if (note_on[channel])
	Sb_FM_Key_Off(channel);

    /* set instrument characteristics */
    Sb_FM_Set_Voice(channel,(FM_Instrument *)instrument_table[instrument]);
    return(0);
}
