#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <process.h>
#include <alloc.h>
#include <fcntl.h>

/* Card parameters */
unsigned SbIOaddr;
unsigned SbIRQ;
unsigned SbDMAchan;
int	SbType;

char ReadAdl( void )
{
 return(inportb(0x388));
}

void WriteAdl( char addr, char data )
{
 outportb(0x388,addr); // write address
 inportb(0x388);       // then read 7 times
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);

 outportb(0x389,data); // write data
 inportb(0x388);       // then read 35 times
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);

 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);

 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);

 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
}

unsigned IOaddr;
extern "C" int InitSB( void );

void main ( int argc, char *argv[] )
{
 SbIOaddr = 0x220;

 long far *tim,t1,t2;
 tim = (long far *)MK_FP(0,0x046C);
 /*
 |   According to the AdLib manual, the 'official' method of checking for a
 |   sound card is as follows:
 |
 |      1)  Reset both timers by writing 60h to register 4.
 |      2)  Enable the interrupts by writing 80h to register 4.  NOTE: this
 |          must be a separate step from number 1.
 |      3)  Read the status register (port 388h).  Store the result.
 |      4)  Write FFh to register 2 (Timer 1).
 |      5)  Start timer 1 by writing 21h to register 4.
 |      6)  Delay for at least 80 microseconds.
 |      7)  Read the status register (port 388h).  Store the result.
 |      8)  Reset both timers and interrupts (see steps 1 and 2).
 |      9)  Test the stored results of steps 3 and 7 by ANDing them
 |          with E0h.  The result of step 3 should be 00h, and the
 |          result of step 7 should be C0h.  If both are correct, an
 |          AdLib-compatible board is installed in the computer.
 */
 char st1,st2;

 WriteAdl(4,0x60); // reset both timers
 WriteAdl(4,0x80); // enable the interrupts
 st1 = ReadAdl();  // read status reg & store result
 WriteAdl(2,0xFF); // FFh to Timer 1
 WriteAdl(4,0x21); // start Timer 1
 delay(1);         // delay, > 80 microsec.
 st2 = ReadAdl();  // read status reg & store result
 WriteAdl(4,0x60); // reset both timers
 WriteAdl(4,0x80); // and interrupts
 st1&=0xE0;        // AND results
 st2&=0xE0;        // with E0h
 if (st1==0 && st2==0xC0)
  printf("AdLib-compatible board detected\r\n");
 else
  printf("AdLib-compatible board not detected\r\n");

 unsigned xa;
 unsigned van=0;

 for ( xa=0x200 ; xa<=0x280 ; xa+=0x20 )
  {
   IOaddr = xa;
   if (InitSB()==0)
    { van=1; break; }
  }

 if (van)
  {
   IOaddr+=0x10;
   if (InitSB()==0)
    van=2;
   IOaddr-=0x10;
  }

 if (van==2)
  printf("SoundBlaster Pro compatible board detected on port %xh:%xh\r\n",IOaddr,0x10+IOaddr);
 else
  if (van==1)
   printf("SoundBlaster compatible board detected on port %xh\r\n",IOaddr);
  else
   printf("SoundBlaster/SoundBlaster Pro compatible board not detected\r\n");


}

