#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <process.h>
#include <alloc.h>
#include <fcntl.h>

#include "sb.h"

/* Card parameters */
unsigned SbIOaddr;
unsigned SbIRQ;
unsigned SbDMAchan;
int	SbType;

extern void WriteFM(int chip, int addr, unsigned char data);

#define __CPPARGS ...

volatile int T_lej = 0;
void interrupt handler(__CPPARGS);
void interrupt ( *oldhandler)(__CPPARGS);

static FM_Instrument instrument = {
    0x11, 0x01, 0x8a, 0x40,
    0xf1, 0xf1, 0x11, 0xb3,
    0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00
};

//                 C#    D     D#     E    F     F#
int notes[12] = {0x16B,0x181,0x198,0x1B0,0x1CA,0x1E5,
		 0x202,0x220,0x241,0x263,0x287,0x2AE};
//                 G     G#    A     A#     B    C

// hangok : 0   1   2    3   4   5    6   7    8   9   A   B
//          C#  D   D#   E   F   F#   G   G#   A   A#  B   C


struct FiledNote
 {
  char octave,ns;
  unsigned dur;
 } far *fn[5];

//float factor[11] = { 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0 };

char ReadAdl( void )
{
 return(inportb(0x388));
}

void WriteAdl( char addr, char data )
{
 outportb(0x388,addr); // write address
 inportb(0x388);       // then read 7 times
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);

 outportb(0x389,data); // write data
 inportb(0x388);       // then read 35 times
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);

 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);

 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);

 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
 inportb(0x388);
}

unsigned IOaddr;
extern "C" int InitSB( void );

void main ( int argc, char *argv[] )
{
 SbIOaddr = 0x220;

 long far *tim,t1,t2;
 tim = (long far *)MK_FP(0,0x046C);
 /*
 |   According to the AdLib manual, the 'official' method of checking for a
 |   sound card is as follows:
 |
 |      1)  Reset both timers by writing 60h to register 4.
 |      2)  Enable the interrupts by writing 80h to register 4.  NOTE: this
 |          must be a separate step from number 1.
 |      3)  Read the status register (port 388h).  Store the result.
 |      4)  Write FFh to register 2 (Timer 1).
 |      5)  Start timer 1 by writing 21h to register 4.
 |      6)  Delay for at least 80 microseconds.
 |      7)  Read the status register (port 388h).  Store the result.
 |      8)  Reset both timers and interrupts (see steps 1 and 2).
 |      9)  Test the stored results of steps 3 and 7 by ANDing them
 |          with E0h.  The result of step 3 should be 00h, and the
 |          result of step 7 should be C0h.  If both are correct, an
 |          AdLib-compatible board is installed in the computer.
 */
 char st1,st2;

 WriteAdl(4,0x60);
 WriteAdl(4,0x80);
 st1 = ReadAdl();
 WriteAdl(2,0xFF);
 WriteAdl(4,0x21);
 delay(1);
 st2 = ReadAdl();
 WriteAdl(4,0x60);
 WriteAdl(4,0x80);
 st1&=0xE0;
 st2&=0xE0;
 if (st1==0 && st2==0xC0)
  printf("AdLib-compatible board detected\r\n");
 else
  printf("AdLib-compatible board not detected\r\n");

 unsigned xa;
 unsigned van=0;

 for ( xa=0x200 ; xa<=0x280 ; xa+=0x20 )
  {
   IOaddr = xa;
   if (InitSB()==0)
    { van=1; break; }
  }

 if (van)
  printf("SoundBlaster-compatible board detected on port %xh\r\n",IOaddr);
 else
  printf("SoundBlaster-compatible board not detected\r\n");
 /*
 IOaddr = 0x220;
 if (InitSB()==0)
  printf("SoundBlaster-compatible board detected\r\n");
 else
  printf("SoundBlaster-compatible board not detected\r\n");
 */
}

void interrupt handler(__CPPARGS)
{
 int val;

 val=inp(SbIOaddr);
 if ( val & (1<<7) )
  {
   T_lej++;
   WriteFM(0, 4,1<<7);
   WriteFM(0, 3,0);
   WriteFM(0, 4,0);
   WriteFM(0, 4,0|2 ); //Reset flags for timers & start T2

   asm MOV AL,0x20
   asm OUT 0x20,AL // send end-of-int
  }
 else
  oldhandler();
}