#include <alloc.h>
#include <stdio.h>
#include <dos.h>

#define MAGIC       0x7746
#define CHECK_INST  0x8201
#define RESPLAY     0x2f
#define SETUP       0x8210
#define PLAYER      0x8200
#define SUCCESS     0x1000
#define FAILED      0x2000
#define PLAY        0
#define SPEAKER     4
#define LPT1        0
#define LPT2        1
//#define SAMPLE      1

int ResPlayPresent = 0;
unsigned RPdevice,RPspeed;

//------------------------//

int ResPlayInstalled( void );
int ResPlaySetup( unsigned device, unsigned speed ); // note:mode is omitted !
int ResPlayPlaysample( char huge * sample, long size );
int ResPlayRatePlaysample( char huge *sample, long size, unsigned srate );

//------------------------//

int ResPlayInstalled( void )
{
 REGS inregs,outregs;

 inregs.x.ax = CHECK_INST;
 int86(RESPLAY,&inregs,&outregs);

 if (outregs.x.ax==MAGIC)
  ResPlayPresent = 1;
 return( (outregs.x.ax==MAGIC) ? 0 : -1 );
}

int ResPlaySetup( unsigned device, unsigned speed )
{                                    // give speed in Hz,^^^ we'll convert it
 if ( !ResPlayPresent )
  return(-1);

 REGS inregs,outregs;

 inregs.x.ax = SETUP;
 inregs.h.cl = PLAY; //mode would stand here,but no need(we only want to play)
 inregs.h.bl = device;
 inregs.h.bh = (speed/250);
 int86(RESPLAY,&inregs,&outregs);

 // Save parameters for later
 RPdevice = device;
 RPspeed = speed;

 return( (outregs.x.ax==SUCCESS) ? 0 : -1 );
}

int ResPlayPlaysample( char huge * sample, long size )
{
 if ( !ResPlayPresent )
  return(-1);

 REGS inregs,outregs;
 unsigned len_msb,len_lsb;

 len_msb = (size/65536);
 len_lsb = size - len_msb*(size/65536);

 inregs.x.ax = PLAYER;
 inregs.x.dx = FP_SEG(sample);
 inregs.x.di = FP_OFF(sample);
 inregs.x.cx = len_msb;
 inregs.x.bx = len_lsb;
 int86(RESPLAY,&inregs,&outregs);

 return( (outregs.x.ax==SUCCESS) ? 0 : -1 );
}

int ResPlayRatePlaysample( char huge *sample, long size, unsigned srate )
{
 if ( !ResPlayPresent )
  return(-1);

 REGS inregs,outregs;
 unsigned len_msb,len_lsb;

 // Set only sample rate - for the others, use the saved values
 ResPlaySetup( RPdevice, srate );

 len_msb = (size/65536);
 len_lsb = size - len_msb*(size/65536);

 inregs.x.ax = PLAYER;
 inregs.x.dx = FP_SEG(sample);
 inregs.x.di = FP_OFF(sample);
 inregs.x.cx = len_msb;
 inregs.x.bx = len_lsb;
 int86(RESPLAY,&inregs,&outregs);

 return( (outregs.x.ax==SUCCESS) ? 0 : -1 );
}

