
PAGE  60,132

;
;								         
;			        RESPLAY				         
;								         
;      Created:   23-Dec-90					         
;      Passes:    5	       Analysis Flags on: H		         
;								         
;

.286c

REL_OFF_2F		EQU	0BCH	    ; 0x2F * 4 -- rel. offs addr of int 2F
REL_SEG_2F		EQU	0BEH	    ; 0x2F * 4 + 2  -- rel. seg addr if int 2F
DATA_3E		EQU	80H	    ;		; (6441:0080=0)
  
SEG_A		SEGMENT
		ASSUME	CS:SEG_A, DS:SEG_A
  
  
		ORG	100h
  
resplay		PROC	FAR
  
start:
		JMP	LOC_22			; (072D)
DATA_4		DB	0			; Data table (indexed access)
DATA_5		DB	0
		DB	0
DATA_6		DB	0
DATA_7		DW	0
DATA_8		DW	0
DATA_9		DB	0
		DB	0, 0FBH, 9CH, 3DH, 0, 82H
		DB	74H, 61H, 3DH, 1, 82H, 74H
		DB	19H, 3DH, 2, 82H, 75H, 3
		DB	0E9H, 8FH, 0, 3DH, 10H, 82H
		DB	74H, 12H, 9AH
SAVE_OFF_2F		DW	0  ; Saved offs of int 2F
SAVE_SEG_2F		DW	0  ; Saved seg of int 2F
		DB	0CAH, 2, 0
LOC_1:
		POP	CX
		RETF	2			; Return far
;---------------------------------------------------------
		DB	0B8H, 46H, 77H, 0EBH, 0F7H
DATA_12		DB	0
LOC_2:
		PUSH	ES
		PUSH	DS
		PUSHA				; Save all regs
		PUSH	CS
		POP	DS
		CMP	BL,4
		JA	LOC_3			; Jump if above
		MOV	DATA_5,BL		; (6441:0104=0)
		CALL	SUB_2			; (021D)
		CMP	BH,14H
		JB	LOC_3			; Jump if below
		CMP	BH,0A0H
		JA	LOC_3			; Jump if above
		MOV	DATA_9,BH		; (6441:010B=0)
		CMP	CL,1
		JA	LOC_3			; Jump if above
		MOV	DATA_12,CL		; (6441:0137=0)
		MOV	DATA_4,1		; (6441:0103=0)
		POPA				; Restore all regs
		POP	DS
		POP	ES
		MOV	AX,1000H
		JMP	SHORT LOC_1		; (012E)
LOC_3:
		POPA				; Restore all regs
		POP	DS
		POP	ES
		MOV	AX,2000H
		JMP	SHORT LOC_1		; (012E)
		DB	6, 1EH, 60H, 0EH, 1FH, 80H
		DB	3EH, 3, 1, 1, 75H, 26H
		DB	89H, 0EH, 7, 1, 89H, 1EH
		DB	9, 1, 89H, 3EH, 13H, 2
		DB	89H, 16H, 11H, 2, 8AH, 1EH
		DB	0BH, 1, 8AH, 26H, 6, 1
		DB	0A0H, 37H, 1, 0E8H, 0BDH, 0
		DB	61H, 1FH, 7, 0B8H, 0, 10H
		DB	0EBH, 87H
LOC_4:
		POPA				; Restore all regs
		POP	DS
		POP	ES
		MOV	AX,2000H
		JMP	LOC_1			; (012E)
		DB	6, 0B8H, 0, 0, 8EH, 0C0H
		DB	2EH, 0A1H, 27H, 1, 26H, 0A3H
		DB	0BCH, 0, 2EH, 0A1H, 29H, 1
		DB	26H, 0A3H, 0BEH, 0, 7, 0B8H
		DB	0, 10H, 0E9H, 61H, 0FFH
DATA_13		DW	27AH
DATA_14		DW	278H
		DB	31H, 78H, 3
		DB	'LPT1   $'
		DB	'2x'
		DB	2
		DB	'LPT2   $'
		DB	'P'
		DB	0, 3
		DB	'PROTO  $'
		DB	'V'
		DB	0BCH, 3
		DB	'LPT3   $'
		DB	'S'
		DB	0, 0
		DB	'SPEAKER$$'
OLDINT8_OFF		DB	0, 0
OLDINT8_SEG		DW	0
OLDINT9_OFF		DW	0
OLDINT9_SEG		DW	0
DATA_19		DW	0
DATA_20		DW	0
DATA_21		DB	0
DATA_22		DB	0
DATA_23		DW	0
		DB	0, 0, 0, 0

resplay		ENDP

;
;			       SUBROUTINE
;

SUB_2		PROC	NEAR
		MOV	DI,1D1H
		MOV	AL,DATA_5		; (6441:0104=0)
		MOV	BL,0BH
		MUL	BL			; ax = reg * al
		ADD	DI,AX
		INC	DI
		MOV	DX,[DI]
		CMP	DX,0
		JE	LOC_5			; Jump if equal
		MOV	DATA_6,1		; (6441:0106=0)
		MOV	DATA_14,DX		; (6441:01CF=278H)
		ADD	DX,2
		MOV	DATA_13,DX		; (6441:01CD=27AH)
		RETN
LOC_5:
		MOV	DATA_6,0		; (6441:0106=0)
		RETN
SUB_2		ENDP

		DB	0C3H, 0C3H, 0, 0, 0EDH, 4
		DB	0, 1, 0BDH, 3, 1, 1
		DB	0FBH, 3, 1, 0, 72H, 4
		DB	24H, 24H

;
;			       SUBROUTINE
;

SUB_3		PROC	NEAR
		MOV	BYTE PTR DATA_26,0	; (6441:0543=0)
		MOV	CX,AX
		MOV	AX,12A0H
		DIV	BL			; al, ah rem = ax/reg
		CMP	AL,4FH			; 'O'
		JLE	LOC_6			; Jump if < or =
		CMP	CL,0
		JNE	LOC_6			; Jump if not equal
		CMP	CH,0
		JNE	LOC_6			; Jump if not equal
		SHR	AL,1			; Shift w/zeros fill
		MOV	BYTE PTR DATA_26,2	; (6441:0543=0)
LOC_6:
		MOV	DATA_22,AL		; (6441:0216=0)
		MOV	DI,24AH
LOC_7:
		MOV	AX,[DI]
		MOV	SI,[DI+2]
		CMP	AL,24H			; '$'
		JE	LOC_8			; Jump if equal
		CMP	AX,CX
		JE	LOC_9			; Jump if equal
		ADD	DI,4
		JMP	SHORT LOC_7		; (0283)
LOC_8:
		MOV	AL,1
		RETN
LOC_9:
		MOV	DATA_23,SI		; (6441:0217=0)
		PUSH	ES

                ;
                ; Now we save the curr Int8 and Int9...
                ;

		MOV	AH,35H			; '5'
		MOV	AL,8
		INT	21H			; DOS Services  ah=function 35h
						;  get intrpt vector al in es:bx
		MOV	WORD PTR OLDINT8_OFF,BX	; (6441:0209=0)
		MOV	OLDINT8_SEG,ES		; (6441:020B=0)
		POP	ES
		PUSH	ES
		MOV	AH,35H			; '5'
		MOV	AL,9
		INT	21H			; DOS Services  ah=function 35h
						;  get intrpt vector al in es:bx
		MOV	OLDINT9_OFF,BX		; (6441:020D=0)
		MOV	OLDINT9_SEG,ES		; (6441:020F=0)
		POP	ES
		IN	AL,21H			; port 21H, 8259-1 int IMR
		MOV	DATA_21,AL		; (6441:0215=0)
		CLI				; Disable interrupts
		MOV	AL,0FFH
		OUT	21H,AL			; port 21H, 8259-1 int comands
		STI				; Enable interrupts
		PUSH	DS
		MOV	DX,DATA_23		; (6441:0217=0)
		PUSH	DS
                ;
                ; ...and replace int with out own, while playing...
                ;
		POP	DS
		MOV	AH,25H			; '%'
		MOV	AL,8
		INT	21H			; DOS Services  ah=function 25h
						;  set intrpt vector al to ds:dx
		POP	DS
		PUSH	DS
		MOV	DX,38BH
		PUSH	DS
		POP	DS
		MOV	AH,25H			; '%'
		MOV	AL,9
		INT	21H			; DOS Services  ah=function 25h
						;  set intrpt vector al to ds:dx
		POP	DS
		MOV	BX,DATA_20		; (6441:0213=0)
		MOV	DATA_25,BX		; (6441:03BB=0)
		MOV	AX,DATA_19		; (6441:0211=0)
		MOV	DATA_24,AX		; (6441:03B9=0)
		DB	2EH			; CS:
		MOV	AL,34H			; '4'
		OUT	43H,AL			; port 43H, 8253 wrt timr mode
		MOV	AL,CS:DATA_22		; (6441:0216=0)
		OUT	40H,AL			; port 40H, 8253 timer 0 clock
		DB	2EH			; CS:
		MOV	AL,0
		OUT	40H,AL			; port 40H, 8253 timer 0 clock
		DB	2EH			; CS:
		MOV	AL,90H
		OUT	43H,AL			; port 43H, 8253 wrt timr mode
		IN	AL,61H			; port 61H, 8255 port B, read
		OR	AL,3
		OUT	61H,AL			; port 61H, 8255 B - spkr, etc
		CLI				; Disable interrupts
		MOV	AL,0FEH
		OUT	21H,AL			; port 21H, 8259-1 int comands
						;  al = 0FEH, IRQ0 (timer) only
		STI				; Enable interrupts
		MOV	DX,DATA_13		; (6441:01CD=27AH)
		MOV	AL,2
		OUT	DX,AL			; port 27AH, printer-3 control
		NOP
		NOP
		NOP
		NOP
		MOV	AL,0
		OUT	DX,AL			; port 27AH, printer-3 control
		NOP
		NOP
		NOP
		NOP
		XOR	CX,CX			; Zero register
		MOV	BP,0
LOC_10:
		OR	BP,BP			; Zero ?
		JZ	LOC_10			; Jump if zero
		CLI				; Disable interrupts
		MOV	AL,0FFH
		OUT	21H,AL			; port 21H, 8259-1 int comands
		STI				; Enable interrupts
		IN	AL,61H			; port 61H, 8255 port B, read
		AND	AL,0FCH
		OUT	61H,AL			; port 61H, 8255 B - spkr, etc
		DB	2EH			; CS:
		MOV	AL,34H			; '4'
		OUT	43H,AL			; port 43H, 8253 wrt timr mode
		DB	2EH			; CS:
		MOV	AX,0
		OUT	40H,AL			; port 40H, 8253 timer 0 clock
		MOV	AL,AH
		OUT	40H,AL			; port 40H, 8253 timer 0 clock
		DB	2EH			; CS:
		MOV	AL,0B6H
		OUT	43H,AL			; port 43H, 8253 wrt timr mode
		DB	2EH			; CS:
		MOV	AX,533H
		OUT	42H,AL			; port 42H, 8253 timer 2 spkr
		MOV	AL,AH
		OUT	42H,AL			; port 42H, 8253 timer 2 spkr
		PUSH	CS
		PUSH	CS
		POP	DS
		POP	ES
		PUSH	DS

                ;
                ; ...when done , we restore Int8 & Int9
                ;
		MOV	DX,WORD PTR OLDINT8_OFF	; (6441:0209=0)
		MOV	DS,OLDINT8_SEG		; (6441:020B=0)
		MOV	AH,25H			; '%'
		MOV	AL,8
		INT	21H			; DOS Services  ah=function 25h
						;  set intrpt vector al to ds:dx
		POP	DS
		PUSH	DS
		MOV	DX,OLDINT9_OFF		; (6441:020D=0)
		MOV	DS,OLDINT9_SEG		; (6441:020F=0)
		MOV	AH,25H			; '%'
		MOV	AL,9
		INT	21H			; DOS Services  ah=function 25h
	        				;  set intrpt vector al to ds:dx
                ;--------------------------------------------

		POP	DS
		CLI				; Disable interrupts
		MOV	AL,DATA_21		; (6441:0215=0)
		OUT	21H,AL			; port 21H, 8259-1 int comands
		STI				; Enable interrupts
		STI				; Enable interrupts
		INT	9			; Keyboard
		MOV	AH,1
		INT	16H			; Keyboard i/o  ah=function 01h
						;  get status, if zf=0  al=char
		XOR	AL,AL			; Zero register
		RETN
SUB_3		ENDP


;
;
;			External Entry Point - Int 9
;
;

INT_09H_ENTRY	PROC	FAR
		MOV	AL,0ADH
		CALL	SUB_4			; (03AC)
		CLI				; Disable interrupts

LOCLOOP_11:
		IN	AL,64H			; port 64H, keyboard status
		TEST	AL,2
		LOOPNZ	LOCLOOP_11		; Loop if zf=0, cx>0

		IN	AL,60H			; port 60H, keybd scan or sw1
		STI				; Enable interrupts
		TEST	AL,80H
		JNZ	LOC_12			; Jump if not zero
		MOV	BP,2
LOC_12:
		MOV	AL,0AEH
		CALL	SUB_4			; (03AC)
		DB	2EH			; CS:
		MOV	AL,20H			; ' '
		OUT	20H,AL			; port 20H, 8259-1 int command
						;  al = 20H, end of interrupt
		IRET				; Interrupt return
INT_09H_ENTRY	ENDP


;
;			       SUBROUTINE
;

SUB_4		PROC	NEAR
		PUSH	AX
		CLI				; Disable interrupts

LOCLOOP_13:
		IN	AL,64H			; port 64H, keyboard status
		TEST	AL,2
		LOOPNZ	LOCLOOP_13		; Loop if zf=0, cx>0

		POP	AX
		OUT	64H,AL			; port 64H, kybd cntrlr functn
						;  al = 0ADH, disable keyboard
		STI				; Enable interrupts
		RETN
SUB_4		ENDP

DATA_24		DW	0
DATA_25		DW	0
		DB	8BH, 1EH, 0BBH, 3, 8BH, 0EH
		DB	0B9H, 3, 8EH, 0C1H, 26H, 8AH
		DB	7, 2EH, 8BH, 16H, 0CFH, 1
		DB	0EEH, 43H, 89H, 1EH, 0BBH, 3
		DB	75H, 4, 81H, 0C1H, 0, 10H
		DB	89H, 0EH, 0B9H, 3, 0FFH, 0EH
		DB	9, 1, 75H, 10H, 83H, 3EH
		DB	7, 1, 0, 74H, 6, 0FFH
		DB	0EH, 7, 1, 0EBH, 3
LOC_14:
		MOV	BP,1
LOC_15:
		DB	2EH			; CS:
		MOV	AL,20H			; ' '
		OUT	20H,AL			; port 20H, 8259-1 int command
						;  al = 20H, end of interrupt
		IRET				; Interrupt return
		DB	8BH, 1EH, 0BBH, 3, 8BH, 0EH
		DB	0B9H, 3, 8EH, 0C1H, 8BH, 16H
		DB	0CDH, 1, 0B0H, 1, 0EEH, 90H
		DB	90H, 90H, 90H, 4AH, 0ECH, 42H
		DB	0D0H, 0E0H, 24H, 0F0H, 88H, 0C4H
		DB	0B0H, 5, 0EEH, 90H, 90H, 90H
		DB	90H, 4AH, 0ECH, 0D0H, 0E8H, 0D0H
		DB	0E8H, 0D0H, 0E8H, 24H, 0FH, 2
		DB	0C4H, 26H, 88H, 7, 2EH, 8BH
		DB	16H, 0CFH, 1, 0EEH, 8BH, 16H
		DB	0CDH, 1, 0B0H, 2, 0EEH, 90H
		DB	90H, 90H, 90H, 0B0H, 0, 0EEH
		DB	90H, 90H, 90H, 90H, 43H, 89H
		DB	1EH, 0BBH, 3, 75H, 4, 81H
		DB	0C1H, 0, 10H, 89H, 0EH, 0B9H
		DB	3, 0FFH, 0EH, 9, 1, 75H
		DB	10H, 83H, 3EH, 7, 1, 0
		DB	74H, 6, 0FFH, 0EH, 7, 1
		DB	0EBH, 3
LOC_16:
		MOV	BP,1
LOC_17:
		DB	2EH			; CS:
		MOV	AL,20H			; ' '
		OUT	20H,AL			; port 20H, 8259-1 int command
						;  al = 20H, end of interrupt
		IRET				; Interrupt return
;----------------------------------------------------------------------
		DB	8BH, 1EH, 0BBH, 3, 8BH, 0EH
		DB	0B9H, 3, 8EH, 0C1H, 8BH, 16H
		DB	0CDH, 1, 0B0H, 1, 0EEH, 90H
		DB	90H, 90H, 90H, 4AH, 0ECH, 42H
		DB	0D0H, 0E0H, 24H, 0F0H, 88H, 0C4H
		DB	0B0H, 5, 0EEH, 90H, 90H, 90H
		DB	90H, 4AH, 0ECH, 0D0H, 0E8H, 0D0H
		DB	0E8H, 0D0H, 0E8H, 24H, 0FH, 2
		DB	0C4H, 26H, 88H, 7, 0F6H, 0D0H
		DB	0D0H, 0E8H, 0D0H, 0E8H, 0FEH, 0C0H
		DB	0E6H, 42H, 8BH, 16H, 0CDH, 1
		DB	0B0H, 2, 0EEH, 90H, 90H, 90H
		DB	90H, 0B0H, 0, 0EEH, 90H, 90H
		DB	90H, 90H, 43H, 89H, 1EH, 0BBH
		DB	3, 75H, 4, 81H, 0C1H, 0
		DB	10H, 89H, 0EH, 0B9H, 3, 0FFH
		DB	0EH, 9, 1, 75H, 10H, 83H
		DB	3EH, 7, 1, 0, 74H, 6
		DB	0FFH, 0EH, 7, 1, 0EBH, 3
LOC_18:
		MOV	BP,1
LOC_19:
		DB	2EH			; CS:
		MOV	AL,20H			; ' '
		OUT	20H,AL			; port 20H, 8259-1 int command
						;  al = 20H, end of interrupt
		IRET				; Interrupt return
;-----------------------------------------------------------------
		DB	8BH, 1EH, 0BBH, 3, 8BH, 0EH
		DB	0B9H, 3, 8EH, 0C1H, 26H, 8AH
		DB	7, 0F6H, 0D0H, 0D0H, 0E8H, 0D0H
		DB	0E8H, 0FEH, 0C0H, 0E6H, 42H, 2EH
		DB	80H, 36H, 43H, 5, 1, 2EH
		DB	80H, 3EH, 43H, 5, 3, 74H
		DB	2BH, 43H, 89H, 1EH, 0BBH, 3
		DB	75H, 4, 81H, 0C1H, 0, 10H
		DB	89H, 0EH, 0B9H, 3, 0FFH, 0EH
		DB	9, 1, 75H, 10H, 83H, 3EH
		DB	7, 1, 0, 74H, 6, 0FFH
		DB	0EH, 7, 1, 0EBH, 3
LOC_20:
		MOV	BP,1
LOC_21:
		DB	2EH			; CS:
		MOV	AL,20H			; ' '
		OUT	20H,AL			; port 20H, 8259-1 int command
						;  al = 20H, end of interrupt
		IRET				; Interrupt return

;------------------------------------------------------------------
		DB	2EH, 0B0H, 20H, 0E6H, 20H, 0CFH
DATA_26		DB	0
MSG_COPYRIGHT		DB	0AH, 0DH, '***** RESPLAY v1.00   '
		DB	' (C) Mark J Cox 1990', 0AH, 0DH, ' '
		DB	'     Resident Sound Sampling Uti'
		DB	'lities', 0AH, 0DH, 0AH, 0DH, '$'
MSG_STATUS_INFO	DB	'Type RESPLAY /D to deinstall', 0AH
		DB	0DH, 'Installed as functions &820'
		DB	'1-&8210 on Interrupt &2F', 0AH, 0DH
		DB	'$'
MSG_ALREADY_INST		DB	'RESPLAY is already installed. Ty'
		DB	'pe RESPLAY /D to deinstall', 0AH
		DB	0DH, '$'
MSG_DEINST_OK		DB	'RESPLAY deinstalled. (Cannot fre'
		DB	'e memory)', 0AH, 0DH, '$'
MSG_DEINST_ERR2		DB	'Error: Resplay cannot deinstall.'
		DB	' This should not ever happen', 0AH
		DB	0DH, 'so I suggest you reboot!', 0AH
		DB	0DH, '$'
MSG_HELP	DB	'Usage: Type RESPLAY to Install, '
		DB	'RESPLAY /d to Deinstall', 0AH, 0DH
		DB	'$'
MSG_DEINST_ERR		DB	'You cannot deinstall RESPLAY, yo'
		DB	'u have not installed it yet!', 0AH
		DB	0DH, '$'
;---------------------------------------------------------------
LOC_22:
		MOV	DX,OFFSET MSG_COPYRIGHT	; (6441:0544=0AH)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		CMP	BYTE PTR DS:DATA_3E,0	; (6441:0080=0)
		JE	LOC_24			; Jump if equal
		MOV	SI,80H
		MOV	CL,[SI]
		INC	SI
LOC_23:
		MOV	AL,[SI]
		INC	SI
		CMP	AL,20H			; ' '
		JE	LOC_23			; Jump if equal
		CMP	AL,0DH
		JE	LOC_24			; Jump if equal
		CMP	AL,2FH			; '/'
		JE	LOC_23			; Jump if equal
		CMP	AL,64H			; 'd'
		JE	LOC_25			; Jump if equal
		CMP	AL,44H			; 'D'
		JE	LOC_25			; Jump if equal
		MOV	DX,OFFSET MSG_HELP	; (6441:06B4=55H)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	AX,4C01H
		INT	21H			; DOS Services  ah=function 4Ch
						;  terminate with al=return code
LOC_24:
		MOV	AX,8201H
		INT	2FH			; Multiplex/Spooler al=func 01h
						;  Check installed status
		CMP	AX,7746H                ; are we already in mem?
		JNE	LOC_28			; No - Jump
		MOV	DX,OFFSET MSG_ALREADY_INST ; Yes - Display
		MOV	AH,9                       ; message
		INT	21H			;

		MOV	AX,4C01H                ; Well,then let's
		INT	21H			; terminate, return value : 1

LOC_25:
		MOV	AX,8201H
		INT	2FH			; Multiplex/Spooler al=func 01h
						;  Check installed status
		CMP	AX,7746H                ; are we in mem?
		JE	LOC_26			; Yes - Jump
		MOV	DX,OFFSET MSG_DEINST_ERR ; No - display message:
		MOV	AH,9                     ; "Error deinstalling"
		INT	21H		         ; ...

		MOV	AX,4C01H                ; ...and terminate
		INT	21H			; return value : 1

LOC_26:
		MOV	AX,8202H
		INT	2FH			; Multiplex/Spooler al=func 02h
						;  Deinstall it
		CMP	AX,1000H                ; Is it OK?
		JE	LOC_27			; Yes - jump
		MOV	DX,OFFSET MSG_DEINST_ERR2 ; No - display message...
		MOV	AH,9
		INT	21H

		MOV	AX,4C01H                ; ...and terminate
		INT	21H			; return value : 1

LOC_27:
		MOV	DX,OFFSET MSG_DEINST_OK	; Deinstall OK - Display
		MOV	AH,9                    ; message...
		INT	21H

		MOV	AX,4C00H                ; ...and terminate :
		INT	21H			; return value : 0

LOC_28:
		MOV	DX,OFFSET MSG_STATUS_INFO ; ... We're going to install
		MOV	AH,9                      ; display message
		INT	21H

		CLI				; Disable interrupts
		PUSH	CS
		POP	DS
		MOV	AX,0
		MOV	ES,AX                   ; Mov ES,0
		MOV	AX,ES:REL_OFF_2F	; Save...
		MOV	SAVE_OFF_2F,AX		; ...int 2F off.
		MOV	AX,ES:REL_SEG_2F	; Save...
		MOV	SAVE_SEG_2F,AX		; ...int 2F seg

		MOV	AX,CS                   ; AX <- CS
		MOV	ES:REL_SEG_2F,AX	; Set our own start
		MOV	AX,10DH                 ; seg. and offs: 0x10D
		MOV	ES:REL_OFF_2F,AX	; in int 2F
		MOV	DX,544H                 ;
		INT	27H			; Terminate & stay resident
  
SEG_A		ENDS
  
  
  
		END	START
