
#include "reg_code.h"
#include "romcheck.h"


void spec_code_tomb ( unsigned long *smt , unsigned long *ott )
{
 unsigned long sumct[11];
 int c;

 for (c=0; c<=4 ; c++ )
  sumct[c]=(((smt[c]+c) ^ (0x96C0) ) ^ S_VER_CODE) ^ 0xBEAD;

 for (c=5; c<=9 ; c++ )
  sumct[c]=(((smt[c-5]+3*c+7) ^ (0x96CE) ) ^ S_VER_CODE) ^ 0xBEAD;

 ott[0]=sumct[4]; // x
 ott[1]=sumct[0]; // x
 ott[2]=sumct[8];
 ott[3]=sumct[3]; // x
 ott[4]=sumct[9];
 ott[5]=sumct[1]; // x
 ott[6]=sumct[7];
 ott[7]=sumct[2]; // x
 ott[8]=sumct[6];
 ott[9]=sumct[5];

 ott[9]=ott[9] - (ott[9] % 10);
 for ( c=0 ; c<=8 ; c++ ) ott[9] += ott[c] % 10;
}

void spec_decode_tomb ( unsigned long *smt , unsigned long *ott )
{
 unsigned long ot[11];
 int c;

 ot[4]=smt[0];
 ot[0]=smt[1];
 ot[8]=smt[2];
 ot[3]=smt[3];
 ot[9]=smt[4];
 ot[1]=smt[5];
 ot[7]=smt[6];
 ot[2]=smt[7];
 ot[6]=smt[8];
 ot[5]=smt[9];

 for (c=0; c<=4+5 ; c++ )
  ott[c]=( (((ot[c]^0xBEAD)^S_VER_CODE) ^ (0x96C0) )-c );
}
