/*
 * -------------------------------------<NOWPWM interface (PWMSPEAK.C)>--------
 * Created by Ern Bcs, using Turbo C++ 1.00 (large model)
 */

#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>

#define BYTE unsigned char
typedef struct {
  int  Sign;		/* FirstByte sign */
  BYTE minor, major;	/* ? Version number ? */
  int (far *Entry)(void);
} SpeakInit;
#define BUFFLEN 254
typedef struct {
  BYTE length;
  BYTE buff[BUFFLEN];
} SpeakBuff;
typedef struct {
  int female;
  int treble;
  int volume;
  int pitch;
  int speed;
  int unknow[2];
} SpeakParam;
SpeakInit  far *Si;
SpeakBuff  far *Sb;
SpeakParam far *Sp;

struct REGPACK rp;

int CheckSpeak(void)
{
  rp.r_ax = 0xfbfb;	/* FirstByte signon */
  intr(0x2f, &rp);
  if (rp.r_ax)
    return 0;
  Si = MK_FP(rp.r_es, rp.r_bx);
  Sb = MK_FP(rp.r_es, rp.r_bx+0x0020);
  Sp = MK_FP(rp.r_es, rp.r_bx+0x0220);
  return 1;
}

int SetSpeakParam(int v, int p, int s)
{
  Sp->volume = v;
  Sp->pitch  = p;
  Sp->speed  = s;
  asm mov al, 2;
  return Si->Entry();
}

int Speak(char *str)
{
  Sb->length  = strlen(str)+1;
  *(Sb->buff) = 0;
  strcpy((char *)(Sb->buff+1), str);
  asm mov al,7
  return Si->Entry();
}

char fgb[BUFFLEN];

int main (int argc, char *argv[])
{
  FILE *fp;
  char *fga;
  int n;
  printf("NOWPWM Speak interface. (Read the file)\n");
  if (argc!=2) {
    printf("Usage : PWMspeak filename\n");
    return 1;
  }
  fp = fopen(argv[1], "rt");
  if (!fp) {
    printf("File open error ()\n", argv[1]);
    return 1;
  }
  if (CheckSpeak()) {
    printf("NOWPWM installed!\n");
    n = SetSpeakParam(9,2,3);
    printf("Set parameter answer is : %x\n", n);
    printf("  Volume : %d,\n"
	   "   Pitch : %d,\n"
	   "   Speed : %d\n",
	   Sp->volume, Sp->pitch, Sp->speed);
    n = Speak("Hi, Ernest!");
    printf("Speak answer is : %x\n", n);
    printf("Reading the `%s' file\n", argv[1]);
    do {
      fga = fgets(fgb, sizeof(fgb), fp);
      if (fga) {
	printf("%s", fgb);
	Speak(fgb);
      }
      if (kbhit()) {
	getch();
	break;
      }
    } while (fga);
    if (fga)
      printf("User Break\n");
    else
      printf("Ready!\n");
  } else
    printf("NOWPWM not installed!\n");
  fclose(fp);
  return 0;
}

/* -----------------------------------------<End of file PWMSPEAK.C>-------- */
