#if 0
-------------------------------------------------------------------------------
Name:		PKFF.C
Description:	File Find Utility
Version:	1.10
Hardware:	IBM PC/XT/AT/PS2
Op. System:	PC/MS DOS 3.30
Compiler:	Turbo C 2.0
Author:		Mikls Pl
-------------------------------------------------------------------------------
#endif

/* include files */

#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <io.h>

/* macro functions */

#define sizeofarray(array) (sizeof(array)/sizeof(array[0]))

/* structures */

struct fullpath
	{
	char drive[MAXDRIVE];
	char dir[MAXDIR];
	char name[MAXFILE];
	char ext[MAXEXT];
	};

struct arc_head
	{
	char signature;
	char c_method;
	char name[MAXFILE+MAXEXT-1];
	unsigned long c_size;
	unsigned short date;
	unsigned short time;
	unsigned short crc16;
	unsigned long uc_size;
	};

struct zip_head
	{
	long signature;
	int vextract;
	int gpflag;
	int c_method;
	unsigned short time;
	unsigned short date;
	unsigned long crc32;
	unsigned long c_size;
	unsigned long uc_size;
	int l_filename;
	int l_extra;
	};

struct shtime
	{
	unsigned short time;
	unsigned short date;
	};

union f2time
	{
	struct shtime shtd;
	struct ftime ftd;
	};

struct videocfg
	{
	unsigned char winleft0;		/* window settings -1 */
	unsigned char wintop0;
	unsigned char winright0;
	unsigned char winbottom0;
	unsigned char curratr;		/* attributes */
	unsigned char normattr;
	unsigned char dspmode;		/* display mode */
	unsigned char scheight;		/* display size */
	unsigned char scwidth;
	unsigned char graphic;		/* graphic mode indicator */
	unsigned char snoweff;		/* snow effect indicator */
	unsigned char far *videoptr;	/* video memory pointer */
	};

/* stack */

extern struct videocfg _video;		/* standard tc 2.0 library */
extern unsigned _stklen=0x4000;		/* redefine the stack size */

/* global data */

int sw_arc;
int sw_zip;
int sw_exe;
int found_n;
int brkflag;
int currentdrive;
char currentdir[MAXDIR];
int startdrive;
char startdir[MAXDIR];

/* global text */

char *startmsg=
"\n"
"PKFF    FAST!    File Find Utility    Version 1.10   "__DATE__"\n"
"Copyright (C) Mikls Pl, Hungary, 1990.    All Rights Reserved.\n\n";

char *help_message=
"  Usage:       C:\\> PKFF [<where>] [<where>] ... <what> [<-options>]\n"
"\n"
"  <where>      [drive:][dir]   (default is the current drive)\n"
"  <what>       filename[.ext]  (with optional wildcards)\n"
"  <-options>   default: search in directories only\n"
"            -a include ARC files\n"
"            -z include ZIP files\n"
"           -az include ARC and ZIP files\n"
"           -ae include normal and self extracting ARC files\n"
"           -ze include normal and self extracting ZIP files\n"
"          -aze include normal and self extracting ARC and ZIP files\n"
"\n"
"  Notes:   (1) The location of the <-options> is arbitrary.\n"
"           (2) Can\'t find files in multiple compressed files. (ARC in ARC)\n"
"           (3) The PKFF environment variable determines default options\n"
"           (4) Type '-' after one option to clear it\n"
"           (5) Press Ctrl-C to cancel search\n"
"\n"
"  Example:     C:\> set pkff=aze          (include arc+zip+exe)\n"
"               C:\> pkff -a-e- c: d: *.c  (exclude arc+exe)\n";

/* function prototypes */

void main(int,char *[]);
void cmdlnsw(char **,char *);
void search(struct fullpath *);
void scan(char *);
int strmatch(char *,char *);
void printf_info(unsigned long,unsigned short, unsigned short);
void ctrl_brk_handler(void);
void exit_to_dos(void);
void videoinit(void);

/* main */

void main(argc,argv)
	int argc;
	char *argv[];
	{
	/* data */
	int argn;
	int lastarg;
	int firstarg;
	int flags;
	int arglen;
	struct fullpath where;
	struct fullpath what;
	char arg[128];
	char *pkffenv;
	/* code */
	printf(startmsg);
	videoinit();
	ctrlbrk((int (*)())ctrl_brk_handler);
	brkflag=getcbrk();
	setcbrk(1);
	currentdrive=getdisk();
	getcurdir(0,currentdir);
	startdrive=currentdrive;
	strcpy(startdir,currentdir);
	atexit(exit_to_dos);
	if(argc<=1)
		{
		printf(help_message);
		exit(1);
		}
	sw_arc=0;
	sw_zip=0;
	sw_exe=0;
	if((pkffenv=getenv("PKFF"))!=NULL)
		{
		strupr(pkffenv);
		cmdlnsw(&pkffenv,"environment");
		}
	for(argn=1;argn<argc;argn++)
		{
		strupr(argv[argn]);
		if((*argv[argn]=='-')||(*argv[argn]=='/'))
			{
			argv[argn]++;
			cmdlnsw(&argv[argn],"command-line");
			}
		}
	if((sw_exe)&(!sw_arc)&(!sw_zip))
		{
		printf("Error: \"a\" or \"z\" option expected with \"e\"\n");
		exit(1);
		}
	lastarg=argc-1;
	while(*argv[lastarg]=='\0')
		{
		--lastarg;
		if(lastarg==0)
			{
			printf(help_message);
			exit(1);
			}
		}
	firstarg=1;
	while(*argv[firstarg]=='\0')
		{
		firstarg++;
		if(firstarg==lastarg)
			{
			break;
			}
		}
	flags=fnsplit(argv[lastarg],what.drive,what.dir,what.name,what.ext);
	if(!(flags&FILENAME))
		{
		printf("Error: filename expected in argument: \"%s\"\n",argv[lastarg]);
		exit(1);
		}
	if(flags&DRIVE)
		{
		printf("Error: unexpected drivename in argument: \"%s\"\n",argv[lastarg]);
		exit(1);
		}
	if(flags&DIRECTORY)
		{
		printf("Error: unexpected pathname in argument: \"%s\"\n",argv[lastarg]);
		exit(1);
		}
	if(!(flags&EXTENSION))
		{
		what.ext[0]='.';
		what.ext[1]='*';
		what.ext[2]='\0';
		}
	found_n=0;
	if(lastarg==firstarg)
		{
		what.drive[0]=(char)getdisk()+'A';
		what.drive[1]=':';
		what.drive[2]='\0';
		what.dir[0]='\\';
		what.dir[1]='\0';
		search(&what);
		}
	else
		{
		for(argn=1;argn<lastarg;argn++)
			{
			if(*argv[argn]=='\0')
				{
				continue;
				}
			strcpy(arg,argv[argn]);
			arglen=strlen(arg);
			if(arg[arglen-1]!='\\')
				{
				arg[arglen]='\\';
				arg[arglen+1]='\0';
				}
			flags=fnsplit(arg,where.drive,where.dir,where.name,where.ext);
			if(!(flags&DRIVE))
				{
				what.drive[0]=(char)getdisk()+'A';
				what.drive[1]=':';
				what.drive[2]='\0';
				}
			else
				{
				strcpy(what.drive,where.drive);
				}
			strcpy(what.dir,where.dir);
			search(&what);
			}
		}
	if(!found_n)
		{
		printf("  No files found\n");
		}
	else if(found_n==1)
		{
		printf("  1 File found\n");
		}
	else
		{
		printf("  %d Files found\n",found_n);
		}
	exit(0);
	}

/* cmdlnsw */

void cmdlnsw(argpp,msg)
	char **argpp;
	char *msg;
	{
	/* data */
	char lastch;
	/* code */
	lastch='\0';
	while(**argpp!='\0')
		{
		switch(**argpp)
			{
		case 'A':
			lastch='A';
			sw_arc=1;
			break;
		case 'Z':
			lastch='Z';
			sw_zip=1;
			break;
		case 'E':
			lastch='E';
			sw_exe=1;
			break;
		case '-':
		case '/':
			switch(lastch)
				{
			case 'A':
				sw_arc=0;
				break;
			case 'Z':
				sw_zip=0;
				break;
			case 'E':
				sw_exe=0;
				break;
				}
			break;
		default:
			printf("Error: illegal option \"%c\" in %s\n",**argpp,msg);
			exit(1);
			}
		(*argpp)++;
		}
	}

/* search */

void search(wp)
	struct fullpath *wp;
	{
	/* data */
	static int dirlen;
	static char nameext[MAXFILE+MAXEXT-1];
	/* code */
	if((dirlen=strlen(wp->dir))>1)
		{
		wp->dir[dirlen-1]='\0';
		}
	setdisk((int)(wp->drive[0]-'A'));
	if(getdisk()!=(wp->drive[0]-'A'))
		{
		printf("%s%s\n  Drive doesn't exist\n",wp->drive,wp->dir);
		return;
		}
	startdrive=getdisk();
	getcurdir(0,startdir);
	if(chdir(wp->dir))
		{
		printf("%s%s\n  Directory not found\n",wp->drive,wp->dir);
		return;
		}
	strcpy(nameext,wp->name);
	strcat(nameext,wp->ext);
	scan(nameext);
	setdisk(startdrive);
	chdir("\\");
	chdir(startdir);
	}

/* scan */
/* this is a recursive function */

void scan(name)
	char *name;
	{
	/* data */
	int done;
	struct ffblk fcs;
	/* static data */
	static int found;
	static char startpath[MAXDRIVE+MAXDIR-1];
	static FILE *fptr;
	static struct arc_head archd;
	static struct zip_head ziphd;
	static char zipname[MAXFILE+MAXEXT-1];
	static int zindex;
	static char nindex;
	static unsigned short exebuff;
	static unsigned long exesize;
	/* code */
	getcwd(startpath,sizeofarray(startpath));
	cprintf("\r");
	clreol();
	cprintf("%s",startpath);
	cprintf("\r");
	found=0;
	done=findfirst(name,&fcs,FA_HIDDEN+FA_SYSTEM);
	while(!done)
		{
		if(found==0)
			{
			printf("%s",startpath);
			}
		found=1;
		found_n++;
		printf("\n  %s",fcs.ff_name);
		printf("%*c",30-strlen(fcs.ff_name),'\x20');
		printf_info(fcs.ff_fsize,fcs.ff_fdate,fcs.ff_ftime);
		done=findnext(&fcs);
		}
	if(sw_arc)
		{
		done=findfirst("*.ARC",&fcs,FA_HIDDEN+FA_SYSTEM);
		while(!done)
			{
			if((fptr=fopen(fcs.ff_name,"rb"))==NULL)
				{
				done=findnext(&fcs);
				continue;
				}
			for(;;)
				{
				if(fread(&archd,sizeof(archd),1,fptr)!=1)
					{
					break;
					}
				if((archd.signature!='\x1a')||(archd.c_method<'\0')||(archd.c_method>'\x09')||(memchr(archd.name,'\0',13)==NULL))
					{
					break;
					}
				if(strmatch(name,archd.name))
					{
					found=1;
					found_n++;
					printf("\n  %s",archd.name);
					printf("%*c",14-strlen(archd.name),'\x20');
					printf("(%s)",fcs.ff_name);
					printf("%*c",14-strlen(fcs.ff_name),'\x20');
					printf_info(archd.uc_size,archd.date,archd.time);
					}
				fseek(fptr,archd.c_size,SEEK_CUR);
				}
			fclose(fptr);
			done=findnext(&fcs);
			}
		}
	if(sw_zip)
		{
		done=findfirst("*.ZIP",&fcs,FA_HIDDEN+FA_SYSTEM);
		while(!done)
			{
			if((fptr=fopen(fcs.ff_name,"rb"))==NULL)
				{
				done=findnext(&fcs);
				continue;
				}
			for(;;)
				{
				if(fread(&ziphd,sizeof(ziphd),1,fptr)!=1)
					{
					break;
					}
				if(ziphd.signature!=0x04034b50L)
					{
					break;
					}
				nindex=0;
				for(zindex=0;zindex<ziphd.l_filename;zindex++)
					{
					if(nindex==sizeof(zipname))
						{
						break;
						}
					if((zipname[nindex++]=fgetc(fptr))=='/')
						{
						nindex=0;
						}
					}
				zipname[nindex]='\0';
				for(zindex=0;zindex<ziphd.l_extra;zindex++)
					{
					fgetc(fptr);	/* throw away extra field */
					}
				if(strmatch(name,zipname))
					{
					found=1;
					found_n++;
					printf("\n  %s",zipname);
					printf("%*c",14-strlen(zipname),'\x20');
					printf("(%s)",fcs.ff_name);
					printf("%*c",14-strlen(fcs.ff_name),'\x20');
					printf_info(ziphd.uc_size,ziphd.date,ziphd.time);
					}
				fseek(fptr,ziphd.c_size,SEEK_CUR);
				}
			fclose(fptr);
			done=findnext(&fcs);
			}
		}
	if(sw_exe)
		{
		done=findfirst("*.EXE",&fcs,FA_HIDDEN+FA_SYSTEM);
		while(!done)
			{
			if((fptr=fopen(fcs.ff_name,"rb"))==NULL)
				{
				done=findnext(&fcs);
				continue;
				}
			if(fread(&exebuff,sizeof(exebuff),1,fptr)!=1)
				{
				fclose(fptr);
				done=findnext(&fcs);
				continue;
				}
			if(exebuff!=0x5a4dU)
				{
				fclose(fptr);
				done=findnext(&fcs);
				continue;
				}
			fread(&exebuff,sizeof(exebuff),1,fptr);
			exesize=(unsigned long)exebuff;
			fread(&exebuff,sizeof(exebuff),1,fptr);
			--exebuff;
			exesize+=(unsigned long)exebuff<<9;
			if(sw_arc)
				{
				fseek(fptr,exesize,SEEK_SET);
				for(;;)
					{
					if(fread(&archd,sizeof(archd),1,fptr)!=1)
						{
						break;
						}
					if((archd.signature!='\x1a')||(archd.c_method<'\0')||(archd.c_method>'\x09')||(memchr(archd.name,'\0',13)==NULL))
						{
						break;
						}
					if(strmatch(name,archd.name))
						{
						found=1;
						found_n++;
						printf("\n  %s",archd.name);
						printf("%*c",14-strlen(archd.name),'\x20');
						printf("(%s)",fcs.ff_name);
						printf("%*c",14-strlen(fcs.ff_name),'\x20');
						printf_info(archd.uc_size,archd.date,archd.time);
						}
					fseek(fptr,archd.c_size,SEEK_CUR);
					}
				}
			if(sw_zip)
				{
				fseek(fptr,exesize,SEEK_SET);
				for(;;)
					{
					if(fread(&ziphd,sizeof(ziphd),1,fptr)!=1)
						{
						break;
						}
					if(ziphd.signature!=0x04034b50L)
						{
						exesize++;
						fseek(fptr,exesize,SEEK_SET);
						if(fread(&ziphd,sizeof(ziphd),1,fptr)!=1)
							{
							break;
							}
						if(ziphd.signature!=0x04034b50L)
							{
							break;
							}
						}
					nindex=0;
					for(zindex=0;zindex<ziphd.l_filename;zindex++)
						{
						if(nindex==sizeof(zipname))
							{
							break;
							}
						if((zipname[nindex++]=fgetc(fptr))=='/')
							{
							nindex=0;
							}
						}
					zipname[nindex]='\0';
					for(zindex=0;zindex<ziphd.l_extra;zindex++)
						{
						fgetc(fptr);
						}
					if(strmatch(name,zipname))
						{
						found=1;
						found_n++;
						printf("\n  %s",zipname);
						printf("%*c",14-strlen(zipname),'\x20');
						printf("(%s)",fcs.ff_name);
						printf("%*c",14-strlen(fcs.ff_name),'\x20');
						printf_info(ziphd.uc_size,ziphd.date,ziphd.time);
						}
					fseek(fptr,ziphd.c_size,SEEK_CUR);
					}
				}
			fclose(fptr);
			done=findnext(&fcs);
			}
		}
	if(found)
		{
		printf("\n\n");
		}
	else
		{
		cprintf("\r");
		clreol();
		}
	done=findfirst("*.*",&fcs,FA_DIREC+FA_HIDDEN+FA_SYSTEM);
	while(!done)
		{
		if(((fcs.ff_attrib&FA_DIREC)!='\0')
		 &&(strcmp(fcs.ff_name,".")!=0)
		 &&(strcmp(fcs.ff_name,"..")!=0))
			{
			if(startpath[strlen(startpath)-1]!='\\')
				{
				strcat(startpath,"\\");
				}
			strcat(startpath,fcs.ff_name);
			chdir(startpath);
			scan(name);
			*strrchr(startpath,'\\')='\0';
			chdir(startpath);
			}
		done=findnext(&fcs);
		}
	}

/* strmatch */

int strmatch(model,ref)	/* case sensitive */
	char *model;	/* filename.ext with optional wildcards, with dot */
	char *ref;	/* filename.ext without wildcards, with dot */
	{
	/* code */
	for(;;)
		{
		if(*model=='\0')
			{
			if(*ref=='\0')
				{
				return 1;
				}
			else
				{
				return 0;
				}
			}
		else if(*model=='*')
			{
			while((*ref!='.')&&(*ref!='\0'))
				{
				ref++;
				}
			}
		else if(*model=='?')
			{
			if(*ref!='\0')
				{
				ref++;
				}
			}
		else if(*model==*ref)
			{
			ref++;
			}
		else
			{
			return 0;
			}
		model++;
		}
	}

/* printf_info */

void printf_info(size,date,time)
	unsigned long size;
	unsigned short date;
	unsigned short time;
	{
	/* data */
	union f2time f2td;
	/* code */
	f2td.shtd.time=time;
	f2td.shtd.date=date;
	printf	(
		"%10ld    %2.2d-%2.2d-%4.4d    %2d:%2.2d",size,
		f2td.ftd.ft_month,f2td.ftd.ft_day,f2td.ftd.ft_year+1980,
		f2td.ftd.ft_hour,f2td.ftd.ft_min
		);
	}

/* ctrl_brk_handler */
/* called when Ctrl-C or Ctrl-Break pressed */

void ctrl_brk_handler()
	{
	/* data */
	int i;
	/* code */
	setcbrk(0);
	for(i=0;i<1024;i++);
	printf("\n  Search canceled\n");
	exit(0);
	}

/* exit_to_dos */
/* called when program terminates */

void exit_to_dos()
	{
	/* code */
	setdisk(startdrive);
	chdir("\\");
	chdir(startdir);
	setdisk(currentdrive);
	chdir("\\");
	chdir(currentdir);
	setcbrk(brkflag);
	exit(0);
	}

/* videoinit */

void videoinit()
	{
	/* data */
	union REGS regs;	/* 8086 registers */
	int rows;		/* number of rows */
	/* code */
	regs.x.ax=0x1130;	/* ega/vga bios returns font info */
	regs.h.bh='\0';	
	regs.h.dl='\xff';	/* return value without ega/vga bios */
	int86(0x0010,&regs,&regs);
	regs.h.dl++;
	rows=(int)regs.h.dl;	/* 0=cga/mono, 25,35,43=ega, 25,40,50=vga */
	if((rows!=0)&&(rows!=25))
		{
		_video.scheight=rows;
		_video.winbottom0=rows-1;
		}
	}

/* end */
