.286

Assume Cs:_Code, Ds:_Data
_Stack Segment Para Stack 'Stack'
;    db 512 dup (?)
	db  512/8 dup ('NOSASOFT')
_Stack EndS


Procedures:

EXTRN  INITIALIZE:FAR            ; Initializes the modplayer for given
                                 ; sounddevice and replayrate

EXTRN  LOADMODULE:FAR            ; Loads the Module into memory

EXTRN  STARTPLAYING:FAR          ; Starts playing the module

EXTRN  STOPPLAYING:FAR           ; Stops playing the module

EXTRN  DEALLOC:FAR               ; Deallocates and erases the module
                                 ; from memory

EXTRN  ASKINIT:FAR

Variables:

EXTRN  SOUNDDEVICE:WORD          ; The Sounddevice number

EXTRN  TIMERSPEED:WORD           ; The replayrate 1193182/Hertz

EXTRN  SBDMA:WORD                ; SoundBlaster's DMA-Channel

EXTRN  SBIRQNR:WORD              ; SoundBlaster's IRQ-Number

Special_Variables:

EXTRN  BAR1,BAR2,BAR3,BAR4:WORD  ; Selfdecrementing Bars, see the docs

EXTRN  SHOWPATTERNS:Word         ; Shows the patterns

EXTRN  MASTERVOLUME:Word         ; Mastervolume from 0 to 64


mycolor	EQU	11
MAXELTOL	EQU	100
barwidth	EQU	10
barbottom	EQU	160
barleft		EQU	10 ;;!
barspacing	EQU	(20+barwidth)/2

drawline	macro	x1,y1,x2,y2,col
	push	col
	push	y2
	push	x2
	PUSH	y1
	PUSH	x1
	call	bline
	add	sp,10
	endm

rectangle	macro	xx1,yy1,xx2,yy2,col
	drawline xx1,yy1,xx2,yy1,col
	drawline xx1,yy2,xx2,yy2,col
	drawline xx1,yy1,xx1,yy2,col
	drawline xx2,yy1,xx2,yy2,col

	endm


_Data  Segment Para Public 'Data'
       Filename db 'happy.mod',0

       Error1   Db 13,10,10,7,'Module not found',13,10,'$'
       PlayMess Db 13,10,10,'Playing . . .',13,10
                Db 'Press ESCAPE to quit$'
	xeltol	DW	0
        elozobars	DW	0,0,0,0
        mostbars	DW	0,0,0,0
        ciklusvar	DW	0
        parx1		DW	?
        parx2		DW	?
        pary1		DW	?
        pary2		DW	?
        param3		DW	?
        vxeltol		DW	1


	v_kiir	DW	0,0,0,0,0
		DB	99	dup ('NSSOUTLST-')
	v_torol	DW	0,0,0,0,0
		DB	99	dup ('NSSINLST--')
	kiir_p	DW	?
	torol_p DW	?

_Data  EndS



_Code  Segment Para Public 'Code'

Proc   Player  Near
       Mov  Ah,4Ah                ; Reduce program memory size
       Mov  Bx,50000/16           ; Approx. size of compiled EXEFILE / 16 + 2
       Int  21h

       Mov  Ax,_Data
       Mov  Ds,Ax

;       Call Askinit              ; Ask for the setup

       Mov  Ax,Seg SoundDevice
       Mov  Es,Ax                  ; Makes ES point to the player-segment

       Mov  Es:SoundDevice,3       ; Set Internal Honker
       Mov  Es:TimerSpeed,60       ; Set 16 kHz (1193182/16000=75)

	; SBIRQ,.. defaults are good (D1 I7 A220)


       Call Initialize           ; Initialize the SoundSystem

       Mov  Dx,Offset FileName
       Call Loadmodule           ; Load the module
       Jnc  NoError

       Mov  Ah,09h
       Lea  Dx,Error1
       Int  21h                  ; Print the error-message

       Mov  Ah,4Ch
       Int  21h                  ; Exit if error...
       NoError:

       Call StartPlaying         ; Roll it !
       Mov  Al,01111010b         ; Mask off all unneccesary interrupts.
       Out  21h,Al
	RET
endp player

;----------------------------------------------------
main proc
	CALL	player
	CALL	GrIniT


       WaitEsc:

       	PUSH	AX
	PUSH	DX
	MOV	DX,3DAh
inhezz:
	IN	AL,DX	; wait for retrace interval
	TEST	AL,8
	JZ 	inhezz
	POP	DX
	POP	AX

	CALL	drawbars

       In   Al,60h
       Cmp  Al,1
       Jne  WaitEsc              ; Wait until someone presses ESCAPE.

	CaLl GrClOsE


       Mov  Al,0                 ; Let the interrupts come again...
       Out  21h,Al

       Call StopPlaying          ; Stop the funky music

       Call DeAlloc              ; Deallocate the memory for the module

       Mov  Ah,4Ch
       Int  21h                  ; Exit to DOS
EndP   main

	public putpixel
PutPixel proc near
	arg xp:word,yp:word,col:word
	push	bp
	mov	bp,sp

	push DX
	push es
	push di
	push ax
	push bx
	pushf

	mov ax,320
	MOV bx,[yp]
	mul bx
	add ax,[xp]
	mov di,ax
	mov ax,000A000h
	mov es,ax
	mov ax,[col]
	stosb
comment &
	MOV	ax,160
	mov	bx,[yp]
	mul bx
	add ax,[xp]
	add ax,[xp]
	mov	di,ax
	mov	ax,00b800h
	mov	es,ax
	mov	ax,[col]
	stosb
&
	popf
	pop bx
	pop ax
	pop di
	pop es
	pop DX

	pop	bp
	ret
PutPixel Endp

GrInit Proc
	mov ax,0013h
	int 10h
	ret
GrInit Endp

GrClose Proc
	mov ax,0003h
	int 10h
	ret
GrClose Endp



ķ Comment &
 The Sounddevices:                                                          
ĺ
                        01  Soundplayer/Covox at LPT1  (Mono)               
                        02  Soundplayer/Covox at LPT2  (Mono)               
                        03  SoundBlaster               (Mono)               
                        04  Internal Honker            (Mono)               
                        05  Two Soundplayers LPT1+2    (Stereo)             
                        06  SoundBlaster Pro           (Stereo)             
                        07  Stereo SoundPlayer in LPT1 (Stereo)             
                        08  Stereo SoundPlayer in LPT2 (Stereo)             
Ľ &

;	include	model.inc
;
;	VGAKIT Version 5.2b
;
;	Copyright 1988,89,90,91,92 John Bridges
;	Free for use in commercial, shareware or freeware applications
;
;	LINE.ASM
;
;

callpt	macro			;C order of parameter passing
	push	[color]
	push	di
	push	si
	call	PutPixel
	add	sp,6
	endm

;bline(x,y,x2,y2,func())
;
;input   : endpoints of line and function to use as point
;output  : nothing
;utility : draw line between endpoints using function
;          converted c routine
;
bline	proc	
		arg x1:word,y1:word,x2:word,y2:word,color:word
jmp bline_eleje
;	local	cnt:word,acc:word
;	local	deltax:word,deltay:word,dirx:word,diry:word
	cnt	DW ?
	acc	DW ?
	deltax	DW ?
	deltay	DW ?
	dirx	DW ?
	diry	DW ?

bline_eleje:
	push	bp
	mov	bp,sp
	pusha
	mov	si,[x1]
	mov	di,[y1]
	xor	ax,ax
	mov	acc,ax
	mov	ax,[x2]
	sub	ax,si
	mov	dx,1
	jns	nosx
	neg	ax
	mov	dx,-1
nosx:	mov	dirx,dx
	mov	deltax,ax
	mov	ax,[y2]
	sub	ax,di
	mov	dx,1
	jns	nosy
	neg	ax
	mov	dx,-1
nosy:	mov	diry,dx
	mov	deltay,ax
	cmp	ax,deltax
	jge	ylp
	callpt
	mov	ax,deltax
	mov	cnt,ax
lp1:
	dec	cnt
	jns	ndone
	jmp	done
ndone:
	add	si,dirx
	mov	ax,deltay
	add	acc,ax
	mov	ax,acc
	cmp	ax,deltax
	jb	noincy
	mov	ax,deltax
	sub	acc,ax
	add	di,diry
noincy:
	callpt
	jmp	short lp1
ylp:
	callpt
	mov	ax,deltay
	mov	cnt,ax
lp2:
	dec	cnt
	js	done
	add	di,diry
	mov	ax,deltax
	add	acc,ax
	mov	ax,acc
	cmp	ax,deltay
	jb	noincx
	mov	ax,deltay
	sub	acc,ax
	add	si,dirx
noincx:
	callpt
	jmp	short lp2
done:	
	popa
	pop	bp
	ret
bline	endp

;-----------------------------------------------------------------------------
drawbars proc near
	PUSHA
	PUSH	ES
	PUSH	DS
	PUSHF

	MOV	AX,Seg sounddevice
	MOV	ES,AX
        MOV     AX,ES:BAR1
;	SHL	AX,1
	MOV	mostbars,AX
        MOV     AX,ES:BAR2
;	SHL	AX,1
	MOV	mostbars[2],AX
        MOV     AX,ES:BAR3
;	SHL	AX,1
	MOV	mostbars[4],AX
        MOV     AX,ES:BAR4
;	SHL	AX,1
	MOV	mostbars[6],AX
	MOV	CX,4
nsb_loop_b:
	PUSH	CX

	MOV	BX,CX
	DEC	BX
	SHL	BX,1

	MOV	AX,barspacing
        MUL	BX
	ADD	AX,barleft
	MOV	parx1,AX
	ADD	AX,barwidth
	MOV	parx2,AX

	MOV	AX,barbottom
	MOV	DX,mostbars[BX]
	SUB	AX,DX
	MOV	pary1,AX

	MOV	AX,barbottom
	MOV	DX,elozobars[BX]
	SUB	AX,DX
	MOV	pary2,AX


	rectangle parx1,pary2,parx2,barbottom,0
        rectangle parx1,pary1,parx2,barbottom,mycolor


nsb_tovabb:
	POP	CX

	DEC	CX
	CMP	CX,0
	JE	netovabb
	JMP	nsb_loop_b
netovabb:

;	LOOP	nsb_loop_b

	MOV	AX,mostbars[0]
	MOV	elozobars[0],AX
	MOV	AX,mostbars[2]
	MOV	elozobars[2],AX
	MOV	AX,mostbars[4]
	MOV	elozobars[4],AX
	MOV	AX,mostbars[6]
	MOV	elozobars[6],AX
	POPF
	POP	DS
	POP	ES
	POPA
	RET
drawbars endp

bar proc
	arg x1:word,y1:word,x2:word,y2:word,col:word
	PUSH	BP
	MOV	BP,SP

	PUSHA
	PUSH	ES

	MOV	AX,0a000h
	MOV	ES,AX

	MOV	BX,x2
	SUB	BX,x1
	CMP	BX,0800h
	JBE	nemnegbx
	NEG	BX
	PUSH	x1
	PUSH	x2	; <- nem hiba!
	POP	x1
	POP	x2
nemnegbx:
	MOV	CX,y2
	SUB	CX,y1
	CMP	CX,0800h
	JBE	nemneg
	NEG	CX
	PUSH	y1
	PUSH	y2
	POP	y1
	POP	y2
nemneg:
	PUSH	CX

	ADD	CX,y1
	MOV	AX,320
	MUL	CX
	ADD	AX,x1
	MOV	DI,AX
	MOV	AX,col
	MOV	CX,BX
	REP	STOSB

	POP	CX
	LOOP	nemneg	

	POP	ES
	POPA

	POP	BP
	RET
bar endp

_code ends
	end main

