#include <dos.h>
#include <bios.h>
#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <process.h>
#include "..\comm\serialpo.hpp"

//inline char getscan( void ) { return(_bios_keybrd(_NKEYBRD_READ) >> 8); }
inline unsigned getfscan( void ) { return(_bios_keybrd(_NKEYBRD_READ)); }

struct
 {
  char st;
  unsigned int kar;
 } sbuf;

SerialPort *sp;

void main ( int argc, char *argv[] )
{
 _setcursortype(_NOCURSOR);

 clrscr();
 textbackground(0);
 textcolor(WHITE);
 clrscr();
 //cprintf("\n");
 gotoxy(15,11); cprintf("Ŀ\n");
 gotoxy(15,12); cprintf("          NOSATron Remote Console       \n");
 gotoxy(15,13); cprintf("\n");

 unsigned int c,d,x;

 int pt=1;

 if (argc>1)
  {
   if (stricmp(argv[1],"COM2")==0)
    pt=2;
  }

 sp = new SerialPort(pt,9600,NOPAR,1,8,false);
 sp->RaiseDTR();

 //ComHandshake(DSR|DTR|DCD, 100 * 3 / 4);

 nosound();

 textcolor(YELLOW);
 gotoxy(20,14); cprintf("Waiting for connection...\n");


 int kilep=0;
 char buf[54];
 //strcpy(buf,"-----------------------------------------");
 sp->PurgeInput();
 do
  {
   if (!sp->InputEmpty())
    {
     buf[12]='\0';
     sp->Read(buf,12,0.1);
     //if (x<12)
     // printf("Com Rx Error !\n");
     if (strncmpi(buf,"NOSATronINRQ",12)==0)
      kilep=1;
    }
   if (kbhit())
    if (getch()==27)
     {
      gotoxy(20,15); cprintf("Aborted by user...\n");
      sp->DropDTR();
      sp->Pause();
      delete sp;

      exit(1);
     }
  }
 while (!kilep);

 strcpy(buf,"NOSATronACK!");
 sp->Write(buf,strlen(buf));


 textcolor(LIGHTGRAY);
 gotoxy(20,14); clreol();
 gotoxy(25,14); cprintf("Sent :\n");
 textcolor(GREEN);
 long sc=0;

 int cnt=0;
 while (1)
  {
   if (cnt>=0)
    cnt++;
   if (cnt%1000==399)
    {
     gotoxy(30,15);
     clreol();
     textcolor(GREEN);
     //cprintf("");
     cnt=-1;
    }

   if (kbhit())
    {
     c=getfscan();// | (1 << 15);

     if ((c>>8)==1)
      exit(1);

     sbuf.kar=c;
     sbuf.st=((c>>8)+(c&0xFF))|128;
     sp->Write(&sbuf,sizeof(sbuf));

     gotoxy(30,15);
     clreol();
     textcolor(RED);
     cprintf("Sending...%X",c);
     sc++;
     gotoxy(32,14); cprintf("%ld",sc);
     cnt=0;
    }
   //printf("%c",c);
  }

 //ComClose();
 sp->DropDTR();
 sp->Pause();

 delete sp;

 _setcursortype(_NORMALCURSOR);
}
