#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <io.h>
#include <stdio.h>
#include <fcntl.h>

int trans=0; // translate Note off to on

void memrev(void *cr,int s )
{
 int c;
 char t;
 for (c=0;c<s/2;c++)
  {
   t=((char *)cr)[c];
   ((char *)cr)[c]=((char *)cr)[s-c-1];
   ((char *)cr)[s-c-1]=t;
  }
}

long getlong( int ff )
{
 long l;
 read(ff,&l,sizeof(l));
 memrev(&l,sizeof(l));
 return(l);
}

int getint( int ff )
{
 int i;
 read(ff,&i,sizeof(i));
 memrev(&i,sizeof(i));
 return(i);
}

long ReadVarLen ( int f )
{
 register long value;
 register unsigned char c;
 char d;

 read(f,&d,1);
 if ((value = d) & 0x80)
  {
   value &= 0x7f;
   do
    {
     read(f,&d,1);
     value = (value << 7) + ((c = d) & 0x7f);
    } while (c & 0x80);
  }
 return (value);
}

char *hangok[] = {"C ","C#","D ","D#","E ","F ","F#","G ",
                  "G#","A ","A#","B "};

char dumper[256];
#define Dump(x) read(f,dumper,x); dumper[x]='\0';
#define ReadNum(x) (read(f,buf,x))

void OutDump( int f, int num)
{
 int c;
 read(f,dumper,num);
 dumper[num]='\0';
 for (c=0;c<num;c++)
  printf("%02X ",dumper[c]);
}

char *keystring( int num )
{
 static char keybuf[5];

 int oct=num/12;
 int hang=num%12;
 sprintf(keybuf,"%s%d",hangok[hang],oct);
 return(keybuf);
}

void process_track( int f, int trnum )
{
 //int pos=0;
 int co,e;
 unsigned char d;
 int cu,chan;
 int laststat=0;
 long delta;
 char buf[256];
 long siz;
 long x;

 Dump(4);
 long len;
 read(f,buf,4);
 len=buf[3];
 len+=buf[2]*256L+buf[1]*256*256L;
 long spos=tell(f);
 long pos=tell(f);

 printf("-> Track %d, length: %ld \n",trnum,len);

 int ends=0;
 while (pos<len+spos && !ends)
  {
   delta=ReadVarLen(f);
   printf("%8lX    ",delta);
   co=0;
   read(f,&co,1);
   if (co<0x80)
    {
     co=laststat;
     lseek(f,-1,SEEK_CUR);
    }
   else
    {
     if (! (trans && ((co&0xF0)==0x80)) )
      printf("%02X ",co);
    }
   cu=co&0xF0;
   chan=co&0x0F;


   switch (cu)
    {
     case 0xC0: // Program change
               OutDump(f,1);
               printf("; Prog Change");
              break;
     case 0x90: // Note on
               OutDump(f,2);
               printf("; Note on: %s %d",keystring(dumper[0]),dumper[1]);
              break;

     case 0x80: // Note off
               if (trans)
                {
                 printf("%02X ",0x90|chan);
                 OutDump(f,1);
                 printf("%02X ",0); // 0 veloc. -> off
                 Dump(1);
                 printf("; Note off /Trans/: %s %d",keystring(dumper[0]),0);
                 break;
                }
               if (trans)
                printf("%02X ",co);

               OutDump(f,2);
               printf("; Note off: %s %d",keystring(dumper[0]),dumper[1]);
              break;
     case 0xE0: // Note on
               OutDump(f,2);
               x=dumper[0]+dumper[1]<<7;
               printf("; Pitch bend: %ld",x);
              break;
     case 0xA0: // Note on
               OutDump(f,2);
               printf("; Polyphonic pressure %s %d",keystring(dumper[0]),dumper[1]);
              break;
     case 0xD0: // Note on
               OutDump(f,2);
               printf("; Channel pressure");
              break;
     case 0xB0: // Note on
               OutDump(f,2);
               printf("; Control change");
              break;
     case 0xF0:if (co==0xFF)
                {
                 read(f,&d,1);
                 printf("%02X ",d);
                 switch (d)
                  {
                   case 0x2F:OutDump(f,1);
                             printf("; Track end");
                             ends=1;
                            break;
                   case 0x00:OutDump(f,3);
                             printf("; Sequence number");
                            break;
                   case 0x01:siz=ReadVarLen(f);
                             printf("%4lX ",siz);
                             Dump(siz);
                             printf("\x22%s\x22 ; Text event",dumper);
                            break;
                   case 0x02:siz=ReadVarLen(f);
                             printf("%4lX ",siz);
                             Dump(siz);
                             printf("\x22%s\x22 ; Copyright",dumper);
                            break;
                   case 0x03:siz=ReadVarLen(f);
                             printf("%4lX ",siz);
                             Dump(siz);
                             printf("\x22%s\x22 ; Seq/Track name",dumper);
                            break;
                   case 0x04:siz=ReadVarLen(f);
                             printf("%4lX ",siz);
                             Dump(siz);
                             printf("\x22%s\x22 ; Instrument name",dumper);
                            break;
                   case 0x05:siz=ReadVarLen(f);
                             printf("%4lX ",siz);
                             Dump(siz);
                             printf("\x22%s\x22 ; Lyric",dumper);
                            break;
                   case 0x06:siz=ReadVarLen(f);
                             printf("%4lX ",siz);
                             Dump(siz);
                             printf("\x22%s\x22 ; Marker",dumper);
                            break;
                   case 0x07:siz=ReadVarLen(f);
                             printf("%4lX ",siz);
                             Dump(siz);
                             printf("\x22%s\x22 ; Cue Point",dumper);
                            break;
                   case 0x51:OutDump(f,4);
                             printf("; Set tempo");
                            break;
                   case 0x54:OutDump(f,6);
                             printf("; SMPTE offset");
                            break;
                   case 0x58:OutDump(f,5);
                             printf("; Time signature");
                            break;
                   case 0x59:OutDump(f,3);
                             printf("; Key signature");
                            break;
                   default:
                             siz=ReadVarLen(f);
                             printf("%4lX ",siz);
                             OutDump(f,siz);
                             printf("; Unknown");
                            break;
                  }
                }
               else
                {
                 ;
                }
    }
   laststat=co;
   printf("\n");
   pos=tell(f);
  }
}

void main( int argc, char *argv[] )
{
 int f;
 long a,b;
 int e,g;
 char buf[40];
 char st[200];
 int tracks;
 long t1pos;

 printf(";Ŀ\n"
        "; MIDI-Disassembler v1.0 (C) 1994 by John Zero/NOSASOFT \n"
        ";\n"
       );

 if (argc<2)
  {
   printf("Usage: ex.: MIDI_MSG MUSIC.MID > MUSIC.LST\n");
   return;
  }

 f=open(argv[1],O_BINARY|O_RDWR);
 strupr(argv[1]);

 if (argv[2][0]=='t')
  trans=1;

 read(f,buf,4);
 buf[4]='\0';
 if (stricmp(buf,"MThd") || (f==-1))
  {
   printf("File %s is not a .MID, or is corrupt...\n",argv[1]);
   return;
  }

 printf(";File: %s\n",argv[1]);
 getlong(f); // kell!
 printf(";Type: %d ",getint(f));
 printf(";Tracks: %d ",tracks=getint(f));
 printf(";TimeVal: %04Xh ",e=getint(f));
 printf(";Length: %ld bytes\n",filelength(f));

 printf("=> %04X  ; Time val.\n",e);

 t1pos=tell(f);

 int tcnt=0;
 while(1)
  {
   tcnt++;
   //read(f,buf,4);
   //buf[4]='\0';
   //a=getlong(f);
  // printf("Track %d, length: %ld ",tcnt,a);
   //lseek(f,a,SEEK_CUR);
  // if (strcmp(buf,"MTrk")!=0)
  //  printf(" -Error with track head-");
  // printf("\n");
   process_track(f,tcnt);
   if (tcnt>=tracks)
    break;
  }
 t1pos+=4+4;
 printf("-END-\n");

 close(f);
}
