#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//#include <alloc.h>


#include "mailgen.h"
#include "msghand.h"
#include "qwkhand.h"
#include "userhand.h"

char *dayname[]={"Sunday","Monday","Tuesday","Wednesday","Thursday",
                  "Friday","Saturday"};

char *monthn[]={"Jan","Feb","Mar","Apr","May","Jun",
                "Jul","Aug","Sep","Okt","Nov","Dec"};

//float MSBINToIEEE(float f);
//float IEEEToMSBIN(float f);
unsigned char *longtoMSBIN( long num );
long MSBINtolong( unsigned char *ms );

long msgtot2;

void replpicr( char *st )
{
 char *q;
 for (q=st;*q;q++)
  if (*q=='')
   *q='\r';
}

void replcrpi( char *st )
{
 char *q;
 for (q=st;*q;q++)
  if (*q=='\r')
   *q='';
}


void rtrim( char *st )
{
 char *q;
 q=&st[strlen(st)-1];
 while (*q==' ') q--;
 *(q+1)=0;
}
//------------------------------------------------------------
int processrepmsg( char *fname, users *us )
{
 FILE *f;
 qmsg_header qm;
 msgtt ms;
 //long aa;

 char buf[10];
 unsigned ml; // message max 64k lehet!!! (sot, kevesebb!)
 int c,cn;

 if (!(f=fopen(fname,"rb")))
  { logerror("opening rep/msg file: %s",fname); return 0; }

 fseek(f,128,SEEK_SET); // header nem kell

 while(1)
  {
   getfrek(&qm,sizeof(qm),f);
   if (feof(f))
    break;

   msgtot2++;
   strncpy(buf,qm.chunks,6);
   buf[6]=0;
   ml=(atoi(buf)-1)*128;

   cn=atoi(cutss(qm.msgnum,7));

   //ms.msg=(char *)malloc(ml+1);
   ms.msg=qbase;
   for (c=0;c<ml;c++)
    {
     ms.msg[c]=fgetc(f);
     if (feof(f))
      break;
    }
   ms.msg[c]=0;

   if (selectconf(cn)) // ellenorzes kell, jogok, stb.
    {
     ms.from=strdupx(cutss(qm.from,25));
     ms.to=strdupx(cutss(qm.to,25));
     appropcase(ms.from);
     appropcase(ms.to);
     ms.subj=strdupx(cutss(qm.subject,25));
     ms.date=(char *)malloc(22);
     dateqwk2pkt(cutss(qm.date,8+5),ms.date);

     rtrim(ms.from);
     rtrim(ms.to);
     rtrim(ms.subj);
     rtrim(ms.msg);
     replpicr(ms.msg);
     //rtrim(ms.date);
     log("[#X %s,%s,%s,%s] [%dk]",ms.from,ms.to,ms.date,ms.subj,(strlen(ms.msg)+1023)/1024);
     xlog(L_RSC,"%4d:%-15s %-15s %-20s",cn,ms.from,ms.to,ms.subj);

     addnewmsg(&ms);
     ms.msg=NULL;
     freemsg(&ms);
    }
   else
    {
     // error -> (esetleg) lost mailbe kene rakni ezt a levelet
     //!!! lost mailbe!!!

     xlog(L_ALL,"! Error: no such conf:%4d (%-15s %-15s %-20s)",cn,ms.from,ms.to,ms.subj);
     ms.msg=NULL;
     free(ms.msg);
    }
  }

 fclose(f);
 closeconf(); //!!!
 return 1;
}

int processrep( char *fname )
{
 char buf[200];
 int rr;
 users us;

 getuser(&us);
 seekback1user();

 log("--- Beginning to process REPly file: %s, user: %s\n",fname,us.name);
 statprintf("\nBeginning to process REPly file: %s, user: %s\n",fname,us.name);
 msgtot2=0;

 strcpy(buf,fname);
 if ( strcmp( struprx(&buf[strlen(buf)-4]) , ".REP") )
  { logerror("I need a file with the extension .REP !"); return 0; }

 cleartmpdir();
 decompress(fname);

 sprintf(buf,WORKDIR "%s",fname);
 buf[strlen(buf)-4]=0;
 strcat(buf,".msg");

 xlog(L_RSC,"       -REP processing stats-          \n\n");
 xlog(L_RSC,"Conf From            To             Subject");
 xlog(L_RSC,"----+---------------+--------------+----------------------");
 rr=processrepmsg( buf, &us );

 xlog(L_RSC,"---------------------------------------------------------------");
 log("--- Processed REPly file, (%ld msgs) - %s.\n",msgtot2,rr?"OK":"Error!");
 xlog(L_RSC,"Processed your reply file.\n%ld messages uploaded - %s.",msgtot2,rr?"OK":"Error!");

 if (rr)
  {
   us.upnum++;
   us.upmsgs+=msgtot2;
   putuser(&us);
   seekback1user();
  }

 return rr;
}

//------------------------------------------------------------

void qwkpackconf( int num, FILE *msg )
{
 FILE *idx;
 qmsg_header qm;
 char *q;
 char buf[200];
 char bufd[22];
 long mn;
 int a,c,ch,sl;
 msgtt ms;
 float ipos;
 char *xx;
 long iph;
 long cnx=0;

 int a1,a2,a3,a4;

 getconftag(buf);
 log("- Packing conf. #%d (%s)\n",num,buf);
 statprintf("Packing conf #%d\r",num);

 sprintf(buf,WORKDIR "%03d.ndx",num);
 idx=fopen(buf,"wb");
 //ipos=0;

 while (1)
  {
   mn=getcurmsgno();
   if (!getmsg(&ms))
    break;

   iph=ftell(msg);

#ifdef MSGHIGHDEBUG
   log("[#%ld %s,%s,%s,%s] [%dk]",mn,ms.from,ms.to,ms.date,ms.subj,(strlen(ms.msg)+1023)/1024);
#endif
   msgtot2++;

   replcrpi(ms.msg);

   memset(&qm,' ',sizeof(qm));
   qm.status=' ';
   sprintf(buf,"%7li",mn);
   memcpy(qm.msgnum,buf,7);

   datepkt2qwk(ms.date,bufd);
   memcpy(qm.date,bufd,8+5);
   memcpy(qm.to,ms.to,(a=strlen(ms.to)) > 25?25:a);
   memcpy(qm.from,ms.from,(a=strlen(ms.from)) > 25?25:a);
   memcpy(qm.subject,ms.subj,(a=strlen(ms.subj)) > 25?25:a);
   qm.alive=0xE1;
   qm.confLSB=num;
   qm.confMSB=0;

   sl=strlen(ms.msg);
   ch=1+(sl+127)/128;
   sprintf(buf,"%6d",ch);
   memcpy(qm.chunks,buf,6);

   putfrek(&qm,sizeof(qm),msg);

   putfrek(ms.msg,sl,msg);
   //   for (c=0;c<strlen(ms.msg);c++)
   //    fputc(ms.msg[c],msg);
   memset(buf,' ',128);
   putfrek(buf,128-(sl%128),msg);

   //for (c=0 ; c<(128-strlen(ms.msg)%128) ; c++)
   // fputc(' ',msg);

   ms.msg=NULL; // nem freezheto!
   freemsg(&ms);

   if (iph%128!=0)
    logerror("Error in QWK/Messages, rec. offset is: %ld (not /128)!",iph);

   xx=(char *)longtoMSBIN(iph/128+1);

   //a1=xx[0]; a2=xx[1]; a3=xx[2]; a4=xx[3];
   //log("XX: %2X %2X %2X %2X",a1,a2,a3,a4); // !!!!

   putfrek(xx,4,idx);
   fputc(num,idx);

   //ipos+=ch; // + chunksnum
  }
 fclose(idx);
 statprintf("                        \r");
}

int qwkpackmaker( char *fname )
{
 FILE *g,*msg;
 users us;
 int c,nc;
 long mtx;
 char buf[200];

 getuser(&us);

 log("--- Beginning to pack a QWK (file: %s) for user: %s\n",fname,us.name);
 statprintf("\nBeginning to pack a QWK (file: %s) for user: %s\n",fname,us.name);
 msgtot2=0;

 cleartmpdir();

 nc=0;
 for (c=0;c<255;c++)
  if (us.lmr[c]!=-1)
   if (selectconf(c))
    nc++;

 closeconf(); //!!!
 msg=fopen(WORKDIR "messages.dat","wb");
 g=fopen(WORKDIR "control.dat","wt");
 if (!g || !msg)
  return 0;

 memset(buf,' ',200);
 strcpy(buf,conf.qwkheadcr);
 buf[strlen(conf.qwkheadcr)]=' ';
 buf[128]=0;
 fputs(buf,msg);

 fprintf(g,"%s\n%s\n%s\n%s\n%s,%s\n",conf.sysname,conf.town,
       conf.number,conf.sysops,conf.mailer,conf.qwkname);

 fputs(timexform(),g); // datum/ido
 fputs("\n",g);

 strcpy(buf,us.name);
 struprx(buf);
 fputs(buf,g); // a celuser neve nagybetukkel!
 fputs("\n" // nevnek cr/lf
       "\n" // ures kell
       "0\n" // ?
       "0\n" // ? a spec szerint (min->max conf #-k?)
      ,g);

 fprintf(g,"%d\n",nc-1+1 ); // max conf #-1 // +1 debug
 xlog(L_RSC,"           -QWK packing stats-          \n\n");
 xlog(L_RSC,"Num  Conf. name                    Msgs ");
 xlog(L_RSC,"---+------------------------------+-----");
 for (c=0;c<255;c++)
  if (us.lmr[c]!=-1)
   if (selectconf(c))
    {
     getconfname(buf);
     fprintf(g,"%d\n%s\n",c,buf);
     mtx=msgtot2;

     if (seekmsg(us.lmr[c]+1))
      qwkpackconf(c,msg);

     xlog(L_RSC,"%3d: %-30s %ld",c,buf,msgtot2-mtx);

     us.lmr[c]=lastmsgno();
    }
   else
    us.lmr[c]=-1;

 fprintf(g,"250\n<Erratic Rulez!>\n"); // +1 debug conf.!!!

 closeconf(); //!!!
 fclose(g);
 fclose(msg);

 compress(fname);

 us.downnum++;
 us.downmsgs+=msgtot2;
 seekback1user();
 putuser(&us); // az updatelt LMR-ekkel
 xlog(L_RSC,"----------------------------------------");
 log("--- Successfully packed QWK (%ld msgs)",msgtot2);
 xlog(L_RSC,"Succesfully packed your QWK.\n%ld messages packed.",msgtot2);

 return 1;
}


//----------------------------------------------------------------

/*
long MSBINtolong( unsigned char *ms )
{
 int c,sign,ex;
 long a,*ax;
 float e,f;
 long ee;

 sign = ms[2] / 0x80;
 ex   = ms[3] - 0x81; //(ms[3] - 0x81 + 0x7f) & 0xff;
 ax=(long *)ms;
 a=(*ax) & ((1L<<24)-1);

 e=1;
 for (c=22,f=0.5;c>0;c--,f/=2)
  if (a & (1L<<c))
   e+=f;

 if (ex==-127)
  return 0;

 for (c=1;c<=ex;c++)
  e*=2;

 if (sign)
  e*=-1;

 ee=long(e);

 return( ee );
}
*/

unsigned char *longtoMSBIN( long num )
{
 int sign;
 long ex;
 //static long numba; // static !
 unsigned char *p;
 unsigned char rt[4];
 static unsigned char rx[4];
 float a,b;
 int c;

 if (num==0)
  {
   rx[0]=0; rx[1]=0; rx[2]=0; rx[3]=2;
   return( rx );
  }

 sign = num<0 ? 1 : 0;
 a=num<0 ? -num : num;
 ex=0;
 if (a<1)
  {
   while (a<1)
    { a*=2; ex--; }
  }
 else
  if (a>=2)
   {
    while (a>=2)
    { a/=2; ex++; }
   }
 ex=(ex+0x81)&0xff;

 a-=1;
 rt[1]=0; rt[2]=0; rt[3]=0;

 //numba=0;
 for (c=1,b=0.5 ; c<24 ; c++,b/=2)
  if (a>=b)
   { a-=b; rt[c/8+1]|=(  1 << (7-(c%8))  ); } //numba|=1L<<(23-c); }
  else
   if (a==0)
    break;

 rt[0]=ex;
 if (sign)
  rt[1]|=0x80;

 rx[0]=rt[3];
 rx[1]=rt[2];
 rx[2]=rt[1];
 rx[3]=rt[0];

 return( rx );
}
