#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <string.h>

#include "mailgen.h"
#include "msghand.h"
#include "userhand.h"
#include "pkthand.h"

long msgcnum;

void swabx( char *hol, int mennyit )
{
 char *q;
 int c;
 char x;

 union uus
  {
   unsigned int a;
   char b[sizeof(unsigned int)];
  } uu;

 uu.a=0; uu.b[0]=1;
 if (uu.a==1)
  return; // jo, nem kell swappolni

 for (q=hol,c=0;c<mennyit;c+=2,q+=2)
  { x=q[0]; q[0]=q[1]; q[1]=x; }
}

//------------------------------------------------------------------------
int getmhead( pkt_mhead *pmh, FILE *pf )
{
 int a;
 a=getfrek((char *)pmh,sizeof(pkt_mhead),pf);

#ifdef BSWAP
 swabx((char *)pmh,18);
 swabx(((char *)pmh)+20,4);
 swabx(((char *)pmh)+34,4);
#endif

 return a;
}

void putmhead( pkt_mhead *pmh, FILE *pf  )
{
#ifdef BSWAP
 swabx((char *)pmh,18);
 swabx(((char *)pmh)+20,4);
 swabx(((char *)pmh)+34,4);
#endif
 putfrek((char *)pmh,sizeof(pkt_mhead),pf);
}


//------------------------------------------------------------------------

int processinpkt( char *fname, nodet *nt=NULL )
{
 FILE *f;
 pkt_head ph;
 pkt_mhead pmh;
 msgtt ms;
 char *q,*r,*p,*p2;
 int len;

 char buf[200];
 unsigned ml; // message max 64k lehet!!! (sot, kevesebb!)
 int a,c,cn,of;
 long cnx=0;

 if (!(f=fopen(fname,"rb")))
  return 0;

 log("-- Processing packet: %s",fname);
 statprintf("Processing packet: %s\n",fname);

 getmhead(&pmh,f);
 if ((pmh.azonx[0]!=2) || (pmh.azonx[1]!=0))
  {
   // error! nem valid packet
   logerror("Not a valid packet (no 02 00 signature) !");

   fclose(f);
   return 0;
  }

 if (nt)
  {
   nt->zone=pmh.origz?pmh.origz:oursys.zone;
   nt->net=pmh.orignet;
   nt->node=pmh.orign;
   nt->point=0;
   xlog(L_SCLOG,"Found from addr: %hd:%hd/%hd.%hd",nt->zone,nt->net,nt->node,nt->point);
  }

 /*if (!(qbase=makeget0buf()))
  {
   logerror("Malloc error #023!");
   xlog(L_SCREEN,"Malloc error #023!");
   return 0;
  }*/
 char dtbuf[22];

 while(1)
  {
   getfrek(&ph,sizeof(ph),f);
   if (feof(f))
    break;

   statprintf("\rMessage #%5d ",++cnx);

   zeromsg(&ms);

   strcpy(dtbuf,cutss(ph.dtime,20));
   ms.date=dtbuf; //strdupx(q);
   ms.to=get0str(f);
   ms.from=get0str(f);
   ms.subj=get0str(f);
   q=qbase;

   get0strlong(q,f);
   //q=(char *)realloc(q,strlen(q)+200);
   r=strtok(q,"\r\n");

   if (r)
    {
     if (strncmp(r,"AREA:",5)==0)
      {
       r+=5; // AREA:
       ms.msg=strtok(NULL,"");
      }
     else
      {
       logerror("No AREA tag on msg imp #%d!",cnx);
       xlog(L_SCREEN,"No AREA tag on msg imp #%d!",cnx);
       r=q; r[0]='!'; r[1]=0; ms.msg=&q[2];
      }
    }
   else
    { r=q; r[0]='!'; r[1]=0; ms.msg=&q[2]; };

   if (!isalloweduser(ms.from))
    addviolator(ms.from);

   if ((a=getconfnumt(r))!=-1)
    {
     selectconf(a);
    }
   else
    {
     log("Lost mail, destined to area: %s",r);
     sprintf(buf,"Original destination: %s area\r",r);

     c=strlen(ms.msg);
     q=&ms.msg[c-1];
     p=q+strlen(buf);

     for (;c>0;c--,q--,p--)
      *p=*q;

     // memmove(&ms.msg[strlen(buf)],ms.msg,strlen(ms.msg)+1); // !!!!!!!!!Unix!

     memcpy(ms.msg,buf,strlen(buf));

     selectconf(CONF_LOSTMAIL);
    }
#ifdef PKTHIGHDEBUG
   log("[#X %s,%s,%s,%s] [%dk]",ms.from,ms.to,ms.date,ms.subj,(strlen(ms.msg)+1023)/1024);
#endif
   addnewmsg(&ms);

   //free(q);
   ms.date=NULL;
   ms.msg=NULL;
   freemsg(&ms);
  }
 //free(qbase); ******

 closeconf(); // mem!!!
 fclose(f);

 statprintf("\rDone.              \r");
 msgcnum+=cnx;
 return 1;
}

//---------------------------------------------------------------------

int processallpkts( void )
{
 DIR *dir,*d2;
 struct dirent *ent,*en2;
 char *p;
 char buf[128],buf2[128];
 nodet nt;
 int foundn;

 log("--- Beginning to process all incoming packets\n");
 statprintf("\nBeginning to process all incoming packets.\n");
 msgcnum=0;

 if ((dir = opendir(PKTINCOMDIR)) == NULL)
  {
   logerror("Unable to open PKT-incoming directory");
   exit(1);
  }

 while ((ent = readdir(dir)) != NULL)
  {
   strcpy(buf,ent->d_name);
   for (p=buf ; *p ; p++)
    *p=tolower(*p);

   if (buf[0]!='.')//strstr(buf,".pkt"))
    {
     log("- Possible compressed bundle: %s",ent->d_name);
     statprintf("Possible bundle: %s\n",ent->d_name);
     sprintf(buf2,"%s%s",PKTINCOMDIR,ent->d_name);
     cleartmpdir();
     decompress(buf2);
     foundn=0;

     d2=opendir(WORKDIR);
     while ((en2 = readdir(d2)) != NULL)
      {
       strcpy(buf,en2->d_name);
       for (p=buf ; *p ; p++)
        *p=tolower(*p);

       if (strstr(buf,".pkt"))
        {
         sprintf(buf,"%s%s",WORKDIR,en2->d_name);
         if (processinpkt(buf,foundn?NULL:&nt))
          foundn=1;
        }
      }
     closedir(d2);
     if (foundn)
      { // neki updatelmr, majd updateallbundle
       if (seeksystemnode(&nt))
        updatesyslmr();
       else
        logerror("Node %hd:%hd/%hd.%hd not found in dbase!",nt.zone,nt.net,nt.node,nt.point);
       updateallsysbundle();
      }
     else
      logerror("Bundle/packets inside didn't contain node# (shouldn't occur)");

     remove(buf2);
     rewinddir(dir);
    }
  }

 closedir(dir);
 log("--- Done processing incoming packets (%ld msgs imported)\n\n",msgcnum);
 statprintf("Done processing. (%ld msgs imported)\n",msgcnum);
}

//---------------------------------------------------------------------

void convputpktmsg( char *msg, char *ctag, long msgnum, int confn, FILE *g )
{
 int hasmid=0;

 fprintf(g,"AREA:%s\r",ctag);
 if (!strstr(msg,"MSGID"))
  fprintf(g,"\x1MSGID: %hd:%hd/%hd %08lx\r",oursys.zone,oursys.net,oursys.node,
   msgnum+confn*65536);
 else
  hasmid=1; // ha volt msgid, akkor mar nem kell!!!

 fputs(msg,g);
 if (msg[strlen(msg)-1]!='\r')
  fputs("\r",g);

 if (!hasmid)
  {
   fputs("--- ",g);
   fputs(PKT_TEARLINE,g);
   fputs("\r",g);

   fprintf(g," * Origin: %s (%hd:%hd/%hd)\r",conf.pktorigin,oursys.zone,oursys.net,oursys.node);

   fprintf(g,"SEEN-BY: %hd/%hd\r",oursys.net,oursys.node);
   // ^aPATH is kell!!! ^^^ add kell a seen-by-hez!
  }
 else
  {
   ; // PATH, SEEN-BY -hez addolas!
  }

 fputc(0,g);
}

void pktpackconf( int num, FILE *msg, users *u )
{
 FILE *idx;
 char *q;
 char buf[200];
 long mn;
 int a,c,ch;
 msgtt ms;
 pkt_head ph;
 char ct[50];

 getconftag( ct );

 while (1)
  {
   mn=getcurmsgno();
   zeromsg(&ms);

   if (!getmsg(&ms))
    break;

   msgcnum++;
   //printf("\r %8d %8d ",num,msgcnum);

   ph.azonx[0]=2;
   ph.azonx[1]=0;

   ph.orign=oursys.node;
   ph.orignet=oursys.net;
   ph.destn=u->n.node;
   ph.destnet=u->n.net;
   //unsigned short attr;
   //unsigned short cost;
   ph.attr=0;
   ph.cost=0;

   strcpy(ph.dtime,ms.date);
   //char dtime[20]; !!!

   putfrek(&ph,sizeof(ph),msg);

   fputs(ms.to,msg); fputc(0,msg);
   fputs(ms.from,msg); fputc(0,msg);
   fputs(ms.subj,msg); fputc(0,msg);

   convputpktmsg(ms.msg,ct,mn,num,msg);

   ms.msg=NULL; // nem freezheto!
   freemsg(&ms);
  }
}

//----------------------------------------------------------------------

int updatesyslmr( void )
{
 FILE *g;
 users us;
 int c,nc;
 char buf[200];
 char sorb[200];

 getuser(&us);
 log("--- Beginning to only update LMR's for system: %s\n",us.name);
 statprintf("\nOnly updating LMR's for system: %s\n",us.name);
 msgcnum=0;

 log("-Conference #,LMR,New LMR:\n");
 sorb[0]=0;

 for (c=0;c<255;c++)
  if (us.lmr[c]!=-1)
   if (selectconf(c))
    {
     //if (seekmsg(us.lmr[c]+1))
     // pktpackconf(c,g,&us);

     sprintf(&sorb[strlen(sorb)]," #%d,%ld/%ld",c,us.lmr[c],lastmsgno());

     if (strlen(sorb)>70)
      { log(sorb); sorb[0]=0; }
     msgcnum+=lastmsgno()-us.lmr[c];
     us.lmr[c]=lastmsgno();
    }

 if (strlen(sorb)>0)
  { log(sorb); sorb[0]=0; }

 closeconf(); //!!!
 seekback1user();
 putuser(&us); // az updatelt LMR-ekkel

 log("--- Done updating LMR-s (%ld skipped)\n",msgcnum);
 statprintf("Done updating LMR-s (%ld skipped).\n",msgcnum);

 return 1;
}

int update1pkt( char *fname )
{
 FILE *g;
 users us;
 int c,nc;
 char buf[200],sorb[200];

 getuser(&us);
 log("--- Beginning to make PKT file: %s (for %s)\n",fname,us.name);
 statprintf("\nBeginning to make PKT file: %s (for %s)\n",fname,us.name);
 msgcnum=0;

// sprintf(buf,PKTEXPDIR "%s",fname);
 strcpy(buf,fname);
 g=fopen(buf,"a+b");
 if (!g)
  {
   logerror("Cannot open PKT file: %s!\n",buf);
   return 0;
  }

 fseek(g,0,SEEK_END);
 if (ftell(g)==0)
  {
   log("-(New packet)\n");

   pkt_mhead mh;
   memset(&mh,0,sizeof(mh));
   mh.orign=oursys.node;
   mh.orignet=oursys.net;
   mh.origz=oursys.zone;
   mh.destn=us.n.node;
   mh.destnet=us.n.net;
   mh.destz=us.n.zone;
   mh.azonx[0]=2;
   mh.azonx[1]=0;
   //unsigned short year,month,day,hour,minute,second,baud;
   //unsigned char prodcode,serno;
   //char passwd[8];

   putmhead(&mh,g);
  }

 log("-Conference #,LMR,Msgs packed:\n");
 sorb[0]=0;

 for (c=0;c<255;c++)
  if (us.lmr[c]!=-1)
   if (selectconf(c))
    {
     if (seekmsg(us.lmr[c]+1))
      pktpackconf(c,g,&us);

     sprintf(&sorb[strlen(sorb)]," #%d,%ld,%ld",c,us.lmr[c],lastmsgno()-us.lmr[c]);

     if (strlen(sorb)>70)
      { log(sorb); sorb[0]=0; }

     us.lmr[c]=lastmsgno();
    }

 if (strlen(sorb)>0)
  { log(sorb); sorb[0]=0; }

 fclose(g);
 closeconf(); //!!!

 seekback1user();
 putuser(&us); // az updatelt LMR-ekkel
 seekback1user();

 log("--- Done making PKT file (%ld msgs)\n",msgcnum);
 statprintf("Done making PKT (%ld msgs).\n",msgcnum);

 return 1;
}

void makebundname( char *bname, users *us )
{
 sprintf(bname,PKTEXPDIR "00%02hx%02hx%02hx.fr0",
         ((oursys.zone-us->n.zone)&0xff),((oursys.net-us->n.net)&0xff),
         ((oursys.node-us->n.node)&0xff) );
}

int updatesysbundle()
{
 FILE *g;
 users us;
 int c,nc;
 char buf[200],bname[130],npname[140];

 getuser(&us);
 seekback1user();
 us.ser=(us.ser+1)%30000;
 putuser(&us);
 seekback1user();

 log("\n--- Beginning to update a system bundle for %s\n",us.name);
 statprintf("\n--- Beginning to update a system bundle for %s\n",us.name);

 makebundname(bname,&us);
 log("Bundle name: %s %s",bname,fexist(buf)?"(file exists)":"(new file)");

 sprintf(npname,PKTEXPDIR "00%06hu.pkt",us.ser);

 update1pkt(npname); // user jo helyen alljon

 compressaf(bname,npname);

 clearfiles(PKTEXPDIR,"*.pkt");

 log("--- Done updating system bundle.");
 statprintf("--- Done updating system bundle.\n");

 return 1;
}

int updateallsysbundle( void )
{
 users us;
 int cnt=0;

 log("--> Updating ALL system bundles");
 openusersfile('0');
 while (1)
  {
   if (!getuser(&us))
    break;

   seekback1user();
   cnt++;
   updatesysbundle();
//   updatesyslmr();
   getuser(&us); // skip to next
  }
 log("--> Done updating ALL system bundles, %d systems processed",cnt);
}
