#include <math.h>
#include <stdio.h>
#include <mem.h>

/***  MSBIN conversion routines ***/

union Converter
      {
       unsigned char uc[10];
       unsigned short int  ui[5];
       unsigned long ul[2];
       float          f[2];
       double         d[1];
      };

/* MSBINToIEEE - Converts an MSBIN floating point number */
/*               to IEEE floating point format           */
/*                                                       */
/*  Input: f - floating point number in MSBIN format     */
/* Output: Same number in IEEE format                    */

float MSBINToIEEE(float f)
{
   union Converter t;
   int sign, exp;       /* sign and exponent */

   t.f[0] = f;

/* extract the sign & move exponent bias from 0x81 to 0x7f */

   sign = t.uc[2] / 0x80;
   exp  = (t.uc[3] - 0x81 + 0x7f) & 0xff;

/* reassemble them in IEEE 4 byte real number format */

   t.ui[1] = (t.ui[1] & 0x7f) | (exp << 7) | (sign << 15);
   return t.f[0];
} /* End of MSBINToIEEE */


/* IEEEToMSBIN - Converts an IEEE floating point number  */
/*               to MSBIN floating point format          */
/*                                                       */
/*  Input: f - floating point number in IEEE format      */
/* Output: Same number in MSBIN format                   */

float IEEEToMSBIN(float f)
{
   union Converter t;
   int sign, exp;       /* sign and exponent */

   t.f[0] = f;

/* extract sign & change exponent bias from 0x7f to 0x81 */

   sign = t.uc[3] / 0x80;
   exp  = ((t.ui[1] >> 7) - 0x7f + 0x81) & 0xff;

/* reassemble them in MSBIN format */

   t.ui[1] = (t.ui[1] & 0x7f) | (sign << 7) | (exp << 8);
   return t.f[0];
} /* End of IEEEToMSBIN */


long MSBINtolong( unsigned char *ms )
{
 int c,sign,ex;
 long a,*ax;
 float e,f;

 sign = ms[2] / 0x80;
 ex   = ms[3] - 0x81; //(ms[3] - 0x81 + 0x7f) & 0xff;
 ax=(long *)ms;
 a=(*ax) & ((1L<<24)-1);

 e=1;
 for (c=22,f=0.5;c>0;c--,f/=2)
  if (a & (1L<<c))
   e+=f;

 if (ex==-127)
  return 0;

 for (c=1;c<=ex;c++)
  e*=2;

 if (sign)
  e*=-1;

 return( e );
}

unsigned char *longtoMSBINo( long num )
{

 int sign;
 long ex;
 static long numba; // static !
 float a,b;
 int c;

 if (num==0)
  {
   numba=0x2000000L;
   return( (char*)&numba );
  }

 sign = num<0 ? 1 : 0;
 a=num<0 ? -num : num;
 ex=0;
 if (a<1)
  {
   while (a<1)
    { a*=2; ex--; }
  }
 else
  if (a>=2)
   {
    while (a>=2)
    { a/=2; ex++; }
   }
 ex=(ex+0x81)&0xff;

 a-=1;
 numba=0;
 for (c=1,b=0.5 ; c<=23 ; c++,b/=2)
  if (a>=b)
   { a-=b; numba|=1L<<(23-c); }
  else
   if (a==0)
    break;

 if (sign)
  numba|=1L<<23;

 numba|=ex<<24;

 return( (char*)&numba );
}

unsigned char *longtoMSBIN( long num )
{
 int sign;
 long ex;
 //static long numba; // static !
 unsigned char *p;
 unsigned char rt[4];
 static unsigned char rx[4];
 float a,b;
 int c;

 if (num==0)
  {
   rx[0]=0; rx[1]=0; rx[2]=0; rx[3]=2;
   return( rx );
  }

 sign = num<0 ? 1 : 0;
 a=num<0 ? -num : num;
 ex=0;
 if (a<1)
  {
   while (a<1)
    { a*=2; ex--; }
  }
 else
  if (a>=2)
   {
    while (a>=2)
    { a/=2; ex++; }
   }
 ex=(ex+0x81)&0xff;

 a-=1;
 rt[1]=0; rt[2]=0; rt[3]=0;

 //numba=0;
 for (c=1,b=0.5 ; c<24 ; c++,b/=2)
  if (a>=b)
   { a-=b; rt[c/8+1]|=(  1 << (7-(c%8))  ); } //numba|=1L<<(23-c); }
  else
   if (a==0)
    break;

 rt[0]=ex;
 if (sign)
  rt[1]|=0x80;

 rx[0]=rt[3];
 rx[1]=rt[2];
 rx[2]=rt[1];
 rx[3]=rt[0];

 return( rx );
}


void main(void)
{
 float a,b,*ff,b2;
 unsigned long *e;
 long aa,bb;
 unsigned int c,d;
 unsigned char *a1,*a2,*a3;
 unsigned char v[4],vo[4],vk[4];

 //e=(unsigned long *)longtoMSBIN(152);

 v[0]=0x82; v[1]=0; v[2]=0; v[3]=0;
 bb=MSBINtolong(v);
 return;

 for (aa=-50000; aa<170000 ;aa++)
  {
   if (aa%10000==0)
    printf(".");
    a3=longtoMSBIN(aa); //memcpy(v,a3,4);
    bb=MSBINtolong(a3); //memcpy(vk,&b,4);

   /*b=IEEEToMSBIN(aa); memcpy(vk,&b,4);
   a1=(unsigned char *)&b;
   a2=longtoMSBINo(aa); memcpy(vo,a2,4);
   a3=longtoMSBIN(aa); memcpy(v,a3,4);*/
   //v[0]=a3[3]; v[1]=a3[2]; v[2]=a3[1]; v[3]=a3[0];

   if (aa!=bb)//memcmp(a1,v,4))
    {
     printf("\naa:%ld\n",aa);
     break;
    }
  }
}
