page	60,132
title	DISPLAY I/O ROUTINES for Trident Grafx mode
;
;
;						for C
;
_text	segment	byte public 'code'
_text	ends
_data	segment	word public 'data'
_data	ends
_bss	segment	word public 'bss'
_bss	ends
	public	_put_vga_pixel
;
dgroup	group	_bss, _data
	assume	cs:_text, ds:dgroup, ss:dgroup, es:dgroup
;
_data	segment	word public 'data'
;
;beeptime	dw	0
;beepptr		dw	0
;
xx	dw	?
yy	dw	?
ccol	db	?
extended_vga_xsize dw 0
current_vga_page db 0
last_vga_page db 0
color db ?

;vidseg	dw	?

_data ends
      page

_text segment
;
; plotxy(x,y,color,rule);
;
;_plotxy:
;	push	bp
;	mov	bp,sp
;	push	si
;	push	di
;	mov	cx,[bp+4]	; get x
;	mov	bx,[bp+6]	; get y
;	mov	dx,[bp+8]	; get color
;	mov	ax,[bp+10]	; get rule
;	mov	dh,al
;	call	pixel
;	pop	di
;	pop	si
;	pop	bp
;	ret
;
;
; put_vga_pixel ( unsigned int x, unsigned int y , char col );
;
_put_vga_pixel:
        mov ax,[bp+4]
        mov xx,ax
        mov ax,[bp+6]
        mov yy,ax
        mov al,[bp+8]
        mov ccol,al

	mov ax,xx
	add ax,yy
	mov dx,0
	mov bx,3
	mov bx,3
	div bx

;	mov al,ccol
;	mov color,al

extended_vga:
	mov dx,40960 ;A000h
	mov es,dx
	mov ax,extended_vga_xsize
	mul yy
	add ax,xx
	adc dx,0
	mov bx,ax
	mov current_vga_page,dl
	cmp dl,last_vga_page
	je put_pixel
	call change_vga_page
put_pixel:
	mov ah,ccol
	mov es:[bx],ah
	jmp endpixel
change_vga_page:
	mov ah,current_vga_page
	mov dx,3C4h
	mov al,0Eh
	out dx,al
	mov dx,3C5h
	in al,dx
	and ax,4080 ;FF0h
	xor ah,2
	or al,ah
	out dx,al
	mov dl,current_vga_page
	mov last_vga_page,dl;
	ret

endpixel:
        ret

;
_text	ends
;
	end
