
#define PLAY_BACKGROUND 0
#define PLAY_POLL       1

#define INCLUDE_IRQ     0
#define CUTOFF_IRQ      1

extern char play_def;
extern char irq_def;

extern int HSC_playing;
extern int AdLib_act;

int HSC_reset( void ); // 1-Ok, 0-Error
/*
   Initialises AdLib card & internal variables
   Expects: -
   Returns: 1-success
	    0-init failed
*/

void HSC_startmusic( char far *music );
/* Starts music
   Expects: music data in the array
   Uses   : play_def (default playing mode) & irq_def (IRQ default)
	    Values: play_def: PLAY_BACKGROUND - play in background
			      PLAY_POLL       - play with calls to
		    irq_def:  INCLUDE_IRQ     -
			      CUTOFF_IRQ      - don't let the old int. work
   Returns: -
*/

void HSC_stopmusic( void );
/* Stops music
   Expects: -
   Returns: -
*/
void HSC_fadeoutmusic( void );
/* Fades-out music
   Expects: -
   Returns: -
*/
void HSC_pollmusic( void );
/* Polls music
   Expects: -
   Returns: -
*/

extern pascal volatile char HSC_NOTE[9];
extern pascal volatile char HSC_POSITION;
extern pascal volatile char HSC_TRACK;
extern pascal volatile char HSC_PATTERN;


extern pascal volatile char HSC_EQUALIZER[9];
